/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Definitions;
import de.interactive_instruments.ShapeChange.Model;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target;
import de.interactive_instruments.ShapeChange.XmlSchema;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class Converter {
    protected ShapeChangeResult result = null;
    protected Options options = null;

    public Converter(Options o, ShapeChangeResult r) {
        this.options = o;
        this.result = r;
    }

    public void convert(Model model) {
        try {
            try {
                HashSet<PackageInfo> schemas;
                if (model == null) {
                    this.result.addFatalError("No model has been loaded to convert.");
                    throw new ShapeChangeAbortException();
                }
                if (!model.isValidated()) {
                    model.validate();
                }
                if ((schemas = model.schemas(this.options.appSchemaName)).isEmpty()) {
                    if (this.options.appSchemaName.equals("")) {
                        this.result.addFatalError("No application schema found.");
                    } else {
                        this.result.addFatalError("Application schema " + this.options.appSchemaName + " not found.");
                    }
                    throw new ShapeChangeAbortException();
                }
                for (PackageInfo pi : schemas) {
                    if (pi == null) continue;
                    int t = 1;
                    while (t <= 2) {
                        Target target = null;
                        switch (t) {
                            case 1: {
                                target = new XmlSchema();
                                break;
                            }
                            case 2: {
                                if (this.options.definitions.equals("NONE")) break;
                                if (this.options.gmlVersion.equals("3.2")) {
                                    target = new Definitions();
                                    break;
                                }
                                this.result.addError("Definitions could not be created for schema " + pi.name() + " as a GML dictionary. This is supported only for GML version 3.2.");
                            }
                        }
                        if (target != null) {
                            target.initialise(pi, model, this.options, this.result);
                            Iterator<ClassInfo> j = model.classes(pi).iterator();
                            while (j.hasNext()) {
                                target.process(j.next());
                            }
                            target.write();
                        }
                        t *= 2;
                    }
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                Exception se = e;
                if (e instanceof SAXException) {
                    se = ((SAXException)e).getException();
                }
                if (se != null) {
                    se.printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                this.result.toFile(String.valueOf(this.options.dirName) + "/ShapeChangeResult.xml");
            }
        }
        finally {
            this.result.toFile(String.valueOf(this.options.dirName) + "/ShapeChangeResult.xml");
        }
    }
}

