/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraintImpl;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.OclParser;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.mitre.ShapeChange.Model.GSIP.ClassInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.GSIPDocument;
import us.mitre.ShapeChange.Model.GSIP.PropertyInfoGSIP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OclConstraintGSIP
extends OclConstraintImpl
implements OclConstraint {
    protected GSIPDocument document = null;

    public OclConstraintGSIP(GSIPDocument doc, ClassInfoGSIP ci, HashMap<String, Object> properties) {
        this.document = doc;
        this.contextClass = ci;
        this.contextModelElmtType = Constraint.ModelElmtContextType.CLASS;
        this.contextModelElmt = ci;
        this.constraintText = (String)properties.get("oclDefinition");
        this.constraintName = null;
        Pattern pat = Pattern.compile("inv\\s*(\\w*)\\s*:");
        Matcher mat = pat.matcher(this.constraintText);
        if (mat.find()) {
            this.constraintName = mat.group(1);
        }
        if (this.constraintName == null || this.constraintName.length() == 0) {
            this.constraintName = this.constraintText.trim();
        }
        this.syntaxTree = null;
        StringReader instream = new StringReader(this.constraintText);
        OclParser parse = new OclParser();
        this.document.result.addDebug(null, 10006, ci.name(), this.constraintName);
        this.syntaxTree = parse.parseOcl(instream, this.contextModelElmt);
        if (this.syntaxTree != null) {
            this.conditionType = this.syntaxTree.expressionType;
        }
        this.comments = parse.getComments();
        if (this.document.options.parameter("reportLevel").equals("DEBUG")) {
            this.document.result.addDebug(null, 10024, parse.debugTempNodes());
            if (this.syntaxTree != null) {
                this.document.result.addDebug(null, 10024, parse.debugOclNodes());
            }
            String[] comments = parse.getComments();
            for (String c : comments) {
                this.document.result.addDebug(null, 10025, c);
            }
        }
        if (parse.getNumberOfMessages() > 0) {
            this.document.result.addError(null, 133, ci.name(), this.constraintName, "class");
            MessageCollection messages = parse.getMessageCollection();
            MessageCollection.Message[] msg = messages.getMessages();
            for (MessageCollection.Message m : msg) {
                String[] del = new String[]{"/", "-", ","};
                String sr = m.getFormattedSourceReferences(1, 1, del);
                String ms = m.getMessageText();
                this.document.result.addError(null, 134, sr, ms);
            }
        }
    }

    public OclConstraintGSIP(GSIPDocument doc, PropertyInfoGSIP pi, HashMap<String, Object> properties) {
        this.document = doc;
        this.contextClass = pi.inClass();
        this.contextModelElmtType = Constraint.ModelElmtContextType.ATTRIBUTE;
        this.contextModelElmt = pi;
        this.constraintText = (String)properties.get("oclDefinition");
        this.constraintName = null;
        Pattern pat = Pattern.compile("inv\\s*(\\w*)\\s*:");
        Matcher mat = pat.matcher(this.constraintText);
        if (mat.find()) {
            this.constraintName = mat.group(1);
        }
        if (this.constraintName == null || this.constraintName.length() == 0) {
            this.constraintName = this.constraintText.trim();
        }
        this.syntaxTree = null;
        StringReader instream = new StringReader(this.constraintText);
        OclParser parse = new OclParser();
        this.document.result.addDebug(null, 10006, this.contextClass.name() + "." + pi.name(), this.constraintName);
        this.syntaxTree = parse.parseOcl(instream, this.contextModelElmt);
        if (this.syntaxTree != null) {
            this.conditionType = this.syntaxTree.expressionType;
        }
        this.comments = parse.getComments();
        if (this.document.options.parameter("reportLevel").equals("DEBUG")) {
            this.document.result.addDebug(null, 10024, parse.debugTempNodes());
            if (this.syntaxTree != null) {
                this.document.result.addDebug(null, 10024, parse.debugOclNodes());
            }
            String[] comments = parse.getComments();
            for (String c : comments) {
                this.document.result.addDebug(null, 10025, c);
            }
        }
        if (parse.getNumberOfMessages() > 0) {
            this.document.result.addError(null, 133, this.contextClass.name() + "." + pi.name(), this.constraintName, "property");
            MessageCollection messages = parse.getMessageCollection();
            MessageCollection.Message[] msg = messages.getMessages();
            for (MessageCollection.Message m : msg) {
                String[] del = new String[]{"/", "-", ","};
                String sr = m.getFormattedSourceReferences(1, 1, del);
                String ms = m.getMessageText();
                this.document.result.addError(null, 134, sr, ms);
            }
        }
    }
}

