/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.AssociationInfoImpl;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.Map;
import us.mitre.ShapeChange.Model.GSIP.ClassInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.GSIPDocument;
import us.mitre.ShapeChange.Model.GSIP.PropertyInfoGSIP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationInfoGSIP
extends AssociationInfoImpl
implements AssociationInfo {
    GSIPDocument document = null;
    protected String gsipConnectorId = null;
    protected String gsipName = null;
    protected int navigability = 0;
    protected boolean relevant = false;
    protected PropertyInfoGSIP[] properties = new PropertyInfoGSIP[]{null, null};
    protected HashMap<String, String> taggedValuesCache = null;
    protected String stereotype = null;

    @Override
    public PropertyInfo end1() {
        return this.properties[0];
    }

    @Override
    public PropertyInfo end2() {
        return this.properties[1];
    }

    AssociationInfoGSIP(GSIPDocument doc, HashMap<String, Object> assocProperties, HashMap<String, Object> supplierProperties, HashMap<String, Object> clientProperties) {
        this.document = doc;
        this.gsipConnectorId = (String)assocProperties.get("itemIdentifier_PK");
        Role[] roles = new Role[2];
        class Role {
            HashMap<String, Object> roleProperties = null;
            ClassInfoGSIP ci = null;

            Role() {
            }
        }
        roles[0] = new Role();
        String supplierClassId = (String)supplierProperties.get("infoEntity_FK");
        roles[0].ci = this.document.fClassById.get(supplierClassId);
        roles[0].roleProperties = (HashMap)supplierProperties.clone();
        roles[1] = new Role();
        String clientClassId = (String)clientProperties.get("infoEntity_FK");
        roles[1].ci = this.document.fClassById.get(clientClassId);
        roles[1].roleProperties = (HashMap)clientProperties.clone();
        if (roles[0].ci != null && roles[1].ci != null) {
            this.relevant = true;
            for (int i = 0; i < 2; ++i) {
                PropertyInfoGSIP pi;
                this.properties[i] = pi = new PropertyInfoGSIP(this.document, roles[1 - i].ci, this, i == 0, roles[1 - i].roleProperties, roles[i].ci);
                if (!pi.isNavigable()) continue;
                roles[1 - i].ci.establishRoles(pi);
            }
            boolean supplierNav = this.properties[0].isNavigable();
            boolean clientNav = this.properties[1].isNavigable();
            this.properties[0].setAggregationType((String)roles[1].roleProperties.get("roleType"));
            this.properties[1].setAggregationType((String)roles[0].roleProperties.get("roleType"));
            if (!supplierNav) {
                this.navigability = 1;
            } else if (!clientNav) {
                this.navigability = -1;
            }
        }
        if (!this.document.suppressAssociationNames) {
            this.gsipName = (String)assocProperties.get("primaryCode");
            if (this.gsipName == null || this.gsipName.length() == 0) {
                this.gsipName = roles[0].ci != null ? roles[0].ci.name() : "roles[0]_";
                this.gsipName = roles[1].ci != null ? this.gsipName + roles[1].ci.name() : this.gsipName + "roles[1]";
            }
        }
        this.setAndValidateTaggedValues(assocProperties);
        this.document.result.addDebug(null, 10013, "association", this.id(), this.name());
    }

    @Override
    public String id() {
        return new Integer(this.gsipConnectorId).toString();
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        return this.gsipName;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }

    private void setAndValidateTaggedValues(HashMap<String, Object> tvs) {
        this.taggedValuesCache = new HashMap(5);
        if (tvs != null) {
            for (Map.Entry<String, Object> e : tvs.entrySet()) {
                String t = e.getKey();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = (String)e.getValue();
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public ClassInfo assocClass() {
        return null;
    }
}

