/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.JSON;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class JsonSchema
implements Target,
MessageSource {
    public static final int TARGET_JSONSCHEMA = 7;
    private HashMap<String, String> contexts = new HashMap();
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String outputDirectory = null;
    private File outputDirectoryFile = null;
    private File subDirectoryFile = null;
    private String subdir = null;
    private String baseURI = null;
    private String schemaURI = null;
    private boolean diagnosticsOnly;
    private boolean includeDocumentation = true;

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        block13: {
            String s;
            this.pi = p;
            this.model = m;
            this.options = o;
            this.result = r;
            this.diagnosticsOnly = diagOnly;
            this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (this.outputDirectory == null) {
                this.outputDirectory = this.options.parameter(".");
            }
            if ((s = this.options.parameter(this.getClass().getName(), "includeDocumentation")) != null && s.equalsIgnoreCase("false")) {
                this.includeDocumentation = false;
            }
            this.schemaURI = this.options.parameter(this.getClass().getName(), "jsonSchemaURI");
            if (this.schemaURI == null) {
                this.schemaURI = "http://json-schema.org/draft-03/schema#";
            }
            this.baseURI = this.pi.taggedValue("jsonBaseURI");
            if (this.baseURI == null) {
                this.baseURI = this.options.parameter(this.getClass().getName(), "jsonBaseURI");
            }
            if (this.baseURI == null) {
                this.baseURI = "FIXME";
            }
            this.result.addDebug(this, 10001, this.pi.name());
            if (!this.diagnosticsOnly) {
                this.outputDirectoryFile = new File(this.outputDirectory);
                boolean exi = this.outputDirectoryFile.exists();
                if (!exi) {
                    this.outputDirectoryFile.mkdirs();
                    exi = this.outputDirectoryFile.exists();
                }
                boolean dir = this.outputDirectoryFile.isDirectory();
                boolean wrt = this.outputDirectoryFile.canWrite();
                boolean rea = this.outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 12, this.outputDirectory);
                    throw new ShapeChangeAbortException();
                }
                this.subdir = this.pi.taggedValue("jsonDirectory");
                if (this.subdir == null) {
                    this.subdir = this.pi.taggedValue("xmlns");
                }
                if (this.subdir == null) {
                    this.subdir = "default";
                }
                this.subDirectoryFile = new File(this.outputDirectoryFile, this.subdir);
                try {
                    this.subDirectoryFile.mkdirs();
                    dir = this.subDirectoryFile.isDirectory();
                    wrt = this.subDirectoryFile.canWrite();
                    rea = this.subDirectoryFile.canRead();
                    if (!(dir && wrt && rea)) {
                        this.result.addFatalError(this, 12, this.subDirectoryFile.getName());
                        throw new ShapeChangeAbortException();
                    }
                    break block13;
                }
                catch (Exception e) {
                    this.result.addFatalError(this, 12, this.subDirectoryFile.getName());
                    this.result.addFatalError(this, 10, e.getMessage());
                    throw new ShapeChangeAbortException();
                }
            }
            this.result.addInfo(this, 10002);
        }
    }

    private boolean notImplemented(String cname) {
        return cname.startsWith("TP_") || cname.startsWith("TM_") || cname.startsWith("MD_") || cname.startsWith("CI_") || cname.startsWith("DQ_") || cname.startsWith("CV_") || cname.startsWith("OM_") || cname.startsWith("SF_") || cname.startsWith("SC_") || cname.startsWith("SV_");
    }

    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (this.options.matchesEncRule(ci.encodingRule("json"), "geoservices") ? cat != 1 && cat != 6 : this.options.matchesEncRule(ci.encodingRule("json"), "geoservices_extended") && cat != 1 && cat != 6 && cat != 5 && cat != 8) {
            return;
        }
        Context ctx = new Context();
        try {
            if (!this.diagnosticsOnly) {
                ctx.writer = new BufferedWriter(new FileWriter(new File(this.subDirectoryFile, ci.name() + ".json")));
            }
            this.write(ctx, "{");
            this.newLine(ctx);
            this.write(ctx, "\t\"$schema\":\"" + this.schemaURI + "\",");
            this.newLine(ctx);
            this.write(ctx, "\t\"id\":\"" + this.baseURI + "/" + this.subdir + "/" + ci.name() + ".json\",");
            this.newLine(ctx);
            String s = ci.aliasName();
            this.write(ctx, "\t\"title\":\"" + (s == null || s.isEmpty() ? ci.name() : s) + "\",");
            this.newLine(ctx);
            if (this.includeDocumentation && !ci.documentation().isEmpty()) {
                this.write(ctx, "\t\"description\":\"" + ci.documentation().trim() + "\",");
                this.newLine(ctx);
            }
            this.write(ctx, "\t\"type\":\"object\",");
            this.newLine(ctx);
            this.write(ctx, "\t\"properties\":{");
            this.newLine(ctx);
            if (cat == 1 || cat == 6) {
                this.write(ctx, "\t\t\"entityType\":{");
                this.newLine(ctx);
                this.write(ctx, "\t\t\t\"title\":\"feature/object type\",");
                this.newLine(ctx);
                this.write(ctx, "\t\t\t\"type\":\"string\",");
                this.newLine(ctx);
                this.write(ctx, "\t\t\t\"default\":\"" + (s == null || s.isEmpty() ? ci.name() : s) + "\"");
                this.newLine(ctx);
                this.write(ctx, "\t\t},");
                this.newLine(ctx);
            }
            if (cat == 1 || cat == 6) {
                String geomType = this.determineGeometryType(ci);
                if (geomType != null) {
                    this.write(ctx, "\t\t\"geometry\":{");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t\t\"$ref\":\"" + geomType + "\"");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t},");
                    this.newLine(ctx);
                }
            } else if (cat == 5 || cat == 8) {
                this.verifyNoGeometry(ci);
            }
            this.write(ctx, "\t\t\"attributes\":{");
            this.newLine(ctx);
            this.write(ctx, "\t\t\t\"title\":\"feature attributes\",");
            this.newLine(ctx);
            this.write(ctx, "\t\t\t\"type\":\"object\",");
            this.newLine(ctx);
            this.write(ctx, "\t\t\t\"properties\":{");
            this.newLine(ctx);
            HashSet<String> st = ci.supertypes();
            if (st != null) {
                for (String sid : st) {
                    ClassInfo cix = this.model.classById(sid);
                    if (cix == null) continue;
                    String cn = cix.name();
                    if (this.notImplemented(cn)) {
                        this.result.addWarning(this, 104, ci.name(), cn);
                        continue;
                    }
                    ctx = this.ProcessProperties(ctx, cix);
                }
            }
            ctx = this.ProcessProperties(ctx, ci);
            this.newLine(ctx);
            this.write(ctx, "\t\t\t}");
            this.newLine(ctx);
            this.write(ctx, "\t\t}");
            this.newLine(ctx);
            this.write(ctx, "\t}");
            if (ctx.links != null) {
                this.write(ctx, ",");
                this.newLine(ctx);
                String[] lines = ctx.links.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.write(ctx, lines[i]);
                    this.newLine(ctx);
                }
                this.write(ctx, "\t]");
            }
            this.newLine(ctx);
            this.write(ctx, "}");
            this.newLine(ctx);
            if (ctx.writer != null) {
                ctx.writer.close();
                this.result.addResult(this.getTargetID(), this.subDirectoryFile.getPath(), ci.name() + ".json", ci.qname());
            }
        }
        catch (IOException e) {
            this.result.addError(this, 11, ci.name() + ".json");
            return;
        }
    }

    private void write(Context ctx, String text) throws IOException {
        if (!this.diagnosticsOnly && ctx != null && ctx.writer != null) {
            ctx.writer.write(text);
        }
    }

    private void newLine(Context ctx) throws IOException {
        if (!this.diagnosticsOnly && ctx != null && ctx.writer != null) {
            ctx.writer.newLine();
        }
    }

    private Context ProcessProperties(Context ctx, ClassInfo ci) throws IOException {
        return this.ProcessProperties(ctx, ci, null, ci.category() != 8);
    }

    private Context ProcessProperties(Context ctx, ClassInfo ci, String propertyPrefix, boolean required) throws IOException {
        for (PropertyInfo propi : ci.properties().values()) {
            Type ti = propi.typeInfo();
            Multiplicity m = propi.cardinality();
            String nam = null;
            nam = propertyPrefix != null ? propertyPrefix + "." + propi.name() : propi.name();
            String type = null;
            String format = null;
            String ref = null;
            String enums = null;
            boolean nillable = false;
            boolean flatten = false;
            MapEntry me = this.options.targetTypeMapEntry(this.getClass().getName(), ti.name, propi.encodingRule("json"));
            if (me != null) {
                if (me.p2.equalsIgnoreCase("geometry")) {
                    this.result.addDebug(this, 10003, propi.inClass().name(), propi.name());
                    continue;
                }
                if (me.p1.startsWith("ref:")) {
                    ref = me.p1.substring(4);
                } else {
                    type = me.p1;
                    if (me.p2.startsWith("format:")) {
                        format = me.p2.substring(7);
                    }
                }
            }
            ClassInfo cix = null;
            if (type == null && ref == null) {
                cix = this.model.classById(ti.id);
                if (cix == null) {
                    if (this.options.matchesEncRule(propi.encodingRule("json"), "geoservices")) {
                        this.result.addWarning(this, 103, propi.inClass().name(), propi.name(), ti.name);
                        type = "string";
                    } else if (this.options.matchesEncRule(propi.encodingRule("json"), "geoservices_extended")) {
                        this.result.addWarning(this, 105, propi.inClass().name(), propi.name(), ti.name);
                        type = "any";
                    }
                } else {
                    int cat = cix.category();
                    if (cat == 2) {
                        if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices")) {
                            type = "string";
                        } else if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices_extended")) {
                            type = "string";
                            format = "uri";
                        }
                    } else if (cat == 3) {
                        type = "string";
                        enums = "[";
                        boolean fst = true;
                        for (PropertyInfo propix : cix.properties().values()) {
                            if (fst) {
                                fst = false;
                            } else {
                                enums = enums + ",";
                            }
                            enums = enums + "\"" + propix.name() + "\"";
                        }
                        enums = enums + "]";
                    } else if (cat == 1 || cat == 6) {
                        if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices")) {
                            type = "integer";
                            String lyrURI = cix.taggedValue("jsonLayerTableURI");
                            if (lyrURI != null) {
                                ctx.links = ctx.links == null ? "\t\"links\":[\n" : ctx.links + ",\n";
                                ctx.links = ctx.links + "\t\t{\n";
                                ctx.links = ctx.links + "\t\t\t\"rel\":\"related\",\n";
                                ctx.links = ctx.links + "\t\t\t\"href\":\"" + lyrURI + "/{#/attributes/" + propi.name() + "}?f=json\"\n";
                                ctx.links = ctx.links + "\t\t}";
                            }
                        } else if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices_extended")) {
                            type = "string";
                            format = "uri";
                        }
                    } else if (cat == 5 || cat == 8) {
                        if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices")) {
                            flatten = true;
                            this.verifyNoGeometry(cix);
                        } else if (this.options.matchesEncRule(cix.encodingRule("json"), "geoservices_extended")) {
                            String refDir;
                            String refBaseURI = cix.pkg().rootPackage().taggedValue("jsonBaseURI");
                            if (refBaseURI == null) {
                                refBaseURI = this.baseURI;
                            }
                            if ((refDir = cix.pkg().rootPackage().taggedValue("jsonDirectory")) == null) {
                                refDir = cix.pkg().rootPackage().taggedValue("xmlns");
                            }
                            if (refDir == null) {
                                refDir = "default";
                            }
                            ref = refBaseURI + "/" + refDir + "/" + cix.name() + ".json";
                        }
                    }
                }
            }
            if (this.options.matchesEncRule(propi.encodingRule("json"), "geoservices_extended") && propi.voidable()) {
                nillable = true;
            }
            int repeat = 1;
            boolean array = false;
            if (type != null || ref != null || flatten) {
                String n;
                if (m.maxOccurs > 1) {
                    if (this.options.matchesEncRule(propi.encodingRule("json"), "geoservices")) {
                        repeat = 3;
                    } else if (this.options.matchesEncRule(propi.encodingRule("json"), "geoservices_extended")) {
                        array = true;
                    }
                }
                if (flatten && cix != null) {
                    for (int i = 1; i <= repeat; ++i) {
                        n = nam;
                        if (repeat > 1) {
                            n = n + "-" + i;
                        }
                        this.ProcessProperties(ctx, cix, n, required && m.minOccurs > 0 && cix.category() != 8);
                    }
                    continue;
                }
                for (int i = 1; i <= repeat; ++i) {
                    if (!ctx.first) {
                        this.write(ctx, ",");
                        this.newLine(ctx);
                    } else {
                        ctx.first = false;
                    }
                    n = nam;
                    if (repeat > 1) {
                        n = n + "-" + i;
                    }
                    this.write(ctx, "\t\t\t\t\"" + n + "\":{");
                    this.newLine(ctx);
                    String s = propi.aliasName();
                    this.write(ctx, "\t\t\t\t\t\"title\":\"" + (s == null || s.isEmpty() ? propi.name() : s) + "\",");
                    this.newLine(ctx);
                    if (this.includeDocumentation && !propi.documentation().isEmpty()) {
                        this.write(ctx, "\t\t\t\t\t\"description\":\"" + propi.documentation().trim() + "\",");
                        this.newLine(ctx);
                    }
                    if (array) {
                        if (nillable && i == 1) {
                            this.write(ctx, "\t\t\t\t\t\"type\":[\"array\",\"null\"],");
                        } else {
                            this.write(ctx, "\t\t\t\t\t\"type\":\"array\",");
                        }
                        this.newLine(ctx);
                        this.write(ctx, "\t\t\t\t\t\"items\":{");
                        this.newLine(ctx);
                        if (ref != null) {
                            this.write(ctx, "\t\t\t\t\t\t\"$ref\":\"" + ref + "\"");
                            this.newLine(ctx);
                        } else {
                            this.write(ctx, "\t\t\t\t\t\t\"type\":\"" + type + "\"");
                            if (format != null) {
                                this.write(ctx, ",");
                                this.newLine(ctx);
                                this.write(ctx, "\t\t\t\t\t\t\"format\":\"" + format + "\"");
                            }
                            if (enums != null) {
                                this.write(ctx, ",");
                                this.newLine(ctx);
                                this.write(ctx, "\t\t\t\t\t\t\"enum\":" + enums + "");
                            }
                            if (m.minOccurs > 0 && required) {
                                this.write(ctx, ",");
                                this.newLine(ctx);
                                this.write(ctx, "\t\t\t\t\t\t\"minItems\":\"" + m.minOccurs + "\"");
                            }
                            this.newLine(ctx);
                        }
                        this.write(ctx, "\t\t\t\t\t}");
                        this.newLine(ctx);
                    } else if (ref != null) {
                        this.write(ctx, "\t\t\t\t\t\"$ref\":\"" + ref + "\"");
                        this.newLine(ctx);
                    } else {
                        if (nillable && i == 1) {
                            this.write(ctx, "\t\t\t\t\t\"type\":[\"" + type + "\",\"null\"]");
                        } else {
                            this.write(ctx, "\t\t\t\t\t\"type\":\"" + type + "\"");
                        }
                        if (format != null) {
                            this.write(ctx, ",");
                            this.newLine(ctx);
                            this.write(ctx, "\t\t\t\t\t\"format\":\"" + format + "\"");
                        }
                        if (enums != null) {
                            this.write(ctx, ",");
                            this.newLine(ctx);
                            this.write(ctx, "\t\t\t\t\t\"enum\":" + enums + "");
                        }
                        if (m.minOccurs > 0 && i == 1 && required) {
                            this.write(ctx, ",");
                            this.newLine(ctx);
                            this.write(ctx, "\t\t\t\t\t\"required\":true");
                        }
                        this.newLine(ctx);
                    }
                    this.write(ctx, "\t\t\t\t}");
                    if (!nillable || i != 1) continue;
                    this.write(ctx, ",");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t\t\t\"" + n + "_nullReason\":{");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t\t\t\t\"title\":\"Reason for null value in property " + (s == null || s.isEmpty() ? propi.name() : s) + "\",");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t\t\t\t\"type\":\"string\"");
                    this.newLine(ctx);
                    this.write(ctx, "\t\t\t\t}");
                }
                continue;
            }
            this.result.addWarning(this, 103, propi.inClass().name(), propi.name(), ti.name);
        }
        return ctx;
    }

    private String determineGeometryType(ClassInfo ci) {
        if (ci == null) {
            return null;
        }
        if (ci.pkg() == null) {
            return null;
        }
        if (this.contexts.containsKey(ci.qname())) {
            return this.contexts.get(ci.qname());
        }
        String geomType = null;
        ClassInfo cibase = ci.baseClass();
        if (cibase != null) {
            geomType = this.contexts.get(cibase.qname());
            this.contexts.put(ci.qname(), geomType);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            geomType = this.determineGeometryType(ci, propi);
        }
        return geomType;
    }

    private String determineGeometryType(ClassInfo ci, PropertyInfo propi) {
        String geomType = this.contexts.get(ci.qname());
        if (!propi.isNavigable()) {
            return geomType;
        }
        if (propi.isRestriction()) {
            return geomType;
        }
        Multiplicity m = propi.cardinality();
        if (m.maxOccurs < 1) {
            return geomType;
        }
        String type = propi.typeInfo().name;
        MapEntry me = this.options.targetTypeMapEntry(this.getClass().getName(), type, propi.encodingRule("json"));
        if (me != null && me.p2.equalsIgnoreCase("geometry")) {
            if (m.maxOccurs > 1) {
                this.result.addWarning(this, 102, propi.name(), propi.inClass().name());
            }
            if (geomType == null) {
                geomType = me.p1.substring(4);
                this.contexts.put(ci.qname(), geomType);
            } else {
                this.result.addWarning(this, 101, propi.name(), propi.inClass().name());
            }
        }
        return geomType;
    }

    private void verifyNoGeometry(ClassInfo ci) {
        if (ci == null) {
            return;
        }
        if (ci.pkg() == null) {
            return;
        }
        for (PropertyInfo propi : ci.properties().values()) {
            this.verifyNoGeometry(ci, propi);
        }
    }

    private void verifyNoGeometry(ClassInfo ci, PropertyInfo propi) {
        if (!propi.isNavigable()) {
            return;
        }
        if (propi.isRestriction()) {
            return;
        }
        Multiplicity m = propi.cardinality();
        if (m.maxOccurs < 1) {
            return;
        }
        String type = propi.typeInfo().name;
        MapEntry me = this.options.targetTypeMapEntry(this.getClass().getName(), type, propi.encodingRule("json"));
        if (me != null && me.p2.equalsIgnoreCase("geometry")) {
            this.result.addWarning(this, 106, propi.name(), propi.inClass().name());
        }
    }

    public void write() {
    }

    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "JSON Schema Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 10: {
                return "System error: Exception raised '$1$'. '$2$'";
            }
            case 11: {
                return "Error opening or writing to file '$1$'. The class is skipped.";
            }
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 100: {
                return "??Unknown geometry type '$1$' in property '$2$' in class '$3$'. This geometry property will be ignored.";
            }
            case 101: {
                return "??More than one geometry property specified for type '$2$'. The geometry property '$1$' will be ignored.";
            }
            case 102: {
                return "??The geometry property '$1$' in type '$2$' has a multiplicity greater than one, the multiplicity will be ignored.";
            }
            case 103: {
                return "??No JSON representation known for type '$3$' of property '$2$' in class '$1$'; 'string' will be used.";
            }
            case 104: {
                return "??No JSON representation known for type '$2$' which is a subtype of '$1$'. The supertype is ignored.";
            }
            case 105: {
                return "??No JSON representation known for type '$3$' of property '$2$' in class '$1$'; 'any' will be used.";
            }
            case 106: {
                return "??A geometry property is specified for data type '$2$', but data types may not have geometry properties. The geometry property '$1$' will be ignored.";
            }
            case 10001: {
                return "Generating JSON schemas for application schema $1$.";
            }
            case 10002: {
                return "Diagnostics-only mode. All output to files is suppressed.";
            }
            case 10003: {
                return "??Property '$2$' in class '$1$' is a geometry property and will be ignored.";
            }
        }
        return null;
    }

    public int getTargetID() {
        return 7;
    }

    private class Context {
        protected String links = null;
        protected boolean first = true;
        protected BufferedWriter writer = null;

        private Context() {
        }
    }
}

