/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Xmi10.AssociationInfoXmi10;
import de.interactive_instruments.ShapeChange.Model.Xmi10.ClassInfoXmi10;
import de.interactive_instruments.ShapeChange.Model.Xmi10.PackageInfoXmi10;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import de.interactive_instruments.ShapeChange.ShapeChangeIgnoreClassException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xmi10Document
extends ModelImpl
implements Model {
    public Document document = null;
    protected String dtd = "";
    public ShapeChangeResult result = null;
    public Options options = null;
    protected HashMap<String, String> fTaggedValues = new HashMap();
    protected HashMap<String, String> fStereotypes = new HashMap();
    protected HashMap<String, HashSet<String>> fSupertypes = new HashMap();
    protected HashMap<String, HashSet<String>> fSubtypes = new HashMap();
    protected HashMap<String, Element> fTypes = new HashMap();
    protected HashMap<String, Element> fSchemas = new HashMap();
    protected HashMap<String, AssociationInfo> fAssociations = new HashMap();
    protected HashMap<String, Vector<PropertyInfo>> fRoles = new HashMap();
    protected HashMap<String, PackageInfo> fPackages = new HashMap();
    protected HashMap<String, ClassInfo> fClasses = new HashMap();
    protected HashMap<String, ClassInfo> fClassnames = new HashMap();
    protected HashMap<String, Multiplicity> fClassesRoseHiddenCardinality = new HashMap();
    public HashMap<String, String> fClassesRoseHiddenLabels = new HashMap();
    protected HashMap<String, UUID> fUUIDs = new HashMap();
    protected int globalSequenceNumber = -2147483647;

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String xmifile) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        this.open(xmifile);
        this.verify();
        this.cleanupDOM();
        this.initTaggedValuesMap();
        this.initStereotypesMap();
        this.initSubSupertypesMap();
        this.initTypesMap();
        this.initAssociations();
        this.initPackages();
        this.initClasses();
        HashSet<PackageInfo> schemas = this.schemas("");
        for (PackageInfo pi : schemas) {
            this.options.addSchemaLocation(pi.targetNamespace(), pi.xsdDocument());
        }
    }

    public void open(String xmlfile) throws ShapeChangeAbortException {
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler errorHandler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            builder = factory.newDocumentBuilder();
            errorHandler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(errorHandler);
        }
        catch (FactoryConfigurationError e) {
            this.result.addFatalError(null, 1);
            throw new ShapeChangeAbortException();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            throw new ShapeChangeAbortException();
        }
        try {
            this.document = builder.parse(xmlfile);
            if (errorHandler.errorsFound()) {
                this.result.addFatalError(null, 3);
                throw new ShapeChangeAbortException();
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        DocumentType dt = this.document.getDoctype();
        this.dtd = dt == null ? "" : dt.getName();
    }

    @Override
    public String characterEncoding() {
        String xmlCharacterEncoding = this.document.getXmlEncoding();
        if (xmlCharacterEncoding == null) {
            xmlCharacterEncoding = "UTF-8";
        }
        return xmlCharacterEncoding;
    }

    protected String textValue(Node n) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n2 = nl.item(i);
            if (n2.getNodeType() != 3) continue;
            return n2.getNodeValue();
        }
        return null;
    }

    protected void verify() throws ShapeChangeAbortException {
        String s;
        Element e;
        if (this.document.getDoctype() == null) {
            this.result.addFatalError(null, 16);
            throw new ShapeChangeAbortException();
        }
        NodeList nl = this.document.getElementsByTagName("XMI");
        if (nl.getLength() == 1) {
            e = (Element)nl.item(0);
            s = e.getAttribute("xmi.version");
            if (!s.equals("1.0")) {
                this.result.addFatalError(null, 4, s);
                throw new ShapeChangeAbortException();
            }
        } else {
            this.result.addFatalError(null, 5);
            throw new ShapeChangeAbortException();
        }
        nl = this.document.getElementsByTagName("XMI.metamodel");
        if (nl.getLength() == 1) {
            e = (Element)nl.item(0);
            s = e.getAttribute("xmi.name");
            if (!s.equals("UML")) {
                this.result.addFatalError(null, 6, s);
                throw new ShapeChangeAbortException();
            }
            s = e.getAttribute("xmi.version");
            if (s.equals("1.4")) {
                this.result.addWarning(null, 1000);
            } else if (!s.equals("1.3")) {
                this.result.addFatalError(null, 7, s);
                throw new ShapeChangeAbortException();
            }
        } else {
            this.result.addFatalError(null, 8);
            throw new ShapeChangeAbortException();
        }
    }

    protected void cleanupDOM() {
        if (this.options.eaIncludeExtentsions) {
            return;
        }
        try {
            Node p;
            Node n;
            int j;
            NodeList elements = this.document.getElementsByTagName("XMI.extensions");
            for (j = 0; j < elements.getLength(); ++j) {
                n = elements.item(j);
                p = n.getParentNode();
                n = p.removeChild(n);
            }
            elements = this.document.getElementsByTagName("XMI.difference");
            for (j = 0; j < elements.getLength(); ++j) {
                n = elements.item(j);
                p = n.getParentNode();
                n = p.removeChild(n);
            }
            this.document.normalize();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    protected String idrefValue(Node n) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n2 = nl.item(i);
            if (n2.getNodeType() != 1) continue;
            return ((Element)n2).getAttribute("xmi.idref");
        }
        return "";
    }

    protected Element getElementById(String id) {
        return this.document.getElementById(id);
    }

    protected String idOfProperty(Element elmt, String child) {
        NodeList nl1 = elmt.getChildNodes();
        for (int j = 0; j < nl1.getLength(); ++j) {
            Node n2;
            Node n1 = nl1.item(j);
            if (n1.getNodeType() != 1 || !n1.getNodeName().equals(child) || (n2 = n1.getFirstChild()) == null || n2.getNodeType() != 1) continue;
            String id = ((Element)n2).getAttribute("xmi.id");
            if (id.equals("")) {
                id = ((Element)n2).getAttribute("xmi.idref");
            }
            return id;
        }
        return "";
    }

    protected Element elementOfProperty(Element elmt, String child) {
        NodeList nl1 = elmt.getChildNodes();
        for (int j = 0; j < nl1.getLength(); ++j) {
            Node n2;
            Node n1 = nl1.item(j);
            if (n1.getNodeType() != 1 || !n1.getNodeName().equals(child) || (n2 = n1.getFirstChild()) == null || n2.getNodeType() != 1) continue;
            String id = ((Element)n2).getAttribute("xmi.idref");
            if (id.equals("")) {
                return (Element)n2;
            }
            return this.document.getElementById(id);
        }
        return null;
    }

    protected Vector<String> idsOfProperty(Element elmt, String child) {
        Vector<String> ids = new Vector<String>();
        NodeList nl1 = elmt.getChildNodes();
        for (int j = 0; j < nl1.getLength(); ++j) {
            Node n2;
            Node n1 = nl1.item(j);
            if (n1.getNodeType() != 1) continue;
            String name1 = n1.getNodeName();
            if (name1.equals(child)) {
                NodeList nl2 = n1.getChildNodes();
                for (int k = 0; k < nl2.getLength(); ++k) {
                    Node n22 = nl2.item(k);
                    if (n22.getNodeType() != 1) continue;
                    String id = ((Element)n22).getAttribute("xmi.id");
                    if (id.equals("")) {
                        id = ((Element)n22).getAttribute("xmi.idref");
                    }
                    ids.add(id);
                }
                continue;
            }
            if (!name1.equals("Foundation.Core.Namespace.ownedElement") || (n2 = n1.getFirstChild()) == null) continue;
            String name2 = n2.getNodeName();
            if (name2.equals("Foundation.Core.Primitive")) {
                ids.addAll(this.idsOfProperty((Element)n2, child));
            }
            if (!name2.equals("Foundation.Core.Enumeration")) continue;
            ids.addAll(this.idsOfProperty((Element)n2, child));
        }
        return ids;
    }

    protected String textOfProperty(Element e, String property) {
        NodeList nl = e.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node n1 = nl.item(j);
            if (n1.getNodeType() != 1) continue;
            String nam = n1.getNodeName();
            if (nam.equals(property)) {
                return this.textValue(n1);
            }
            if (!nam.equals("Foundation.Core.Namespace.ownedElement")) continue;
            Node n2 = n1.getFirstChild();
            nam = n2.getNodeName();
            if (nam.equals("Foundation.Core.Primitive")) {
                return this.textOfProperty((Element)n2, property);
            }
            if (!nam.equals("Foundation.Core.Enumeration")) continue;
            return this.textOfProperty((Element)n2, property);
        }
        return null;
    }

    protected String attributeOfProperty(Element elmt, String child, String att) {
        NodeList nl1 = elmt.getChildNodes();
        for (int j = 0; j < nl1.getLength(); ++j) {
            Node n1 = nl1.item(j);
            if (n1.getNodeType() != 1) continue;
            String name1 = n1.getNodeName();
            if (name1.equals(child)) {
                return ((Element)n1).getAttribute(att);
            }
            if (!name1.equals("Foundation.Core.Namespace.ownedElement")) continue;
            Node n2 = n1.getFirstChild();
            String name2 = n2.getNodeName();
            if (name2.equals("Foundation.Core.Primitive")) {
                return this.attributeOfProperty((Element)n2, child, att);
            }
            if (!name2.equals("Foundation.Core.Enumeration")) continue;
            return this.attributeOfProperty((Element)n2, child, att);
        }
        return "";
    }

    protected Element firstChildElement(Element elmt) {
        NodeList nl1 = elmt.getChildNodes();
        for (int j = 0; j < nl1.getLength(); ++j) {
            Node n1 = nl1.item(j);
            if (n1.getNodeType() != 1) continue;
            return (Element)n1;
        }
        return null;
    }

    protected boolean visible(Element e) {
        if (e == null) {
            return false;
        }
        if (this.options.parameter("publicOnly").equals("true") && !"public".equals(this.attributeOfProperty(e, "Foundation.Core.ModelElement.visibility", "xmi.value")) && !"".equals(this.attributeOfProperty(e, "Foundation.Core.ModelElement.visibility", "xmi.value"))) {
            return false;
        }
        String stereotype = this.fStereotypes.get(e.getAttribute("xmi.id"));
        return stereotype == null || !stereotype.equals("_ShapeChangeIgnore_");
    }

    public String taggedValue(String idref, String tag) {
        String key = tag + "###" + idref;
        String res = this.fTaggedValues.get(key);
        if (this.options.eaBugFixWrongID && res == null) {
            if (idref.startsWith("EAID")) {
                res = this.fTaggedValues.get(tag + "###EAPK" + idref.substring(4));
            } else if (idref.startsWith("EAPK")) {
                res = this.fTaggedValues.get(tag + "###EAID" + idref.substring(4));
            }
        }
        return res;
    }

    public HashMap<String, String> taggedValues(String idref) {
        HashMap<String, String> taggedValuesforIdref = new HashMap<String, String>();
        for (String key : this.fTaggedValues.keySet()) {
            String value = this.fTaggedValues.get(key);
            String tmpKey = "###" + idref;
            if (this.options.eaBugFixWrongID) {
                if (idref.startsWith("EAID")) {
                    tmpKey = "###EAPK" + idref.substring(4);
                } else if (idref.startsWith("EAPK")) {
                    tmpKey = "###EAID" + idref.substring(4);
                }
            }
            if (!key.endsWith(tmpKey)) continue;
            taggedValuesforIdref.put(key.substring(0, key.indexOf(tmpKey)), value);
        }
        return taggedValuesforIdref;
    }

    protected Vector<String> getOwnerId(Element e) {
        Element owner = (Element)e.getParentNode().getParentNode();
        String id = owner.getAttribute("xmi.id");
        Vector<String> v = new Vector<String>();
        if (id != null) {
            v.add(id);
        }
        return v;
    }

    protected String getOwnerIdAsString(Element e) {
        Element owner = (Element)e.getParentNode().getParentNode();
        String id = owner.getAttribute("xmi.id");
        if (id == null) {
            id = "";
        }
        return id;
    }

    protected boolean notAReference(Element e) {
        return !e.getAttribute("xmi.id").equals("");
    }

    protected boolean isOwnerOfEnumeration(Element elmt) {
        Node n2;
        String name2;
        Node n1 = elmt.getFirstChild();
        String name1 = n1.getNodeName();
        return name1.equals("Foundation.Core.Namespace.ownedElement") && (name2 = (n2 = n1.getFirstChild()).getNodeName()).equals("Foundation.Core.Enumeration");
    }

    protected void initTaggedValuesMap() {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Extension_Mechanisms.TaggedValue");
        for (int j = 0; j < nl1.getLength(); ++j) {
            String t;
            Node n1 = nl1.item(j);
            NodeList nl2 = n1.getChildNodes();
            String tag = "";
            String value = "";
            String id = "";
            for (int k = 0; k < nl2.getLength(); ++k) {
                Node n2 = nl2.item(k);
                if (n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.tag" || n2.getNodeName() == "Foundation.Core.ModelElement.name") {
                    tag = this.textValue(n2);
                }
                if (n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.value" || n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.dataValue") {
                    value = this.textValue(n2);
                }
                if (n2.getNodeName() != "Foundation.Extension_Mechanisms.TaggedValue.modelElement") continue;
                id = this.idrefValue(n2);
            }
            if (value == null || value.equals("")) continue;
            if (id.equals("")) {
                Element parent = (Element)n1.getParentNode().getParentNode();
                id = parent.getAttribute("xmi.id");
            }
            if ((t = this.normalizeTaggedValue(tag)) == null) continue;
            this.fTaggedValues.put(tag + "###" + id, value);
            this.result.addDebug(null, 10000, tag, id, value);
        }
    }

    protected void initStereotypesMap() {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Extension_Mechanisms.Stereotype");
        for (int j = 0; j < nl1.getLength(); ++j) {
            Vector<String> ids;
            int i;
            Element n1 = (Element)nl1.item(j);
            String id2 = n1.getAttribute("xmi.id");
            if (id2.equals("")) continue;
            String name = this.textOfProperty(n1, "Foundation.Core.ModelElement.name");
            String baseClass = this.textOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.baseClass");
            String s2 = this.options.stereotypeAlias(name);
            if (s2 != null) {
                name = s2;
            }
            if (name.equals("")) continue;
            boolean found = false;
            if (baseClass.equals("Class")) {
                for (i = 0; i < Options.classStereotypes.length; ++i) {
                    if (!name.toLowerCase().equals(Options.classStereotypes[i])) continue;
                    ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                    if (ids.size() == 0) {
                        ids = this.getOwnerId(n1);
                    }
                    for (String s2 : ids) {
                        this.fStereotypes.put(s2, name);
                        this.result.addDebug(null, 10019, name, s2);
                    }
                    found = true;
                    break;
                }
            }
            if (baseClass.equals("Association")) {
                for (i = 0; i < Options.assocStereotypes.length; ++i) {
                    if (!name.toLowerCase().equals(Options.assocStereotypes[i])) continue;
                    ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                    if (ids.size() == 0) {
                        ids = this.getOwnerId(n1);
                    }
                    for (String s2 : ids) {
                        this.fStereotypes.put(s2, name);
                        this.result.addDebug(null, 10019, name, s2);
                    }
                    found = true;
                    break;
                }
            }
            if (baseClass.equals("Package") || baseClass.equals("ClassifierRole")) {
                for (i = 0; i < Options.packageStereotypes.length; ++i) {
                    if (!name.toLowerCase().equals(Options.packageStereotypes[i])) continue;
                    ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                    if (ids.size() == 0) {
                        ids = this.getOwnerId(n1);
                    }
                    for (String s2 : ids) {
                        this.fStereotypes.put(s2, name);
                        this.result.addDebug(null, 10019, name, s2);
                        Element e1 = this.document.getElementById(s2);
                        if (e1 == null) continue;
                        String ename = this.textOfProperty(e1, "Foundation.Core.ModelElement.name");
                        this.result.addDebug(null, 10020, ename);
                        this.fSchemas.put(ename, e1);
                    }
                    found = true;
                    break;
                }
            }
            if (baseClass.equals("Dependency")) {
                for (i = 0; i < Options.depStereotypes.length; ++i) {
                    if (!name.toLowerCase().equals(Options.depStereotypes[i])) continue;
                    ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                    if (ids.size() == 0) {
                        ids = this.getOwnerId(n1);
                    }
                    for (String s2 : ids) {
                        this.fStereotypes.put(s2, name);
                        this.result.addDebug(null, 10019, name, s2);
                    }
                    found = true;
                    break;
                }
            }
            if (baseClass.equals("Attribute") || baseClass.equals("AssociationEnd")) {
                for (i = 0; i < Options.propertyStereotypes.length; ++i) {
                    if (!name.toLowerCase().equals(Options.propertyStereotypes[i])) continue;
                    ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                    if (ids.size() == 0) {
                        ids = this.getOwnerId(n1);
                    }
                    for (String s2 : ids) {
                        this.fStereotypes.put(s2, name);
                        this.result.addDebug(null, 10019, name, s2);
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.result.addWarning(null, 1005, name, baseClass);
            Vector<String> ids2 = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
            for (String id2 : ids2) {
                this.fStereotypes.put(id2, "_ShapeChangeIgnore_");
                Element e1 = this.document.getElementById(id2);
                name = e1 != null ? this.textOfProperty(e1, "Foundation.Core.ModelElement.name") : "";
                if (name == null || name.equals("")) {
                    name = "(unknown)";
                }
                this.result.addWarning(null, 1006, baseClass, name);
            }
        }
    }

    protected void initSubSupertypesMap() {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Core.Generalization");
        for (int j = 0; j < nl1.getLength(); ++j) {
            Element n1 = (Element)nl1.item(j);
            String id = n1.getAttribute("xmi.id");
            if (!this.visible(n1)) continue;
            String disc = this.textOfProperty(n1, "Foundation.Core.Generalization.discriminator");
            if (disc != null && !disc.equals("")) {
                this.result.addWarning(null, 1007, id);
                continue;
            }
            Vector<String> childs = this.idsOfProperty(n1, "Foundation.Core.Generalization.child");
            Vector<String> parents = this.idsOfProperty(n1, "Foundation.Core.Generalization.parent");
            Iterator<String> idx = childs.iterator();
            while (idx.hasNext()) {
                Iterator<String> jdx = parents.iterator();
                while (jdx.hasNext()) {
                    String child = idx.next();
                    String parent = jdx.next();
                    if (this.fSubtypes.containsKey(parent)) {
                        ((Set)this.fSubtypes.get(parent)).add(child);
                    } else {
                        HashSet<String> s2 = new HashSet<String>();
                        s2.add(child);
                        this.fSubtypes.put(parent, s2);
                    }
                    if (this.fSupertypes.containsKey(child)) {
                        ((Set)this.fSupertypes.get(child)).add(parent);
                        continue;
                    }
                    HashSet<String> s1 = new HashSet<String>();
                    s1.add(parent);
                    this.fSupertypes.put(child, s1);
                }
            }
        }
    }

    protected void initTypesMap() throws ShapeChangeAbortException {
        String tname;
        Element e;
        int j;
        NodeList nl = this.document.getElementsByTagName("Foundation.Core.DataType");
        for (j = 0; j < nl.getLength(); ++j) {
            e = (Element)nl.item(j);
            tname = this.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (tname == null) continue;
            this.fTypes.put(tname.trim(), e);
        }
        nl = this.document.getElementsByTagName("Foundation.Core.Class");
        for (j = 0; j < nl.getLength(); ++j) {
            e = (Element)nl.item(j);
            tname = this.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (tname == null) continue;
            this.fTypes.put(tname.trim(), e);
        }
    }

    protected void initAssociations() throws ShapeChangeAbortException {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Core.Association");
        for (int j = 0; j < nl1.getLength(); ++j) {
            AssociationInfoXmi10 ai = new AssociationInfoXmi10(this, (Element)nl1.item(j));
            if (ai == null) continue;
            this.fAssociations.put(ai.id(), ai);
        }
    }

    private void addPackageElements(NodeList nl) throws ShapeChangeAbortException {
        for (int j = 0; j < nl.getLength(); ++j) {
            Element e = (Element)nl.item(j);
            if (!this.visible(e) && !this.options.eaBugFixPublicPackagesAreMarkedAsPrivate || !this.notAReference(e)) continue;
            PackageInfoXmi10 pi = new PackageInfoXmi10(this, e);
            this.fPackages.put(pi.id(), pi);
        }
    }

    protected void initPackages() throws ShapeChangeAbortException {
        Element root = this.document.getDocumentElement();
        this.addPackageElements(root.getElementsByTagName("Model_Management.Model"));
        this.addPackageElements(root.getElementsByTagName("Model_Management.Package"));
    }

    private void addClassElements(NodeList nl) throws ShapeChangeAbortException {
        for (int j = 0; j < nl.getLength(); ++j) {
            Element e = (Element)nl.item(j);
            if (!this.visible(e) || !this.notAReference(e)) continue;
            try {
                String rl;
                ClassInfoXmi10 ci = new ClassInfoXmi10(this, e);
                this.fClasses.put(ci.id(), ci);
                Multiplicity rm = ci.roseHiddenCardinality();
                if (rm != null) {
                    this.fClassesRoseHiddenCardinality.put(ci.id(), rm);
                }
                if ((rl = ci.roseHiddenLabels()) != null) {
                    this.fClassesRoseHiddenLabels.put(ci.id(), rl);
                }
                if (!this.options.roseBugFixDuplicateGlobalDataTypes) continue;
                ClassInfo ci2 = this.fClassnames.get(ci.name());
                if (ci2 != null) {
                    if (ci.id().startsWith("G.")) {
                        this.fClasses.put(ci.id(), ci2);
                        this.result.addDebug(null, 10018, ci.name() + " (" + ci.id() + ")", ci2.name() + " (" + ci2.id() + ")");
                    }
                    if (!ci2.id().startsWith("G.")) continue;
                    this.fClasses.put(ci2.id(), ci);
                    this.fClassnames.put(ci.name(), ci);
                    this.result.addDebug(null, 10018, ci2.name() + " (" + ci2.id() + ")", ci.name() + " (" + ci.id() + ")");
                    continue;
                }
                this.fClassnames.put(ci.name(), ci);
                continue;
            }
            catch (ShapeChangeIgnoreClassException ice) {
                // empty catch block
            }
        }
    }

    protected void initClasses() throws ShapeChangeAbortException {
        this.result.addDebug("Processing Classes...");
        Element root = this.document.getDocumentElement();
        this.addClassElements(root.getElementsByTagName("Foundation.Core.Class"));
        this.addClassElements(root.getElementsByTagName("Foundation.Core.Interface"));
        this.addClassElements(root.getElementsByTagName("Foundation.Core.DataType"));
        if (this.options.eaIncludeExtentsions) {
            this.addClassElements(root.getElementsByTagName("Foundation.Core.ModelElement"));
        }
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfo pi : this.fPackages.values()) {
            if (!pi.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (!pi.name().equals(name)) continue;
                res.add(this.fPackages.get(pi.id()));
                continue;
            }
            res.add(this.fPackages.get(pi.id()));
        }
        return res;
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.fPackages.get(id);
    }

    @Override
    public ClassInfo classById(String id) {
        return this.fClasses.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return this.fClassnames.get(nam);
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        for (Map.Entry<String, ClassInfo> entry : this.fClasses.entrySet()) {
            ClassInfo ci;
            String ky;
            if (this.options.roseBugFixDuplicateGlobalDataTypes && (ky = entry.getKey()).startsWith("G.") || (ci = entry.getValue()) == null) continue;
            if (pi == null) {
                res.add(ci);
                continue;
            }
            if (!ci.inSchema(pi)) continue;
            res.add(ci);
        }
        return res;
    }

    protected Multiplicity cardinalityFromString(String multiplicityRanges) {
        String[] ranges = multiplicityRanges.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < ranges.length; ++i) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].equals("n") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        this.result.addWarning(null, 1003, minmax[1]);
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0 || ranges[i].equals("*") || ranges[i].equals("n")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    this.result.addWarning(null, 1003, ranges[i]);
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper <= maxv) continue;
            maxv = upper;
        }
        Multiplicity m = new Multiplicity();
        m.minOccurs = minv;
        m.maxOccurs = maxv;
        return m;
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public void shutdown() {
    }
}

