/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;

public abstract class InfoImpl
implements Info {
    boolean postprocessed = false;
    protected String documentation = null;
    protected String aliasName = null;
    protected String definition = null;
    protected String description = null;

    public String aliasName() {
        if (this.aliasName == null) {
            String s = this.taggedValue("alias");
            if (s == null || s.isEmpty()) {
                s = this.documentation();
                String[] ss = s.split("[-]+- Definition -[-]+");
                s = (s = ss[0]).contains("-- Name --") ? s.replaceAll("[-]+- Name -[-]+", "") : "";
            }
            if (s != null) {
                s = s.trim();
            }
            this.aliasName = s;
        }
        return this.aliasName;
    }

    public String documentation() {
        if (this.documentation == null) {
            String s = this.taggedValue("documentation");
            if (s == null && (s = this.taggedValue("description")) == null) {
                s = "";
            }
            this.documentation = s;
        }
        return this.documentation;
    }

    public String encodingRule(String platform) {
        String s = this.taggedValue(platform + "EncodingRule");
        if (s == null || s.isEmpty()) {
            if (platform.equalsIgnoreCase("xsd")) {
                s = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule");
                if (s == null) {
                    s = Options.ISO19136_2007;
                }
            } else if (platform.equalsIgnoreCase("json")) {
                s = this.options().parameter("de.interactive_instruments.ShapeChange.Target.JSON.JsonSchema", "defaultEncodingRule");
                if (s == null) {
                    s = "geoservices";
                }
            } else if (platform.equalsIgnoreCase("rdf")) {
                s = this.options().parameter("de.interactive_instruments.ShapeChange.Target.Ontology.RDF", "defaultEncodingRule");
                if (s == null) {
                    s = "*";
                }
            } else if (platform.equalsIgnoreCase("fc") && (s = this.options().parameter(" de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.FeatureCatalogue", "defaultEncodingRule")) == null) {
                s = "*";
            }
        }
        if (s != null) {
            s = s.toLowerCase();
        }
        return s;
    }

    public boolean matches(String rule) {
        String param;
        String encRule = null;
        String[] ra = rule.toLowerCase().split("-", 4);
        if (ra.length != 4) {
            this.result().addError(null, 21, rule);
            return false;
        }
        if (!this.options().hasRule(rule)) {
            this.result().addError(null, 164, rule);
            return false;
        }
        if (ra[0].equals("rule") && !ra[1].equals("all") && !this.options().targetMode(this.options().targetClassName(rule)).equals("enabled")) {
            return false;
        }
        if (ra[0].matches("re[cq]") && !ra[1].equals("all") && this.options().targetMode(this.options().targetClassName(rule)).equals("disabled")) {
            return false;
        }
        if (!ra[2].equals("all")) {
            if (ra[2].equals("pkg")) {
                if (!(this instanceof PackageInfo)) {
                    return false;
                }
            } else if (ra[2].equals("cls")) {
                if (!(this instanceof ClassInfo)) {
                    return false;
                }
            } else if (ra[2].equals("prop")) {
                if (!(this instanceof PropertyInfo)) {
                    return false;
                }
            } else if (ra[2].equals("rel")) {
                if (!(this instanceof AssociationInfo)) {
                    return false;
                }
            } else if (ra[2].equals("op")) {
                if (!(this instanceof OperationInfo)) {
                    return false;
                }
            } else {
                this.result().addError(null, 21, rule);
                return false;
            }
        }
        if (rule.equals("rule-xsd-all-no-documentation") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation")) != null && param.equals("false")) {
            return true;
        }
        if (rule.equals("rule-xsd-cls-local-enumeration") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "enumStyle")) != null && param.equalsIgnoreCase("local")) {
            return true;
        }
        if (rule.equals("rule-xsd-cls-local-basictype") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "basicTypeStyle")) != null && param.equalsIgnoreCase("local")) {
            return true;
        }
        if (rule.equals("rule-xsd-pkg-schematron") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "schematron")) != null && param.equalsIgnoreCase("true")) {
            return true;
        }
        if (rule.equals("rule-xsd-prop-exclude-derived") && (param = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDerivedProperties")) != null && param.equalsIgnoreCase("false")) {
            return true;
        }
        if (ra[1].equals("all")) {
            boolean res = false;
            encRule = this.encodingRule("xsd");
            if (encRule != null) {
                boolean bl = res = res || this.options().hasRule(rule, encRule);
            }
            if ((encRule = this.encodingRule("json")) != null) {
                boolean bl = res = res || this.options().hasRule(rule, encRule);
            }
            if ((encRule = this.encodingRule("rdf")) != null) {
                boolean bl = res = res || this.options().hasRule(rule, encRule);
            }
            if ((encRule = this.encodingRule("fc")) != null) {
                res = res || this.options().hasRule(rule, encRule);
            }
            return res;
        }
        encRule = this.encodingRule(ra[1]).toLowerCase();
        if (encRule != null) {
            return this.options().hasRule(rule, encRule);
        }
        return false;
    }

    public void postprocessAfterLoadingAndValidate() {
    }

    public String definition() {
        if (this.definition == null) {
            String doc = this.documentation();
            String[] ss = doc.split("[-]+- Description -[-]+");
            if ((doc = ss[0]).contains("-- Definition --")) {
                ss = doc.split("[-]+- Definition -[-]+");
                doc = ss[1];
                doc = doc.replaceAll("[-]+- Definition -[-]+", "");
            }
            if (doc.contains("-- Name --")) {
                ss = doc.split("[-]+- Name -[-]+");
                doc = ss[0];
            }
            this.definition = doc.trim();
        }
        return this.definition;
    }

    public String description() {
        String[] ss;
        String doc;
        if (this.description == null && (doc = this.documentation()).contains("-- Description --") && (ss = doc.split("[-]+- Description -[-]+")).length > 1) {
            doc = ss[1];
            this.description = doc.trim();
        }
        return this.description;
    }
}

