/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Info;
import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.OclConstraint;
import de.interactive_instruments.ShapeChange.OclConstraint_KindOf;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Xmi10Document;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XsdDocument {
    protected Document document = null;
    protected Element root = null;
    protected Comment hook = null;
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected Model model = null;
    protected String name = null;
    protected Vector<String> includes = null;
    protected Vector<String> imports = null;
    protected boolean printed = false;

    public XsdDocument(PackageInfo pi, Model m, Options o, ShapeChangeResult r, String n) throws ShapeChangeAbortException, ParserConfigurationException {
        this.options = o;
        this.result = r;
        this.model = m;
        this.name = n;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.document = db.newDocument();
        this.root = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.root, "xmlns", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.root, "elementFormDefault", "qualified");
        this.addAttribute(this.root, "version", pi.version());
        this.addAttribute(this.root, "targetNamespace", pi.targetNamespace());
        this.addAttribute(this.root, "xmlns:" + pi.xmlns(), pi.targetNamespace());
        this.addStandardAnnotation(this.root, pi);
        this.hook = this.addHook(this.root);
        this.includes = new Vector();
        this.imports = new Vector();
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Comment addHook(Element e) {
        Comment e1 = this.document.createComment("XML Schema document created by ShapeChange");
        e.appendChild(e1);
        return e1;
    }

    protected void addStandardAnnotation(Element e, Info info) {
        Element e3;
        Element e1 = null;
        String txt = info.documentation();
        if (this.options.includeDocumentation && txt != null && !txt.equals("")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
            e1.appendChild(this.document.createTextNode(txt));
        }
        Element e2 = null;
        if (info instanceof PackageInfo) {
            PackageInfo pi = (PackageInfo)info;
            String profile = pi.gmlProfileSchema();
            if (this.options.gmlVersion.equals("3.2") && profile != null) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                Element e0 = this.document.createElementNS(this.options.GML_NS, "gmlProfileSchema");
                e2.appendChild(e0);
                e0.appendChild(this.document.createTextNode(profile));
            }
        }
        if (info instanceof PropertyInfo) {
            String l;
            Element e32;
            PropertyInfo propi = (PropertyInfo)info;
            ClassInfo ci = this.model.classById(propi.typeInfo().id);
            if (ci != null && ci.pkg() != null) {
                if (propi.inlineOrByReference().equals("byreference") && this.options.gmlVersion.equals("3.2")) {
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    e32 = this.document.createElementNS(this.options.GML_NS, "targetElement");
                    e2.appendChild(e32);
                    e32.appendChild(this.document.createTextNode(ci.qname()));
                }
                if (propi.reverseProperty() != null && this.options.gmlVersion.equals("3.2")) {
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    e32 = this.document.createElementNS(this.options.GML_NS, "reversePropertyName");
                    e2.appendChild(e32);
                    e32.appendChild(this.document.createTextNode(propi.reverseProperty().qname()));
                }
            }
            if (!propi.defaultCodeSpace().equals("") && this.options.gmlVersion.equals("3.2")) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e32 = this.document.createElementNS(this.options.GML_NS, "defaultCodeSpace");
                e2.appendChild(e32);
                e32.appendChild(this.document.createTextNode(propi.defaultCodeSpace()));
            }
            if ((l = ((Xmi10Document)this.model).fClassesRoseHiddenLabels.get(propi.typeInfo().id)) != null) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "taggedValue");
                this.addAttribute(e3, "tag", "labels");
                e3.appendChild(this.document.createTextNode(l));
                e2.appendChild(e3);
                this.result.addWarning(" Property Name: " + propi.inClass().qname() + "/" + propi.qname() + ", Type ID: " + propi.typeInfo().id + ", hidden labels: " + l);
                this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
            }
        }
        HashMap<String, String> taggedValues = info.taggedValues(this.options.representTaggedValues);
        for (Map.Entry<String, String> entry : taggedValues.entrySet()) {
            if (e2 == null) {
                e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            }
            e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "taggedValue");
            this.addAttribute(e3, "tag", entry.getKey());
            e3.appendChild(this.document.createTextNode(entry.getValue()));
            e2.appendChild(e3);
            this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
        }
        if (e1 != null || e2 != null) {
            Element e0 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
            if (e1 != null) {
                e0.appendChild(e1);
            }
            if (e2 != null) {
                e0.appendChild(e2);
            }
            e.appendChild(e0);
        }
    }

    private boolean classHasObjectType(ClassInfo ci) {
        int cat = ci.category();
        return cat == 5 || cat == 8 && !ci.asGroup() || cat == 1 || cat == 6;
    }

    private boolean classHasObjectElement(ClassInfo ci) {
        if (ci.encodingRule("xsd").equals("iso19139_2007")) {
            int cat = ci.category();
            return cat == 5 || cat == 8 || cat == 1 || cat == 6 || cat == 3 || cat == 2;
        }
        return this.classHasObjectType(ci);
    }

    private boolean classHasIdentity(ClassInfo ci) {
        int cat = ci.category();
        return cat == 4 || cat == 1 || cat == 6;
    }

    protected String mapToKnownSubstitute(MapEntry me) {
        int idx;
        this.result.addDebug("Found: " + me.p1 + " - " + me.rule);
        String s = null;
        if (!me.p1.equals("") && (idx = (s = me.p1).indexOf(":")) > 0) {
            String nsabr = s.substring(0, idx);
            this.addImport(nsabr, this.options.fullNamespace(nsabr));
        }
        return s;
    }

    protected String mapBaseType(ClassInfo ci) {
        String s = null;
        String rule = ci.encodingRule("xsd");
        MapEntry me = this.options.baseMapEntry(ci.name(), rule);
        if (me == null) {
            if (this.classHasObjectType(ci)) {
                s = rule.equals("iso19139_2007") ? (ci.isAbstract() ? String.valueOf(ci.pkg().xmlns()) + ":Abstract" + ci.name() + "_Type" : String.valueOf(ci.qname()) + "_Type") : String.valueOf(ci.qname()) + "Type";
            } else {
                this.result.addError("No XML Schema type for type " + ci.name() + " is defined. Only object and data types are supported.");
            }
        } else {
            this.result.addDebug("Looking for BASE substitute for type " + ci.name());
            if (me != null) {
                s = this.mapToKnownSubstitute(me);
            } else {
                this.result.addError("The type " + ci.name() + " is neither part of the UML application schema nor does a mapping to a predefined type exist.");
            }
        }
        return s;
    }

    protected String mapElement(ClassInfo ci) {
        String s = null;
        String rule = ci.encodingRule("xsd");
        MapEntry me = this.options.elementMapEntry(ci.name(), rule);
        if (me == null) {
            if (this.classHasObjectElement(ci)) {
                s = rule.equals("iso19139_2007") && ci.isAbstract() ? String.valueOf(ci.pkg().xmlns()) + ":Abstract" + ci.name() : ci.qname();
            } else {
                this.result.addError("No element for type " + ci.name() + " is defined. Only object and data types are represented by elements.");
            }
        } else {
            this.result.addDebug("Looking for ELEMENT substitute for " + ci.name());
            if (me != null) {
                s = this.mapToKnownSubstitute(me);
            } else {
                this.result.addError("The type " + ci.name() + " is neither part of the UML application schema nor does a mapping to a predefined type exist.");
            }
        }
        return s;
    }

    public void pObjectElement(ClassInfo ci, ClassInfo cibase, String rule) {
        String s;
        int catbase;
        int cat = ci.category();
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.document.getDocumentElement().appendChild(e4);
        if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes")) {
            this.addAttribute(e4, "name", ci.name());
            this.addAttribute(e4, "type", String.valueOf(ci.qname()) + "Type");
        } else if (rule.equals("iso19139_2007")) {
            if (cat == 2) {
                this.addAttribute(e4, "name", ci.name());
                this.addAttribute(e4, "type", "gco:CodeListValue_Type");
            } else if (ci.isAbstract()) {
                this.addAttribute(e4, "name", "Abstract" + ci.name());
                this.addAttribute(e4, "type", String.valueOf(ci.pkg().xmlns()) + ":Abstract" + ci.name() + "_Type");
            } else {
                this.addAttribute(e4, "name", ci.name());
                this.addAttribute(e4, "type", String.valueOf(ci.qname()) + "_Type");
            }
        }
        if (ci.isAbstract()) {
            this.addAttribute(e4, "abstract", "true");
        }
        if (cibase == null) {
            if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007")) {
                if (cat == 6) {
                    if (this.options.gmlVersion.equals("2.1")) {
                        this.addAttribute(e4, "substitutionGroup", "gml:_Feature");
                    } else if (this.options.gmlVersion.equals("3.1")) {
                        this.addAttribute(e4, "substitutionGroup", "gml:_GML");
                    } else {
                        this.addAttribute(e4, "substitutionGroup", "gml:AbstractGML");
                    }
                } else if (cat == 5 || cat == 8) {
                    if (this.options.gmlVersion.equals("3.1")) {
                        this.addAttribute(e4, "substitutionGroup", "gml:_Object");
                    } else if (this.options.gmlVersion.equals("3.2")) {
                        this.addAttribute(e4, "substitutionGroup", "gml:AbstractObject");
                    }
                } else if (this.options.gmlVersion.equals("2.1") || this.options.gmlVersion.equals("3.1")) {
                    this.addAttribute(e4, "substitutionGroup", "gml:_Feature");
                } else {
                    this.addAttribute(e4, "substitutionGroup", "gml:AbstractFeature");
                }
                this.addImport("gml", this.options.fullNamespace("gml"));
            } else if (rule.equals("iso19139_2007")) {
                if (cat == 2 || cat == 3) {
                    this.addAttribute(e4, "substitutionGroup", "gco:CharacterString");
                } else {
                    this.addAttribute(e4, "substitutionGroup", "gco:AbstractObject");
                }
                this.addImport("gco", this.options.fullNamespace("gco"));
            }
        } else if (cibase != null && ((catbase = cibase.category()) == 1 || catbase == 6 || catbase == 5) && (s = this.mapElement(cibase)) != null) {
            this.addAttribute(e4, "substitutionGroup", s);
        }
        this.addStandardAnnotation(e4, ci);
    }

    public Element pComplexType(ClassInfo ci, ClassInfo cibase, String rule) {
        Element ret;
        Element e3;
        int cat = ci.category();
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes")) {
            this.addAttribute(e1, "name", String.valueOf(ci.name()) + "Type");
        } else if (rule.equals("iso19139_2007")) {
            if (ci.isAbstract()) {
                this.addAttribute(e1, "name", "Abstract" + ci.name() + "_Type");
            } else {
                this.addAttribute(e1, "name", String.valueOf(ci.name()) + "_Type");
            }
        }
        if (ci.isAbstract()) {
            this.addAttribute(e1, "abstract", "true");
        }
        if (cibase == null && ((cat == 5 || cat == 8) && (rule.equals("iso19136_2007") || rule.equals("iso19136_2007")) || rule.equals("iso19136_2007_NoGmlBaseTypes"))) {
            e3 = e1;
        } else {
            Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
            e1.appendChild(e2);
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            e2.appendChild(e3);
            if (cibase == null) {
                if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007")) {
                    if (cat == 6 && !this.options.gmlVersion.equals("2.1")) {
                        this.addAttribute(e3, "base", "gml:AbstractGMLType");
                    } else {
                        this.addAttribute(e3, "base", "gml:AbstractFeatureType");
                    }
                    this.addImport("gml", this.options.fullNamespace("gml"));
                } else if (rule.equals("iso19139_2007")) {
                    this.addAttribute(e3, "base", "gco:AbstractObject_Type");
                    this.addImport("gco", this.options.fullNamespace("gco"));
                }
            } else {
                String s = this.mapBaseType(cibase);
                if (s != null) {
                    this.addAttribute(e3, "base", s);
                } else {
                    this.result.addError("Base type " + cibase.name() + " could not be mapped. Missing base type in complex type " + ci.name() + "Type.");
                }
            }
        }
        if (cat == 8) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            if (rule.equals("iso19136_2007")) {
                this.addGroupReferences(ci, ret);
            }
        }
        e3.appendChild(ret);
        return ret;
    }

    public Element pGroup(ClassInfo ci, ClassInfo cibase) {
        Element ret;
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", String.valueOf(ci.name()) + "Group");
        this.addStandardAnnotation(e1, ci);
        if (ci.category() == 8) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            this.addGroupReferences(ci, ret);
        }
        e1.appendChild(ret);
        return ret;
    }

    private void addGroupReferences(ClassInfo ci, Element e) {
        HashSet<String> st = ci.supertypes();
        if (st != null) {
            for (String sid : st) {
                ClassInfo cix = this.model.classById(sid);
                if (cix == null || cix.category() != 4) continue;
                Element eg = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
                e.appendChild(eg);
                this.addAttribute(eg, "ref", String.valueOf(cix.qname()) + "Group");
            }
        }
    }

    private void addElements(Element e, HashSet<ClassInfo> v) {
        Iterator<ClassInfo> i = v.iterator();
        while (i.hasNext()) {
            Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e.appendChild(e3);
            String s = this.mapElement(i.next());
            if (s == null) continue;
            this.addAttribute(e3, "ref", s);
        }
    }

    private HashSet<ClassInfo> subtypes(ClassInfo ci) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        if (ci.subtypes() != null) {
            Iterator<String> i = ci.subtypes().iterator();
            while (i.hasNext()) {
                ClassInfo cix = this.model.classById(i.next());
                if (cix != null && cix.category() == 4) {
                    res.addAll(this.subtypes(cix));
                    continue;
                }
                res.add(cix);
            }
        }
        return res;
    }

    public void pPropertyTypeWithSubtypes(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", String.valueOf(ci.name()) + "PropertyType");
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        e1.appendChild(e4);
        this.addAttribute(e4, "minOccurs", "0");
        this.addElements(e4, this.subtypes(ci));
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        e1.appendChild(e4);
        if (!ci.noGMLType()) {
            this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (this.options.gmlVersion.equals("3.2")) {
                e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e4);
                this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
            }
        } else {
            this.addAttribute(e4, "ref", "xlink:simpleLink");
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        }
    }

    public void pPropertyTypes(ClassInfo ci, String rule) {
        Element e3;
        Element e4;
        Element e1;
        int cat = ci.category();
        if ((rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes") || rule.equals("iso19136_2007")) && ci.includePropertyType() || rule.equals("iso19139_2007")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
            this.document.getDocumentElement().appendChild(e1);
            if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes") || rule.equals("iso19136_2007")) {
                this.addAttribute(e1, "name", String.valueOf(ci.name()) + "PropertyType");
            } else if (rule.equals("iso19139_2007")) {
                this.addAttribute(e1, "name", String.valueOf(ci.name()) + "_PropertyType");
            }
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            e1.appendChild(e4);
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e4.appendChild(e3);
            if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes") || rule.equals("iso19136_2007")) {
                this.addAttribute(e3, "ref", ci.qname());
            } else if (rule.equals("iso19139_2007")) {
                if (ci.isAbstract()) {
                    this.addAttribute(e3, "ref", String.valueOf(ci.pkg().xmlns()) + ":Abstract" + ci.name());
                } else {
                    this.addAttribute(e3, "ref", ci.qname());
                }
            }
            if (rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes") || rule.equals("iso19136_2007")) {
                if (cat == 1 || cat == 6) {
                    this.addAttribute(e4, "minOccurs", "0");
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e1.appendChild(e3);
                    if (!rule.equals("iso19136_2007")) {
                        this.addAttribute(e3, "ref", "gml:AssociationAttributeGroup");
                        this.addImport("gml", this.options.fullNamespace("gml"));
                        if (this.options.gmlVersion.equals("3.2")) {
                            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                            e1.appendChild(e3);
                            this.addAttribute(e3, "ref", "gml:OwnershipAttributeGroup");
                        }
                    } else {
                        this.addAttribute(e3, "ref", "xlink:simpleLink");
                        this.addImport("xlink", this.options.fullNamespace("xlink"));
                    }
                }
            } else if (rule.equals("iso19139_2007")) {
                this.addAttribute(e4, "minOccurs", "0");
                if (cat != 2 && cat != 3) {
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    this.addAttribute(e3, "ref", "gco:ObjectReference");
                    e1.appendChild(e3);
                }
                this.addImport("gco", this.options.fullNamespace("gco"));
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                e1.appendChild(e3);
                this.addAttribute(e3, "ref", "gco:nilReason");
            }
        }
        if ((rule.equals("iso19136_2007") || rule.equals("iso19136_2007_NoGmlBaseTypes") || rule.equals("iso19136_2007")) && (cat == 1 || cat == 6) && ci.includeByValuePropertyType()) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", String.valueOf(ci.name()) + "PropertyByValueType");
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            e1.appendChild(e4);
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e4.appendChild(e3);
            this.addAttribute(e3, "ref", ci.qname());
        }
    }

    private Element pAnonymousBasicType(ClassInfo ci) {
        Element e1 = null;
        String id = ci.id();
        String rule = ci.encodingRule("xsd");
        if (id != null) {
            String base = this.model.taggedValue(id, "base");
            String length = this.model.taggedValue(id, "length");
            String min = this.model.taggedValue(id, "rangeMinimum");
            String max = this.model.taggedValue(id, "rangeMaximum");
            if (base == null && ci.supertypes() != null) {
                Iterator<String> i = ci.supertypes().iterator();
                while (i.hasNext()) {
                    MapEntry me;
                    ClassInfo cix = this.model.classById(i.next());
                    if (cix == null || (me = this.options.baseMapEntry(cix.name(), rule)) == null) continue;
                    base = me.p1;
                }
            }
            if (base != null) {
                Element e5;
                Element e3;
                if (base.indexOf(":") > 0) {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    this.addStandardAnnotation(e1, ci);
                    Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                    e1.appendChild(e4);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    e4.appendChild(e3);
                } else {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                    this.addStandardAnnotation(e1, ci);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    e1.appendChild(e3);
                }
                this.addAttribute(e3, "base", base);
                if (("integer".equals(base) || "positiveInteger".equals(base) || "nonNegativeInteger".equals(base) || "decimal".equals(base)) && length != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "totalDigits");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", length);
                }
                if (("string".equals(base) || "gml:CodeType".equals(base)) && length != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", length);
                }
                if (!"string".equals(base) && min != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minInclusive");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", min);
                }
                if (!"string".equals(base) && max != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", max);
                }
            } else {
                this.result.addError("The type with the name " + ci.name() + " has no tagged value 'base' or valid supertype and cannot be mapped to a basic type.");
            }
        } else {
            this.result.addError("The type with the name " + ci.name() + " has no ID and cannot be mapped to a basic type.");
        }
        return e1;
    }

    public void pGlobalBasicType(ClassInfo ci) {
        Element e1 = this.pAnonymousBasicType(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", String.valueOf(ci.name()) + "Type");
        } else {
            this.result.addError("Failed to create basic type '" + ci.name() + "Type'.");
        }
    }

    private Element pAnonymousEnumeration(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        for (PropertyInfo atti : ci.properties().values()) {
            Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "enumeration");
            e4.appendChild(e3);
            String val = atti.name();
            String doc = atti.documentation().trim();
            if (atti.initialValue() != null) {
                val = atti.initialValue();
                if (doc == null || doc.equals("")) {
                    doc = atti.name();
                }
            }
            this.addAttribute(e3, "value", val);
            this.addStandardAnnotation(e3, atti);
        }
        return e1;
    }

    public void pGlobalEnumeration(ClassInfo ci, String rule) {
        Element e1;
        HashSet<String> sc = ci.supertypes();
        if (sc != null && sc.size() > 0) {
            this.result.addError("The class " + ci.name() + " is an enumeration. Generalization relationships are not supported for these classes. All such relationships are ignored.");
        }
        if ((e1 = this.pAnonymousEnumeration(ci)) != null) {
            this.document.getDocumentElement().appendChild(e1);
            if (rule.equals("iso19139_2007")) {
                this.addAttribute(e1, "name", String.valueOf(ci.name()) + "_Type");
            } else {
                this.addAttribute(e1, "name", String.valueOf(ci.name()) + "Type");
            }
        } else {
            this.result.addError("Failed to create enumeration type '" + ci.name() + "Type'.");
        }
    }

    public void pGlobalCodeList(ClassInfo ci) {
        HashSet<String> sc = ci.supertypes();
        if (sc != null && sc.size() > 0) {
            this.result.addError("The class " + ci.name() + " is a codelist. Generalization relationships are not supported for these classes. All such relationships are ignored.");
        }
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", String.valueOf(ci.name()) + "Type");
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "union");
        e1.appendChild(e4);
        this.addAttribute(e4, "memberTypes", String.valueOf(ci.qname()) + "EnumerationType " + ci.qname() + "OtherType");
        e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", String.valueOf(ci.name()) + "EnumerationType");
        } else {
            this.result.addError("Failed to create enumeration type '" + ci.name() + "EnumerationType'.");
        }
        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", String.valueOf(ci.name()) + "OtherType");
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
        e4.appendChild(e3);
        this.addAttribute(e3, "value", "other: \\w{2,}");
    }

    public boolean processLocalProperties(ClassInfo ci, Element e, String rule) {
        int res = 0;
        this.result.addDebug("Processing local properties of class " + ci.name() + " ...");
        for (PropertyInfo pi : ci.properties().values()) {
            if (!pi.isNavigable() || pi.restriction()) continue;
            Element e1 = this.addProperty(ci, pi, rule);
            if (e1.getLocalName().equals("attribute") || e1.getLocalName().equals("attributeGroup")) {
                e.getParentNode().appendChild(e1);
            } else {
                e.appendChild(e1);
            }
            if (!pi.isAggregation() && !pi.isComposition()) continue;
            if (res == 0) {
                res = 1;
                continue;
            }
            if (res != true) continue;
            res = 2;
        }
        return res == 1;
    }

    private void addMinMaxOccurs(Element e, Multiplicity m) {
        if (m.minOccurs != 1) {
            this.addAttribute(e, "minOccurs", Integer.valueOf(m.minOccurs).toString());
        }
        if (m.maxOccurs == Integer.MAX_VALUE) {
            this.addAttribute(e, "maxOccurs", "unbounded");
        } else if (m.maxOccurs != 1) {
            this.addAttribute(e, "maxOccurs", Integer.valueOf(m.maxOccurs).toString());
        }
    }

    protected Element addProperty(ClassInfo cibase, PropertyInfo pi, String rule) {
        Element e1;
        ClassInfo ci = this.model.classById(pi.typeInfo().id);
        Multiplicity m = pi.cardinality();
        String asAtt = this.model.taggedValue(pi.id(), "xsdAsAttribute");
        if (ci != null && ci.category() == 8 && ci.asGroup() && rule.equals("iso19136_2007")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "ref", String.valueOf(ci.qname()) + "Group");
            this.addMinMaxOccurs(e1, m);
        } else if (rule.equals("iso19136_2007") && asAtt != null && asAtt.equals("true") && m.maxOccurs == 1) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            this.addAttribute(e1, "name", pi.name());
            if (m.minOccurs == 1) {
                this.addAttribute(e1, "use", "required");
            }
            this.mapPropertyType(cibase, pi, e1, rule);
        } else {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addAttribute(e1, "name", pi.name());
            this.addMinMaxOccurs(e1, m);
            if (pi.nilReasonAllowed() && rule.equals("iso19136_2007")) {
                this.addAttribute(e1, "nillable", "true");
            }
            if (pi.initialValue() != null && !pi.initialValue().equals("") && rule.equals("iso19136_2007")) {
                if (pi.initialValue().indexOf("{frozen}") > 0) {
                    String[] parts = pi.initialValue().split("\\{frozen\\}");
                    this.addAttribute(e1, "fixed", this.stripQuotes(parts[0].trim()));
                } else {
                    this.addAttribute(e1, "default", this.stripQuotes(pi.initialValue()));
                }
            }
            this.mapPropertyType(cibase, pi, e1, rule);
        }
        return e1;
    }

    protected void mapPropertyType(ClassInfo cibase, PropertyInfo propi, Element e, String rule) {
        Vector<OclConstraint> cs;
        String pName = String.valueOf(cibase.name()) + "." + propi.name();
        Element e1 = null;
        boolean mustBeSimple = e.getLocalName().equals("attribute");
        if (rule.equals("iso19136_2007") && (cs = cibase.constraints()) != null) {
            for (OclConstraint c : cs) {
                if (c == null || !(c instanceof OclConstraint_KindOf)) continue;
                OclConstraint_KindOf cx = (OclConstraint_KindOf)c;
                if (!cx.pi.id().equals(propi.id())) continue;
                this.addPropertyType(e, propi, null, ((OclConstraint_KindOf)c).types);
                return;
            }
        }
        Type ti = propi.typeInfo();
        this.result.addDebug("Looking for TYPE substitute for " + ti.name + ", encoding rule = " + rule);
        MapEntry me = this.options.typeMapEntry(ti.name, rule);
        if (me != null) {
            if (me.rule.equals("direct")) {
                String s = this.mapToKnownSubstitute(me);
                this.addAttribute(e, "type", s);
            } else if (mustBeSimple) {
                this.result.addError("The property '" + pName + "' cannot be assigned a type as it is mapped to an XML attribute, but the type has complex content.");
            } else if (me.rule.equals("propertyType")) {
                this.addPropertyType(e, propi, me.p1, null);
            } else if (me.rule.equals("metadataPropertyType")) {
                propi.isMetadata(true);
                this.addPropertyType(e, propi, me.p1, null);
            }
            return;
        }
        ClassInfo ci = this.model.classById(ti.id);
        String rule2 = ci.encodingRule("xsd");
        if (ci != null) {
            if (ci.category() == 9 && rule2.equals("iso19136_2007")) {
                for (PropertyInfo pi2 : ci.properties().values()) {
                    if (!pi2.isNavigable() || pi2.restriction() || pi2.implementedByNilReason()) continue;
                    if (ci.hasNilReason()) {
                        pi2.nilReasonAllowed(true);
                    }
                    this.addAttribute(e, "nillable", "true");
                    this.mapPropertyType(cibase, pi2, e, rule);
                    return;
                }
                this.result.addError("Union '" + ci.name() + "' as the value type of '" + pName + "' could not be mapped as it does not contain the expected number of exactly one property to be encoded in the application schema.");
            } else if (this.classHasObjectElement(ci)) {
                if (rule2.equals("iso19139_2007")) {
                    this.addAttribute(e, "type", String.valueOf(ci.qname()) + "_PropertyType");
                } else if (rule2.equals("iso19136_2007") || rule2.equals("iso19136_2007") || rule2.equals("iso19136_2007_NoGmlBaseTypes")) {
                    boolean embedPropertyType = true;
                    if (!propi.isComposition() || ci.category() == 5 || ci.category() == 8) {
                        if (ci.includePropertyType() && !propi.nilReasonAllowed() && !propi.isMetadata()) {
                            this.addAttribute(e, "type", String.valueOf(ci.qname()) + "PropertyType");
                            this.addStandardAnnotation(e, propi);
                            embedPropertyType = false;
                        }
                    } else if (ci.includeByValuePropertyType() && !propi.nilReasonAllowed() && !propi.isMetadata() && !propi.inlineOrByReference().equals("byreference")) {
                        this.addAttribute(e, "type", String.valueOf(ci.qname()) + "PropertyByValueType");
                        this.addStandardAnnotation(e, propi);
                        embedPropertyType = false;
                    }
                    if (embedPropertyType) {
                        this.addPropertyType(e, propi, ci.qname(), null);
                    }
                }
            } else if (ci.category() == 4 && rule.equals("iso19136_2007")) {
                this.addPropertyType(e, propi, null, this.subtypes(ci));
            } else if (rule2.equals("iso19136_2007") || rule2.equals("iso19136_2007") || rule2.equals("iso19136_2007_NoGmlBaseTypes")) {
                if (ci.category() == 2 && ci.asDictionary()) {
                    if (!propi.nilReasonAllowed()) {
                        this.addAttribute(e, "type", "gml:CodeType");
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                        this.addAttribute(e3, "base", "gml:CodeType");
                        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e2);
                        this.addAttribute(e2, "name", "nilReason");
                        if (this.options.gmlVersion.equals("3.2")) {
                            this.addAttribute(e2, "type", "gml:NilReasonType");
                        } else {
                            this.addAttribute(e2, "type", "gml:NullType");
                        }
                    }
                    if (propi.isMetadata()) {
                        this.result.addWarning("The property '" + pName + "' is tagged as a metadata property. This is only possible for properties with complex content.");
                    }
                    this.addStandardAnnotation(e, propi);
                    this.addImport("gml", this.options.fullNamespace("gml"));
                } else if (ci.category() == 2 || ci.category() == 3 && this.options.enumStyle == 1 || ci.category() == 7 && this.options.basicTypeStyle == 1) {
                    this.addStandardAnnotation(e, propi);
                    if (!propi.nilReasonAllowed()) {
                        this.addAttribute(e, "type", String.valueOf(ci.qname()) + "Type");
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                        this.addAttribute(e3, "base", String.valueOf(ci.qname()) + "Type");
                        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e2);
                        this.addAttribute(e2, "name", "nilReason");
                        if (this.options.gmlVersion.equals("3.2")) {
                            this.addAttribute(e2, "type", "gml:NilReasonType");
                        } else {
                            this.addAttribute(e2, "type", "gml:NullType");
                        }
                        this.addImport("gml", this.options.fullNamespace("gml"));
                    }
                    if (propi.isMetadata()) {
                        this.result.addWarning("The property '" + pName + "' is tagged as a metadata property. This is only possible for properties with complex content.");
                    }
                } else if (ci.category() == 3 && this.options.enumStyle == 2) {
                    this.addStandardAnnotation(e, propi);
                    e1 = this.pAnonymousEnumeration(ci);
                    if (propi.nilReasonAllowed()) {
                        this.result.addWarning("Support for nilReason attributes was requested in property '" + pName + "'. This is not possible for properties which have a local enumeration as their value.");
                    }
                    if (propi.isMetadata()) {
                        this.result.addWarning("The property '" + pName + "' is tagged as a metadata property. This is only possible for properties with complex content.");
                    }
                } else if (ci.category() == 7 && this.options.basicTypeStyle == 2) {
                    this.addStandardAnnotation(e, propi);
                    e1 = this.pAnonymousBasicType(ci);
                    if (propi.nilReasonAllowed()) {
                        this.result.addWarning("Support for nilReason attributes was requested in property '" + pName + "'. This is not possible for properties which have a local basic type as their value.");
                    }
                    if (propi.isMetadata()) {
                        this.result.addWarning("The property '" + pName + "' is tagged as a metadata property. This is only possible for properties with complex content.");
                    }
                } else {
                    this.result.addError("No type can be provided for the property '" + pName + "'.");
                }
            } else {
                this.result.addError("No type can be provided for the property '" + pName + "'.");
            }
        } else {
            this.result.addError("The type of property " + pName + " was not found.");
        }
    }

    protected void addPropertyType(Element e, PropertyInfo propi, String targetElement, HashSet<ClassInfo> types) {
        ClassInfo cibase = propi.inClass();
        if (propi.typeInfo().collectionType == 0) {
            if (propi.inlineOrByReference().equals("byreference")) {
                this.addStandardAnnotation(e, propi);
                if ((propi.isMetadata() || propi.isAggregation() || propi.isComposition() || propi.nilReasonAllowed()) && (cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType())) {
                    Element e3;
                    Element e2;
                    Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    if (propi.isMetadata() && this.options.gmlVersion.equals("3.2")) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                        e1.appendChild(e2);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e2.appendChild(e3);
                        this.addAttribute(e3, "base", "gml:AbstractMetadataPropertyType");
                    } else if ((propi.isAggregation() || propi.isComposition()) && this.options.gmlVersion.equals("3.2")) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                        e1.appendChild(e2);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e2.appendChild(e3);
                        this.addAttribute(e3, "base", "gml:AbstractMemberType");
                    } else {
                        e3 = e1;
                    }
                    Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                    e3.appendChild(e4);
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e3.appendChild(e4);
                    this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
                    if (this.options.gmlVersion.equals("3.2") && !propi.isMetadata() && !propi.isAggregation() && !propi.isComposition()) {
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                        e3.appendChild(e4);
                        this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
                    }
                    if (propi.nilReasonAllowed() && !this.options.gmlVersion.equals("3.2")) {
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e4);
                        this.addAttribute(e4, "name", "nilReason");
                        this.addAttribute(e4, "type", "gml:NullType");
                    }
                } else if (cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType()) {
                    this.addAttribute(e, "type", "gml:ReferenceType");
                } else {
                    Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                    e1.appendChild(e4);
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e1.appendChild(e4);
                    this.addAttribute(e4, "ref", "xlink:simpleLink");
                }
            } else {
                ClassInfo cix;
                Element e4;
                Element e3;
                this.addStandardAnnotation(e, propi);
                Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1);
                if ((propi.isMetadata() || propi.isAggregation() || propi.isComposition()) && this.options.gmlVersion.equals("3.2") && (cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType())) {
                    Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                    e1.appendChild(e2);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e2.appendChild(e3);
                    if (propi.isMetadata()) {
                        this.addAttribute(e3, "base", "gml:AbstractMetadataPropertyType");
                    } else if (propi.isAggregation() || propi.isComposition()) {
                        this.addAttribute(e3, "base", "gml:AbstractMemberType");
                    }
                } else {
                    e3 = e1;
                }
                if (types != null) {
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
                    e3.appendChild(e4);
                    this.addElements(e4, types);
                } else if (targetElement != null) {
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                    e3.appendChild(e4);
                    Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
                    e4.appendChild(e5);
                    this.addAttribute(e5, "ref", targetElement);
                    int idx = targetElement.indexOf(":");
                    if (idx > 0) {
                        String nsabr = targetElement.substring(0, idx);
                        this.addImport(nsabr, this.options.fullNamespace(nsabr));
                    }
                } else {
                    this.result.addError("Target object element(s) missing in property type for property '" + propi.name() + "'");
                    return;
                }
                if (!propi.inlineOrByReference().equals("inline")) {
                    this.addAttribute(e4, "minOccurs", "0");
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e3.appendChild(e4);
                    if (cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType()) {
                        this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
                    } else {
                        this.addAttribute(e4, "ref", "xlink:simpleLink");
                    }
                }
                if (!((cibase != null || this.options.noGMLtypeDefault) && (cibase == null || cibase.noGMLType()) || !this.options.gmlVersion.equals("3.2") || propi.isMetadata() || propi.isAggregation() || propi.isComposition() || (cix = this.model.classById(propi.typeInfo().id)) == null || cix.category() != 1 && cix.category() != 6)) {
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e3.appendChild(e4);
                    this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
                }
                if ((cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType()) && propi.nilReasonAllowed() && (!this.options.gmlVersion.equals("3.2") || propi.inlineOrByReference().equals("inline"))) {
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                    e3.appendChild(e4);
                    this.addAttribute(e4, "name", "nilReason");
                    if (this.options.gmlVersion.equals("3.2")) {
                        this.addAttribute(e4, "type", "gml:NilReasonType");
                    } else {
                        this.addAttribute(e4, "type", "gml:NullType");
                    }
                }
            }
        } else {
            this.result.addError("Error while creating property type for collection property with XMI id '" + propi.id() + "'.");
        }
        if (cibase == null && !this.options.noGMLtypeDefault || cibase != null && !cibase.noGMLType()) {
            this.addImport("gml", this.options.fullNamespace("gml"));
        } else {
            this.addImport("gml", this.options.fullNamespace("xlink"));
        }
    }

    private String stripQuotes(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    protected Element addPropertyRef(PackageInfo pkg, String ref, String minOccurs, String maxOccurs) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addAttribute(e1, "ref", ref);
        if (!minOccurs.equals("1")) {
            this.addAttribute(e1, "minOccurs", minOccurs);
        }
        if (!maxOccurs.equals("1")) {
            this.addAttribute(e1, "maxOccurs", maxOccurs);
        }
        return e1;
    }

    public void addInclude(XsdDocument xsd) {
        if (xsd == this) {
            return;
        }
        boolean found = false;
        for (String f : this.includes) {
            if (!f.equals(xsd.name)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.includes.add(xsd.name);
        }
    }

    public void addImport(String nsabr, String ns) {
        if (ns == null) {
            return;
        }
        boolean found = false;
        for (String nsx : this.imports) {
            if (!nsx.equals(ns)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.imports.add(ns);
            this.result.addDebug("Import to namespace '" + ns + "' added.");
            if (nsabr != null) {
                this.addAttribute(this.root, "xmlns:" + nsabr, ns);
            }
        }
    }

    public void printFile(Properties outputFormat) throws Exception {
        Element e;
        if (this.printed) {
            return;
        }
        Iterator<String> i = this.includes.iterator();
        while (i.hasNext()) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "include");
            this.addAttribute(e, "schemaLocation", i.next());
            this.root.insertBefore(e, this.hook);
        }
        Iterator<String> i2 = this.imports.iterator();
        while (i2.hasNext()) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            String s = i2.next();
            this.addAttribute(e, "namespace", s);
            String loc = this.options.schemaLocationOfNamespace(s);
            if (loc != null) {
                this.addAttribute(e, "schemaLocation", loc);
            }
            this.root.insertBefore(e, this.hook);
        }
        File file = new File(String.valueOf(this.options.dirName) + "/" + this.name);
        FileWriter outputXML = new FileWriter(file);
        Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
        serializer.setWriter((Writer)outputXML);
        serializer.asDOMSerializer().serialize((Node)this.document);
        outputXML.close();
        this.printed = true;
    }

    public boolean printed() {
        return this.printed;
    }

    public void test(ClassInfo ci) {
    }
}

