/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.FeatureCatalogue;

import de.interactive_instruments.ShapeChange.Fop.FopErrorListener;
import de.interactive_instruments.ShapeChange.Fop.FopMsgHandler;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.ModelDiff.Differ;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FeatureCatalogue
implements SingleTarget,
MessageSource {
    public static final int TARGET_FeatureCatalogue = 9;
    public static final int STATUS_WRITE_PDF = 22;
    public static final int STATUS_WRITE_HTML = 23;
    public static final int STATUS_WRITE_XML = 24;
    public static final int STATUS_WRITE_RTF = 25;
    private static boolean initialised = false;
    private static Document document = null;
    private static String Package = "";
    private static HashSet<ClassInfo> additionalClasses = new HashSet();
    private static HashSet<ClassInfo> enumerations = new HashSet();
    private static Model refModel = null;
    private static Boolean Inherit = false;
    private static HashSet<PropertyInfo> exportedRoles = new HashSet();
    private static HashSet<PropertyInfo> exportedProperties = new HashSet();
    private static String OutputFormat = "";
    private static String outputDirectory = null;
    private static String outputFilename = null;
    private static Element root = null;
    private static boolean error = false;
    private static boolean printed = false;
    private static String encoding = null;
    private static String xslfofileName = "pdf.xsl";
    private static String xslTransformerFactory = null;
    private static String xslhtmlfileName = "html.xsl";
    private static String xslrtffileName = "rtf.xsl";
    private static String xslxmlfileName = "xml.xsl";
    private static String xsltPath = "src/main/resources/xslt";
    private static String featureTerm = "Feature";
    private static boolean includeVoidable = true;
    private static boolean includeTitle = true;
    private static boolean getDocFromSupertypes = false;
    private static boolean deleteXmlFile = false;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    public int getTargetID() {
        return 9;
    }

    public void reset() {
        initialised = false;
        document = null;
        Package = "";
        additionalClasses.clear();
        enumerations.clear();
        Inherit = false;
        exportedRoles.clear();
        exportedProperties.clear();
        OutputFormat = "";
        outputDirectory = null;
        outputFilename = null;
        root = null;
        error = false;
        printed = false;
        encoding = null;
        xslfofileName = "pdf.xsl";
        xslhtmlfileName = "html.xsl";
        xslrtffileName = "rtf.xsl";
        xslxmlfileName = "xml.xsl";
        xsltPath = "src/main/resources/xslt";
        featureTerm = "Feature";
        includeVoidable = true;
        includeTitle = true;
        getDocFromSupertypes = false;
        deleteXmlFile = false;
    }

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        if (!initialised) {
            String s;
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = ".";
            }
            if ((outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename")) == null) {
                outputFilename = "FeatureCatalogue";
            }
            if ((s = this.options.parameter(this.getClass().getName(), "inheritedProperties")) != null && s.equals("true")) {
                Inherit = true;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "inheritDocumentation")) != null && s.equals("true")) {
                getDocFromSupertypes = true;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "deleteXmlfile")) != null && s.equals("true")) {
                deleteXmlFile = true;
            }
            Package = (s = this.options.parameter(this.getClass().getName(), "package")) != null && s.length() > 0 ? s : "";
            s = this.options.parameter(this.getClass().getName(), "outputFormat");
            OutputFormat = s != null && s.length() > 0 ? s : "";
            s = this.options.parameter(this.getClass().getName(), "featureTerm");
            if (s != null && s.length() > 0) {
                featureTerm = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "includeVoidable")) != null && s.equalsIgnoreCase("false")) {
                includeVoidable = false;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "includeTitle")) != null && s.equalsIgnoreCase("false")) {
                includeTitle = false;
            }
            encoding = this.model.characterEncoding();
            s = this.options.parameter(this.getClass().getName(), "xslTransformerFactory");
            if (s != null && s.length() > 0) {
                xslTransformerFactory = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xslhtmlFile")) != null && s.length() > 0) {
                xslhtmlfileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xslfoFile")) != null && s.length() > 0) {
                xslfofileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xslrtfFile")) != null && s.length() > 0) {
                xslrtffileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xslxmlFile")) != null && s.length() > 0) {
                xslxmlfileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xsltPfad")) != null && s.length() > 0) {
                xsltPath = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "xsltPath")) != null && s.length() > 0) {
                xsltPath = s;
            }
            if ((refModel = this.getReferenceModel()) != null) {
                Differ differ = new Differ();
                HashSet<PackageInfo> set = refModel.schemas(p.name());
                if (set.size() == 1) {
                    HashMap<Info, HashSet<DiffElement>> diffs = differ.diff(p, set.iterator().next());
                    for (Map.Entry<Info, HashSet<DiffElement>> me : diffs.entrySet()) {
                        ShapeChangeResult.MessageContext mc = this.result.addInfo("Model difference - " + me.getKey().fullName().replace(p.fullName(), p.name()));
                        for (DiffElement diff : me.getValue()) {
                            s = (Object)((Object)diff.change) + " " + (Object)((Object)diff.subElementType);
                            if (diff.subElementType == DiffElement.ElementType.TAG) {
                                s = s + "(" + diff.tag + ")";
                            }
                            s = diff.subElement != null ? s + " " + diff.subElement.name() : (diff.diff != null ? s + " " + new diff_match_patch().diff_prettyHtml(diff.diff) : s + " ???");
                            mc.addDetail(s);
                        }
                    }
                }
            }
            document = this.createDocument();
            ProcessingInstruction proci = document.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./html.xsl'");
            document.appendChild(proci);
            document.appendChild(document.createComment("Feature catalogue created using ShapeChange"));
            root = document.createElement("FeatureCatalogue");
            document.appendChild(root);
            this.addAttribute(document, root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(document, root, "xsi:noNamespaceSchemaLocation", "FC.xsd");
            Element e1 = document.createElement("name");
            s = this.options.parameter(this.getClass().getName(), "name");
            if (s != null && s.length() > 0) {
                e1.setTextContent(s);
            } else {
                e1.setTextContent("unknown");
            }
            root.appendChild(e1);
            s = this.options.parameter(this.getClass().getName(), "scope");
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "scope", root);
            } else {
                e1 = document.createElement("scope");
                e1.setTextContent("unknown");
                root.appendChild(e1);
            }
            e1 = document.createElement("versionNumber");
            s = this.options.parameter(this.getClass().getName(), "versionNumber");
            if (s != null && s.length() > 0) {
                e1.setTextContent(s);
            } else {
                e1.setTextContent("unknown");
            }
            root.appendChild(e1);
            e1 = document.createElement("versionDate");
            s = this.options.parameter(this.getClass().getName(), "versionDate");
            if (s != null && s.length() > 0) {
                e1.setTextContent(s);
            } else {
                e1.setTextContent("unknown");
            }
            root.appendChild(e1);
            e1 = document.createElement("producer");
            s = this.options.parameter(this.getClass().getName(), "producer");
            if (s != null && s.length() > 0) {
                e1.setTextContent(s);
            } else {
                e1.setTextContent("unknown");
            }
            root.appendChild(e1);
        }
        Element e0 = document.createElement("ApplicationSchema");
        root.appendChild(e0);
        this.addAttribute(document, e0, "id", "_P" + this.pi.id());
        Element e1 = document.createElement("name");
        e1.setTextContent(this.pi.name());
        e0.appendChild(e1);
        String s = this.pi.definition();
        if (s != null && s.length() > 0) {
            this.PrintLineByLine(s, "definition", e0);
        }
        if ((s = this.pi.description()) != null && s.length() > 0) {
            this.PrintLineByLine(s, "description", e0);
        }
        e1 = document.createElement("versionNumber");
        e1.setTextContent(this.pi.version());
        e0.appendChild(e1);
        try {
            for (PackageInfo pix : this.pi.containedPackages()) {
                this.PrintPackage(pix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Model getReferenceModel() {
        String imt = this.options.parameter(this.getClass().getName(), "referenceModelType");
        String mdl = this.options.parameter(this.getClass().getName(), "referenceModelFile");
        if (imt == null || imt.isEmpty()) {
            return null;
        }
        if (mdl == null || mdl.isEmpty()) {
            return null;
        }
        if (imt.equalsIgnoreCase("ea7")) {
            imt = "de.interactive_instruments.ShapeChange.Model.EA.EADocument";
        } else if (imt.equalsIgnoreCase("xmi10")) {
            imt = "de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document";
        } else if (imt.equalsIgnoreCase("gsip")) {
            imt = "us.mitre.ShapeChange.Model.GSIP.GSIPDocument";
        }
        Model m = null;
        try {
            Class<?> theClass = Class.forName(imt);
            if (theClass == null) {
                this.result.addError(null, 17, imt);
                this.result.addError(null, 22, mdl);
                return null;
            }
            m = (Model)theClass.newInstance();
            if (m == null) {
                this.result.addError(null, 17, imt);
                this.result.addError(null, 22, mdl);
                return null;
            }
            m.initialise(this.result, this.options, mdl);
        }
        catch (ClassNotFoundException e) {
            this.result.addError(null, 17, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (InstantiationException e) {
            this.result.addError(null, 19, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (IllegalAccessException e) {
            this.result.addError(null, 20, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (ShapeChangeAbortException e) {
            this.result.addError(null, 22, mdl);
            m = null;
        }
        return m;
    }

    private void PrintPackage(PackageInfo pix) throws Exception {
        if (this.packageInPackage(pix)) {
            Element e1 = document.createElement("Package");
            Element e3 = document.createElement("parent");
            this.addAttribute(document, e3, "idref", "_P" + pix.owner().id());
            this.addAttribute(document, e1, "id", "_P" + pix.id());
            root.appendChild(e1);
            Element e2 = document.createElement("name");
            e2.setTextContent(this.PrepareToPrint(pix.name()));
            e1.appendChild(e2);
            String s = pix.definition();
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", e1);
            }
            if ((s = pix.description()) != null && s.length() > 0) {
                this.PrintLineByLine(s, "description", e1);
            }
            if ((s = pix.taggedValue("Code")) != null && s.length() > 0) {
                e2 = document.createElement("code");
                e2.setTextContent(this.PrepareToPrint(s));
                e1.appendChild(e2);
            }
            if (e3 != null) {
                e1.appendChild(e3);
            }
        }
        try {
            for (PackageInfo pix2 : pix.containedPackages()) {
                this.PrintPackage(pix2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void PrintLineByLine(String s, String ename, Element e1) {
        String[] lines;
        for (String line : lines = s.replace("[NEWLINE]", "\n").split("\n")) {
            Element e2 = document.createElement(ename);
            e2.setTextContent(this.PrepareToPrint(line));
            e1.appendChild(e2);
        }
    }

    private String PrepareToPrint(String s) {
        s = s.trim();
        return s;
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private boolean packageInPackage(PackageInfo pi) {
        if (Package.length() == 0) {
            return true;
        }
        if (pi.name().equals(Package)) {
            return true;
        }
        if (pi.isSchema()) {
            return false;
        }
        return this.packageInPackage(pi.owner());
    }

    public void process(ClassInfo ci) {
        if (error) {
            return;
        }
        if (!this.packageInPackage(ci.pkg())) {
            return;
        }
        int cat = ci.category();
        switch (cat) {
            case 1: 
            case 6: 
            case 12: {
                this.PrintClass(ci, true);
                break;
            }
            case 4: {
                if (Inherit.booleanValue()) break;
                this.PrintClass(ci, true);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                this.PrintClass(ci, true);
                for (String t : ci.supertypes()) {
                    ClassInfo cix = this.model.classById(t);
                    if (cix == null) continue;
                    additionalClasses.add(cix);
                }
                break;
            }
        }
    }

    private void PrintValues(ClassInfo ci) {
        for (PropertyInfo propi : ci.properties().values()) {
            if (propi == null || !this.ExportValue(propi)) continue;
            Element e1 = document.createElement("Value");
            this.addAttribute(document, e1, "id", "_A" + propi.id());
            root.appendChild(e1);
            Element e2 = document.createElement("label");
            e2.setTextContent(propi.aliasName());
            e1.appendChild(e2);
            e2 = document.createElement("code");
            String s = propi.initialValue();
            if (s == null || s.length() == 0) {
                s = propi.name();
            }
            e2.setTextContent(this.PrepareToPrint(s));
            e1.appendChild(e2);
            s = propi.definition();
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", e1);
            }
            if ((s = propi.description()) != null && s.length() > 0) {
                this.PrintLineByLine(s, "description", e1);
            }
            this.PrintStandardElements(propi, e1);
        }
    }

    private boolean ExportItem(Info i) {
        return true;
    }

    private boolean ExportValue(PropertyInfo propi) {
        return this.ExportItem(propi);
    }

    private boolean ExportProperty(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return false;
        }
        return this.ExportItem(propi);
    }

    private boolean ExportClass(ClassInfo ci, Boolean onlyProperties) {
        if (!ci.inSchema(this.pi) && !onlyProperties.booleanValue()) {
            return false;
        }
        if (!this.packageInPackage(ci.pkg()) && !onlyProperties.booleanValue()) {
            return false;
        }
        return this.ExportItem(ci);
    }

    private void PrintClass(ClassInfo ci, boolean onlyProperties) {
        if (!this.ExportClass(ci, onlyProperties)) {
            return;
        }
        if (onlyProperties) {
            String s;
            Element e1 = document.createElement("FeatureType");
            this.addAttribute(document, e1, "id", "_C" + ci.id());
            root.appendChild(e1);
            Element e2 = document.createElement("name");
            e2.setTextContent(this.PrepareToPrint(ci.name()));
            e1.appendChild(e2);
            if (includeTitle) {
                e2 = document.createElement("title");
                e2.setTextContent(ci.aliasName());
                e1.appendChild(e2);
            }
            if ((s = ci.definition()) != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", e1);
            } else if (getDocFromSupertypes) {
                // empty if block
            }
            s = ci.description();
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "description", e1);
            } else if (getDocFromSupertypes) {
                // empty if block
            }
            if (ci.isAbstract()) {
                this.PrintLineByLine("This type is abstract.", "description", e1);
            }
            if ((s = ci.taggedValue("Code")) != null && s.length() > 0) {
                e2 = document.createElement("code");
                e2.setTextContent(this.PrepareToPrint(s));
                e1.appendChild(e2);
            }
            for (String t : ci.supertypes()) {
                ClassInfo cix = this.model.classById(t);
                if (cix == null || Inherit.booleanValue() && cix.category() == 4) continue;
                e2 = document.createElement("subtypeOf");
                e2.setTextContent(cix.name());
                this.addAttribute(document, e2, "idref", "_C" + cix.id());
                e1.appendChild(e2);
            }
            this.PrintProperties(ci, true, e1);
            e2 = document.createElement("package");
            this.addAttribute(document, e2, "idref", "_P" + ci.pkg().id());
            e1.appendChild(e2);
            switch (ci.category()) {
                case 1: 
                case 12: {
                    e2 = document.createElement("type");
                    e2.setTextContent(featureTerm + " Type");
                    e1.appendChild(e2);
                    break;
                }
                case 6: {
                    e2 = document.createElement("type");
                    e2.setTextContent("Object Type");
                    e1.appendChild(e2);
                    break;
                }
                case 5: 
                case 11: {
                    e2 = document.createElement("type");
                    e2.setTextContent("Data Type");
                    e1.appendChild(e2);
                    break;
                }
                case 8: {
                    e2 = document.createElement("type");
                    e2.setTextContent("Union Data Type");
                    e1.appendChild(e2);
                }
            }
            this.PrintStandardElements(ci, e1);
            for (Constraint ocl : ci.constraints()) {
                e2 = document.createElement("constraint");
                s = ocl.text();
                if (s != null && s.contains("/*") && s.contains("*/")) {
                    s = s.replaceAll("/\\*|\\*/[\\w|\\W]*", "");
                }
                e2.setTextContent(ocl.name() + ": " + s);
                e1.appendChild(e2);
            }
            s = ci.taggedValue("alwaysVoid");
            if (s != null && s.length() > 0) {
                e2 = document.createElement("constraint");
                e2.setTextContent("Properties that are always void: " + s);
                e1.appendChild(e2);
            }
            if ((s = ci.taggedValue("neverVoid")) != null && s.length() > 0) {
                e2 = document.createElement("constraint");
                e2.setTextContent("Properties that are never void: " + s);
                e1.appendChild(e2);
            }
            if ((s = ci.taggedValue("appliesTo")) != null && s.length() > 0) {
                e2 = document.createElement("constraint");
                e2.setTextContent("Applies to the following network elements: " + s);
                e1.appendChild(e2);
            }
        }
        this.PrintProperties(ci, false, root);
    }

    private void PrintProperties(ClassInfo ci, boolean listOnly, Element e1) {
        for (PropertyInfo propi : ci.properties().values()) {
            if (listOnly) {
                this.PrintPropertyRef(propi, e1);
                continue;
            }
            this.PrintProperty(propi);
        }
        if (Inherit.booleanValue()) {
            for (String cid : ci.supertypes()) {
                ClassInfo cix = this.model.classById(cid);
                if (cix == null) continue;
                this.PrintProperties(cix, listOnly, e1);
            }
        }
    }

    private void PrintPropertyRef(PropertyInfo propi, Element e1) {
        if (this.ExportProperty(propi)) {
            Element e2 = document.createElement("characterizedBy");
            this.addAttribute(document, e2, "idref", "_A" + propi.id());
            e1.appendChild(e2);
        }
    }

    private void PrintProperty(PropertyInfo propi) {
        if (!this.ExportProperty(propi)) {
            return;
        }
        if (exportedProperties.contains(propi)) {
            return;
        }
        String assocId = "__FIXME";
        if (!propi.isAttribute()) {
            if (!exportedRoles.contains(propi)) {
                ClassInfo aci;
                Element e1 = document.createElement("FeatureRelationship");
                assocId = "__" + propi.id();
                this.addAttribute(document, e1, "id", assocId);
                root.appendChild(e1);
                Element e2 = document.createElement("name");
                e2.setTextContent(this.PrepareToPrint("(unbestimmt)"));
                e1.appendChild(e2);
                AssociationInfo ai = propi.association();
                if (ai != null && (aci = ai.assocClass()) != null) {
                    e2 = document.createElement("associationClass");
                    this.addAttribute(document, e2, "idref", "_C" + aci.id());
                    e2.setTextContent(this.PrepareToPrint(aci.name()));
                    e1.appendChild(e2);
                }
                e2 = document.createElement("roles");
                this.addAttribute(document, e2, "idref", "_A" + propi.id());
                e1.appendChild(e2);
                this.PrintPropertyDetail(propi, assocId);
                exportedRoles.add(propi);
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    if (this.ExportProperty(propi2)) {
                        e2 = document.createElement("roles");
                        this.addAttribute(document, e2, "idref", "_A" + propi2.id());
                        e1.appendChild(e2);
                        this.PrintPropertyDetail(propi2, assocId);
                    }
                    exportedRoles.add(propi2);
                }
            } else {
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    assocId = "__" + propi2.id();
                }
            }
        } else {
            this.PrintPropertyDetail(propi, assocId);
        }
        exportedProperties.add(propi);
    }

    private void PrintPropertyDetail(PropertyInfo propi, String assocId) {
        Element e1 = propi.isAttribute() ? document.createElement("FeatureAttribute") : document.createElement("RelationshipRole");
        this.addAttribute(document, e1, "id", "_A" + propi.id());
        root.appendChild(e1);
        Element e2 = document.createElement("name");
        e2.setTextContent(this.PrepareToPrint(propi.name()));
        e1.appendChild(e2);
        if (includeTitle) {
            e2 = document.createElement("title");
            e2.setTextContent(propi.aliasName());
            e1.appendChild(e2);
        }
        e2 = document.createElement("cardinality");
        Multiplicity m = propi.cardinality();
        String s = m.maxOccurs == m.minOccurs ? "" + m.minOccurs : (m.maxOccurs == Integer.MAX_VALUE ? "" + m.minOccurs + ".." + "*" : "" + m.minOccurs + ".." + m.maxOccurs);
        e2.setTextContent(this.PrepareToPrint(s));
        e1.appendChild(e2);
        s = propi.definition();
        if (s != null && s.length() > 0) {
            this.PrintLineByLine(s, "definition", e1);
        }
        if ((s = propi.description()) != null && s.length() > 0) {
            this.PrintLineByLine(s, "description", e1);
        }
        if (!propi.isAttribute() && !propi.isNavigable()) {
            this.PrintLineByLine("This is a non-navigable relationship role.", "description", e1);
        }
        if (propi.isDerived()) {
            this.PrintLineByLine("This is a derived property.", "description", e1);
        }
        s = propi.initialValue();
        if (propi.isAttribute() && s != null && s.length() > 0) {
            this.PrintLineByLine("This attribute is initialised with the value " + this.PrepareToPrint(s) + ".", "description", e1);
        }
        if ((s = propi.taggedValue("Code")) != null && s.length() > 0) {
            e2 = document.createElement("code");
            if (propi.isDerived()) {
                s = "(DER) " + s;
            }
            e2.setTextContent(this.PrepareToPrint(s));
            e1.appendChild(e2);
        }
        if (includeVoidable) {
            e2 = document.createElement("voidable");
            e1.appendChild(e2);
            if (propi.voidable()) {
                e2.setTextContent("true");
            } else {
                e2.setTextContent("false");
            }
        }
        this.PrintStandardElements(propi, e1);
        Type ti = propi.typeInfo();
        if (!propi.isAttribute() && !propi.isComposition()) {
            if (ti != null) {
                e2 = document.createElement("FeatureTypeIncluded");
                ClassInfo cix = this.model.classById(ti.id);
                if (cix != null) {
                    this.addAttribute(document, e2, "idref", "_C" + ti.id);
                }
                e2.setTextContent(ti.name);
                e1.appendChild(e2);
                this.addAttribute(document, e2, "category", featureTerm.toLowerCase() + " type");
            }
            e2 = document.createElement("relation");
            this.addAttribute(document, e2, "idref", assocId);
            e1.appendChild(e2);
            PropertyInfo propi2 = propi.reverseProperty();
            if (propi2 != null && this.ExportProperty(propi2) && propi2.isNavigable()) {
                e2 = document.createElement("InverseRole");
                this.addAttribute(document, e2, "idref", "_A" + propi2.id());
                e1.appendChild(e2);
            }
            e2 = document.createElement("orderIndicator");
            if (propi.isOrdered()) {
                e2.setTextContent("1");
            } else {
                e2.setTextContent("0");
            }
            e1.appendChild(e2);
        } else if (ti != null) {
            ClassInfo cix = this.model.classById(ti.id);
            if (cix != null) {
                int cat = cix.category();
                switch (cat) {
                    case 2: 
                    case 3: {
                        e2 = document.createElement("ValueDataType");
                        e2.setTextContent(this.PrepareToPrint(cix.name()));
                        e1.appendChild(e2);
                        if (cat == 2) {
                            this.addAttribute(document, e2, "category", "code list");
                        } else if (cat == 3 && !cix.name().equals("Boolean")) {
                            this.addAttribute(document, e2, "category", "enumeration");
                        }
                        e2 = document.createElement("ValueDomainType");
                        e1.appendChild(e2);
                        if (!cix.name().equals("Boolean")) {
                            e2.setTextContent("1");
                            for (PropertyInfo ei : cix.properties().values()) {
                                if (ei == null || !this.ExportValue(ei)) continue;
                                e2 = document.createElement("enumeratedBy");
                                this.addAttribute(document, e2, "idref", "_A" + ei.id());
                                e1.appendChild(e2);
                            }
                            enumerations.add(cix);
                            break;
                        }
                        e2.setTextContent("0");
                        break;
                    }
                    default: {
                        e2 = document.createElement("ValueDataType");
                        this.addAttribute(document, e2, "idref", "_C" + cix.id());
                        e2.setTextContent(this.PrepareToPrint(cix.name()));
                        e1.appendChild(e2);
                        if (cat == 1 || cat == 12) {
                            this.addAttribute(document, e2, "category", featureTerm.toLowerCase() + " type");
                        } else if (cat == 5 || cat == 11) {
                            this.addAttribute(document, e2, "category", "data type");
                        } else if (cat == 8 || cat == 9) {
                            this.addAttribute(document, e2, "category", "union data type");
                        } else if (cat == 7) {
                            this.addAttribute(document, e2, "category", "basic type");
                        }
                        e2 = document.createElement("ValueDomainType");
                        e2.setTextContent("0");
                        e1.appendChild(e2);
                        break;
                    }
                }
            } else {
                e2 = document.createElement("ValueDataType");
                e2.setTextContent(this.PrepareToPrint(ti.name));
                e1.appendChild(e2);
            }
        } else {
            e2 = document.createElement("ValueDataType");
            e2.setTextContent("(unknown)");
            e1.appendChild(e2);
        }
    }

    private void PrintStandardElements(Info i, Element e1) {
    }

    public void write() {
    }

    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        if (error || printed) {
            return;
        }
        for (ClassInfo cix : additionalClasses) {
            this.PrintClass(cix, false);
        }
        for (ClassInfo cix : enumerations) {
            this.PrintValues(cix);
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        if (encoding != null) {
            outputFormat.setProperty("encoding", encoding);
        }
        String xmlName = outputFilename + ".tmp.xml";
        try {
            File outputDirectoryFile = new File(outputDirectory);
            boolean exi = outputDirectoryFile.exists();
            if (!exi) {
                outputDirectoryFile.mkdirs();
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(this, 12, outputDirectory);
                throw new ShapeChangeAbortException();
            }
            FileOutputStream fout = new FileOutputStream(outputDirectory + "/" + xmlName);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)document);
            outputXML.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.writePDF(xmlName, outputFilename);
        this.writeHTML(xmlName, outputFilename);
        this.writeXML(xmlName, outputFilename);
        this.writeRTF(xmlName, outputFilename);
        File outDir = new File(outputDirectory);
        File xmlFile = new File(outDir, xmlName);
        printed = true;
    }

    private void writePDF(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(22);
        if (!OutputFormat.toLowerCase().contains("pdf")) {
            return;
        }
        String pdffileName = outfileBasename + ".pdf";
        String mime = "application/pdf";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && pdffileName != null && pdffileName.length() > 0) {
            this.fopWrite(xmlName, xslfofileName, pdffileName, mime);
        }
    }

    private void writeHTML(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(23);
        if (!OutputFormat.toLowerCase().contains("html")) {
            return;
        }
        String htmlfileName = outfileBasename + ".html";
        if (xmlName != null && xmlName.length() > 0 && xslhtmlfileName != null && xslhtmlfileName.length() > 0 && htmlfileName != null && htmlfileName.length() > 0) {
            this.xsltWrite(xmlName, xslhtmlfileName, htmlfileName);
        }
    }

    private void writeRTF(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(25);
        if (!OutputFormat.toLowerCase().contains("rtf")) {
            return;
        }
        String rtffileName = outfileBasename + ".rtf";
        if (xmlName != null && xmlName.length() > 0 && xslrtffileName != null && xslrtffileName.length() > 0 && rtffileName != null && rtffileName.length() > 0) {
            this.xsltWrite(xmlName, xslrtffileName, rtffileName);
        }
    }

    private void writeXML(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(24);
        if (!OutputFormat.toLowerCase().contains("xml")) {
            return;
        }
        String xmloutFileName = outfileBasename + ".xml";
        if (xmlName != null && xmlName.length() > 0 && xslxmlfileName != null && xslxmlfileName.length() > 0 && xmloutFileName != null && xmloutFileName.length() > 0) {
            this.xsltWrite(xmlName, xslxmlfileName, xmloutFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fopWrite(String xmlName, String xslfofileName, String outfileName, String outputMimetype) {
        block13: {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", encoding);
            Logger fl = Logger.getLogger("org.apache.fop");
            fl.setLevel(Level.WARNING);
            FopMsgHandler fmh = new FopMsgHandler(this.result, this);
            fl.addHandler(fmh);
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
                boolean skip = false;
                File outDir = new File(outputDirectory);
                File xmlFile = new File(outDir, xmlName);
                File xsltFile = new File(xsltPath, xslfofileName);
                File outFile = new File(outDir, outfileName);
                if (!xmlFile.canRead()) {
                    this.result.addError(null, 301, xmlFile.getName(), outfileName);
                    skip = true;
                }
                if (!xsltFile.canRead()) {
                    this.result.addError(null, 301, xsltFile.getName(), outfileName);
                    skip = true;
                }
                if (skip) break block13;
                OutputStream out = null;
                try {
                    out = new FileOutputStream(outFile);
                    out = new BufferedOutputStream(out);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outFile.getName(), e.getMessage());
                    skip = true;
                }
                if (skip) break block13;
                try {
                    Fop fop = fopFactory.newFop("application/pdf", foUserAgent, out);
                    TransformerFactory factory = null;
                    factory = xslTransformerFactory == null ? TransformerFactory.newInstance() : TransformerFactory.newInstance(xslTransformerFactory, null);
                    Transformer transformer = factory.newTransformer(new StreamSource(xsltFile));
                    FopErrorListener el = new FopErrorListener(xmlFile.getName(), this.result, this);
                    transformer.setErrorListener(el);
                    transformer.setParameter("versionParam", "2.0");
                    StreamSource src = new StreamSource(xmlFile);
                    SAXResult res = new SAXResult(fop.getDefaultHandler());
                    transformer.transform(src, res);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outfileName, e.getMessage());
                    skip = true;
                }
                finally {
                    out.close();
                    this.result.addResult(this.getTargetID(), outputDirectory, outfileName, null);
                    if (deleteXmlFile) {
                        xmlFile.delete();
                    }
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
    }

    public void xsltWrite(String xmlName, String xsltfileName, String outfileName) {
        try {
            File outDir = new File(outputDirectory);
            File xmlFile = new File(outDir, xmlName);
            if (!xmlFile.canRead()) {
                this.result.addError(null, 301, xmlFile.getName(), outfileName);
                return;
            }
            File outFile = new File(outDir, outfileName);
            InputStream stream = null;
            if (xsltPath.toLowerCase().startsWith("http")) {
                URL url = new URL(xsltPath + "/" + xsltfileName);
                URLConnection urlConnection = url.openConnection();
                stream = urlConnection.getInputStream();
            } else {
                File xsl = new File(xsltPath + "/" + xsltfileName);
                if (xsl.exists()) {
                    stream = new FileInputStream(xsl);
                } else {
                    this.result.addError("XSLT stylesheet " + xsl.getAbsolutePath() + " not found.");
                    return;
                }
            }
            StreamSource xsltSource = new StreamSource(stream);
            StreamSource xmlSource = new StreamSource(xmlFile);
            StreamResult res = new StreamResult(outFile);
            TransformerFactory transFact = null;
            transFact = xslTransformerFactory == null ? TransformerFactory.newInstance() : TransformerFactory.newInstance(xslTransformerFactory, null);
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, res);
            this.result.addResult(this.getTargetID(), outputDirectory, outfileName, null);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "Feature Catalogue Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
        }
        return null;
    }
}

