/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Type;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

public abstract class OclNode {
    static final HashMap<String, BuiltInType> iso19103Map = new HashMap();
    static BuiltInDescr[] builtInDescriptors;
    static BuiltInDescr[] operSymbDescriptors;
    public DataType dataType = null;

    public static BuiltInType iso19103AssumedBuiltInType(ClassInfo ci) {
        BuiltInType bit = iso19103Map.get(ci.name());
        if (bit != null) {
            return bit;
        }
        HashSet<String> scids = ci.supertypes();
        if (scids != null) {
            for (String scid : scids) {
                BuiltInType sbit;
                ClassInfo sci = ci.model().classById(scid);
                if (sci == null || (sbit = OclNode.iso19103AssumedBuiltInType(sci)) == null) continue;
                return sbit;
            }
        }
        return null;
    }

    public void debugPrint(PrintWriter stream) {
        stream.print("[");
        this.debugPrintContent(stream);
        stream.print(":");
        stream.print(this.dataType.name);
        stream.print("]");
    }

    public void debugPrintContent(PrintWriter stream) {
        stream.print("TODO<");
        stream.print(this.getClass().getSimpleName());
        stream.print(">");
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isBuiltInType() {
        return this.dataType.isBuiltIn();
    }

    public boolean isMultiple() {
        return false;
    }

    static {
        iso19103Map.put("CharacterString", BuiltInType.STRING);
        iso19103Map.put("Character", BuiltInType.STRING);
        iso19103Map.put("Boolean", BuiltInType.BOOLEAN);
        iso19103Map.put("Number", BuiltInType.REAL);
        iso19103Map.put("Real", BuiltInType.REAL);
        iso19103Map.put("Decimal", BuiltInType.REAL);
        iso19103Map.put("Area", BuiltInType.REAL);
        iso19103Map.put("Length", BuiltInType.REAL);
        iso19103Map.put("Integer", BuiltInType.INTEGER);
        iso19103Map.put("Date", BuiltInType.DATE);
        iso19103Map.put("DateTime", BuiltInType.DATE);
        builtInDescriptors = new BuiltInDescr[]{new BuiltInDescr("allInstances", BuiltInType.CLASS, null, 0, false, MultiplicityMapping.ONE2MANY, BuiltInType.UMLTYPE, 1), new BuiltInDescr("size", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.INTEGER), new BuiltInDescr("isEmpty", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("notEmpty", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("exists", BuiltInType.ANY, new BuiltInType[]{BuiltInType.BOOLEAN}, 1, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("forAll", BuiltInType.ANY, new BuiltInType[]{BuiltInType.BOOLEAN}, 1, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("isUnique", BuiltInType.ANY, new BuiltInType[]{BuiltInType.ANY}, 1, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("select", BuiltInType.ANY, new BuiltInType[]{BuiltInType.BOOLEAN}, 1, true, MultiplicityMapping.MANY2MANY, BuiltInType.ANY, 2), new BuiltInDescr("size", BuiltInType.STRING, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("substring", BuiltInType.STRING, new BuiltInType[]{BuiltInType.INTEGER, BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.STRING, 4), new BuiltInDescr("concat", BuiltInType.STRING, new BuiltInType[]{BuiltInType.STRING}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.STRING, 4), new BuiltInDescr("matches", BuiltInType.STRING, new BuiltInType[]{BuiltInType.STRING}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN, 4), new BuiltInDescr("oclIsKindOf", BuiltInType.ANY, new BuiltInType[]{BuiltInType.CLASS}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("oclIsTypeOf", BuiltInType.ANY, new BuiltInType[]{BuiltInType.CLASS}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("oclAsType", BuiltInType.ANY, new BuiltInType[]{BuiltInType.CLASS}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.ANY, 3)};
        operSymbDescriptors = new BuiltInDescr[]{new BuiltInDescr("or", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("xor", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("and", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("implies", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("not", BuiltInType.BOOLEAN, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("-", BuiltInType.INTEGER, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("-", BuiltInType.REAL, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("+", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("-", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("*", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("/", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("=", BuiltInType.ANY, new BuiltInType[]{BuiltInType.ANY}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<>", BuiltInType.ANY, new BuiltInType[]{BuiltInType.ANY}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN)};
    }

    public static class IterationCallExp
    extends OperationCallExp {
        public Declaration[] declarations = null;

        IterationCallExp(OclNode o, String name, Declaration[] decls, OclNode[] args, DataType type, MultiplicityMapping mm) {
            super(o, true, name, args, type, mm, false);
            this.selector.category = PropertyCategory.ITEROPER;
            this.declarations = decls;
        }

        public void debugPrintContent(PrintWriter stream) {
            this.object.debugPrint(stream);
            stream.print("->");
            stream.print(this.selector.name);
            stream.print("(");
            int i = 0;
            for (Declaration d : this.declarations) {
                d.debugPrint(stream);
                if (i++ <= 0) continue;
                stream.print(",");
            }
            i = 0;
            for (OclNode n : this.arguments) {
                n.debugPrint(stream);
                if (i++ <= 0) continue;
                stream.print(",");
            }
            stream.print(")");
        }
    }

    public static class OperationCallExp
    extends PropertyCallExp {
        public OclNode[] arguments = null;

        OperationCallExp(OclNode o, OperationInfo oi, OclNode[] args, boolean im) {
            this.object = o;
            TreeMap<Integer, String> pnames = oi.parameterNames();
            TreeMap<Integer, String> ptypes = oi.parameterTypes();
            String tname = null;
            for (int i = 1; i <= pnames.size(); ++i) {
                if (!pnames.get(i).equals("__RETURN__")) continue;
                tname = ptypes.get(i);
            }
            ClassInfo ci = null;
            if (tname != null) {
                ci = oi.model().classByName(tname);
            } else {
                tname = "Void";
            }
            this.dataType = ci != null ? new DataType(ci) : new DataType(tname);
            this.selector = new PropertySelector(oi);
            this.isImplicit = im;
            this.multMapping = MultiplicityMapping.ONE2ONE;
            this.arguments = args;
        }

        OperationCallExp(OclNode o, boolean setLevel, String name, OclNode[] args, DataType type, MultiplicityMapping mm, boolean imp) {
            this.object = o;
            this.dataType = type;
            this.selector = o instanceof ClassLiteralExp ? new PropertySelector(PropertyCategory.CLASSOPER, name) : (setLevel ? new PropertySelector(PropertyCategory.SETOPER, name) : (o.isBuiltInType() ? new PropertySelector(PropertyCategory.BASEOPER, name) : new PropertySelector(PropertyCategory.UMLADDOPER, name)));
            this.multMapping = mm;
            this.isImplicit = imp;
            this.arguments = args;
        }

        public void debugPrintContent(PrintWriter stream) {
            this.object.debugPrint(stream);
            if (this.selector.category == PropertyCategory.SETOPER) {
                stream.print("->");
            } else {
                stream.print(".");
            }
            stream.print(this.selector.name);
            stream.print("(");
            int i = 0;
            for (OclNode n : this.arguments) {
                n.debugPrint(stream);
                if (i++ <= 0) continue;
                stream.print(",");
            }
            stream.print(")");
        }
    }

    public static class AttributeCallExp
    extends PropertyCallExp {
        AttributeCallExp(OclNode o, PropertyInfo pi, boolean im) {
            this.object = o;
            Type t = pi.typeInfo();
            ClassInfo ci = pi.model().classById(t.id);
            this.dataType = ci != null ? new DataType(ci) : new DataType(t.name);
            this.selector = new PropertySelector(pi);
            this.isImplicit = im;
            this.multMapping = pi.cardinality().maxOccurs <= 1 ? MultiplicityMapping.ONE2ONE : MultiplicityMapping.ONE2MANY;
        }

        public void debugPrintContent(PrintWriter stream) {
            this.object.debugPrint(stream);
            stream.print(".");
            stream.print(this.selector.name);
        }
    }

    public static abstract class PropertyCallExp
    extends OclNode {
        public OclNode object;
        public PropertySelector selector;
        public MultiplicityMapping multMapping;
        public boolean isImplicit = false;

        public boolean isMultiple() {
            return this.multMapping == MultiplicityMapping.MANY2MANY || this.multMapping == MultiplicityMapping.ONE2MANY || this.multMapping == MultiplicityMapping.ONE2ONE && this.object.isMultiple();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultiplicityMapping {
        ONE2ONE,
        ONE2MANY,
        MANY2ONE,
        MANY2MANY;

    }

    public static class PropertySelector {
        public PropertyCategory category = PropertyCategory.INVALID;
        public String name = null;
        public Info modelProperty = null;

        PropertySelector(PropertyInfo pi) {
            this.category = PropertyCategory.UMLPROPERTY;
            this.modelProperty = pi;
            this.name = pi.name();
        }

        PropertySelector(OperationInfo oi) {
            this.category = PropertyCategory.UMLOPERATION;
            this.modelProperty = oi;
            this.name = oi.name();
        }

        PropertySelector(PropertyCategory pc, String name) {
            this.category = pc;
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyCategory {
        UMLPROPERTY,
        UMLOPERATION,
        UMLADDOPER,
        BASEOPER,
        SETOPER,
        ITEROPER,
        CLASSOPER,
        INVALID;

    }

    public static class LetExp
    extends OclNode {
        public Declaration[] declarations;
        public OclNode body;

        LetExp(Declaration[] dcls, OclNode body) {
            this.dataType = body.dataType;
            this.declarations = dcls;
            this.body = body;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("let");
            int i = 0;
            for (Declaration d : this.declarations) {
                d.debugPrint(stream);
                if (i++ <= 0) continue;
                stream.print(",");
            }
            stream.print("|");
            this.body.debugPrint(stream);
        }
    }

    public static class IfExp
    extends OclNode {
        public OclNode condition;
        public OclNode ifExpression;
        public OclNode elseExpression;

        IfExp(DataType type, OclNode c, OclNode i, OclNode e) {
            this.dataType = type;
            this.condition = c;
            this.ifExpression = i;
            this.elseExpression = e;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("if");
            this.condition.debugPrint(stream);
            stream.print("then");
            this.ifExpression.debugPrint(stream);
            stream.print("else ");
            this.elseExpression.debugPrint(stream);
            stream.print("endif");
        }

        public boolean isMultiple() {
            return this.ifExpression.isMultiple() || this.elseExpression.isMultiple();
        }
    }

    public static class VariableExp
    extends OclNode {
        public Declaration declaration = null;

        public VariableExp(Declaration decl) {
            this.dataType = decl.dataType;
            this.declaration = decl;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("?");
            stream.print(this.declaration.name);
        }
    }

    public static class Declaration
    extends OclNode {
        public String name = null;
        public OclNode initialValue = null;
        public Declaration nextOuter = null;
        public OclNode ownerNode = null;
        public boolean isImplicit = false;

        public Declaration(String name, DataType dt, OclNode ival, Declaration declCtx, OclNode owner, boolean impl) {
            this.name = name != null ? name : "(noname)";
            this.dataType = dt;
            this.initialValue = ival;
            this.nextOuter = declCtx;
            this.ownerNode = owner;
            this.isImplicit = impl;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.name);
        }
    }

    public static class PackageLiteralExp
    extends LiteralExp {
        public PackageInfo umlPackage;

        PackageLiteralExp(PackageInfo pi) {
            this.dataType = new DataType(BuiltInType.PACKAGE);
            this.umlPackage = pi;
        }

        PackageInfo getPackage() {
            return this.umlPackage;
        }

        public String asString() {
            return this.umlPackage.name();
        }
    }

    public static class EnumerationLiteralExp
    extends LiteralExp {
        public PropertyInfo umlProperty;

        EnumerationLiteralExp(PropertyInfo pi) {
            this.dataType = new DataType(pi.inClass());
            this.umlProperty = pi;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("#");
            stream.print(this.umlProperty.name());
        }

        public String asString() {
            return this.umlProperty.name();
        }
    }

    public static class ClassLiteralExp
    extends LiteralExp {
        public ClassInfo umlClass;

        ClassLiteralExp(ClassInfo ci) {
            this.dataType = new DataType(BuiltInType.CLASS);
            this.umlClass = ci;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.umlClass.name());
        }

        public String asString() {
            return this.umlClass.name();
        }
    }

    public static class OclVoidLiteralExp
    extends LiteralExp {
        OclVoidLiteralExp() {
            this.dataType = new DataType(BuiltInType.OCLVOID);
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("*NULL*");
        }

        public String asString() {
            return "*NULL*";
        }
    }

    public static class DateTimeLiteralExp
    extends LiteralExp {
        public boolean current;
        public GregorianCalendar dateTime = null;

        DateTimeLiteralExp() {
            this.dataType = new DataType(BuiltInType.DATE);
            this.current = true;
        }

        DateTimeLiteralExp(GregorianCalendar date) {
            this.dataType = new DataType(BuiltInType.DATE);
            this.current = false;
            this.dateTime = date;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.asString());
        }

        public String asString() {
            if (this.current) {
                return "*NOW*";
            }
            return this.dateTime.getTime().toString();
        }
    }

    public static class BooleanLiteralExp
    extends LiteralExp {
        public boolean value;

        BooleanLiteralExp(boolean value) {
            this.dataType = new DataType(BuiltInType.BOOLEAN);
            this.value = value;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.value ? "true" : "false");
        }

        public String asString() {
            return this.value ? "true" : "false";
        }
    }

    public static class StringLiteralExp
    extends LiteralExp {
        public String value;

        StringLiteralExp(String value) {
            this.dataType = new DataType(BuiltInType.STRING);
            this.value = value;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print("'");
            stream.print(this.value);
            stream.print("'");
        }

        public String asString() {
            return this.value;
        }
    }

    public static class IntegerLiteralExp
    extends LiteralExp {
        public long value;

        IntegerLiteralExp(long value) {
            this.dataType = new DataType(BuiltInType.INTEGER);
            this.value = value;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.value);
        }

        public String asString() {
            return Long.toString(this.value);
        }
    }

    public static class RealLiteralExp
    extends LiteralExp {
        public double value;

        RealLiteralExp(double value) {
            this.dataType = new DataType(BuiltInType.REAL);
            this.value = value;
        }

        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.value);
        }

        public String asString() {
            return Double.toString(this.value);
        }
    }

    public static abstract class LiteralExp
    extends OclNode {
        public abstract String asString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Expression
    extends OclNode {
        public String name;
        public OclConstraint.ConditionType expressionType;
        public OclNode expression;
        public Declaration selfDeclaration;
        public ArrayList<Declaration> environmentDeclarations;

        Expression(String name, OclConstraint.ConditionType et, OclNode exp, Declaration self, ArrayList<Declaration> envDecls) {
            this.dataType = exp.getDataType();
            this.name = name;
            this.expressionType = et;
            this.expression = exp;
            this.selfDeclaration = self;
            this.environmentDeclarations = envDecls;
        }

        @Override
        public void debugPrintContent(PrintWriter stream) {
            stream.print(this.expressionType.toString());
            stream.print(":");
            this.selfDeclaration.debugPrint(stream);
            stream.print("|");
            this.expression.debugPrint(stream);
        }

        @Override
        public boolean isMultiple() {
            return this.expression.isMultiple();
        }
    }

    public static class DataType {
        public String name = null;
        public BuiltInType builtInType = BuiltInType.VOID;
        public ClassInfo umlClass = null;

        public DataType(ClassInfo ci) {
            BuiltInType bi;
            this.name = ci.name();
            this.umlClass = ci;
            int cat = ci.category();
            this.builtInType = BuiltInType.UMLTYPE;
            if (cat == 2 || cat == 3) {
                this.builtInType = BuiltInType.ENUMERATION;
            }
            if ((bi = OclNode.iso19103AssumedBuiltInType(this.umlClass)) != null) {
                this.builtInType = bi;
            }
        }

        public DataType(BuiltInType bit) {
            this.name = bit.oclName();
            this.umlClass = null;
            this.builtInType = bit;
        }

        public DataType(String name) {
            BuiltInType bi;
            this.name = name;
            this.umlClass = null;
            for (BuiltInType bi2 : BuiltInType.values()) {
                if (!bi2.oclName().equals(name)) continue;
                this.builtInType = bi2;
                break;
            }
            if ((bi = iso19103Map.get(name)) != null) {
                this.builtInType = bi;
            }
        }

        public boolean isBuiltIn() {
            return this.builtInType != BuiltInType.UMLTYPE && this.builtInType != BuiltInType.ENUMERATION;
        }

        public boolean isSubTypeOf(DataType type) {
            if (this.isBuiltIn()) {
                if (!type.isBuiltIn()) {
                    return false;
                }
                BuiltInType bit1 = this.builtInType;
                BuiltInType bit2 = type.builtInType;
                if (bit1 == bit2) {
                    return true;
                }
                return bit1 == BuiltInType.INTEGER && bit2 == BuiltInType.REAL;
            }
            if (type.isBuiltIn()) {
                return false;
            }
            BuiltInType bit1 = this.builtInType;
            BuiltInType bit2 = type.builtInType;
            if (bit1 != bit2) {
                return false;
            }
            if (this.umlClass == type.umlClass) {
                return true;
            }
            for (ClassInfo ci = this.umlClass; ci != null; ci = ci.baseClass()) {
                if (ci != type.umlClass) continue;
                return true;
            }
            return false;
        }

        public DataType commonSuperType(DataType type) {
            if (this.builtInType == BuiltInType.OCLVOID) {
                return type;
            }
            if (type.builtInType == BuiltInType.OCLVOID) {
                return this;
            }
            if (this.isBuiltIn()) {
                if (!type.isBuiltIn()) {
                    return null;
                }
                BuiltInType bit1 = this.builtInType;
                BuiltInType bit2 = type.builtInType;
                if (bit1 == bit2) {
                    return this;
                }
                if (bit1 == BuiltInType.INTEGER) {
                    bit1 = BuiltInType.REAL;
                }
                if (bit2 == BuiltInType.INTEGER) {
                    bit2 = BuiltInType.REAL;
                }
                if (bit1 == bit2) {
                    return new DataType(BuiltInType.REAL);
                }
                return null;
            }
            if (type.isBuiltIn()) {
                return null;
            }
            BuiltInType bit1 = this.builtInType;
            BuiltInType bit2 = type.builtInType;
            if (bit1 != bit2) {
                return null;
            }
            if (this.umlClass == type.umlClass) {
                return this;
            }
            ClassInfo sci = null;
            block0: for (ClassInfo ci1 = this.umlClass; ci1 != null; ci1 = ci1.baseClass()) {
                for (ClassInfo ci2 = type.umlClass; ci2 != null; ci2 = ci2.baseClass()) {
                    if (ci1 != ci2) continue;
                    sci = ci1;
                    break block0;
                }
            }
            if (sci == null) {
                return null;
            }
            return new DataType(sci);
        }
    }

    public static class BuiltInDescr {
        String name;
        BuiltInType applType;
        BuiltInType[] arguTypes;
        int noOfDecls;
        boolean arrow;
        MultiplicityMapping multMap;
        BuiltInType resType;
        int specialTreatment;

        BuiltInDescr(String name, BuiltInType applType, BuiltInType[] arguTypes, int noOfDecls, boolean arrow, MultiplicityMapping multMap, BuiltInType resType) {
            this(name, applType, arguTypes, noOfDecls, arrow, multMap, resType, 0);
        }

        BuiltInDescr(String name, BuiltInType applType, BuiltInType[] arguTypes, int noOfDecls, boolean arrow, MultiplicityMapping multMap, BuiltInType resType, int specialTreatment) {
            this.name = name;
            this.applType = applType;
            this.arguTypes = arguTypes;
            this.noOfDecls = noOfDecls;
            this.arrow = arrow;
            this.multMap = multMap;
            this.resType = resType;
            this.specialTreatment = specialTreatment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuiltInType {
        REAL,
        INTEGER,
        STRING,
        BOOLEAN,
        DATE,
        CLASS,
        ENUMERATION,
        PACKAGE,
        ANY,
        OCLVOID,
        INVALID,
        VOID,
        UMLTYPE;


        String oclName() {
            String s = this.name();
            if (this.equals((Object)OCLVOID)) {
                return "OclVoid";
            }
            return s.substring(0, 1) + s.substring(1).toLowerCase();
        }
    }
}

