/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Xmi10Document;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyInfoXmi10
implements PropertyInfo {
    protected Element prp = null;
    protected Xmi10Document doc = null;
    protected String id = null;
    protected boolean attribute = true;
    protected ClassInfo classInfo = null;
    protected int sequenceNumber = Integer.MIN_VALUE;
    protected boolean restriction = false;
    protected PropertyInfo reverseProperty = null;
    private boolean metadata = false;
    private boolean nilReasonAllowed = false;

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        if (s != null) {
            if ((s = s.trim()).startsWith("/")) {
                s = s.substring(1);
            }
            if (this.attribute && s.indexOf("[") > 0 && s.endsWith("]")) {
                String[] parts = s.split("\\[");
                s = parts[0].trim();
            }
        } else {
            this.doc.result.addWarning("The attribute with ID " + this.id + " has no name. The ID is used instead.");
            s = this.id;
        }
        return s;
    }

    @Override
    public String qname() {
        return String.valueOf(this.inClass().pkg().xmlns()) + ":" + this.name();
    }

    @Override
    public String encodingRule(String platform) {
        String s = this.doc.taggedValue(this.id, String.valueOf(platform) + "EncodingRule");
        if (s == null) {
            s = this.inClass().encodingRule(platform);
        }
        return s;
    }

    @Override
    public boolean isDerived() {
        String s = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        return s != null && (s = s.trim()).startsWith("/");
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public Type typeInfo() {
        String[] parts;
        Element e;
        Type ti = new Type();
        ti.id = this.attribute ? this.doc.idOfProperty(this.prp, "Foundation.Core.StructuralFeature.type").trim() : this.doc.idOfProperty(this.prp, "Foundation.Core.AssociationEnd.type").trim();
        if (this.doc.options.supportSequenceSetEtc && this.attribute && (e = this.doc.getElementById(ti.id)) != null) {
            ti.name = this.doc.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (ti.name == null) {
                return ti;
            }
            ti.name = ti.name.trim();
            if (ti.name.indexOf("<") > 0 && ti.name.endsWith(">") || ti.name.indexOf("&lt;") > 0 && ti.name.endsWith("&gt;")) {
                String[] parts2;
                if (ti.name.indexOf("<") > 0) {
                    parts2 = ti.name.split("\\<");
                    ti.name = parts2[1].substring(0, parts2[1].length() - 1);
                } else {
                    parts2 = ti.name.split("\\&lt;");
                    ti.name = parts2[1].substring(0, parts2[1].length() - 4);
                }
                if (parts2[0].equals("Set")) {
                    this.doc.result.addDebug("Parameterised type of kind 'set'.");
                    ti.collectionType = 1;
                } else if (parts2[0].equals("Bag")) {
                    this.doc.result.addDebug("Parameterised type of kind 'bag'.");
                    ti.collectionType = 2;
                } else if (parts2[0].equals("Sequence")) {
                    this.doc.result.addDebug("Parameterised type of kind 'sequence'.");
                    ti.collectionType = 3;
                } else {
                    this.doc.result.addError("The parameterised type '" + parts2[0] + "'<T> is not known/supported. Supported are Set<T>, Bag<T> and Sequence<T>. Set<T> is used instead.");
                    ti.collectionType = 1;
                }
                e = this.doc.fTypes.get(ti.name);
                if (e != null) {
                    ti.id = e.getAttribute("xmi.id").trim();
                }
            }
        }
        if (this.attribute && ti.name.indexOf("[") > 0 && (ti.name.endsWith("]") || ti.name.endsWith("}"))) {
            parts = ti.name.split("\\[");
            ti.name = parts[0].trim();
        }
        if (this.attribute && ti.name.indexOf("{") > 0 && ti.name.endsWith("}")) {
            parts = ti.name.split("\\{");
            ti.name = parts[0].trim();
        }
        return ti;
    }

    @Override
    public Multiplicity cardinality() {
        Multiplicity mx;
        Element e2;
        Multiplicity m = new Multiplicity();
        Element e1 = this.doc.elementOfProperty(this.prp, "Foundation.Core.StructuralFeature.multiplicity");
        if (e1 == null) {
            e1 = this.doc.elementOfProperty(this.prp, "Foundation.Core.AssociationEnd.multiplicity");
        }
        if (e1 != null && (e2 = this.doc.elementOfProperty(e1, "Foundation.Data_Types.Multiplicity.range")) != null) {
            Integer lower = new Integer(this.doc.textOfProperty(e2, "Foundation.Data_Types.MultiplicityRange.lower"));
            m.minOccurs = lower;
            String upperval = this.doc.textOfProperty(e2, "Foundation.Data_Types.MultiplicityRange.upper");
            if (upperval.equals("*")) {
                m.maxOccurs = Integer.MAX_VALUE;
            } else {
                Integer upper = new Integer(upperval);
                m.maxOccurs = upper;
                if (m.maxOccurs == -1) {
                    m.maxOccurs = Integer.MAX_VALUE;
                }
            }
        }
        String name = this.doc.textOfProperty(this.prp, "Foundation.Core.ModelElement.name");
        if (this.attribute && name.indexOf("[") > 0 && name.endsWith("]")) {
            String[] parts = name.split("\\[");
            String multiplicityRanges = parts[1].substring(0, parts[1].length() - 1);
            String[] ranges = multiplicityRanges.split(",");
            int minv = Integer.MAX_VALUE;
            int maxv = Integer.MIN_VALUE;
            int i = 0;
            while (i < ranges.length) {
                int upper;
                int lower;
                if (ranges[i].indexOf("..") > 0) {
                    String[] minmax = ranges[i].split("\\.\\.", 2);
                    lower = Integer.parseInt(minmax[0]);
                    if (minmax[1].equals("*") || minmax[1].equals("n") || minmax[1].length() == 0) {
                        upper = Integer.MAX_VALUE;
                    } else {
                        try {
                            upper = Integer.parseInt(minmax[1]);
                        }
                        catch (NumberFormatException e) {
                            this.doc.result.addWarning("The multiplicity value of '" + minmax[1] + "' is neither a number nor a known string. '*' is used instead.");
                            upper = Integer.MAX_VALUE;
                        }
                    }
                } else if (ranges[i].length() == 0 || ranges[i].equals("*") || ranges[i].equals("n")) {
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = lower = Integer.parseInt(ranges[i]);
                    }
                    catch (NumberFormatException e) {
                        this.doc.result.addWarning("The multiplicity value of '" + ranges[i] + "' is neither a number nor a known string. '*' is used instead.");
                        lower = 0;
                        upper = Integer.MAX_VALUE;
                    }
                }
                if (lower < minv && lower >= 0) {
                    minv = lower;
                }
                if (upper < 0) {
                    maxv = Integer.MAX_VALUE;
                }
                if (upper > maxv) {
                    maxv = upper;
                }
                ++i;
            }
            m.minOccurs = minv;
            m.maxOccurs = maxv;
        }
        if (this.attribute && (mx = this.doc.fClassesRoseHiddenCardinality.get(this.typeInfo().id)) != null) {
            m = mx;
            this.doc.result.addDebug(" Property Name: " + this.inClass().qname() + "/" + this.qname() + ", Type ID: " + this.typeInfo().id + ", hidden cardinality: " + Integer.valueOf(m.minOccurs).toString() + ".." + Integer.valueOf(m.maxOccurs).toString());
        }
        return m;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] tags = tagList.split("\\,");
        int i = 0;
        while (i < tags.length) {
            String s = this.doc.taggedValue(this.id(), tags[i].trim());
            if (s != null) {
                ret.put(tags[i].trim(), s);
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isNavigable() {
        if (this.attribute) {
            return true;
        }
        return this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.isNavigable", "xmi.value").equals("true");
    }

    @Override
    public boolean isOrdered() {
        if (this.attribute) {
            return false;
        }
        return this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.ordering", "xmi.value").equals("ordered");
    }

    @Override
    public boolean isComposition() {
        if (this.attribute) {
            return true;
        }
        return this.doc.options.gmlVersion.equals("3.2") && this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.aggregation", "xmi.value").equals("composite");
    }

    @Override
    public boolean isAggregation() {
        if (this.attribute) {
            return true;
        }
        return this.doc.options.gmlVersion.equals("3.2") && this.doc.attributeOfProperty(this.prp, "Foundation.Core.AssociationEnd.aggregation", "xmi.value").equals("aggregate");
    }

    @Override
    public String documentation() {
        String s = this.doc.taggedValue(this.id, "documentation");
        if (s == null) {
            s = "";
        }
        return s;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.doc.taggedValue(this.id, "inlineOrByReference");
        if (s == null) {
            s = "";
        }
        return s.toLowerCase();
    }

    @Override
    public boolean isMetadata() {
        if (this.metadata && this.doc.options.gmlVersion.equals("3.2")) {
            return true;
        }
        String s = this.doc.taggedValue(this.id, "isMetadata");
        return s != null && s.toLowerCase().equals("true") && this.doc.options.gmlVersion.equals("3.2");
    }

    @Override
    public void isMetadata(boolean b) {
        this.metadata = b;
    }

    @Override
    public String defaultCodeSpace() {
        String s = this.doc.taggedValue(this.id, "defaultCodeSpace");
        if (s == null) {
            s = "";
        }
        return s;
    }

    @Override
    public boolean implementedByNilReason() {
        String s = this.doc.taggedValue(this.id, "gmlImplementedByNilReason");
        return s != null && s.toLowerCase().equals("true") && this.doc.options.gmlVersion.equals("3.2");
    }

    @Override
    public void nilReasonAllowed(boolean b) {
        this.nilReasonAllowed = b;
    }

    @Override
    public boolean nilReasonAllowed() {
        String s = this.doc.taggedValue(this.id, "nilReasonAllowed");
        if (s != null && s.toLowerCase().equals("true") && this.doc.options.gmlVersion.equals("3.2")) {
            return true;
        }
        return this.nilReasonAllowed;
    }

    @Override
    public int sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String initialValue() {
        Element e;
        NodeList nl;
        String initialValue = null;
        if (this.attribute && (nl = this.prp.getElementsByTagName("Foundation.Core.Attribute.initialValue")).getLength() == 1 && (nl = (e = (Element)nl.item(0)).getElementsByTagName("Foundation.Data_Types.Expression")).getLength() == 1 && (initialValue = this.doc.textOfProperty(e = (Element)nl.item(0), "Foundation.Data_Types.Expression.body")) != null) {
            if ((initialValue = initialValue.trim()).toLowerCase().equals("true")) {
                initialValue = "true";
            } else if (initialValue.toLowerCase().equals("false")) {
                initialValue = "false";
            }
        }
        return initialValue;
    }

    @Override
    public boolean restriction() {
        return this.restriction;
    }

    @Override
    public void restriction(boolean r) {
        this.restriction = r;
    }

    @Override
    public PropertyInfo reverseProperty() {
        return this.reverseProperty;
    }

    public PropertyInfoXmi10(Xmi10Document d, Element e, boolean att) throws ShapeChangeAbortException {
        this.doc = d;
        this.prp = e;
        this.attribute = att;
        this.id = this.prp.getAttribute("xmi.id");
        if (this.doc.options.useSequenceNumbers) {
            String s = this.doc.taggedValue(this.id, "sequenceNumber");
            if (s != null) {
                Integer sN = new Integer(s);
                this.sequenceNumber = sN;
            } else {
                this.sequenceNumber = this.doc.globalSequenceNumber++;
            }
        }
        this.doc.result.addDebug("The property with ID " + this.id + " and name '" + this.name() + "' was created.");
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = ci;
    }
}

