/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.OperationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Element;
import org.sparx.Method;
import org.sparx.TaggedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoEA
extends ClassInfoImpl
implements ClassInfo {
    protected boolean aliasAccessed = false;
    protected boolean connectorsAccessed = false;
    protected boolean documentationAccessed = false;
    protected boolean isAssocClassAccessed = false;
    protected AssociationInfo assoc = null;
    protected Collection<Connector> conns = null;
    protected HashSet<String> supplierIds = null;
    protected EADocument document;
    protected PackageInfoEA packageInfo;
    protected ClassInfoEA baseclassInfo = null;
    protected HashSet<ClassInfoEA> baseclassInfoSet = null;
    protected HashSet<ClassInfoEA> subclassInfoSet = new HashSet();
    protected Element eaClassElement = null;
    protected int eaClassId = 0;
    protected String eaName = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected Vector<PropertyInfoEA> registeredRoles = new Vector();
    protected HashMap<String, String> taggedValuesCache = null;
    protected HashSet<String> stereotypesCache = null;
    protected TreeMap<StructuredNumber, PropertyInfo> propertiesCache = null;
    protected TreeMap<Integer, OperationInfo> operationsCache = null;
    protected Vector<Constraint> constraintsCache = null;
    protected boolean hasNilReason = false;
    private Boolean realization = null;

    public ClassInfoEA(EADocument doc, PackageInfoEA pi, Element elmt) throws ShapeChangeAbortException {
        this.document = doc;
        this.packageInfo = pi;
        pi.childCI.add(this);
        this.eaClassElement = elmt;
        this.eaClassId = this.eaClassElement.GetElementID();
        this.eaName = this.eaClassElement.GetName().trim();
        this.isAbstract = this.eaClassElement.GetAbstract().equals("1");
        this.isLeaf = this.eaClassElement.GetIsLeaf();
        this.establishCategory();
        String realization = this.document.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "realisationLikeGeneralisation");
        if (realization != null && realization.equalsIgnoreCase("false")) {
            this.realization = Boolean.FALSE;
        }
    }

    public void establishClassDerivationHierarchy() {
        if (!this.connectorsAccessed) {
            this.conns = this.eaClassElement.GetConnectors();
            this.connectorsAccessed = true;
        }
        if (this.conns != null) {
            int nbcl = 0;
            for (Connector conn : this.conns) {
                int cat;
                int bclid;
                ClassInfoEA baseCI;
                int clientid;
                String conntype = conn.GetType();
                boolean gen = conntype.equals("Generalization");
                boolean rea = conntype.equals("Realisation");
                if (this.realization != null && !this.realization.booleanValue()) {
                    rea = false;
                }
                if (!gen && !rea || (clientid = conn.GetClientID()) != this.eaClassId || (baseCI = this.document.fClassById.get(String.valueOf(bclid = conn.GetSupplierID()))) == null || rea && (cat = baseCI.category()) != 4) continue;
                if (++nbcl == 1) {
                    this.baseclassInfo = baseCI;
                } else {
                    if (this.baseclassInfoSet == null) {
                        this.baseclassInfoSet = new HashSet();
                        this.baseclassInfoSet.add(this.baseclassInfo);
                        this.baseclassInfo = null;
                    }
                    this.baseclassInfoSet.add(baseCI);
                }
                baseCI.subclassInfoSet.add(this);
            }
        }
    }

    public void establishAssociations() {
        if (!this.connectorsAccessed) {
            this.conns = this.eaClassElement.GetConnectors();
            this.connectorsAccessed = true;
        }
        if (this.conns != null) {
            for (Connector conn : this.conns) {
                int id;
                String connid;
                boolean known;
                String type = conn.GetType();
                if (!type.equalsIgnoreCase("Association") && !type.equalsIgnoreCase("Aggregation") || (known = this.document.fAssociationById.containsKey(connid = new Integer(id = conn.GetConnectorID()).toString()))) continue;
                AssociationInfoEA ai = new AssociationInfoEA(this.document, conn, id);
                if (!ai.relevant) continue;
                this.document.fAssociationById.put(connid, ai);
            }
        }
    }

    public void establishRoles(PropertyInfoEA pi) {
        this.registeredRoles.add(pi);
    }

    public Element getEaClassElement() {
        return this.eaClassElement;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public ClassInfo baseClass() {
        int stsize = 0;
        ClassInfoEA cir = null;
        int cat = this.category();
        if (cat == 1 || cat == 6 || cat == 5 || cat == 4 || cat == 8) {
            ShapeChangeResult.MessageContext mc;
            HashSet<ClassInfoEA> baseCIs = null;
            if (this.baseclassInfoSet != null) {
                baseCIs = this.baseclassInfoSet;
            } else if (this.baseclassInfo != null) {
                baseCIs = new HashSet(1);
                baseCIs.add(this.baseclassInfo);
            }
            if (baseCIs != null) {
                for (ClassInfoEA baseCI : baseCIs) {
                    int bcat = baseCI.category();
                    if ((cat == bcat || bcat == -1) && bcat != 4) {
                        ++stsize;
                        cir = baseCI;
                        continue;
                    }
                    if (bcat == 4) continue;
                    ShapeChangeResult.MessageContext mc2 = this.document.result.addError(null, 108, this.name());
                    if (mc2 != null) {
                        mc2.addDetail(null, 400, "Package", this.pkg().fullName());
                    }
                    this.document.result.addDebug(null, 10003, this.name(), "" + cat, "!FALSE");
                    this.document.result.addDebug(null, 10003, this.name(), "" + bcat, "!TRUE");
                }
            }
            if (stsize > 1 && (mc = this.document.result.addError(null, 109, this.name())) != null) {
                mc.addDetail(null, 400, "Package", this.pkg().fullName());
            }
        }
        return cir;
    }

    @Override
    public boolean checkSupertypes(int cat) {
        HashSet<Object> bcis = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        boolean res = true;
        for (ClassInfoEA classInfoEA : bcis) {
            int bcicat = classInfoEA.category();
            if (bcicat == -1) {
                res = classInfoEA.checkSupertypes(cat);
            } else {
                if (bcicat == 4) continue;
                if (bcicat != cat) {
                    res = false;
                }
            }
            if (res) continue;
            break;
        }
        if (res) {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "TRUE");
        } else {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    @Override
    public PackageInfo pkg() {
        return this.packageInfo;
    }

    @Override
    public TreeMap<StructuredNumber, PropertyInfo> properties() {
        this.validatePropertiesCache();
        return (TreeMap)this.propertiesCache.clone();
    }

    @Override
    public PropertyInfo property(String name) {
        this.validatePropertiesCache();
        for (PropertyInfo pi : this.propertiesCache.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        HashSet<ClassInfoEA> bcis = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoEA bci : bcis) {
            PropertyInfo pi = bci.property(name);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaClassElement.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            for (String stereotype : stereotypes) {
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st == null) continue;
                for (String s : Options.classStereotypes) {
                    if (!st.toLowerCase().equals(s)) continue;
                    this.stereotypesCache.add(s);
                }
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> i$ = this.stereotypesCache.iterator();
        if (i$.hasNext()) {
            String st = i$.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    @Override
    public HashSet<String> subtypes() {
        HashSet<String> subids = new HashSet<String>(this.subclassInfoSet.size());
        for (ClassInfoEA sci : this.subclassInfoSet) {
            subids.add(sci.id());
        }
        return subids;
    }

    @Override
    public HashSet<String> supertypes() {
        HashSet<String> baseids = new HashSet<String>(1);
        if (this.baseclassInfo != null) {
            baseids.add(this.baseclassInfo.id());
        } else if (this.baseclassInfoSet != null) {
            for (ClassInfoEA bci : this.baseclassInfoSet) {
                baseids.add(bci.id());
            }
        }
        return baseids;
    }

    @Override
    public String documentation() {
        if (!this.documentationAccessed) {
            this.documentationAccessed = true;
            String s = super.documentation();
            if ((s == null || s.length() == 0) && (s = this.eaClassElement.GetNotes()) != null) {
                this.documentation = s = EADocument.removeSpuriousEA75EntitiesFromStrings(s);
            }
            if (s == null || s.isEmpty()) {
                for (String cid : this.supplierIds()) {
                    ClassInfoEA cix = this.document.fClassById.get(cid);
                    if (cix == null || !cix.name().equalsIgnoreCase(this.name()) || !cix.stereotype().equalsIgnoreCase("featureconcept")) continue;
                    this.documentation = s = cix.documentation();
                    break;
                }
            }
            this.documentation = s != null ? s : "";
        }
        return this.documentation;
    }

    @Override
    public String id() {
        return new Integer(this.eaClassId).toString();
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            this.eaName = this.id();
            ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "class", this.eaName);
            if (mc != null) {
                mc.addDetail(null, 400, "Package", this.pkg().fullName());
            }
        }
        return this.eaName;
    }

    @Override
    public String aliasName() {
        if (!this.aliasAccessed) {
            this.aliasAccessed = true;
            String a = super.aliasName();
            if (a == null || a.length() == 0) {
                this.aliasName = a = this.eaClassElement.GetAlias();
            }
        }
        return this.aliasName;
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaClassElement.GetTaggedValues();
            if (tvs != null) {
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = new HashMap(ntvs);
                for (TaggedValue tv : tvs) {
                    String t = tv.GetName();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.put(t, v);
                }
            } else {
                this.taggedValuesCache = new HashMap();
            }
        }
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    public void taggedValue(String tag, String value) {
        Collection cTV = this.eaClassElement.GetTaggedValues();
        TaggedValue tv = (TaggedValue)cTV.GetByName(tag);
        if (tv == null && value != null) {
            tv = (TaggedValue)cTV.AddNew(tag, value);
            tv.Update();
        } else if (tv != null) {
            if (value == null) {
                value = "";
            }
            if (!tv.GetValue().equals(value)) {
                tv.SetValue(value);
                tv.Update();
            }
        }
        this.taggedValuesCache = null;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public boolean hasNilReason() {
        this.validatePropertiesCache();
        return this.hasNilReason;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            HashSet<ClassInfoEA> sts;
            this.constraintsCache = new Vector();
            String check = this.document.options.parameter("checkingConstraints");
            if (check != null && check.equalsIgnoreCase("disabled")) {
                return;
            }
            if (!this.document.options.isClassTypeToCreateConstraintsFor(this.category())) {
                return;
            }
            HashMap<String, TextConstraintEA> namefilter = new HashMap<String, TextConstraintEA>();
            Collection constrs = this.eaClassElement.GetConstraints();
            String types = this.document.options.parameter("oclConstraintTypeRegex");
            if (constrs != null) {
                for (org.sparx.Constraint constr : constrs) {
                    OclConstraintEA ocl;
                    String type = constr.GetType();
                    Constraint oc = types.length() > 0 && type.matches(types) ? ((ocl = new OclConstraintEA(this.document, this, constr)).syntaxTree() == null ? new TextConstraintEA(this.document, this, constr) : ocl) : new TextConstraintEA(this.document, this, constr);
                    this.constraintsCache.add(oc);
                    String conam = oc.name();
                    if (conam == null || conam.length() <= 0) continue;
                    namefilter.put(conam, (TextConstraintEA)oc);
                }
            }
            if ((sts = this.supertypesAsClassInfoEA()) != null) {
                for (ClassInfoEA stci : sts) {
                    Vector<Constraint> stcos = null;
                    if (stci != null) {
                        stcos = stci.constraints();
                    }
                    if (stcos == null) continue;
                    for (Constraint stco : stcos) {
                        String nam;
                        String string = nam = stco == null ? null : stco.name();
                        if (nam != null && nam.length() > 0 && namefilter.containsKey(nam)) continue;
                        this.constraintsCache.add(stco);
                    }
                }
            }
        }
    }

    private HashSet<ClassInfoEA> supertypesAsClassInfoEA() {
        HashSet<ClassInfoEA> baseClasses = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            baseClasses.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            for (ClassInfoEA bci : this.baseclassInfoSet) {
                baseClasses.add(bci);
            }
        }
        return baseClasses;
    }

    @Override
    public Vector<Constraint> constraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }

    private void validatePropertiesCache() {
        if (this.propertiesCache == null) {
            this.propertiesCache = new TreeMap();
            Collection attrs = this.eaClassElement.GetAttributes();
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    ShapeChangeResult.MessageContext mc;
                    String vis;
                    if (this.document.options.parameter("publicOnly").equals("true") && !(vis = attr.GetVisibility()).equals("Public")) continue;
                    PropertyInfoEA pi = new PropertyInfoEA(this.document, this, attr);
                    PropertyInfo piTemp = this.propertiesCache.get(pi.sequenceNumber());
                    if (piTemp != null && (mc = this.document.result.addError(null, 107, pi.name(), this.name(), piTemp.name())) != null) {
                        mc.addDetail(null, 400, "Package", this.pkg().fullName());
                    }
                    this.propertiesCache.put(pi.sequenceNumber(), pi);
                    if (!pi.implementedByNilReason()) continue;
                    this.hasNilReason = true;
                }
            }
            for (PropertyInfoEA pi : this.registeredRoles) {
                ShapeChangeResult.MessageContext mc;
                PropertyInfo piTemp = this.propertiesCache.get(pi.sequenceNumber());
                if (piTemp != null && (mc = this.document.result.addError(null, 107, pi.name(), this.name(), piTemp.name())) != null) {
                    mc.addDetail(null, 400, "Package", this.pkg().fullName());
                }
                this.propertiesCache.put(pi.sequenceNumber(), pi);
                if (!pi.implementedByNilReason()) continue;
                this.hasNilReason = true;
            }
        }
    }

    private void validateOperationsCache() {
        if (this.operationsCache == null) {
            this.operationsCache = new TreeMap();
            Collection meths = this.eaClassElement.GetMethods();
            int i = 0;
            if (meths != null) {
                for (Method meth : meths) {
                    OperationInfoEA oi = new OperationInfoEA(this.document, this, meth);
                    this.operationsCache.put(++i, oi);
                }
            }
        }
    }

    @Override
    public OperationInfo operation(String name, String[] types) {
        this.validateOperationsCache();
        block0: for (OperationInfo oi : this.operationsCache.values()) {
            if (!oi.name().equals(name)) continue;
            if (types == null) {
                return oi;
            }
            if (types.length != oi.parameterCount()) continue;
            TreeMap<Integer, String> ptypes = oi.parameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals("*") && !ptypes.get(i + 1).equals(types[i])) continue block0;
            }
            return oi;
        }
        HashSet<ClassInfoEA> bcis = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoEA bci : bcis) {
            OperationInfo oi = bci.operation(name, types);
            if (oi == null) continue;
            return oi;
        }
        return null;
    }

    @Override
    public AssociationInfo isAssocClass() {
        if (!this.isAssocClassAccessed) {
            this.isAssocClassAccessed = true;
            if (this.eaClassElement.GetSubtype() == 17 && !this.eaClassElement.MiscData(3).isEmpty()) {
                this.assoc = this.document.fAssociationById.get(this.eaClassElement.MiscData(3));
            }
        }
        return this.assoc;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }

    protected HashSet<String> supplierIds() {
        if (this.supplierIds == null) {
            this.supplierIds = new HashSet();
            if (!this.connectorsAccessed) {
                this.conns = this.eaClassElement.GetConnectors();
                this.connectorsAccessed = true;
            }
            if (this.conns != null) {
                for (Connector conn : this.conns) {
                    ClassInfoEA suppClass;
                    String suppPackId;
                    String type = conn.GetType();
                    if (!type.equals("Dependency")) continue;
                    int suppId = conn.GetSupplierID();
                    String suppIdS = Integer.toString(suppId);
                    if (suppId == this.eaClassId || (suppPackId = (suppClass = this.document.fClassById.get(suppIdS)).id()) == null) continue;
                    this.supplierIds.add(suppPackId);
                }
            }
        }
        return this.supplierIds;
    }
}

