/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.AssociationInfoImpl;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.ConnectorTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationInfoEA
extends AssociationInfoImpl
implements AssociationInfo {
    EADocument document = null;
    Connector eaConnector = null;
    protected int eaConnectorId = 0;
    protected String name = null;
    protected int navigability = 0;
    protected boolean relevant = false;
    protected PropertyInfoEA[] properties = new PropertyInfoEA[]{null, null};
    protected HashMap<String, String> taggedValuesCache = null;
    protected HashSet<String> stereotypesCache = null;

    AssociationInfoEA(EADocument doc, Connector conn, int id) {
        this.document = doc;
        this.eaConnector = conn;
        this.eaConnectorId = id;
        this.name = this.eaConnector.GetName();
        String dirText = this.eaConnector.GetDirection();
        if (dirText.equals("Source -> Destination")) {
            this.navigability = 1;
        } else if (dirText.equals("Destination -> Source")) {
            this.navigability = -1;
        }
        Role[] roles = new Role[2];
        ConnectorEnd ce = null;
        class Role {
            ConnectorEnd eaConnEnd = null;
            ClassInfoEA ci = null;

            Role() {
            }
        }
        roles[0] = new Role();
        ce = this.eaConnector.GetClientEnd();
        Integer cid = this.eaConnector.GetClientID();
        roles[0].ci = this.document.fClassById.get(cid.toString());
        roles[0].eaConnEnd = ce;
        roles[1] = new Role();
        ce = this.eaConnector.GetSupplierEnd();
        cid = this.eaConnector.GetSupplierID();
        roles[1].ci = this.document.fClassById.get(cid.toString());
        roles[1].eaConnEnd = ce;
        if (roles[0].ci != null && roles[1].ci != null) {
            this.relevant = true;
            for (int i = 0; i < 2; ++i) {
                PropertyInfoEA pi;
                this.properties[i] = pi = new PropertyInfoEA(this.document, roles[1 - i].ci, this, i == 0, roles[i].eaConnEnd, roles[i].ci);
                if (!pi.isNavigable()) continue;
                roles[1 - i].ci.establishRoles(pi);
            }
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = roles[0].ci != null ? roles[0].ci.name() : "roles[0]_";
            this.name = roles[1].ci != null ? this.name + roles[1].ci.name() : this.name + "roles[1]";
        }
        this.document.result.addDebug(null, 10013, "association", this.id(), this.name());
    }

    @Override
    public PropertyInfo end1() {
        return this.properties[0];
    }

    @Override
    public PropertyInfo end2() {
        return this.properties[1];
    }

    @Override
    public String id() {
        return new Integer(this.eaConnectorId).toString();
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String aliasName() {
        String a = super.aliasName();
        if (a == null || a.length() == 0) {
            this.aliasName = a = this.eaConnector.GetAlias();
        }
        return a;
    }

    @Override
    public String documentation() {
        String s = super.documentation();
        if ((s == null || s.length() == 0) && (s = this.eaConnector.GetNotes()) != null) {
            this.documentation = s = EADocument.removeSpuriousEA75EntitiesFromStrings(s);
        }
        return s != null ? s : "";
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaConnector.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            for (String stereotype : stereotypes) {
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st == null) continue;
                for (String s : Options.assocStereotypes) {
                    if (!st.toLowerCase().equals(s)) continue;
                    this.stereotypesCache.add(s);
                }
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> i$ = this.stereotypesCache.iterator();
        if (i$.hasNext()) {
            String st = i$.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaConnector.GetTaggedValues();
            short ntvs = tvs.GetCount();
            this.taggedValuesCache = new HashMap(ntvs);
            for (ConnectorTag tv : tvs) {
                String t = tv.GetName();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = tv.GetValue();
                if (v.equals("<memo>")) {
                    v = tv.GetNotes();
                }
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public ClassInfo assocClass() {
        String s = this.eaConnector.GetSubtype();
        ClassInfo assocClass = null;
        if (s.equalsIgnoreCase("class") && !this.eaConnector.MiscData(0).isEmpty()) {
            assocClass = this.document.fClassById.get(this.eaConnector.MiscData(0));
        }
        return assocClass;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }
}

