/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.katalogtool;

import de.adv_online.aaa.profiltool.ProfilRep;
import de.interactive_instruments.ShapeChange.Fop.FopErrorListener;
import de.interactive_instruments.ShapeChange.Fop.FopMsgHandler;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.ModelDiff.Differ;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class Katalog
implements Target {
    public static final int TARGET_AAA_Katalogtool = 401;
    public static final int STATUS_WRITE_RTF = 21;
    public static final int STATUS_WRITE_PDF = 22;
    public static final int STATUS_WRITE_HTML = 23;
    public static final int STATUS_WRITE_XML = 24;
    public static final int STATUS_WRITE_GFC = 25;
    public static final int STATUS_WRITE_CSV = 26;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private Document document = null;
    private String outputDirectory = null;
    private Boolean error = false;
    private Element root = null;
    private String Prefixes = "";
    private String Package = "";
    private HashSet<ClassInfo> additionalClasses = new HashSet();
    private HashSet<ClassInfo> enumerations = new HashSet();
    private HashSet<ProfilRep> profile = new HashSet();
    private Boolean OnlyGDB = false;
    private Boolean OnlyProfile = false;
    private String[] MAList;
    private String[] PList;
    private String PQuelle = "Modell";
    private Model refModel = null;
    private PackageInfo refPackage = null;
    private HashMap<Info, HashSet<DiffElement>> diffs = null;
    private Differ differ = null;
    private Boolean Inherit = false;
    private HashSet<PropertyInfo> exportedAssociation = new HashSet();
    private HashSet<PropertyInfo> processedProperty = new HashSet();
    private Map<String, String> regeln = null;
    private String OutputFormat = "";

    public int getTargetID() {
        return 401;
    }

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        HashSet set;
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        if (!this.options.gmlVersion.equals("3.2")) {
            this.result.addError(null, 110, this.pi.name());
            this.error = true;
            return;
        }
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "Verzeichnis");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if ((s = this.options.parameter(this.getClass().getName(), "nurGrunddatenbestand")) != null && s.equals("true")) {
            this.OnlyGDB = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), "geerbteEigenschaften")) != null && s.equals("true")) {
            this.Inherit = true;
        }
        this.PList = (s = this.options.parameter(this.getClass().getName(), "profile")) == null || s.trim().length() == 0 ? new String[0] : s.trim().split(",");
        if (this.PList.length > 0) {
            this.OnlyProfile = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), "profilquelle")) != null) {
            this.PQuelle = s.trim();
        }
        if (!this.PQuelle.equals("Datei") && !this.PQuelle.equals("Modell")) {
            this.result.addError("Die Profilquelle '" + this.PQuelle + "' ist unbekannt, es wird 'Modell' verwendet.");
            this.PQuelle = "Modell";
        }
        this.MAList = (s = this.options.parameter(this.getClass().getName(), "modellarten")) == null || s.trim().length() == 0 ? new String[0] : s.trim().split(",");
        s = this.options.parameter(this.getClass().getName(), "schemakennungen");
        this.Prefixes = s != null && s.length() > 0 ? s : "*";
        s = this.options.parameter(this.getClass().getName(), "paket");
        this.Package = s != null && s.length() > 0 ? s : "";
        s = this.options.parameter(this.getClass().getName(), "ausgabeformat");
        this.OutputFormat = s != null && s.length() > 0 ? s : "";
        this.refModel = this.getReferenceModel();
        if (this.refModel != null && (set = this.refModel.schemas(p.name())).size() == 1) {
            this.differ = new Differ(true);
            this.refPackage = (PackageInfo)set.iterator().next();
            this.diffs = this.differ.diff(p, this.refPackage);
            for (Map.Entry<Info, HashSet<DiffElement>> me : this.diffs.entrySet()) {
                ShapeChangeResult.MessageContext mc = this.result.addInfo("Model difference - " + me.getKey().fullName().replace(p.fullName(), p.name()));
                if (mc == null) continue;
                for (DiffElement diff : me.getValue()) {
                    s = diff.change + " " + diff.subElementType;
                    if (diff.subElementType == DiffElement.ElementType.TAG) {
                        s = s + "(" + diff.tag + ")";
                    }
                    if (diff.subElement != null) {
                        String s2;
                        s = s + " " + diff.subElement.name();
                        if (diff.subElementType == DiffElement.ElementType.CLASS || diff.subElementType == DiffElement.ElementType.SUBPACKAGE || diff.subElementType == DiffElement.ElementType.PROPERTY) {
                            s2 = diff.subElement.taggedValue("AAA:Kennung");
                            if (s2 != null && !s2.isEmpty()) {
                                s = s + " (" + s2 + ")";
                            }
                        } else if (diff.subElementType == DiffElement.ElementType.ENUM && (s2 = ((PropertyInfo)diff.subElement).initialValue()) != null && !s2.isEmpty()) {
                            s = s + " (" + s2 + ")";
                        }
                    } else {
                        s = diff.diff != null ? s + " " + this.differ.diff_toString(diff.diff).replace("[[/ins]][[ins]]", "").replace("[[/del]][[del]]", "").replace("[[ins]][[/ins]]", "").replace("[[del]][[/del]]", "") : s + " ???";
                    }
                    mc.addDetail(s);
                }
            }
        }
        this.document = this.createDocument();
        ProcessingInstruction proci = this.document.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./aaa-html.xsl'");
        this.document.appendChild(proci);
        this.document.appendChild(this.document.createComment("(c) Arbeitsgemeinschaft der Vermessungsverwaltungen der L\u00e4nder der Bundesrepublik Deutschland [http://www.adv-online.de/]"));
        this.root = this.document.createElement("FC_FeatureCatalogue");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(this.document, this.root, "xsi:noNamespaceSchemaLocation", "Katalogtool.xsd");
        Element e1 = this.document.createElement("name");
        e1.setTextContent(this.pi.name());
        this.root.appendChild(e1);
        e1 = this.document.createElement("scope");
        s = this.pi.documentation() + "\n" + "Ber\u00fccksichtigte Modellarten:";
        ClassInfo cma = this.model.classByName("AA_AdVStandardModell");
        Collection cpropi = null;
        if (cma != null) {
            cpropi = cma.properties().values();
        }
        for (String ma : this.MAList) {
            s = s + "\n" + ma + ": ";
            String s1 = "(unbekannt)";
            if (cpropi != null) {
                for (PropertyInfo propi : cpropi) {
                    String siv = propi.initialValue();
                    if (siv == null || !siv.equals(ma)) continue;
                    s1 = propi.name();
                    break;
                }
            }
            s = s + s1;
        }
        e1.setTextContent(s);
        this.root.appendChild(e1);
        for (String ma : this.MAList) {
            e1 = this.document.createElement("modellart");
            e1.setTextContent(ma);
            this.root.appendChild(e1);
        }
        for (String pf : this.PList) {
            e1 = this.document.createElement("profil");
            e1.setTextContent(pf);
            this.root.appendChild(e1);
        }
        e1 = this.document.createElement("versionNumber");
        e1.setTextContent(this.pi.version());
        this.root.appendChild(e1);
        s = this.pi.taggedValue("AAA:Datum");
        e1 = this.document.createElement("versionDate");
        if (s != null) {
            e1.setTextContent(this.pi.taggedValue("AAA:Datum"));
        } else {
            e1.setTextContent("(unbekannt)");
        }
        this.root.appendChild(e1);
        e1 = this.document.createElement("producer");
        Element e2 = this.document.createElement("CI_ResponsibleParty");
        Element e3 = this.document.createElement("CI_MandatoryParty");
        Element e4 = this.document.createElement("organisationName");
        s = this.pi.taggedValue("AAA:Organisation");
        if (s != null) {
            e4.setTextContent(s);
        } else {
            e4.setTextContent("(unbekannt)");
        }
        this.root.appendChild(e1);
        e1.appendChild(e2);
        e2.appendChild(e3);
        e3.appendChild(e4);
        if (this.refPackage != null) {
            e1 = this.document.createElement("referenceModelVersionNumber");
            this.root.appendChild(e1);
            e1.setTextContent(this.refPackage.version());
        }
        for (String pf : this.PList) {
            if (this.PQuelle.equals("Datei")) {
                this.profile.add(new ProfilRep(this.pi, this.model, this.options, this.result, this.outputDirectory + "/" + pf + ".3ap"));
                continue;
            }
            String[] sa = pf.split("_", 2);
            this.profile.add(new ProfilRep(this.pi, this.model, this.options, this.result, sa[0], sa[1]));
        }
        try {
            this.PrintPackage(this.pi, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Model getReferenceModel() {
        String imt = this.options.parameter(this.getClass().getName(), "referenceModelType");
        String mdl = this.options.parameter(this.getClass().getName(), "referenceModelFile");
        if (imt == null || mdl == null || imt.isEmpty() || mdl.isEmpty()) {
            return null;
        }
        if (imt.equalsIgnoreCase("ea7")) {
            imt = "de.interactive_instruments.ShapeChange.Model.EA.EADocument";
        } else if (imt.equalsIgnoreCase("xmi10")) {
            imt = "de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document";
        } else if (imt.equalsIgnoreCase("gsip")) {
            imt = "us.mitre.ShapeChange.Model.GSIP.GSIPDocument";
        }
        Model m = null;
        try {
            Class<?> theClass = Class.forName(imt);
            if (theClass == null) {
                this.result.addError(null, 17, imt);
                this.result.addError(null, 22, mdl);
                return null;
            }
            m = (Model)theClass.newInstance();
            if (m == null) {
                this.result.addError(null, 17, imt);
                this.result.addError(null, 22, mdl);
                return null;
            }
            m.initialise(this.result, this.options, mdl);
        }
        catch (ClassNotFoundException e) {
            this.result.addError(null, 17, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (InstantiationException e) {
            this.result.addError(null, 19, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (IllegalAccessException e) {
            this.result.addError(null, 20, imt);
            this.result.addError(null, 22, mdl);
        }
        catch (ShapeChangeAbortException e) {
            this.result.addError(null, 22, mdl);
            m = null;
        }
        return m;
    }

    private void PrintPackage(PackageInfo pix, DiffElement.Operation op) throws Exception {
        if (this.ExportPackage(pix, op)) {
            Element e3;
            Element e1;
            if (pix.containedPackages().size() == 0) {
                e1 = this.document.createElement("AC_Objektartengruppe");
                if (op != null) {
                    this.addAttribute(this.document, e1, "mode", op.toString());
                }
                e3 = this.document.createElement("Objektbereichzugehoerigkeit");
            } else {
                e1 = this.document.createElement("AC_Objektbereich");
                e3 = null;
            }
            this.addAttribute(this.document, e1, "id", "_P" + pix.id());
            if (op != null) {
                this.addAttribute(this.document, e1, "mode", op.toString());
            }
            this.root.appendChild(e1);
            Element e2 = this.document.createElement("name");
            String s = pix.name();
            if (this.diffs != null && this.diffs.get(pix) != null) {
                for (DiffElement diff : this.diffs.get(pix)) {
                    if (diff.subElementType != DiffElement.ElementType.NAME) continue;
                    s = this.differ.diff_toString(diff.diff);
                    break;
                }
            }
            e2.setTextContent(this.PrepareToPrint(s));
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
            s = pix.documentation();
            if (this.diffs != null && this.diffs.get(pix) != null) {
                for (DiffElement diff : this.diffs.get(pix)) {
                    if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                    s = this.differ.diff_toString(diff.diff).replace("[[/ins]][[ins]]", "").replace("[[/del]][[del]]", "").replace("[[ins]][[/ins]]", "").replace("[[del]][[/del]]", "");
                    break;
                }
            }
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", e1, op);
            }
            s = pix.taggedValue("AAA:Kennung");
            if (this.diffs != null && this.diffs.get(pix) != null) {
                for (DiffElement diff : this.diffs.get(pix)) {
                    if (diff.subElementType != DiffElement.ElementType.TAG || !diff.tag.equalsIgnoreCase("AAA:Kennung")) continue;
                    s = this.differ.diff_toString(diff.diff);
                    break;
                }
            }
            if (s != null && s.length() > 0) {
                e2 = this.document.createElement("code");
                e2.setTextContent(this.PrepareToPrint(s));
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if (e3 != null) {
                e1.appendChild(e3);
            }
        }
        try {
            for (PackageInfo pix2 : pix.containedPackages()) {
                boolean found = false;
                if (this.diffs != null && this.diffs.get(pix) != null) {
                    for (DiffElement diff : this.diffs.get(pix)) {
                        if (diff.subElementType != DiffElement.ElementType.SUBPACKAGE || diff.subElement != pix2 || diff.change != DiffElement.Operation.INSERT) continue;
                        this.PrintPackage(pix2, DiffElement.Operation.INSERT);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.PrintPackage(pix2, op);
            }
            if (this.diffs != null && this.diffs.get(pix) != null) {
                for (DiffElement diff : this.diffs.get(pix)) {
                    int cat;
                    if (diff.subElementType == DiffElement.ElementType.SUBPACKAGE && diff.change == DiffElement.Operation.DELETE) {
                        this.PrintPackage((PackageInfo)diff.subElement, DiffElement.Operation.DELETE);
                    }
                    if (diff.subElementType != DiffElement.ElementType.CLASS || diff.change != DiffElement.Operation.DELETE || (cat = ((ClassInfo)diff.subElement).category()) == 2 || cat == 3) continue;
                    this.PrintClass((ClassInfo)diff.subElement, true, DiffElement.Operation.DELETE, pix);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int count(String str, String substr) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(substr, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    private void PrintLineByLine(String s, String ename, Element e1, DiffElement.Operation op) {
        String[] lines;
        boolean ins = false;
        boolean del = false;
        for (String line : lines = s.replace("\r\n", "\n").replace("\r", "\n").split("\n")) {
            Element e2 = this.document.createElement(ename);
            line = this.PrepareToPrint(line);
            if (ins) {
                line = "[[ins]]" + line;
                ins = false;
            } else if (del) {
                line = "[[del]]" + line;
                del = false;
            }
            if (this.count(line, "[[ins]]") > this.count(line, "[[/ins]]")) {
                ins = true;
                line = line + "[[/ins]]";
            } else if (this.count(line, "[[del]]") > this.count(line, "[[/del]]")) {
                del = true;
                line = line + "[[/del]]";
            }
            e2.setTextContent(line);
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
    }

    private String PrepareToPrint(String s) {
        s = s.trim();
        return s;
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private boolean packageInPackage(PackageInfo pi) {
        if (this.Package.length() == 0) {
            return true;
        }
        if (pi.name().equals(this.Package)) {
            return true;
        }
        if (pi.isSchema()) {
            return false;
        }
        return this.packageInPackage(pi.owner());
    }

    public void process(ClassInfo ci) {
        if (this.error.booleanValue()) {
            return;
        }
        if (!this.Prefixes.contains("*") && !this.Prefixes.contains(ci.name().substring(0, 3))) {
            return;
        }
        if (!this.packageInPackage(ci.pkg())) {
            return;
        }
        DiffElement.Operation op = null;
        if (this.diffs != null && this.diffs.get(ci.pkg()) != null) {
            for (DiffElement diff : this.diffs.get(ci.pkg())) {
                if (diff.subElementType != DiffElement.ElementType.CLASS || (ClassInfo)diff.subElement != ci || diff.change != DiffElement.Operation.INSERT) continue;
                op = DiffElement.Operation.INSERT;
                break;
            }
        }
        if (op == null) {
            PackageInfo pix = ci.pkg();
            while (pix != null) {
                if (this.diffs != null && this.diffs.get(pix.owner()) != null) {
                    for (DiffElement diff : this.diffs.get(pix.owner())) {
                        if (diff.subElementType != DiffElement.ElementType.SUBPACKAGE || (PackageInfo)diff.subElement != pix || diff.change != DiffElement.Operation.INSERT) continue;
                        op = DiffElement.Operation.INSERT;
                        pix = null;
                        break;
                    }
                }
                if (pix == null) continue;
                pix = pix.owner();
            }
        }
        int cat = ci.category();
        switch (cat) {
            case 1: 
            case 6: {
                this.PrintClass(ci, true, op, ci.pkg());
                break;
            }
            case 4: {
                this.PrintClass(ci, true, op, ci.pkg());
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                this.PrintClass(ci, true, op, ci.pkg());
                for (String t : ci.supertypes()) {
                    ClassInfo cix = this.model.classById(t);
                    if (cix == null || !this.Prefixes.contains("*") && !this.Prefixes.contains(cix.name().substring(0, 3))) continue;
                    this.additionalClasses.add(cix);
                }
                break;
            }
        }
    }

    private void PrintValues(ClassInfo ci, DiffElement.Operation op) {
        for (PropertyInfo propi : ci.properties().values()) {
            if (propi == null || !this.ExportValue(propi)) continue;
            DiffElement.Operation top = op;
            if (this.diffs != null && this.diffs.get(ci) != null) {
                for (DiffElement diff : this.diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.ENUM || (PropertyInfo)diff.subElement != propi || diff.change != DiffElement.Operation.INSERT) continue;
                    top = DiffElement.Operation.INSERT;
                    break;
                }
            }
            this.PrintValue(propi, top);
        }
        if (this.diffs != null && this.diffs.get(ci) != null) {
            for (DiffElement diff : this.diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.ENUM || diff.change != DiffElement.Operation.DELETE) continue;
                for (PropertyInfo propi : ci.properties().values()) {
                    if ((PropertyInfo)diff.subElement != propi) continue;
                    this.PrintValue(propi, DiffElement.Operation.DELETE);
                }
            }
        }
    }

    private void PrintValue(PropertyInfo propi, DiffElement.Operation op) {
        Element e1 = this.document.createElement("FC_Value");
        this.addAttribute(this.document, e1, "id", "_A" + propi.id());
        if (op != null) {
            this.addAttribute(this.document, e1, "mode", op.toString());
        }
        this.root.appendChild(e1);
        Element e2 = this.document.createElement("label");
        String s = propi.name();
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.NAME) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        e2.setTextContent(this.PrepareToPrint(s));
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        e2 = this.document.createElement("code");
        s = propi.initialValue();
        if (s == null || s.length() == 0) {
            s = "(wie Bezeichner)";
        }
        e2.setTextContent(this.PrepareToPrint(s));
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        e2 = this.document.createElement("definition");
        s = propi.documentation();
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        e2.setTextContent(this.PrepareToPrint(s));
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        this.PrintStandardElements((Info)propi, e1, op);
        String nart = propi.taggedValue("AAA:Nutzungsartkennung");
        if (nart != null && nart.length() > 0) {
            e2 = this.document.createElement("nutzungsartkennung");
            e2.setTextContent(nart);
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
    }

    private boolean MatchingMA(String malist) {
        if (malist == null) {
            return true;
        }
        if ((malist = malist.trim()).length() == 0) {
            return true;
        }
        for (String ma : malist.split(",")) {
            ma = ma.trim();
            for (String max : this.MAList) {
                if (!ma.equals(max)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean MatchingGDB(String malist) {
        if (!this.OnlyGDB.booleanValue()) {
            return true;
        }
        if (malist == null) {
            return false;
        }
        if ((malist = malist.trim()).length() == 0) {
            return false;
        }
        for (String ma : malist.split(",")) {
            ma = ma.trim();
            for (String max : this.MAList) {
                if (!ma.equals(max)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean MatchingProfile(String pflist) {
        if (!this.OnlyProfile.booleanValue()) {
            return true;
        }
        if (pflist == null) {
            return false;
        }
        if ((pflist = pflist.trim()).length() == 0) {
            return false;
        }
        for (String pf : pflist.split(",")) {
            pf = pf.trim();
            for (String pfx : this.PList) {
                if (!pf.equals(pfx)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ExportItem(Info i, boolean considerProfile) {
        if (!this.MatchingMA(i.taggedValue("AAA:Modellart"))) {
            return false;
        }
        if (this.OnlyGDB.booleanValue() && !this.MatchingGDB(i.taggedValue("AAA:Grunddatenbestand"))) {
            return false;
        }
        if (considerProfile && this.OnlyProfile.booleanValue()) {
            String s = "";
            for (ProfilRep pf : this.profile) {
                if (!pf.contains(i)) continue;
                if (s.length() > 0) {
                    s = s + ",";
                }
                s = s + pf.name();
            }
            if (!this.MatchingProfile(s)) {
                return false;
            }
        }
        return true;
    }

    private boolean ExportValue(PropertyInfo propi) {
        return this.ExportItem((Info)propi, true);
    }

    private boolean ExportProperty(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return false;
        }
        if (propi.name().startsWith("role_")) {
            return false;
        }
        return this.ExportItem((Info)propi, true);
    }

    private boolean ExportClass(ClassInfo ci, Boolean onlyProperties, DiffElement.Operation op) {
        if (!ci.inSchema(this.pi) && op != DiffElement.Operation.DELETE && !onlyProperties.booleanValue()) {
            return false;
        }
        if (!(this.Prefixes.contains("*") || this.Prefixes.contains(ci.name().substring(0, 3)) || onlyProperties.booleanValue())) {
            return false;
        }
        if (!this.packageInPackage(ci.pkg()) && op != DiffElement.Operation.DELETE && !onlyProperties.booleanValue()) {
            return false;
        }
        return this.ExportItem((Info)ci, true);
    }

    private boolean ExportPackage(PackageInfo pi, DiffElement.Operation op) {
        if (!this.packageInPackage(pi) && op != DiffElement.Operation.DELETE) {
            return false;
        }
        return this.ExportItem((Info)pi, false);
    }

    private String getDocBrEkKbd(ClassInfo ci, String cat, String filter) {
        String reg;
        String marker;
        String ret = null;
        String doc = ci.documentation();
        if (this.diffs != null && this.diffs.get(ci) != null) {
            for (DiffElement diff : this.diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                doc = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        if ((marker = this.options.parameter(this.getClass().getName(), "notesRuleMarker")) == null || marker.length() == 0) {
            marker = "-==-";
        }
        if (this.regeln == null) {
            this.regeln = new TreeMap<String, String>();
            this.regeln.put("BR", "Bildungsregel");
            this.regeln.put("EK", "Erfassungskriterium");
            this.regeln.put("KBD", "Konsistenzbedingung");
        }
        if ((reg = this.regeln.get(cat)) == null) {
            return null;
        }
        if (doc != null && doc.contains(filter = marker + " " + (reg + " " + filter).trim() + " " + marker)) {
            int start = doc.indexOf(filter) + filter.length();
            int end = doc.indexOf(marker, start);
            if (end == -1) {
                end = doc.length();
            }
            ret = doc.substring(start, end).trim();
        }
        return ret;
    }

    private String getDoc(ClassInfo ci) {
        String marker;
        String doc = ci.documentation();
        if (this.diffs != null && this.diffs.get(ci) != null) {
            for (DiffElement diff : this.diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                doc = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        if ((marker = this.options.parameter(this.getClass().getName(), "notesRuleMarker")) == null || marker.length() == 0) {
            marker = "-==-";
        }
        if (doc != null && doc.contains(marker)) {
            int end = doc.indexOf(marker);
            if (end == -1) {
                end = doc.length();
            }
            doc = doc.substring(0, end).trim();
        }
        return doc;
    }

    private void PrintClass(ClassInfo ci, boolean onlyProperties, DiffElement.Operation op, PackageInfo pix) {
        if (!this.ExportClass(ci, onlyProperties, op)) {
            return;
        }
        if (onlyProperties) {
            Element e1 = this.document.createElement("AC_FeatureType");
            this.addAttribute(this.document, e1, "id", "_C" + ci.id());
            if (op != null) {
                this.addAttribute(this.document, e1, "mode", op.toString());
            }
            this.root.appendChild(e1);
            Element e2 = this.document.createElement("name");
            String s = ci.name();
            if (this.diffs != null && this.diffs.get(ci) != null) {
                for (DiffElement diff : this.diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.NAME) continue;
                    s = this.differ.diff_toString(diff.diff);
                    break;
                }
            }
            e2.setTextContent(this.PrepareToPrint(s));
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
            s = this.getDoc(ci);
            String s1 = "";
            String s2 = "";
            String s3 = "";
            String s4 = "";
            s = s.replace("Lebenszeitinterval:", "Lebenszeitintervall:");
            s = s.replace("Lebenszeitintervallbescheibung:", "Lebenszeitintervall:");
            if (s.contains("Lebenszeitintervall:")) {
                String[] sarr = s.split("Lebenszeitintervall:");
                s = sarr[0];
                s1 = sarr[1];
            }
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", e1, op);
            }
            if (ci.isAbstract()) {
                this.PrintLineByLine("Es handelt sich um eine abstrakte Objektart.", "definition", e1, op);
            }
            s = ci.taggedValue("AAA:Kennung");
            if (this.diffs != null && this.diffs.get(ci) != null) {
                for (DiffElement diff : this.diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.TAG || !diff.tag.equalsIgnoreCase("AAA:Kennung")) continue;
                    s = this.differ.diff_toString(diff.diff);
                    break;
                }
            }
            if (s != null && s.length() > 0) {
                e2 = this.document.createElement("code");
                e2.setTextContent(this.PrepareToPrint(s));
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            for (String t : ci.supertypes()) {
                ClassInfo cix = this.model.classById(t);
                if (cix == null) continue;
                e2 = this.document.createElement("subtypeOf");
                s = cix.name();
                if (this.diffs != null && this.diffs.get(ci) != null) {
                    for (DiffElement diff : this.diffs.get(ci)) {
                        if (diff.subElementType != DiffElement.ElementType.SUPERTYPE || diff.change != DiffElement.Operation.INSERT || (ClassInfo)diff.subElement != cix) continue;
                        s = "[[ins]]" + s + "[[/ins]]";
                        break;
                    }
                }
                e2.setTextContent(s);
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if (this.diffs != null && this.diffs.get(ci) != null) {
                for (DiffElement diff : this.diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.SUPERTYPE || diff.change != DiffElement.Operation.DELETE) continue;
                    e2 = this.document.createElement("subtypeOf");
                    s = "[[del]]" + diff.subElement.name() + "[[/del]]";
                    e2.setTextContent(s);
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                }
            }
            this.PrintProperties(ci, true, e1, op);
            e2 = this.document.createElement("Objektartengruppenzugehoerigkeit");
            if (op != DiffElement.Operation.DELETE) {
                this.addAttribute(this.document, e2, "idref", "_P" + ci.pkg().id());
            } else {
                this.addAttribute(this.document, e2, "idref", "_P" + pix.id());
            }
            e1.appendChild(e2);
            s = this.getDocBrEkKbd(ci, "BR", "");
            if (s != null && s.length() > 0) {
                s2 = s;
            }
            for (String ma : this.MAList) {
                s = this.getDocBrEkKbd(ci, "BR", ma);
                if (s == null || s.length() <= 0) continue;
                s2 = s2 + "\n" + ma + ": " + s;
            }
            s = this.getDocBrEkKbd(ci, "KBD", "");
            if (s != null && s.length() > 0) {
                s3 = s;
            }
            for (String ma : this.MAList) {
                s = this.getDocBrEkKbd(ci, "KBD", ma);
                if (s == null || s.length() <= 0) continue;
                s3 = s3 + "\n" + ma + ": " + s;
            }
            if (this.refModel == null) {
                for (Constraint ocl : ci.constraints()) {
                    String[] sa;
                    s = null;
                    if (!ocl.contextModelElmt().id().equals(ci.id())) continue;
                    if (ocl.name().equalsIgnoreCase("alle")) {
                        s = ocl.text();
                    } else {
                        for (String ma : this.MAList) {
                            if (!ocl.name().equalsIgnoreCase(ma)) continue;
                            s = ocl.text();
                            break;
                        }
                    }
                    if (s == null) continue;
                    for (String sc : sa = s.split("/\\*")) {
                        if ((sc = sc.trim()).isEmpty()) continue;
                        if (sc.contains("*/")) {
                            sc = sc.replaceAll("\\*/.*", "");
                            sc = sc.trim();
                        }
                        s3 = ocl.name().equalsIgnoreCase("alle") ? s3 + "\n" + sc : s3 + "\n" + ocl.name() + ": " + sc;
                    }
                }
            }
            if ((s = this.getDocBrEkKbd(ci, "EK", "")) != null && s.length() > 0) {
                s4 = s;
            }
            for (String ma : this.MAList) {
                s = this.getDocBrEkKbd(ci, "EK", ma);
                if (s == null || s.length() <= 0) continue;
                s4 = s4 + "\n" + ma + ": " + s;
            }
            if (s4.length() > 0) {
                this.PrintLineByLine(s4, "Erfassungskriterium", e1, op);
            }
            if (s3.length() > 0) {
                this.PrintLineByLine(s3, "Konsistenzbedingung", e1, op);
            }
            if (s2.length() > 0) {
                this.PrintLineByLine(s2, "Bildungsregel", e1, op);
            }
            if (s1.length() > 0) {
                this.PrintLineByLine(s1, "Lebenszeitintervall", e1, op);
            }
            if (ci.isKindOf("AA_REO")) {
                e2 = this.document.createElement("wirdTypisiertDurch");
                e2.setTextContent("REO");
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if (ci.isKindOf("AA_NREO")) {
                e2 = this.document.createElement("wirdTypisiertDurch");
                e2.setTextContent("NREO");
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if (ci.isKindOf("AA_ZUSO")) {
                e2 = this.document.createElement("wirdTypisiertDurch");
                e2.setTextContent("ZUSO");
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if (ci.isKindOf("AA_PMO")) {
                e2 = this.document.createElement("wirdTypisiertDurch");
                e2.setTextContent("PMO");
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            switch (ci.category()) {
                case 1: {
                    e2 = this.document.createElement("bedeutung");
                    e2.setTextContent("Objektart");
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                    break;
                }
                case 5: {
                    e2 = this.document.createElement("bedeutung");
                    e2.setTextContent("Datentyp");
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                    break;
                }
                case 8: {
                    e2 = this.document.createElement("bedeutung");
                    e2.setTextContent("Auswahldatentyp");
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                }
            }
            this.PrintStandardElements((Info)ci, e1, op);
            s = ci.taggedValue("AAA:Nutzungsartkennung");
            if (s != null && s.length() > 0) {
                e2 = this.document.createElement("nutzungsartkennung");
                e2.setTextContent(s);
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            if ((s = ci.taggedValue("AAA:Nutzungsart")) != null && s.length() > 0) {
                e2 = this.document.createElement("nutzungsart");
                e2.setTextContent(s);
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
        }
        this.PrintProperties(ci, false, this.root, op);
    }

    private void PrintProperties(ClassInfo ci, boolean listOnly, Element e1, DiffElement.Operation op) {
        for (PropertyInfo propi : ci.properties().values()) {
            DiffElement.Operation top = op;
            if (this.diffs != null && this.diffs.get(ci) != null) {
                for (DiffElement diff : this.diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.PROPERTY || (PropertyInfo)diff.subElement != propi || diff.change != DiffElement.Operation.INSERT) continue;
                    top = DiffElement.Operation.INSERT;
                    break;
                }
            }
            if (listOnly) {
                this.PrintPropertyRef(propi, e1, top);
                continue;
            }
            this.PrintProperty(propi, top);
        }
        if (this.diffs != null && this.diffs.get(ci) != null) {
            for (DiffElement diff : this.diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.PROPERTY || diff.change != DiffElement.Operation.DELETE) continue;
                if (listOnly) {
                    this.PrintPropertyRef((PropertyInfo)diff.subElement, e1, DiffElement.Operation.DELETE);
                    continue;
                }
                this.PrintProperty((PropertyInfo)diff.subElement, DiffElement.Operation.DELETE);
            }
        }
        if (listOnly && this.Inherit.booleanValue()) {
            for (String cid : ci.supertypes()) {
                ClassInfo cix = this.model.classById(cid);
                if (cix == null) continue;
                this.PrintProperties(cix, listOnly, e1, op);
            }
        }
    }

    private void PrintPropertyRef(PropertyInfo propi, Element e1, DiffElement.Operation op) {
        if (this.ExportProperty(propi)) {
            Element e2 = this.document.createElement("characterizedBy");
            this.addAttribute(this.document, e2, "idref", "_A" + propi.id());
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
    }

    private void PrintProperty(PropertyInfo propi, DiffElement.Operation op) {
        PropertyInfo propi2;
        if (!this.ExportProperty(propi)) {
            return;
        }
        if (this.processedProperty.contains(propi)) {
            return;
        }
        String assocId = "__FIXME";
        if (!propi.isAttribute()) {
            if (!this.exportedAssociation.contains(propi)) {
                Element e1 = this.document.createElement("FC_FeatureRelationship");
                assocId = "__" + propi.id();
                this.addAttribute(this.document, e1, "id", assocId);
                this.root.appendChild(e1);
                Element e2 = this.document.createElement("name");
                e2.setTextContent(this.PrepareToPrint("(unbestimmt)"));
                e1.appendChild(e2);
                e2 = this.document.createElement("roles");
                this.addAttribute(this.document, e2, "idref", "_A" + propi.id());
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
                this.exportedAssociation.add(propi);
                propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    if (this.ExportProperty(propi2)) {
                        e2 = this.document.createElement("roles");
                        this.addAttribute(this.document, e2, "idref", "_A" + propi2.id());
                        if (op != null) {
                            this.addAttribute(this.document, e2, "mode", op.toString());
                        }
                        e1.appendChild(e2);
                    }
                    this.exportedAssociation.add(propi2);
                }
            } else {
                propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    assocId = "__" + propi2.id();
                }
            }
        }
        this.PrintPropertyDetail(propi, assocId, op);
        propi2 = propi.reverseProperty();
        if (propi2 != null && this.ExportProperty(propi2)) {
            this.PrintPropertyDetail(propi2, assocId, op);
        }
        this.processedProperty.add(propi);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void PrintPropertyDetail(PropertyInfo propi, String assocId, DiffElement.Operation op) {
        ClassInfo cix;
        Element e1 = propi.isAttribute() ? this.document.createElement("FC_FeatureAttribute") : this.document.createElement("FC_RelationshipRole");
        this.addAttribute(this.document, e1, "id", "_A" + propi.id());
        if (op != null) {
            this.addAttribute(this.document, e1, "mode", op.toString());
        }
        this.root.appendChild(e1);
        Element e2 = this.document.createElement("name");
        String s = propi.name();
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.NAME) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        e2.setTextContent(this.PrepareToPrint(s));
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        e2 = this.document.createElement("cardinality");
        s = propi.cardinality().toString();
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.MULTIPLICITY) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        e2.setTextContent(this.PrepareToPrint(s));
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        s = propi.documentation();
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        if (s != null && s.length() > 0) {
            this.PrintLineByLine(s, "definition", e1, op);
        }
        if (!propi.isAttribute() && !propi.isNavigable()) {
            this.PrintLineByLine("Es handelt sich um die inverse Relationsrichtung.", "definition", e1, op);
        }
        if (propi.isDerived()) {
            this.PrintLineByLine("Es handelt sich um eine abgeleitete Eigenschaft.", "definition", e1, op);
        }
        s = propi.initialValue();
        if (propi.isAttribute() && s != null && s.length() > 0) {
            this.PrintLineByLine("Das Attribut ist bei Objekterzeugung mit dem Wert " + this.PrepareToPrint(s) + " vorbelegt.", "definition", e1, op);
        }
        s = propi.taggedValue("AAA:Kennung");
        if (this.diffs != null && this.diffs.get(propi) != null) {
            for (DiffElement diff : this.diffs.get(propi)) {
                if (diff.subElementType != DiffElement.ElementType.TAG || !diff.tag.equalsIgnoreCase("AAA:Kennung")) continue;
                s = this.differ.diff_toString(diff.diff);
                break;
            }
        }
        if (s != null && s.length() > 0) {
            e2 = this.document.createElement("code");
            if (propi.isDerived()) {
                s = "(DER) " + s;
            }
            e2.setTextContent(this.PrepareToPrint(s));
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
        if ((s = propi.taggedValue("AAA:objektbildend")) != null && s.toLowerCase().equals("true")) {
            e2 = this.document.createElement("objektbildend");
            e2.setTextContent("true");
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
        this.PrintStandardElements((Info)propi, e1, op);
        e2 = this.document.createElement("inType");
        this.addAttribute(this.document, e2, "idref", "_C" + propi.inClass().id());
        this.addAttribute(this.document, e2, "name", propi.inClass().name());
        if (op != null) {
            this.addAttribute(this.document, e2, "mode", op.toString());
        }
        e1.appendChild(e2);
        Type ti = propi.typeInfo();
        if (!propi.isAttribute()) {
            if (ti != null) {
                e2 = this.document.createElement("FeatureTypeIncluded");
                cix = this.model.classById(ti.id);
                if (cix != null && this.ExportClass(cix, false, null)) {
                    this.addAttribute(this.document, e2, "idref", "_C" + ti.id);
                }
                s = ti.name;
                if (this.diffs != null && this.diffs.get(propi) != null) {
                    for (DiffElement diff : this.diffs.get(propi)) {
                        if (diff.subElementType != DiffElement.ElementType.VALUETYPE) continue;
                        s = this.differ.diff_toString(diff.diff);
                        break;
                    }
                }
                this.addAttribute(this.document, e2, "name", s);
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            e2 = this.document.createElement("relation");
            this.addAttribute(this.document, e2, "idref", assocId);
            e1.appendChild(e2);
            PropertyInfo propi2 = propi.reverseProperty();
            if (propi2 != null && this.ExportProperty(propi2)) {
                e2 = this.document.createElement("InverseRole");
                this.addAttribute(this.document, e2, "idref", "_A" + propi2.id());
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            e2 = this.document.createElement("orderIndicator");
            if (propi.isOrdered()) {
                e2.setTextContent("1");
            } else {
                e2.setTextContent("0");
            }
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
            return;
        } else if (ti != null) {
            cix = op != DiffElement.Operation.DELETE ? this.model.classById(ti.id) : this.refModel.classById(ti.id);
            if (cix != null) {
                int cat = cix.category();
                switch (cat) {
                    case 2: 
                    case 3: {
                        e2 = this.document.createElement("ValueDataType");
                        s = cix.name();
                        if (this.diffs != null && this.diffs.get(propi) != null) {
                            for (DiffElement diff : this.diffs.get(propi)) {
                                if (diff.subElementType != DiffElement.ElementType.VALUETYPE) continue;
                                s = this.differ.diff_toString(diff.diff);
                                break;
                            }
                        }
                        e2.setTextContent(this.PrepareToPrint(s));
                        if (op != null) {
                            this.addAttribute(this.document, e2, "mode", op.toString());
                        }
                        e1.appendChild(e2);
                        e2 = this.document.createElement("ValueDomainType");
                        if (op != null) {
                            this.addAttribute(this.document, e2, "mode", op.toString());
                        }
                        e1.appendChild(e2);
                        if (!cix.name().equals("Boolean")) {
                            e2.setTextContent("1");
                            for (PropertyInfo ei : cix.properties().values()) {
                                if (ei == null || !this.ExportValue(ei)) continue;
                                e2 = this.document.createElement("enumeratedBy");
                                this.addAttribute(this.document, e2, "idref", "_A" + ei.id());
                                e1.appendChild(e2);
                            }
                            if (op != DiffElement.Operation.DELETE) {
                                if (!cix.inSchema(propi.inClass().pkg())) return;
                                this.enumerations.add(cix);
                                return;
                            }
                            if (!cix.inSchema(this.refPackage)) return;
                            this.enumerations.add(cix);
                            return;
                        }
                        e2.setTextContent("0");
                        return;
                    }
                    default: {
                        e2 = this.document.createElement("ValueDataType");
                        if (this.ExportClass(cix, false, null)) {
                            this.addAttribute(this.document, e2, "idref", "_C" + cix.id());
                        }
                        s = cix.name();
                        if (this.diffs != null && this.diffs.get(propi) != null) {
                            for (DiffElement diff : this.diffs.get(propi)) {
                                if (diff.subElementType != DiffElement.ElementType.VALUETYPE) continue;
                                s = this.differ.diff_toString(diff.diff);
                                break;
                            }
                        }
                        e2.setTextContent(this.PrepareToPrint(s));
                        if (op != null) {
                            this.addAttribute(this.document, e2, "mode", op.toString());
                        }
                        e1.appendChild(e2);
                        e2 = this.document.createElement("ValueDomainType");
                        e2.setTextContent("0");
                        if (op != null) {
                            this.addAttribute(this.document, e2, "mode", op.toString());
                        }
                        e1.appendChild(e2);
                        return;
                    }
                }
            } else {
                e2 = this.document.createElement("ValueDataType");
                s = ti.name;
                if (this.diffs != null && this.diffs.get(propi) != null) {
                    for (DiffElement diff : this.diffs.get(propi)) {
                        if (diff.subElementType != DiffElement.ElementType.VALUETYPE) continue;
                        s = this.differ.diff_toString(diff.diff);
                        break;
                    }
                }
                e2.setTextContent(this.PrepareToPrint(s));
                if (op != null) {
                    this.addAttribute(this.document, e2, "mode", op.toString());
                }
                e1.appendChild(e2);
            }
            return;
        } else {
            e2 = this.document.createElement("ValueDataType");
            e2.setTextContent("(unbestimmt)");
            if (op != null) {
                this.addAttribute(this.document, e2, "mode", op.toString());
            }
            e1.appendChild(e2);
        }
    }

    private void PrintStandardElements(Info i, Element e1, DiffElement.Operation op) {
        Element e2;
        String s = i.taggedValue("AAA:Modellart");
        if (s != null) {
            block0: for (String ma : s.split(",")) {
                ma = ma.trim();
                for (String max : this.MAList) {
                    if (!ma.equals(max)) continue;
                    e2 = this.document.createElement("modellart");
                    e2.setTextContent(ma);
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                    continue block0;
                }
            }
        }
        if ((s = i.taggedValue("AAA:Grunddatenbestand")) != null) {
            block2: for (String ma : s.split(",")) {
                ma = ma.trim();
                for (String max : this.MAList) {
                    if (!ma.equals(max)) continue;
                    e2 = this.document.createElement("grunddatenbestand");
                    e2.setTextContent(ma);
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                    continue block2;
                }
            }
        }
        s = "";
        for (ProfilRep pf : this.profile) {
            if (!pf.contains(i)) continue;
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + pf.name();
        }
        if (s != null) {
            block5: for (String pf : s.split(",")) {
                pf = pf.trim();
                for (String pfx : this.PList) {
                    if (!pf.equals(pfx)) continue;
                    e2 = this.document.createElement("profil");
                    e2.setTextContent(pf);
                    if (op != null) {
                        this.addAttribute(this.document, e2, "mode", op.toString());
                    }
                    e1.appendChild(e2);
                    continue block5;
                }
            }
        }
        if ((s = i.taggedValue("AAA:Revisionsnummer")) != null && !s.isEmpty()) {
            e2 = this.document.createElement("letzteAenderungRevisionsnummer");
            e2.setTextContent(this.PrepareToPrint(s));
            e1.appendChild(e2);
        }
    }

    public void write() {
        DiffElement.Operation top;
        if (this.error.booleanValue() || this.printed) {
            return;
        }
        for (ClassInfo cix : this.additionalClasses) {
            if (!this.Prefixes.contains("*") && !this.Prefixes.contains(cix.name().substring(0, 3))) continue;
            top = null;
            if (this.diffs != null && this.diffs.get(cix.pkg()) != null) {
                for (DiffElement diff : this.diffs.get(cix.pkg())) {
                    if (diff.subElementType != DiffElement.ElementType.CLASS || (ClassInfo)diff.subElement != cix) continue;
                    top = diff.change;
                    break;
                }
            }
            this.PrintClass(cix, false, top, cix.pkg());
        }
        for (ClassInfo cix : this.enumerations) {
            top = null;
            if (this.diffs != null && this.diffs.get(cix.pkg()) != null) {
                for (DiffElement diff : this.diffs.get(cix.pkg())) {
                    if (diff.subElementType != DiffElement.ElementType.CLASS || (ClassInfo)diff.subElement != cix) continue;
                    top = diff.change;
                    break;
                }
            }
            this.PrintValues(cix, top);
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", this.model.characterEncoding());
        try {
            String xmlName = this.pi.xsdDocument().replace(".xsd", "") + ".tmp.xml";
            FileOutputStream fout = new FileOutputStream(this.outputDirectory + "/" + xmlName);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer(outputFormat);
            serializer.setWriter(outputXML);
            serializer.asDOMSerializer().serialize(this.document);
            outputXML.close();
            String outfileBasename = this.pi.xsdDocument().replace(".xsd", "");
            this.writePDF(xmlName, outfileBasename);
            this.writeRTF(xmlName, outfileBasename);
            this.writeHTML(xmlName, outfileBasename);
            this.writeXML(xmlName, outfileBasename);
            this.writeGFC(xmlName, outfileBasename);
            this.writeCSV(xmlName, outfileBasename);
            File outDir = new File(this.outputDirectory);
            File xmlFile = new File(outDir, xmlName);
            String s = this.options.parameter(this.getClass().getName(), "tmpLoeschen");
            if (s != null && s.equalsIgnoreCase("true")) {
                xmlFile.delete();
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        if (this.refModel != null) {
            this.refModel.shutdown();
        }
        this.printed = true;
    }

    private void writePDF(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(22);
        if (!this.OutputFormat.toLowerCase().contains("nart-pdf")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslfoFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-nart.xsl";
        }
        String pdffileName = outfileBasename + ".pdf";
        String mime = "application/pdf";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && pdffileName != null && pdffileName.length() > 0) {
            this.fopWrite(xmlName, xslfofileName, pdffileName, mime);
        }
    }

    private void writeRTF(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(21);
        if (!this.OutputFormat.toLowerCase().contains("rtf")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslrtfFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-rtf.xsl";
        }
        String rtffileName = outfileBasename + ".rtf";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && rtffileName != null && rtffileName.length() > 0) {
            this.xsltWrite(xmlName, xslfofileName, rtffileName);
        }
    }

    private void writeHTML(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(23);
        if (!this.OutputFormat.toLowerCase().contains("html")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslhtmlFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-html.xsl";
        }
        String htmlfileName = outfileBasename + ".html";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && htmlfileName != null && htmlfileName.length() > 0) {
            this.xsltWrite(xmlName, xslfofileName, htmlfileName);
        }
    }

    private void writeXML(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(24);
        if (!this.OutputFormat.toLowerCase().contains("xml")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslxmlFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-xml.xsl";
        }
        String xmloutFileName = outfileBasename + ".xml";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && xmloutFileName != null && xmloutFileName.length() > 0) {
            this.xsltWrite(xmlName, xslfofileName, xmloutFileName);
        }
    }

    private void writeGFC(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(25);
        if (!this.OutputFormat.toLowerCase().contains("gfc")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslgfcFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-xml-gfc.xsl";
        }
        String xmloutFileName = outfileBasename + ".gfc.xml";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && xmloutFileName != null && xmloutFileName.length() > 0) {
            this.xsltWrite(xmlName, xslfofileName, xmloutFileName);
        }
    }

    private void writeCSV(String xmlName, String outfileBasename) {
        StatusBoard.getStatusBoard().statusChanged(26);
        if (!this.OutputFormat.toLowerCase().contains("csv")) {
            return;
        }
        String xslfofileName = this.options.parameter(this.getClass().getName(), "xslcsvFile");
        if (xslfofileName == null) {
            xslfofileName = "aaa-csv.xsl";
        }
        String csvoutFileName = outfileBasename + ".csv";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && csvoutFileName != null && csvoutFileName.length() > 0) {
            this.xsltWrite(xmlName, xslfofileName, csvoutFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fopWrite(String xmlName, String xslfofileName, String outfileName, String outputMimetype) {
        block15: {
            String xsltPath = this.options.parameter(this.getClass().getName(), "xsltPfad");
            if (xsltPath == null) {
                xsltPath = "src/main/resources/xslt";
            }
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties("xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", this.model.characterEncoding());
            Logger fl = Logger.getLogger("org.apache.fop");
            fl.setLevel(Level.WARNING);
            if (this.options.parameter("reportLevel").equals("ERROR")) {
                fl.setLevel(Level.SEVERE);
            }
            FopMsgHandler fmh = new FopMsgHandler(this.result, (Target)this);
            fl.addHandler((Handler)fmh);
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
                boolean skip = false;
                File outDir = new File(this.outputDirectory);
                File xmlFile = new File(outDir, xmlName);
                File xsltFile = new File(xsltPath, xslfofileName);
                File outFile = new File(outDir, outfileName);
                if (!xmlFile.canRead()) {
                    this.result.addError(null, 301, xmlFile.getName(), outfileName);
                    skip = true;
                }
                if (!xsltFile.canRead()) {
                    this.result.addError(null, 301, xsltFile.getName(), outfileName);
                    skip = true;
                }
                if (skip) break block15;
                OutputStream out = null;
                try {
                    out = new FileOutputStream(outFile);
                    out = new BufferedOutputStream(out);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outFile.getName(), e.getMessage());
                    skip = true;
                }
                if (skip) break block15;
                try {
                    Fop fop = fopFactory.newFop("application/pdf", foUserAgent, out);
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer(new StreamSource(xsltFile));
                    FopErrorListener el = new FopErrorListener(xmlFile.getName(), this.result, (Target)this);
                    transformer.setErrorListener((ErrorListener)el);
                    transformer.setParameter("versionParam", "2.0");
                    StreamSource src = new StreamSource(xmlFile);
                    SAXResult res = new SAXResult(fop.getDefaultHandler());
                    transformer.transform(src, res);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outfileName, e.getMessage());
                    skip = true;
                }
                finally {
                    out.close();
                    String del = this.options.parameter(this.getClass().getName(), "deleteXmlfile");
                    if (del != null && del.equalsIgnoreCase("true")) {
                        xmlFile.delete();
                    }
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
    }

    private void xsltWrite(String xmlName, String xsltfileName, String outfileName) {
        block11: {
            try {
                String xsltPath = this.options.parameter(this.getClass().getName(), "xsltPfad");
                if (xsltPath == null) {
                    xsltPath = "src/main/resources/xslt";
                }
                File outDir = new File(this.outputDirectory);
                File xmlFile = new File(outDir, xmlName);
                File outFile = new File(outDir, outfileName);
                if (!xmlFile.canRead()) {
                    this.result.addError(null, 301, xmlFile.getName(), outfileName);
                    return;
                }
                StreamSource xmlSource = new StreamSource(xmlFile);
                StreamResult res = new StreamResult(outFile);
                if (xsltfileName == null || xsltfileName.isEmpty()) break block11;
                StreamSource xsltSource = null;
                if (xsltPath.toLowerCase().startsWith("http")) {
                    URL url = new URL(xsltPath + "/" + xsltfileName);
                    URLConnection urlConnection = url.openConnection();
                    xsltSource = new StreamSource(urlConnection.getInputStream());
                } else {
                    try {
                        File xsltFile = new File(xsltPath + "/" + xsltfileName);
                        if (!xsltFile.canRead()) {
                            throw new Exception("Cannot read " + xsltPath + "/" + xsltFile.getName());
                        }
                        xsltSource = new StreamSource(xsltFile);
                    }
                    catch (Exception e) {
                        InputStream stream = this.getClass().getResourceAsStream("/xslt/" + xsltfileName);
                        xsltSource = new StreamSource(stream);
                    }
                }
                if (xsltSource != null) {
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    Transformer trans = transFact.newTransformer(xsltSource);
                    trans.transform(xmlSource, res);
                    this.result.addResult(this.getTargetID(), this.outputDirectory, outfileName, this.options.parameter(this.getClass().getName(), "modellarten"));
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
    }
}

