/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import us.mitre.ShapeChange.Model.GSIP.AssociationInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.ClassInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.GSIPDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfoGSIP
extends PropertyInfoImpl
implements PropertyInfo {
    protected boolean isAttribute = true;
    protected GSIPDocument document = null;
    protected ClassInfoGSIP classInfo = null;
    protected String gsipPropertyId = null;
    protected String gsipName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoGSIP typeClassInfo = null;
    AssociationInfoGSIP associationInfo = null;
    boolean reversedAssoc = false;
    protected StructuredNumber sequenceNumber = new StructuredNumber(Integer.MIN_VALUE);
    protected Multiplicity multiplicity = new Multiplicity();
    protected String initialValueCache = null;
    protected Boolean isDerivedCache = null;
    protected Boolean isNavigableCache = null;
    protected String aggregationTypeCache = null;
    protected Boolean isOrderedCache = null;
    protected String stereotype = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected Vector<Constraint> constraintsCache = null;

    public PropertyInfoGSIP(GSIPDocument doc, ClassInfoGSIP ci, HashMap<String, Object> properties) {
        this(doc, ci, properties, false);
    }

    public PropertyInfoGSIP(GSIPDocument doc, ClassInfoGSIP ci, HashMap<String, Object> properties, boolean isEnumLiteral) {
        String resourceURI;
        String typeClassId;
        ClassInfoGSIP typeClassInfo;
        this.document = doc;
        this.classInfo = ci;
        this.gsipName = (String)properties.get("nsgAlphaCode");
        this.gsipPropertyId = (String)properties.get("itemIdentifier_PK");
        this.isAttribute = true;
        String st = this.document.options.normalizeStereotype("attribute");
        if (st != null) {
            for (String s : Options.propertyStereotypes) {
                if (!st.toLowerCase().equals(s)) continue;
                this.stereotype = s;
            }
        }
        if (this.stereotype == null) {
            st = this.document.options.normalizeStereotype("");
            this.stereotype = st != null ? st : "";
        }
        String descriptionString = GSIPDocument.getDescriptionString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"));
        String documentation = GSIPDocument.getDocumentationString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"), (String)properties.get("note"));
        properties.remove("description");
        properties.put("description", descriptionString);
        properties.put("documentation", documentation);
        String s = !isEnumLiteral ? (String)properties.get("sequenceNumber") : (this.document.enumLiteralSortType == "integer" ? (String)properties.get("dfddCode") : Integer.toString(ci.enumLiteralSequenceNumber++));
        this.sequenceNumber = new StructuredNumber(s);
        this.isNavigableCache = new Boolean(true);
        if (!isEnumLiteral) {
            this.isOrderedCache = new Boolean((String)properties.get("isOrdered"));
            this.isDerivedCache = new Boolean((String)properties.get("isDerived"));
            String inlineOrByRef = (String)properties.get("gmlInlineOrByReference");
            properties.remove("gmlInlineOrByReference");
            properties.put("gmlInlineOrByReference", this.setInlineOrByReference(inlineOrByRef));
            this.aggregationTypeCache = "composite";
            this.initialValueCache = (String)properties.get("defaultValue");
        } else {
            this.initialValueCache = (String)properties.get("nsgAlphaCode");
        }
        if (this.document.suppressDatatypes) {
            typeClassInfo = this.document.fClassByName.get("CharacterString");
            typeClassId = typeClassInfo.gsipClassId;
        } else if (!isEnumLiteral) {
            typeClassId = (String)properties.get("dataType_FK");
            typeClassInfo = this.document.fClassById.get(typeClassId);
        } else {
            typeClassInfo = this.document.fClassByName.get("Integer");
        }
        if (typeClassInfo != null) {
            this.typeInfo.name = typeClassInfo.name();
            this.typeInfo.id = typeClassInfo.id();
        } else {
            this.document.result.addError(null, 130, ci.name() + "." + this.gsipName);
        }
        if (!isEnumLiteral) {
            String card = (String)properties.get("valueMultiplicity");
            String[] ranges = card.split(",");
            int minv = Integer.MAX_VALUE;
            int maxv = Integer.MIN_VALUE;
            for (int i = 0; i < ranges.length; ++i) {
                int upper;
                int lower;
                if (ranges[i].indexOf("..") > 0) {
                    String[] minmax = ranges[i].split("\\.\\.", 2);
                    lower = Integer.parseInt(minmax[0]);
                    if (minmax[1].equals("*") || minmax[1].length() == 0) {
                        upper = Integer.MAX_VALUE;
                    } else {
                        try {
                            upper = Integer.parseInt(minmax[1]);
                        }
                        catch (NumberFormatException e) {
                            this.document.result.addWarning(null, 1003, minmax[1]);
                            upper = Integer.MAX_VALUE;
                        }
                    }
                } else if (ranges[i].length() == 0 || ranges[i].equals("*")) {
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = lower = Integer.parseInt(ranges[i]);
                    }
                    catch (NumberFormatException e) {
                        this.document.result.addWarning(null, 1003, ranges[i]);
                        lower = 0;
                        upper = Integer.MAX_VALUE;
                    }
                }
                if (lower < minv && lower >= 0) {
                    minv = lower;
                }
                if (upper < 0) {
                    maxv = Integer.MAX_VALUE;
                }
                if (upper <= maxv) continue;
                maxv = upper;
            }
            this.multiplicity.minOccurs = minv;
            this.multiplicity.maxOccurs = maxv;
        } else {
            this.multiplicity.minOccurs = 1;
            this.multiplicity.maxOccurs = 1;
        }
        if (ci.stereotype().equalsIgnoreCase("codelist") && (resourceURI = ci.taggedValue("codeList")) != null && resourceURI.length() > 0) {
            properties.put("codeList", resourceURI + "/" + this.gsipName);
        }
        if (!isEnumLiteral && ci.packageInfo.schema != null) {
            String propertyQueryResource;
            String schemaQueryResource = null;
            if (this.document.kmlReferenceType.equalsIgnoreCase("standard")) {
                propertyQueryResource = (String)properties.get("asStandardRefID");
                schemaQueryResource = ci.packageInfo.schema.taggedValue("asQueryResource");
            } else if (this.document.kmlReferenceType.equalsIgnoreCase("fdd")) {
                propertyQueryResource = (String)properties.get("fddConceptRefID");
                schemaQueryResource = ci.packageInfo.schema.taggedValue("fddQueryResource");
            } else {
                propertyQueryResource = (String)properties.get("asAlternateRefID");
                if (propertyQueryResource == null || propertyQueryResource == "") {
                    propertyQueryResource = (String)properties.get("asStandardRefID");
                }
                schemaQueryResource = ci.packageInfo.schema.taggedValue("asQueryResource");
            }
            if (propertyQueryResource != null && propertyQueryResource != "" && schemaQueryResource != null && schemaQueryResource != "") {
                properties.put("kmlReference", schemaQueryResource + propertyQueryResource);
            }
        }
        this.setAndValidateTaggedValues(properties);
        ci.addProperty(this);
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    public PropertyInfoGSIP(GSIPDocument doc, ClassInfoGSIP ci, AssociationInfoGSIP ai, boolean reversed, HashMap<String, Object> properties, ClassInfoGSIP tci) {
        this.document = doc;
        this.classInfo = ci;
        this.associationInfo = ai;
        this.reversedAssoc = reversed;
        this.gsipName = (String)properties.get("nsgAlphaCode");
        this.gsipPropertyId = (String)properties.get("itemIdentifier_PK");
        this.isAttribute = false;
        String descriptionString = GSIPDocument.getDescriptionString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"));
        String documentation = GSIPDocument.getDocumentationString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"), (String)properties.get("note"));
        properties.remove("description");
        properties.put("description", descriptionString);
        properties.put("documentation", documentation);
        this.typeClassInfo = tci;
        this.typeInfo.id = tci.id();
        this.typeInfo.name = tci.name();
        String s = (String)properties.get("sequenceNumber");
        this.sequenceNumber = new StructuredNumber(s);
        this.isOrderedCache = new Boolean((String)properties.get("isOrdered"));
        this.isDerivedCache = new Boolean((String)properties.get("isDerived"));
        this.isNavigableCache = new Boolean((String)properties.get("isNavigable"));
        String inlineOrByRef = (String)properties.get("gmlInlineOrByReference");
        properties.remove("gmlInlineOrByReference");
        properties.put("gmlInlineOrByReference", this.setInlineOrByReference(inlineOrByRef));
        String card = (String)properties.get("valueMultiplicity");
        String[] ranges = card.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < ranges.length; ++i) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        this.document.result.addWarning(null, 1003, minmax[1]);
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0 || ranges[i].equals("*")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    this.document.result.addWarning(null, 1003, ranges[i]);
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper <= maxv) continue;
            maxv = upper;
        }
        this.multiplicity.minOccurs = minv;
        this.multiplicity.maxOccurs = maxv;
        if (ci.packageInfo.schema != null) {
            String entityQueryResource;
            String schemaQueryResource = null;
            if (this.document.kmlReferenceType.equalsIgnoreCase("fdd")) {
                entityQueryResource = (String)properties.get("fddConceptRefID");
                schemaQueryResource = ci.packageInfo.schema.taggedValue("fddQueryResource");
            } else {
                entityQueryResource = (String)properties.get("asStandardRefID");
                schemaQueryResource = ci.packageInfo.schema.taggedValue("asQueryResource");
            }
            if (entityQueryResource != null && entityQueryResource != "" && schemaQueryResource != null && schemaQueryResource != "") {
                properties.put("kmlReference", schemaQueryResource + entityQueryResource);
            }
        }
        this.setAndValidateTaggedValues(properties);
        if (this.aggregationTypeCache == null) {
            this.setAggregationType(null);
        }
        ci.addProperty(this);
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public Multiplicity cardinality() {
        return this.multiplicity;
    }

    @Override
    public String defaultCodeSpace() {
        String s = this.taggedValue("defaultCodeSpace");
        return s != null ? s : "";
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = (ClassInfoGSIP)ci;
    }

    @Override
    public String initialValue() {
        return this.initialValueCache;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.taggedValue("inlineOrByReference");
        if (s == null) {
            s = "";
        }
        return s.toLowerCase();
    }

    @Override
    public boolean isAggregation() {
        if (this.isAttribute) {
            return true;
        }
        return this.aggregationTypeCache.equals("aggregate");
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public boolean isComposition() {
        if (this.isAttribute) {
            return true;
        }
        return this.aggregationTypeCache.equals("composite");
    }

    @Override
    public boolean isDerived() {
        return this.isDerivedCache;
    }

    @Override
    public boolean isNavigable() {
        return this.isNavigableCache;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrderedCache;
    }

    @Override
    public PropertyInfo reverseProperty() {
        if (this.isAttribute()) {
            return null;
        }
        return this.associationInfo.properties[this.reversedAssoc ? 1 : 0];
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    private void setAndValidateTaggedValues(HashMap<String, Object> tvs) {
        this.taggedValuesCache = new HashMap(5);
        if (tvs != null) {
            for (Map.Entry<String, Object> e : tvs.entrySet()) {
                String t = e.getKey();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = (String)e.getValue();
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public boolean voidable() {
        return false;
    }

    @Override
    public String id() {
        return this.gsipPropertyId;
    }

    @Override
    public String name() {
        String s = this.gsipName;
        if (s == null || s.equals("")) {
            if (this.classInfo == null || this.classInfo.category() != 2 && this.classInfo.category() != 3) {
                s = this.id();
                this.document.result.addWarning(null, 100, "property", s);
            } else {
                this.document.result.addWarning(null, 136, this.id(), this.classInfo.name());
            }
        }
        return s;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }

    @Override
    public Vector<Constraint> constraints() {
        return this.constraintsCache;
    }

    public void setAggregationType(String aggregation) {
        this.aggregationTypeCache = aggregation == null ? "none" : (aggregation.equalsIgnoreCase("Aggregation") ? "aggregate" : (aggregation.equalsIgnoreCase("Composition") ? "composite" : "none"));
    }

    public String setInlineOrByReference(String inlineOrByRef) {
        if (inlineOrByRef == null || inlineOrByRef.equalsIgnoreCase("") || inlineOrByRef.equalsIgnoreCase("ByReference")) {
            return "byreference";
        }
        if (inlineOrByRef.equalsIgnoreCase("ByValue")) {
            return "inline";
        }
        return "unspecified";
    }

    @Override
    public AssociationInfo association() {
        return this.associationInfo;
    }
}

