/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XsdDocument;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlSchema
implements Target {
    public static final int TARGET_XMLSCHEMA = 1;
    private ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private boolean printed = false;
    private final HashMap<String, XsdDocument> xsdMap = new HashMap();
    private SchematronSchema schDoc = null;
    private boolean diagnosticsOnly = false;
    private String outputDirectory;

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        File trgdir;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        if (this.pi.matches("rule-xsd-all-notEncoded") && this.pi.encodingRule("xsd").equalsIgnoreCase("notencoded")) {
            return;
        }
        this.result.addDebug(null, 10012, this.pi.name());
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if (this.pi.matches("rule-xsd-pkg-schematron")) {
            this.schDoc = new SchematronSchema(this.model, this.options, this.result, this.pi);
        }
        this.createXSDs(this.pi, null);
        if (this.pi.matches("rule-xsd-pkg-dependencies")) {
            this.processDependecies(this.pi);
        }
        if (!this.diagnosticsOnly && !(trgdir = new File(this.outputDirectory)).exists()) {
            trgdir.mkdirs();
        }
        for (ClassInfo ci : this.model.classes(this.pi)) {
            ci.processed(this.getTargetID(), false);
        }
    }

    public void process(ClassInfo ci) {
        Element propertyHook;
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (ci.processed(this.getTargetID())) {
            return;
        }
        int cat = ci.category();
        this.result.addDebug(null, 10016, ci.name(), ci.encodingRule("xsd"));
        if (ci.matches("rule-xsd-all-notEncoded") && ci.encodingRule("xsd").equalsIgnoreCase("notencoded")) {
            return;
        }
        PackageInfo pi = ci.pkg();
        XsdDocument xsd = this.xsdMap.get(pi.id());
        while (xsd == null) {
            if ((pi = pi.owner()) == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 10, ci.name(), ci.pkg().name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
                return;
            }
            xsd = this.xsdMap.get(pi.id());
        }
        ClassInfo cibase = ci.baseClass();
        if (ci.matches("rule-xsd-cls-no-base-class")) {
            cibase = null;
        }
        if (this.schDoc != null) {
            Vector<Constraint> cs = ci.constraints();
            Collections.sort(cs, new Comparator<Constraint>(){

                @Override
                public int compare(Constraint ci1, Constraint ci2) {
                    return ci1.name().compareTo(ci2.name());
                }
            });
            if (cs != null) {
                for (Constraint c : cs) {
                    if (c == null || !(c instanceof OclConstraint) || this.schDoc == null) continue;
                    this.schDoc.addAssertion(ci, (OclConstraint)c);
                }
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!ci.matches("rule-xsd-cls-enum-object-element")) break;
                xsd.pObjectElement(ci, cibase);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString() || ci.matches("rule-xsd-cls-union-as-group-property-type")) break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: {
                if (ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract() || ci.matches("rule-xsd-cls-suppress") && ci.suppressed() || !ci.matches("rule-xsd-cls-object-element")) break;
                xsd.pObjectElement(ci, cibase);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
            }
        }
        switch (cat) {
            case 3: {
                if (!ci.matches("rule-xsd-cls-global-enumeration")) break;
                xsd.pGlobalEnumeration(ci);
                break;
            }
            case 2: {
                if ((!ci.matches("rule-xsd-cls-codelist-asDictionary") || ci.asDictionary()) && (!ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") || ci.asDictionaryGml33())) break;
                xsd.pGlobalCodeList(ci);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString()) break;
                if (ci.matches("rule-xsd-cls-union-as-group-property-type")) {
                    xsd.pValueTypeGroup(ci);
                    break;
                }
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: {
                if (ci.matches("rule-xsd-cls-adeelement") && ci.stereotype().equalsIgnoreCase("adeelement")) {
                    xsd.processLocalProperties(ci, xsd.root, this.schDoc);
                    break;
                }
                if (ci.matches("rule-xsd-cls-suppress") && ci.suppressed() || ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract() || !ci.matches("rule-xsd-cls-type")) break;
                propertyHook = xsd.pComplexType(ci, cibase, this.schDoc);
                if (!ci.matches("rule-xsd-cls-local-properties")) break;
                xsd.processLocalProperties(ci, propertyHook, this.schDoc);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!ci.matches("rule-xsd-cls-enum-property-type")) break;
                xsd.pPropertyTypes(ci);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString()) break;
                if (ci.matches("rule-xsd-cls-union-as-group-property-type")) {
                    xsd.pPropertyTypeWithGroup(ci);
                    break;
                }
            }
            case 1: 
            case 5: 
            case 6: {
                if (ci.matches("rule-xsd-cls-suppress") && ci.suppressed()) break;
                if (ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract()) {
                    xsd.pPropertyTypeWithSubtypes(ci);
                    break;
                }
                if (!ci.matches("rule-xsd-cls-type")) break;
                xsd.pPropertyTypes(ci);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
                xsd.pPropertyTypeWithSubtypes(ci);
                break;
            }
            case 11: {
                if (!ci.matches("rule-xsd-cls-okstra-schluesseltabelle")) break;
                xsd.pOKSTRAKEYPropertyType(ci);
            }
        }
        switch (cat) {
            case 8: {
                if (!ci.matches("rule-xsd-cls-union-asGroup") || !ci.asGroup()) break;
                propertyHook = xsd.pGroup(ci, cibase);
                xsd.processLocalProperties(ci, propertyHook, this.schDoc);
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                if (!ci.matches("rule-xsd-cls-basictype") || ci.matches("rule-xsd-cls-local-basictype")) break;
                xsd.pGlobalBasicType(ci);
            }
        }
        ci.processed(this.getTargetID(), true);
    }

    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        for (XsdDocument xsd : this.xsdMap.values()) {
            if (xsd.printed()) continue;
            try {
                xsd.printFile(outputFormat);
                this.result.addResult(this.getTargetID(), this.outputDirectory, xsd.name, this.pi.targetNamespace());
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
        if (this.schDoc != null) {
            this.schDoc.write(this.outputDirectory);
        }
        this.printed = true;
    }

    protected boolean createXSDs(PackageInfo pi, XsdDocument xsdcurr) throws ShapeChangeAbortException {
        XsdDocument xsd;
        boolean res = false;
        String xsdDocument = pi.xsdDocument();
        if (xsdDocument != null && xsdDocument.length() > 0) {
            try {
                this.result.addDebug(null, 10017, xsdDocument, pi.name());
                xsd = new XsdDocument(pi, this.model, this.options, this.result, xsdDocument);
                res = true;
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(null, 2);
                throw new ShapeChangeAbortException();
            }
        }
        xsd = xsdcurr;
        if (xsd == null) {
            this.result.addFatalError(null, 15, pi.name());
            xsdDocument = pi.name() + ".xsd";
            try {
                this.result.addDebug(null, 10017, xsdDocument, pi.name());
                xsd = new XsdDocument(pi, this.model, this.options, this.result, xsdDocument);
                res = true;
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(null, 2);
                throw new ShapeChangeAbortException();
            }
        }
        this.xsdMap.put(pi.id(), xsd);
        if (pi.matches("rule-xsd-pkg-contained-packages")) {
            try {
                HashSet<PackageInfo> sub = pi.containedPackages();
                for (PackageInfo pix : sub) {
                    if (pix.isSchema()) {
                        xsd.addImport(pix.xmlns(), pix.targetNamespace());
                        continue;
                    }
                    boolean created = this.createXSDs(pix, xsd);
                    if (!created) continue;
                    xsd.addInclude(this.xsdMap.get(pix.id()));
                    this.xsdMap.get(pix.id()).addInclude(xsd);
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                Exception se = e;
                if (e instanceof SAXException) {
                    se = ((SAXException)e).getException();
                }
                if (se != null) {
                    se.printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                throw new ShapeChangeAbortException();
            }
        }
        return res;
    }

    protected void processDependecies(PackageInfo pi) throws ShapeChangeAbortException {
        XsdDocument xsd1 = this.xsdMap.get(pi.id());
        for (String pid : pi.supplierIds()) {
            XsdDocument xsd2 = this.xsdMap.get(pid);
            if (xsd2 != null) {
                xsd1.addInclude(xsd2);
                continue;
            }
            PackageInfo pi2 = this.model.packageById(pid);
            if (pi2 == null || pi2.xmlns() == null || pi2.xmlns().length() <= 0 || pi2.targetNamespace() == null || pi2.targetNamespace().length() <= 0) continue;
            xsd1.addImport(pi2.xmlns(), pi2.targetNamespace());
        }
        try {
            HashSet<PackageInfo> sub = pi.containedPackages();
            for (PackageInfo pix : sub) {
                if (pix.isSchema()) continue;
                this.processDependecies(pix);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException();
        }
    }

    public int getTargetID() {
        return 1;
    }

    public static boolean classHasObjectElement(ClassInfo ci) {
        MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            return me.p1 != null && me.p1.length() > 0;
        }
        int cat = ci.category();
        if (ci.encodingRule("xsd").equals(Options.ISO19139_2007)) {
            return cat == 5 || cat == 8 || cat == 1 || cat == 6 || cat == 3 || cat == 2 || cat == -1;
        }
        return cat == 5 || cat == 8 && (!ci.matches("rule-xsd-cls-union-asGroup") || !ci.asGroup()) || cat == 1 || cat == 6 || cat == -1 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid");
    }

    public static boolean classCanBeReferenced(ClassInfo ci) {
        if (XmlSchema.classHasObjectElement(ci)) {
            int cat = ci.category();
            if (cat == 1) {
                return true;
            }
            if (cat == 12) {
                return true;
            }
            if (cat == 6) {
                return true;
            }
            if (ci.encodingRule("xsd").equals(Options.ISO19139_2007)) {
                if (cat == 5) {
                    return true;
                }
                if (cat == 8) {
                    return true;
                }
            }
        }
        return false;
    }
}

