/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EADocument
extends ModelImpl
implements Model {
    public static final int STATUS_EADOCUMENT_INITSTART = 101;
    public static final int STATUS_EADOCUMENT_READMODEL = 102;
    public static final int STATUS_EADOCUMENT_ESTABLISHCLASSES = 103;
    public static final int STATUS_EADOCUMENT_READCONSTARINTS = 104;
    public Options options = null;
    public ShapeChangeResult result = null;
    protected Repository repository = null;
    protected final String characterEncoding = "Windows-1252";
    HashMap<String, ClassInfoEA> fClassById = new HashMap(500);
    HashMap<String, ClassInfoEA> fClassByName = new HashMap(500);
    HashMap<String, PackageInfoEA> fPackageById = new HashMap(100);
    HashMap<String, PackageInfoEA> fPackageByElmtId = new HashMap(100);
    HashMap<String, AssociationInfoEA> fAssociationById = new HashMap(100);
    protected int globalSequenceNumber = -1073741824;

    public EADocument() {
    }

    public EADocument(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.initialise(r, o, repositoryFileName);
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        StatusBoard.getStatusBoard().statusChanged(101);
        File repfile = new File(repositoryFileName);
        boolean ex = true;
        if (!repfile.exists()) {
            ex = false;
            if (!repositoryFileName.toLowerCase().endsWith(".eap")) {
                repositoryFileName = repositoryFileName + ".eap";
                repfile = new File(repositoryFileName);
                ex = repfile.exists();
            }
        }
        if (!ex) {
            r.addFatalError(null, 31, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        String absname = repfile.getAbsolutePath();
        this.repository = new Repository();
        if (!this.repository.OpenFile(absname)) {
            String errormsg = this.repository.GetLastError();
            r.addFatalError(null, 30, errormsg, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        StatusBoard.getStatusBoard().statusChanged(102);
        class EvalTask {
            PackageInfoEA fatherPI;
            Package eaPackage;

            EvalTask(PackageInfoEA fpi, Package p) {
                this.fatherPI = fpi;
                this.eaPackage = p;
            }
        }
        LinkedList<EvalTask> evalp = new LinkedList<EvalTask>();
        Collection model = this.repository.GetModels();
        for (Package p : model) {
            evalp.addLast(new EvalTask(null, p));
        }
        while (evalp.size() > 0) {
            EvalTask et = (EvalTask)evalp.removeFirst();
            Package pack = et.eaPackage;
            PackageInfoEA fpi = et.fatherPI;
            Element packelmt = pack.GetElement();
            PackageInfoEA pi = new PackageInfoEA(this, fpi, pack, packelmt);
            this.fPackageById.put(pi.id(), pi);
            if (packelmt != null) {
                this.fPackageByElmtId.put(new Integer(packelmt.GetElementID()).toString(), pi);
            }
            for (Element elmt : pack.GetElements()) {
                String type = elmt.GetType();
                if (!type.equals("DataType") && !type.equals("Class") && !type.equals("Interface")) continue;
                ClassInfoEA ci = new ClassInfoEA(this, pi, elmt);
                this.fClassById.put(ci.id(), ci);
                this.fClassByName.put(ci.name(), ci);
            }
            for (Package pnxt : pack.GetPackages()) {
                evalp.addLast(new EvalTask(pi, pnxt));
            }
        }
        StatusBoard.getStatusBoard().statusChanged(103);
        for (ClassInfoEA ci : this.fClassById.values()) {
            ci.establishClassDerivationHierarchy();
            ci.establishAssociations();
        }
        String checkingConstraints = this.options.parameter("checkingConstraints");
        if (checkingConstraints == null || !checkingConstraints.toLowerCase().trim().equals("disabled")) {
            StatusBoard.getStatusBoard().statusChanged(104);
            for (ClassInfoEA ci : this.fClassById.values()) {
                ci.constraints();
                TreeMap<StructuredNumber, PropertyInfo> props = ci.properties();
                for (PropertyInfo pi : props.values()) {
                    pi.constraints();
                }
            }
        }
        HashSet<PackageInfo> schemas = this.schemas("");
        for (PackageInfo pi : schemas) {
            this.options.addSchemaLocation(pi.targetNamespace(), pi.xsdDocument());
        }
    }

    @Override
    public String characterEncoding() {
        return "Windows-1252";
    }

    @Override
    public ClassInfo classById(String id) {
        return this.fClassById.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return this.fClassByName.get(nam);
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>(30);
        String tns = pi.targetNamespace();
        return this.addClasses((PackageInfoEA)pi, tns, res);
    }

    private HashSet<ClassInfo> addClasses(PackageInfoEA pi, String tns, HashSet<ClassInfo> res) {
        String ctns = pi.targetNamespace();
        if (!(ctns == null || tns != null && tns.equals(ctns))) {
            return res;
        }
        res.addAll(pi.childCI);
        for (PackageInfoEA cpi : pi.childPI) {
            res = this.addClasses(cpi, tns, res);
        }
        return res;
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.fPackageById.get(id);
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfoEA pi : this.fPackageById.values()) {
            if (pi.isSchema()) {
                if (name != null && !name.equals("")) {
                    if (!pi.name().equals(name)) continue;
                    res.add(pi);
                    continue;
                }
                res.add(pi);
                continue;
            }
            if (!pi.isAppSchema()) continue;
        }
        return res;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public void shutdown() {
        if (this.repository != null) {
            this.repository.CloseFile();
            this.repository.Exit();
            this.repository = null;
        }
    }

    public static String removeSpuriousEA75EntitiesFromStrings(String s) {
        if (!s.contains("&")) {
            return s;
        }
        return s.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&euro;", "\u20ac");
    }

    public Repository repository() {
        return this.repository;
    }
}

