/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XsdDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfoXmi10
extends PackageInfoImpl
implements PackageInfo {
    protected Element pkg;
    protected Xmi10Document doc;
    protected String id;
    protected XsdDocument gmlASD = null;
    protected boolean processedIncludes = false;
    protected UUID uuid = null;
    protected Document defDocument = null;
    protected Document smDocument = null;

    @Override
    public Model model() {
        return this.doc;
    }

    @Override
    public Options options() {
        return this.doc.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.doc.result;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String s = this.doc.textOfProperty(this.pkg, "Foundation.Core.ModelElement.name");
        if (s == null) {
            s = this.id();
            this.doc.result.addWarning(100, "package", s);
        } else {
            s = s.trim();
        }
        return s;
    }

    @Override
    public String stereotype() {
        String s;
        String stereotype = this.doc.fStereotypes.get(this.id);
        if (stereotype == null) {
            stereotype = "";
        }
        if ((s = this.doc.options.stereotypeAlias(stereotype)) != null) {
            stereotype = s;
        }
        return stereotype;
    }

    @Override
    public String taggedValue(String tag) {
        return this.doc.taggedValue(this.id, tag);
    }

    @Override
    public PackageInfo owner() {
        String s = this.doc.idOfProperty(this.pkg, "Foundation.Core.ModelElement.namespace");
        if (s.length() == 0) {
            s = this.doc.getOwnerIdAsString(this.pkg);
        }
        return this.doc.fPackages.get(s);
    }

    @Override
    public HashSet<String> supplierIds() {
        HashSet<String> suppliers = new HashSet<String>();
        Vector<String> depids = this.doc.idsOfProperty(this.pkg, "Foundation.Core.ModelElement.clientDependency");
        Iterator<String> i = depids.iterator();
        while (i.hasNext()) {
            Element e = this.doc.getElementById(i.next());
            if (e == null || !this.doc.visible(e) && !this.doc.options.eaBugFixPublicPackagesAreMarkedAsPrivate) continue;
            Vector<String> pkgids = this.doc.idsOfProperty(e, "Foundation.Core.Dependency.supplier");
            for (String sid : pkgids) {
                suppliers.add(sid);
            }
        }
        return suppliers;
    }

    public XsdDocument gmlApplicationSchemaDocument() {
        return this.gmlASD;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] tags = tagList.split("\\,");
        int i = 0;
        while (i < tags.length) {
            String s = this.doc.taggedValue(this.id(), tags[i].trim());
            if (s != null) {
                ret.put(tags[i].trim(), s);
            }
            ++i;
        }
        return ret;
    }

    public PackageInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException {
        this.doc = d;
        this.pkg = e;
        this.id = this.pkg.getAttribute("xmi.id");
        this.uuid = UUID.randomUUID();
        this.doc.fUUIDs.put(this.id, this.uuid);
        this.doc.result.addDebug(10001, this.id, this.name(), this.targetNamespace());
    }

    @Override
    public PackageInfo rootPackage() {
        return this.doc.fPackages.get(this.schemaId());
    }

    @Override
    public HashSet<PackageInfo> containedPackages() throws Exception {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        NodeList nl = this.pkg.getChildNodes();
        int j = 0;
        while (j < nl.getLength()) {
            Node n = nl.item(j);
            if (n.getLocalName().equals("Foundation.Core.Namespace.ownedElement")) {
                NodeList nl2 = n.getChildNodes();
                int k = 0;
                while (k < nl2.getLength()) {
                    Node n2 = nl2.item(k);
                    if (n2.getLocalName().equals("Model_Management.Package")) {
                        Element e = (Element)n2;
                        String xid = e.getAttribute("xmi.id");
                        res.add(this.doc.fPackages.get(xid));
                    }
                    ++k;
                }
                break;
            }
            ++j;
        }
        return res;
    }
}

