/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;

public abstract class PackageInfoImpl
extends InfoImpl
implements PackageInfo {
    public String encodingRule(String platform) {
        String s = this.taggedValue(String.valueOf(platform) + "EncodingRule");
        if (s == null) {
            PackageInfo o = this.owner();
            if (o != null) {
                s = o.encodingRule(platform);
            }
            if (s == null && (s = this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule")) == null) {
                s = "iso19136_2007";
            }
        }
        return s;
    }

    public String targetNamespace() {
        PackageInfo o;
        String s = this.options().nsOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.targetNamespace();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String xmlns() {
        PackageInfo o;
        String s = this.options().nsabrOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("xmlns");
        if (s == null) {
            s = this.taggedValue("xmlNamespaceAbbreviation");
        }
        if (s == null && (o = this.owner()) != null) {
            s = o.xmlns();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    protected String mapPackageNameToFilename(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case ' ': {
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return String.valueOf(str.toString()) + ".xsd";
    }

    public String xsdDocument() {
        String stereotype;
        String s = this.options().xsdOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("xsdDocument");
        if (s == null) {
            s = this.taggedValue("xsdName");
        }
        if (s == null && (stereotype = this.stereotype()) != null && stereotype.equals("application schema")) {
            s = this.mapPackageNameToFilename(this.name());
            this.result().addWarning(101, this.name(), this.id(), s);
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String gmlProfileSchema() {
        return this.taggedValue("gmlProfileSchema");
    }

    public String version() {
        String s = this.options().versionOfPackage(this.name());
        if (s != null) {
            s = s.trim();
            return s;
        }
        s = this.taggedValue("version");
        PackageInfo o = this.owner();
        if (s == null && o != null) {
            s = o.version();
        }
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public boolean isAppSchema() {
        String stereotype = this.stereotype();
        return stereotype != null && stereotype.equals("application schema");
    }

    public boolean isSchema() {
        String s = this.taggedValue("targetNamespace");
        if (s == null) {
            s = this.taggedValue("xmlNamespace");
        }
        if (s != null) {
            return true;
        }
        return this.options().nsOfPackage(this.name()) != null;
    }

    public String schemaId() {
        if (this.isSchema()) {
            return this.id();
        }
        PackageInfo o = this.owner();
        if (o != null) {
            return o.schemaId();
        }
        return "(null)";
    }
}

