/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.sparx.Collection;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EADocument
implements Model {
    public Options options = null;
    public ShapeChangeResult result = null;
    protected Repository repository = null;
    protected final String characterEncoding = "Windows-1252";
    HashMap<String, ClassInfoEA> fClassById = new HashMap(500);
    HashMap<String, ClassInfoEA> fClassByName = new HashMap(500);
    HashMap<String, PackageInfoEA> fPackageById = new HashMap(100);
    HashMap<String, PackageInfoEA> fPackageByElmtId = new HashMap(100);
    HashMap<String, AssociationInfoEA> fAssociationById = new HashMap(100);
    protected int globalSequenceNumber = -1073741824;
    static String[] gmlTags = new String[]{"targetNamespace", "xmlns", "version", "xsdDocument", "gmlProfileSchema", "sequenceNumber", "noPropertyType", "byValuePropertyType", "isCollection", "asDictionary", "inlineOrByReference", "isMetadata", "defaultCodeSpace", "xmlSchemaType", "documentation"};
    static String[] shapeChangeTags = new String[]{"xsdEncodingRule", "xsdAsAttribute", "xsdDerivation", "gmlAsGroup", "length", "base", "rangeMinimum", "rangeMaximum", "default", "nilReasonAllowed", "gmlImplementedByNilReason", "noGMLType", "primaryCode", "secondaryCode", "oclExpressions", "schPatterns", "unitMeasure", "voidable", "description", "infoURL", "alias"};
    protected HashSet<String> allowedTags = null;

    String normalizeTaggedValue(String tag) {
        if (this.allowedTags == null) {
            String s;
            this.allowedTags = new HashSet(70);
            String[] stringArray = gmlTags;
            int n = gmlTags.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                this.allowedTags.add(s);
                ++n2;
            }
            stringArray = shapeChangeTags;
            n = shapeChangeTags.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                this.allowedTags.add(s);
                ++n2;
            }
            stringArray = this.options.parameter("representTaggedValues").split("\\,");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                this.allowedTags.add(s);
                ++n2;
            }
        }
        if (this.allowedTags.contains(tag)) {
            return tag;
        }
        if (tag.equals("xmlNamespace")) {
            return "targetNamespace";
        }
        if (tag.equals("xmlNamespaceAbbreviation")) {
            return "xmlns";
        }
        if (tag.equals("xsdName")) {
            return "xsdDocument";
        }
        if (tag.equals("asGroup")) {
            return "gmlAsGroup";
        }
        if (tag.equals("implementedByNilReason")) {
            return "gmlImplementedByNilReason";
        }
        return null;
    }

    public EADocument(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        File repfile = new File(repositoryFileName);
        boolean ex = true;
        if (!repfile.exists()) {
            ex = false;
            if (!repositoryFileName.toLowerCase().endsWith(".eap")) {
                repositoryFileName = String.valueOf(repositoryFileName) + ".eap";
                repfile = new File(repositoryFileName);
                ex = repfile.exists();
            }
        }
        if (!ex) {
            r.addFatalError(31, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        String absname = repfile.getAbsolutePath();
        this.repository = new Repository();
        if (!this.repository.OpenFile(absname)) {
            String errormsg = this.repository.GetLastError();
            r.addFatalError(30, errormsg, repositoryFileName);
            throw new ShapeChangeAbortException();
        }
        class EvalTask {
            PackageInfoEA fatherPI;
            Package eaPackage;

            EvalTask(PackageInfoEA fpi, Package p) {
                this.fatherPI = fpi;
                this.eaPackage = p;
            }
        }
        LinkedList<EvalTask> evalp = new LinkedList<EvalTask>();
        Collection model = this.repository.GetModels();
        for (Package p : model) {
            evalp.addLast(new EvalTask(null, p));
        }
        while (evalp.size() > 0) {
            EvalTask et = (EvalTask)evalp.removeFirst();
            Package pack = et.eaPackage;
            PackageInfoEA fpi = et.fatherPI;
            Element packelmt = pack.GetElement();
            PackageInfoEA pi = new PackageInfoEA(this, fpi, pack, packelmt);
            this.fPackageById.put(new Integer(pack.GetPackageID()).toString(), pi);
            if (packelmt != null) {
                this.fPackageByElmtId.put(new Integer(packelmt.GetElementID()).toString(), pi);
            }
            for (Element elmt : pack.GetElements()) {
                if (!elmt.GetType().equals("Class")) continue;
                ClassInfoEA ci = new ClassInfoEA(this, pi, elmt);
                this.fClassById.put(new Integer(elmt.GetElementID()).toString(), ci);
                this.fClassByName.put(elmt.GetName(), ci);
            }
            for (Package pnxt : pack.GetPackages()) {
                evalp.addLast(new EvalTask(pi, pnxt));
            }
        }
        for (ClassInfoEA ci : this.fClassById.values()) {
            ci.establishClassDerivationHierarchy();
            ci.establishAssociations();
            ci.constraints();
        }
    }

    @Override
    public String characterEncoding() {
        return "Windows-1252";
    }

    @Override
    public ClassInfo classById(String id) {
        return this.fClassById.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return this.fClassByName.get(nam);
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>(30);
        String tns = pi.targetNamespace();
        return this.addClasses((PackageInfoEA)pi, tns, res);
    }

    private HashSet<ClassInfo> addClasses(PackageInfoEA pi, String tns, HashSet<ClassInfo> res) {
        String ctns = pi.targetNamespace();
        if (!(ctns == null || tns != null && tns.equals(ctns))) {
            return res;
        }
        res.addAll(pi.childCI);
        for (PackageInfoEA cpi : pi.childPI) {
            res = this.addClasses(cpi, tns, res);
        }
        return res;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.fPackageById.get(id);
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfo packageInfo : this.fPackageById.values()) {
            if (!packageInfo.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (!packageInfo.name().equals(name)) continue;
                res.add(packageInfo);
                continue;
            }
            res.add(packageInfo);
        }
        return res;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public void validate() {
    }

    @Override
    public void shutdown() {
        if (this.repository != null) {
            this.repository.CloseFile();
            this.repository.Exit();
            this.repository = null;
        }
    }
}

