/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Element;
import org.sparx.TaggedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoEA
extends ClassInfoImpl
implements ClassInfo {
    protected EADocument document;
    protected PackageInfoEA packageInfo;
    protected ClassInfoEA baseclassInfo = null;
    protected HashSet<ClassInfoEA> baseclassInfoSet = null;
    protected HashSet<ClassInfoEA> subclassInfoSet = new HashSet();
    protected Element eaClassElement = null;
    protected int eaClassId = 0;
    protected String eaName = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected Vector<PropertyInfoEA> registeredRoles = new Vector();
    protected HashMap<String, String> taggedValuesCache = null;
    protected HashSet<String> stereotypesCache = null;
    protected TreeMap<StructuredNumber, PropertyInfo> propertiesCache = null;
    protected Vector<Constraint> constraintsCache = null;
    protected boolean hasNilReason = false;

    public ClassInfoEA(EADocument doc, PackageInfoEA pi, Element elmt) throws ShapeChangeAbortException {
        this.document = doc;
        this.packageInfo = pi;
        pi.childCI.add(this);
        this.eaClassElement = elmt;
        this.eaClassId = this.eaClassElement.GetElementID();
        this.eaName = this.eaClassElement.GetName();
        this.isAbstract = this.eaClassElement.GetAbstract().equals("1");
        this.isLeaf = this.eaClassElement.GetIsLeaf();
        this.establishCategory();
    }

    public void establishClassDerivationHierarchy() {
        Collection baseclasses = this.eaClassElement.GetBaseClasses();
        short nbcl = baseclasses.GetCount();
        for (Element baseclass : baseclasses) {
            int bclid = baseclass.GetElementID();
            ClassInfoEA baseCI = this.document.fClassById.get(new Integer(bclid).toString());
            if (baseCI == null) continue;
            if (nbcl == 1) {
                this.baseclassInfo = baseCI;
            } else {
                if (this.baseclassInfoSet == null) {
                    this.baseclassInfoSet = new HashSet(nbcl);
                }
                this.baseclassInfoSet.add(baseCI);
            }
            baseCI.subclassInfoSet.add(this);
        }
    }

    public void establishAssociations() {
        Collection conns = this.eaClassElement.GetConnectors();
        for (Connector conn : conns) {
            int id = conn.GetConnectorID();
            String connid = new Integer(id).toString();
            boolean known = this.document.fAssociationById.containsKey(connid);
            if (known) continue;
            AssociationInfoEA ai = new AssociationInfoEA(this.document, conn, id);
            if (!ai.relevant) continue;
            this.document.fAssociationById.put(connid, ai);
        }
    }

    public void establishRoles(PropertyInfoEA pi) {
        this.registeredRoles.add(pi);
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public ClassInfo baseClass() {
        int stsize = 0;
        ClassInfoEA cir = null;
        int cat = this.category();
        if (cat == 1 || cat == 6 || cat == 5 || cat == 4 || cat == 8) {
            HashSet<ClassInfoEA> baseCIs = null;
            if (this.baseclassInfoSet != null) {
                baseCIs = this.baseclassInfoSet;
            } else if (this.baseclassInfo != null) {
                baseCIs = new HashSet(1);
                baseCIs.add(this.baseclassInfo);
            }
            if (baseCIs != null) {
                for (ClassInfoEA baseCI : baseCIs) {
                    int bcat = baseCI.category();
                    if ((cat == bcat || bcat == -1) && bcat != 4) {
                        ++stsize;
                        cir = baseCI;
                        continue;
                    }
                    if (bcat == 4) continue;
                    this.document.result.addError(108, this.name());
                    this.document.result.addDebug(10003, this.name(), "" + cat, "!FALSE");
                    this.document.result.addDebug(10003, this.name(), "" + bcat, "!TRUE");
                }
            }
            if (stsize > 1) {
                this.document.result.addError(109, this.name());
            }
        }
        return cir;
    }

    @Override
    public boolean checkSupertypes(int cat) {
        HashSet<Object> bcis = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        boolean res = true;
        for (ClassInfoEA classInfoEA : bcis) {
            int bcicat = classInfoEA.category();
            if (bcicat == -1) {
                res = classInfoEA.checkSupertypes(cat);
            } else {
                if (bcicat == 4) continue;
                if (bcicat != cat) {
                    res = false;
                }
            }
            if (!res) break;
        }
        if (res) {
            this.document.result.addDebug(10003, this.name(), "" + cat, "TRUE");
        } else {
            this.document.result.addDebug(10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    @Override
    public PackageInfo pkg() {
        return this.packageInfo;
    }

    @Override
    public TreeMap<StructuredNumber, PropertyInfo> properties() {
        this.validatePropertiesCache();
        return (TreeMap)this.propertiesCache.clone();
    }

    @Override
    public PropertyInfo property(String name) {
        this.validatePropertiesCache();
        for (PropertyInfo pi : this.propertiesCache.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        HashSet<ClassInfoEA> bcis = new HashSet<ClassInfoEA>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoEA bci : bcis) {
            PropertyInfo pi = bci.property(name);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaClassElement.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            String[] stringArray = stereotypes;
            int n = stereotypes.length;
            int n2 = 0;
            while (n2 < n) {
                String stereotype = stringArray[n2];
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st != null) {
                    String[] stringArray2 = Options.classStereotypes;
                    int n3 = Options.classStereotypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray2[n4];
                        if (st.toLowerCase().equals(s)) {
                            this.stereotypesCache.add(s);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> iterator = this.stereotypesCache.iterator();
        if (iterator.hasNext()) {
            String st = iterator.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    @Override
    public HashSet<String> subtypes() {
        HashSet<String> subids = new HashSet<String>(this.subclassInfoSet.size());
        for (ClassInfoEA sci : this.subclassInfoSet) {
            subids.add(sci.id());
        }
        return subids;
    }

    @Override
    public HashSet<String> supertypes() {
        HashSet<String> baseids = new HashSet<String>(1);
        if (this.baseclassInfo != null) {
            baseids.add(this.baseclassInfo.id());
        } else if (this.baseclassInfoSet != null) {
            for (ClassInfoEA bci : this.baseclassInfoSet) {
                baseids.add(bci.id());
            }
        }
        return baseids;
    }

    @Override
    public String documentation() {
        String s = super.documentation();
        if (s == null || s.length() == 0) {
            s = this.eaClassElement.GetNotes();
        }
        return s != null ? s : "";
    }

    @Override
    public String id() {
        return new Integer(this.eaClassId).toString();
    }

    @Override
    public String name() {
        String s = this.eaName.trim();
        if (s == null || s.equals("")) {
            s = this.id();
            this.document.result.addWarning(100, "class", s);
        }
        return s;
    }

    @Override
    public String aliasName() {
        String a = super.aliasName();
        if (a == null || a.length() == 0) {
            a = this.eaClassElement.GetAlias();
        }
        return a;
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = this.eaClassElement.GetTaggedValues();
            short ntvs = tvs.GetCount();
            this.taggedValuesCache = new HashMap(ntvs);
            for (TaggedValue tv : tvs) {
                String t = tv.GetName();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = tv.GetValue();
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v != null) {
                res.put(t, v);
            }
            ++n2;
        }
        return res;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public boolean hasNilReason() {
        return this.hasNilReason;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            this.constraintsCache = new Vector();
            Collection constrs = this.eaClassElement.GetConstraints();
            for (org.sparx.Constraint constr : constrs) {
                String type = constr.GetType();
                Constraint oc = type.equals("OCL") ? new OclConstraintEA(this.document, this, constr) : new TextConstraintEA(this.document, this, constr);
                this.constraintsCache.add(oc);
            }
        }
    }

    @Override
    public Vector<Constraint> constraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }

    private void validatePropertiesCache() {
        if (this.propertiesCache == null) {
            this.propertiesCache = new TreeMap();
            Collection attrs = this.eaClassElement.GetAttributes();
            for (Attribute attr : attrs) {
                String vis;
                if (this.document.options.parameter("publicOnly").equals("true") && !(vis = attr.GetVisibility()).equals("Public")) continue;
                PropertyInfoEA pi = new PropertyInfoEA(this.document, this, attr);
                PropertyInfo piTemp = this.propertiesCache.get(pi.sequenceNumber());
                if (piTemp != null) {
                    this.document.result.addError(107, pi.name(), this.name(), piTemp.name());
                }
                this.propertiesCache.put(pi.sequenceNumber(), pi);
                if (!pi.implementedByNilReason()) continue;
                this.hasNilReason = true;
            }
            for (PropertyInfoEA pi : this.registeredRoles) {
                PropertyInfo piTemp = this.propertiesCache.get(pi.sequenceNumber());
                if (piTemp != null) {
                    this.document.result.addError(107, pi.name(), this.name(), piTemp.name());
                }
                this.propertiesCache.put(pi.sequenceNumber(), pi);
                if (!pi.implementedByNilReason()) continue;
                this.hasNilReason = true;
            }
        }
    }
}

