/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import com.sun.net.ssl.internal.ssl.Provider;
import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Xmi10Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConverterServlet
extends HttpServlet {
    private static final long serialVersionUID = -7060868172540625542L;
    protected static int fMAX_REQUEST_SIZE;
    protected static String fConfigFile;
    protected static String fReportLevel;
    protected static String fShapeChangeSystemConfiguration;
    protected static String ABS_PATH;
    protected static String sep;
    protected static String repOptionTags;
    protected static String wrsOptionTags;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        fMAX_REQUEST_SIZE = Integer.parseInt(config.getInitParameter("maxSizeOfRequest"));
        fConfigFile = config.getInitParameter("configFile");
        fReportLevel = config.getInitParameter("reportLevel");
        fShapeChangeSystemConfiguration = config.getInitParameter("systemConfigFile");
        ABS_PATH = this.getServletContext().getRealPath("/");
        sep = System.getProperty("file.separator");
        try {
            repOptionTags = this.sysConfigXMLToHTML(String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeSystemRepositoryConfig.xsl");
            wrsOptionTags = this.sysConfigXMLToHTML(String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeSystemWrsConfig.xsl");
        }
        catch (Exception e) {
            System.err.println("Error in init with xslt processing: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    protected String sysConfigXMLToHTML(String xsltFile) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xsltFile));
            StringWriter result = new StringWriter();
            transformer.transform(new StreamSource(fShapeChangeSystemConfiguration), new StreamResult(result));
            return result.toString();
        }
        catch (Exception e) {
            System.err.println("Error in xslt processing of sysConfig: " + e.getMessage());
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.denyAttacks(req);
        boolean selection = false;
        if (req.getParameter("RegSearch") != null) {
            this.doRegSearch(req, res);
        } else if (req.getParameter("EnterURL") != null) {
            this.doEnterURL(req, res);
        } else if (req.getParameter("Convert") != null) {
            this.doConvert(req, res);
        } else if (req.getParameter("Search") != null) {
            this.doSearch(req, res);
        } else if (req.getParameter("Cancel") != null) {
            this.doHome(req, res, selection);
        } else if (req.getParameter("NewSearch") != null) {
            this.doRegSearch(req, res);
        } else if (req.getParameter("MoreInfo") != null) {
            this.doMoreInfo(req, res);
        } else if (req.getParameter("SelectID") != null) {
            this.doSelectID(req, res);
        } else if (req.getParameter("ShowMessages") != null) {
            this.doShowMessages(req, res);
        } else if (req.getParameter("Register") != null) {
            this.doRegister(req, res);
        } else if (req.getParameter("Select") != null) {
            selection = true;
            this.doHome(req, res, selection);
        } else if (req.getParameter("Remove") != null) {
            this.doHome(req, res, selection);
        } else if (req.getParameter("Done") != null) {
            this.doHome(req, res, selection);
        } else {
            this.doHome(req, res, selection);
        }
    }

    private void denyAttacks(HttpServletRequest req) throws ServletException {
        boolean requestIsVeryLarge;
        boolean bl = requestIsVeryLarge = req.getContentLength() > fMAX_REQUEST_SIZE;
        if (requestIsVeryLarge) {
            throw new ServletException("Request is very large. Size is : " + req.getContentLength());
        }
    }

    protected boolean validateUrl(String url) {
        StringCharacterIterator iterator = new StringCharacterIterator(url);
        char character = iterator.current();
        while (character != '\uffff') {
            boolean isValidChar = this.isPrintableAscii(character);
            if (!isValidChar) {
                return false;
            }
            character = iterator.next();
        }
        return true;
    }

    protected boolean isPrintableAscii(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    protected void doPrint_ii_Head(HttpServletRequest req, HttpServletResponse res, String title) throws ServletException, IOException {
        res.setContentType("text/html; charset=ISO-8859-1");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        out.print("<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD>\n");
        out.print("<BODY BGCOLOR='#F0F0F0' BACKGROUND='' TEXT='black'>\n");
        out.print("<table cellpadding='5'>");
        out.print("<tr>");
        out.print("<td width='90%' align='right'>");
        out.print("<FONT color='#0065FF'><b>interactive instruments GmbH</b><br><b>ShapeChange - UML to GML Application Schema Converter Tool</b><br></FONT>");
        out.print("<hr>");
        out.print("</td>");
        out.print("<td width='10%'>");
        out.print("<img src='../images/ii.gif' width='223'>");
        out.print("</td>");
        out.print("</tr>");
        out.print("</table>");
    }

    protected void doHome(HttpServletRequest req, HttpServletResponse res, boolean selection) throws ServletException, IOException {
        String Schema = "";
        if (req.getParameter("Cancel") == null && req.getParameter("allApplicationSchemas") != null && req.getParameter("allApplicationSchemas").equals("false")) {
            Schema = req.getParameter("SingleSchema");
        }
        String title = "ShapeChange - UML to GML Application Schema Converter";
        this.doPrint_ii_Head(req, res, title);
        PrintWriter out = res.getWriter();
        out.print("<h3>Converting an ISO 19100 Application Schema in UML to a GML Application Schema</h3>\n");
        out.print("<noscript><span style='color:#FF0000'>Please enable JavaScript in your browser to make this sites work properly.</span></noscript>\n");
        out.print("<script type='text/javascript'>\n");
        out.print("function CheckInput() {if(document.pressed == 'Convert') { document.pressed = ''; ");
        out.print("if (document.HomeForm.xmiFile == null) { alert('Please enter a source URL'); return false;} ");
        out.print("var checkOK = \"&'ABCDEFGHIJKLMNOPQRSTUVWXYZ@|~\u00b5*+;?!`\u00b4\u00df|<>\u00b0^\u00d6\u00c4\u00dc\u00f6\u00e4\u00fcabcdefghijklmnopqrstuvwxyz0123456789#=()[]\\-_./: \"; var checkStr = document.HomeForm.xmiFile.value; var allValid = true; for (i = 0; i < checkStr.length; i++) { \tch = checkStr.charAt(i); \tfor (j = 0; j < checkOK.length; j++) \t\tif (ch == checkOK.charAt(j) ) \t        break; \tif (j == checkOK.length){ \t\tallValid = false; break; } } if (!allValid) { \talert('Please provide a valid URL address including the filename. Example: \\nhttp://www.interactive-instruments.de/ows3/repository/xmi/test.xml'); \tdocument.HomeForm.xmiFile.focus(); \treturn false; } else return true; } } </script>\n");
        out.print("<FORM METHOD='POST' name='HomeForm' action='../servlet/ConverterServlet' onSubmit='return CheckInput();'>\n");
        out.print("<table cellspacing='10'>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>UML Application Schema:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        if (selection) {
            if (req.getParameter("xmiFile") != null) {
                String url = req.getParameter("xmiFile");
                if (this.validateUrl(url)) {
                    out.print("<td>Source:&nbsp;<INPUT TYPE='text' SIZE=" + url.length() + " NAME='xmiFile' value='" + url + "'></td>");
                } else {
                    out.print("<td>Source:&nbsp;<i>no valid source available</i></td>");
                }
            } else {
                out.print("<td>Source:&nbsp;<INPUT TYPE='text' SIZE=90 NAME='xmiFile' value=''></td>");
            }
            out.print("</tr>");
            out.print("<tr>");
            out.print("<td>&nbsp;</td>");
            if (req.getParameter("title") != null) {
                out.print("<td>");
                out.print("<b>Basic info:&nbsp;&nbsp;</b>");
                out.print("<table cellpadding='3'>");
                out.print("<tr><td>&nbsp;</td><td><u>title</u>:&nbsp;" + req.getParameter("title") + "&nbsp;&nbsp;</td></tr>");
                out.print("<tr><td>&nbsp;</td><td><u>alternative</u>:&nbsp;" + req.getParameter("alternative") + "&nbsp;&nbsp;</td></tr>");
                out.print("<tr><td>&nbsp;</td><td><u>description</u>:&nbsp;" + req.getParameter("description") + "</td></tr>");
                out.print("<tr><td>&nbsp;</td><td><INPUT TYPE='submit' VALUE='Remove schema' NAME='Remove' onClick='document.pressed=this.name'></td></tr>");
                out.print("</table>");
                out.print("</td>");
            } else {
                out.print("<td><INPUT TYPE='submit' VALUE='Remove schema' NAME='Remove' onClick='document.pressed=this.name'></td>");
            }
            out.print("</tr>");
            out.print("<tr>");
            out.print("<td>&nbsp;</td>");
            out.print("<td><b>Name of the Application Schema UML package:</b></td>");
            out.print("</tr>");
            out.print("<tr>");
            out.print("<td>&nbsp;</td>");
            out.print("<td><INPUT TYPE='text' SIZE=40 NAME='appSchemaName' value='" + Schema + "'></td>");
        } else {
            out.print("<td><INPUT TYPE='submit' VALUE='Search in Schema Registry' NAME='RegSearch' onClick='document.pressed=this.name'>&nbsp;&nbsp;");
            out.print("<INPUT TYPE='submit' VALUE='Enter URL' NAME='EnterURL' onClick='document.pressed=this.name'></td>");
        }
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>Convert either all elements or only those with visibility 'public':</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td>");
        out.print("<INPUT TYPE='radio' NAME='publicOnly' VALUE='true' checked='checked'>public only&nbsp;");
        out.print("<INPUT TYPE='radio' NAME='publicOnly' VALUE='false'>all elements</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>Include documentation in the UML model also in the XML Schema files:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td>");
        out.print("<INPUT TYPE='radio' NAME='includeDocumentation' VALUE='true' checked='checked'>yes&nbsp;");
        out.print("<INPUT TYPE='radio' NAME='includeDocumentation' VALUE='false'>no</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>Schema metadata enconding:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><SELECT NAME='metadataStyle'>");
        out.print("<OPTION value='NONE' selected='selected'>No schema metadata</OPTION>");
        out.print("<OPTION value='OWS3'>OWS-3 schema metadata (DDMS)</OPTION>");
        out.print("</SELECT></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>Select the target version of GML:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td>GML <SELECT NAME='gmlVersion'>");
        out.print("<OPTION>2.1</OPTION>");
        out.print("<OPTION selected='selected'>3.1</OPTION>");
        out.print("<OPTION>3.2.0</OPTION>");
        out.print("</SELECT></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><b>GML Application Schema Repository:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><select name='GML_Rep' size='1'>" + repOptionTags + "</select></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td><INPUT TYPE='submit' VALUE='Convert UML application schema to GML' NAME='Convert'  onClick='document.pressed=this.name'></td>");
        out.print("</tr>");
        out.print("</table>");
        out.print("<br>");
        out.print("<hr>");
        out.print("<p>If you have any feedback or problems please <a href='mailto:ShapeChange@interactive-instruments.de'>send an email to us</a>. Thank you.</p>");
        out.print("</FORM>");
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    protected void doRegSearch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html; charset=ISO-8859-1");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        out.print("<HTML><HEAD><TITLE>Registry Search for UML Application Schemas</TITLE>\n");
        out.print("<script type='text/javascript'>function popUpHelp(wintype, name){");
        out.print("popUp=window.open(wintype, 'servlet_popup', 'toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes,width=690,height=690'); ");
        out.print("popUp.window.focus(); } </script>\n");
        out.print("</HEAD>\n");
        out.print("<BODY BGCOLOR='#F0F0F0' BACKGROUND='' TEXT='black'>\n");
        out.print("<table cellpadding='5'>");
        out.print("<tr>");
        out.print("<td width='90%' align='right'>");
        out.print("<FONT color='#0065FF'><b>interactive instruments GmbH</b><br><b>ShapeChange - UML to GML Application Schema Converter Tool</b><br></FONT>");
        out.print("<hr>");
        out.print("</td>");
        out.print("<td width='10%'>");
        out.print("<img src='../images/ii.gif' width='223'>");
        out.print("</td>");
        out.print("</tr>");
        out.print("</table>");
        out.print("<h4>Search in Schema Registry</h4><br>\n");
        out.print("<script type='text/javascript'>\n");
        out.print("function CheckInput() {if(document.pressed == 'Search') { document.pressed = ''; ");
        out.print("for (i = 0; i < document.forms[0].elements.length; ++i) ");
        out.print("if (document.forms[0].elements[i].value == '') { alert('Please enter your keyword(s) first'); ");
        out.print("document.forms[0].elements[i].focus(); return false; } ");
        out.print("var checkOK = \"&'ABCDEFGHIJKLMNOPQRSTUVWXYZ@|~\u00b5*+;?!`\u00b4\u00df|<>\u00b0^\u00d6\u00c4\u00dc\u00f6\u00e4\u00fcabcdefghijklmnopqrstuvwxyz0123456789#=()[]\\-_.,/:% \"; var checkStr = document.RegSearchForm.keywords.value; var allValid = true; for (i = 0; i < checkStr.length; i++){ \tch = checkStr.charAt(i); \tfor (j = 0; j < checkOK.length; j++) \t\tif (ch == checkOK.charAt(j)) \t        break; \tif (j == checkOK.length){ \t\tallValid = false;break; } } if (!allValid){ \talert('Please use only valid characters. See the help for more information.'); \tdocument.RegSearchForm.keywords.focus(); \treturn false; } else return true;} } </script>\n");
        out.print("<FORM METHOD='POST' name='RegSearchForm' onSubmit='return CheckInput();'>\n");
        out.print("<table cellspacing='10'>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>Application Schema Registry:&nbsp;</b></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><select name='SApplReg' size='1'>" + wrsOptionTags + "</select><br>\n</td>");
        out.print("<td>&nbsp;</td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>Application Schema Type:&nbsp;</b></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><select name='type' size='1'><option value='All types'>All types&nbsp;</option><option value='UML (XMI 1.0)'>UML (XMI 1.0)&nbsp;</option><option value='UML (ISO 19109)' selected>UML (ISO 19109)&nbsp;</option><option value='UML (ISO 19136 Annex E)'>UML (ISO 19136 Annex E)&nbsp;</option><option value='GML'>GML&nbsp;</option><option value='GML 2.1'>GML 2.1&nbsp;</option><option value='GML 3.1'>GML 3.1&nbsp;</option><option value='GML 3.2'>GML 3.2&nbsp;</option><option value='GML Simple Feature Profile'>GML Simple Feature Profile&nbsp;</option></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>search in property ( <a href=\"javascript:popUpHelp('../HTML/help_properties.htm')\">help</a> ):</b></td>");
        out.print("<td><b>keywords for the search ( <a href=\"javascript:popUpHelp('../HTML/help_search.htm')\">help</a> ): </b></td>");
        out.print("<td><b>max. results:</b></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><select name='group' size='1'><option value='title' selected>title, description, alternative&nbsp;</option><option value='creator'>created, creator, publisher&nbsp;</option><option value='other'>format, identifier, type, ...&nbsp;</option><option value='all'>all&nbsp;</option></select></td>");
        out.print("<td><INPUT TYPE='text' SIZE=40 NAME='keywords'></td>");
        out.print("<td><select name='maxRecords' size='1'><option value='20' selected>20&nbsp;</option><option value='100'>100&nbsp;</option><option value='1000'>1000&nbsp;</option><option value='0'>unlimited&nbsp;</option></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><INPUT TYPE='submit' VALUE='Search' NAME='Search' onClick='document.pressed=this.name'>&nbsp;<INPUT TYPE='submit' VALUE='Cancel' NAME='Cancel'></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("</table>");
        out.print("</FORM>");
        out.print("</BODY></HTML>");
        out.close();
    }

    protected void doEnterURL(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String title = "Enter URL for UML Application Schema";
        this.doPrint_ii_Head(req, res, title);
        PrintWriter out = res.getWriter();
        out.print("<script type='text/javascript'>\n");
        out.print("function CheckInput() {if(document.pressed == 'Select') { document.pressed = ''; ");
        out.print("if (document.EnterUrlForm.xmiFile.value == '') { alert('Please enter the source URL'); return false;} ");
        out.print("var checkOK = \"&'ABCDEFGHIJKLMNOPQRSTUVWXYZ@|~\u00b5*+;?!`\u00b4\u00df|<>\u00b0^\u00d6\u00c4\u00dc\u00f6\u00e4\u00fcabcdefghijklmnopqrstuvwxyz0123456789#=()[]\\-_./: \"; var checkStr = document.EnterUrlForm.xmiFile.value; var urlValid = true; var schemaValid = true; for (i = 0; i < checkStr.length; i++) { \tch = checkStr.charAt(i); \tfor (j = 0; j < checkOK.length; j++) \t\tif (ch == checkOK.charAt(j) ) \t        break; \tif (j == checkOK.length){ \t\turlValid = false; break; } } if (document.EnterUrlForm.SingleSchema.value != '') { \tcheckStr = document.EnterUrlForm.SingleSchema.value; \tfor (i = 0; i < checkStr.length; i++)  \t{ \t \t\tch = checkStr.charAt(i); \t\tfor (j = 0; j < checkOK.length; j++) \t\t\tif (ch == checkOK.charAt(j) ) \t\t\t\tbreak; \t\tif (j == checkOK.length) \t\t{ \t\t \t\t\tschemaValid = false; \t\t\tbreak;  \t\t} \t} } if (!urlValid && !schemaValid) { \talert('Please provide a valid URL address including the filename. Example: \\nhttp://www.interactive-instruments.de/ows3/repository/xmi/test.xml \\nThe schema name contains invalid characters.'); \tdocument.EnterUrlForm.xmiFile.focus(); \treturn false; }if (!urlValid) { \talert('Please provide a valid URL address including the filename. Example: \\nhttp://www.interactive-instruments.de/ows3/repository/xmi/test.xml'); \tdocument.EnterUrlForm.xmiFile.focus(); \treturn false; }if (!schemaValid) { \talert('The schema name contains invalid characters.'); \tdocument.EnterUrlForm.SingleSchema.focus(); \treturn false; }return true; } } ");
        out.print("</script>\n");
        out.print("<FORM name='EnterUrlForm' METHOD='POST' onSubmit='return CheckInput();'>\n");
        out.print("<table cellspacing='10'>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>URL of the UML model containing the application schema:</b></td>");
        out.print("<td></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><INPUT TYPE='text' SIZE=100 NAME='xmiFile' value='http://www.interactive-instruments.de/ows3/repository/xmi/test.xml'></td>");
        out.print("<td></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><input type='radio' name='allApplicationSchemas' value='true' checked='checked'> all application schemas in the UML model</td>");
        out.print("<td></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><input type='radio' name='allApplicationSchemas' value='false'> only the application schema:&nbsp;\n");
        out.print("<INPUT TYPE='text' onFocus='document.EnterUrlForm.allApplicationSchemas[1].checked = true' SIZE=20 NAME='SingleSchema' value=''></td>");
        out.print("<td></td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><INPUT TYPE='submit' VALUE='Select' NAME='Select' onClick='document.pressed=this.name'>&nbsp;<INPUT TYPE='submit' VALUE='Cancel' NAME='Cancel' onClick='document.pressed=this.name'></td>");
        out.print("<td></td>");
        out.print("</tr>");
        out.print("</table>");
        out.print("</FORM>");
        out.print("</BODY></HTML>");
        out.close();
    }

    protected void doSearch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String title = "Registry search result for UML Application Schemas";
        this.doPrint_ii_Head(req, res, title);
        PrintWriter out = res.getWriter();
        String group = req.getParameter("group");
        String keywords = req.getParameter("keywords");
        String type = req.getParameter("type");
        String typeFilter = "";
        if (type.equals("UML (XMI 1.0)")) {
            typeFilter = "<ogc:Or><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0\"</ogc:Literal></ogc:PropertyIsEqualTo><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0/iso19109\"</ogc:Literal></ogc:PropertyIsEqualTo><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0/iso19136\"</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Or>";
        } else if (type.equals("UML (ISO 19109)")) {
            typeFilter = "<ogc:Or><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0/iso19109\"</ogc:Literal></ogc:PropertyIsEqualTo><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0/iso19136\"</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Or>";
        } else if (type.equals("UML (ISO 19136 Annex E)")) {
            typeFilter = "<ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"xmi/1.0/iso19136\"</ogc:Literal></ogc:PropertyIsEqualTo>";
        } else if (type.equals("GML")) {
            typeFilter = "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"gmlas/%</ogc:Literal></ogc:PropertyIsLike>";
        } else if (type.equals("GML 2.1")) {
            typeFilter = "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"gmlas/2.1%</ogc:Literal></ogc:PropertyIsLike>";
        } else if (type.equals("GML 3.1")) {
            typeFilter = "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"gmlas/3.1%</ogc:Literal></ogc:PropertyIsLike>";
        } else if (type.equals("GML 3.2")) {
            typeFilter = "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"gmlas/3.2%</ogc:Literal></ogc:PropertyIsLike>";
        } else if (type.equals("GML Simple Feature Profile")) {
            typeFilter = "<ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>text/xml; subtype=\"gmlas/3.1.1/sfgml\"</ogc:Literal></ogc:PropertyIsEqualTo>";
        }
        String maxRecords = req.getParameter("maxRecords");
        maxRecords = maxRecords.equals("20") ? "maxRecords='20'" : (maxRecords.equals("100") ? "maxRecords='100'" : (maxRecords.equals("1000") ? "maxRecords='1000'" : ""));
        String tempSearchURL = req.getParameter("SApplReg");
        String searchURL = this.setConfigParam(fShapeChangeSystemConfiguration, tempSearchURL, "urlPost");
        HttpSession session = req.getSession();
        session.setAttribute("search.URL", (Object)searchURL);
        String[] keywordlist = this.tokenizeString(keywords);
        String searchReq = "";
        String searchReqBeginnig = "<GetRecords xmlns=\"http://www.opengis.net/csw\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:dc=\"http://www.purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation= \"http://www.opengis.net/csw http://schemas.opengis.net/csw/2.0.0/CSW-discovery.xsd http://www.opengis.net/ogc http://schemas.opengis.net/filter/1.0.0/filter.xsd http://www.purl.org/dc/elements/1.1/ http://schemas.opengis.net/csw/2.0.0/rec-dcmes.xsd\" version=\"2.0.0\" service=\"CSW\" outputFormat=\"text/xml\" outputSchema=\"http://schemas.opengis.net/csw/2.0.0/record.xsd\" " + maxRecords + "><Query typeNames=\"csw:Record\"><ElementSetName>full</ElementSetName><Constraint><ogc:Filter>";
        String filter = "";
        String searchReqEnd = "</ogc:Filter></Constraint></Query></GetRecords>";
        int j = 0;
        while (j < keywordlist.length) {
            filter = group.equals("title") ? String.valueOf(filter) + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:alternative</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:description</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:title</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" : (group.equals("creator") ? String.valueOf(filter) + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dct:created</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:creator</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:publisher</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" : (group.equals("other") ? String.valueOf(filter) + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:identifier</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:language</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:relation</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:rights</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:type</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" : String.valueOf(filter) + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:alternative</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dct:created</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:creator</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:description</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:format</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:identifier</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:language</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:publisher</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:relation</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:rights</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:title</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>" + "<ogc:PropertyIsLike wildCard=\"%\" singleChar=\"_\" escape=\"\\\" matchCase=\"false\"><ogc:PropertyName>/csw:Record/dc:type</ogc:PropertyName><ogc:Literal>%" + keywordlist[j] + "%</ogc:Literal></ogc:PropertyIsLike>"));
            ++j;
        }
        filter = "<ogc:Or>" + filter + "</ogc:Or>";
        searchReq = type.equals("All types") ? String.valueOf(searchReqBeginnig) + filter + searchReqEnd : String.valueOf(searchReqBeginnig) + "<ogc:And>" + typeFilter + filter + "</ogc:And>" + searchReqEnd;
        try {
            String searchResponse = this.postRequest(searchReq, searchURL, false);
            StringReader sResp = new StringReader(searchResponse);
            out.print(this.transfXMLToHTML(sResp, String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeSearch.xsl"));
        }
        catch (Exception e) {
            System.err.println("Error in reg search (or xslt processing)" + e.getMessage());
            e.printStackTrace(System.err);
        }
        out.print("\n<FORM METHOD='POST'>");
        out.print("<INPUT TYPE='submit' VALUE='New Search' NAME='NewSearch'>&nbsp;");
        out.print("<INPUT TYPE='submit' VALUE='Cancel' NAME='Cancel'>");
        out.print("</FORM>");
        out.print("</BODY></HTML>");
        out.close();
    }

    protected void doSelectID(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block6: {
            String title = "Show parent Schema";
            this.doPrint_ii_Head(req, res, title);
            out = res.getWriter();
            String id = req.getParameter("SchemaID");
            out.print("<h4>ID: " + id + "</h4>\n");
            String searchURL = "";
            try {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    searchURL = session.getAttribute("search.URL").toString();
                    String searchReq = "<GetRecords xmlns=\"http://www.opengis.net/csw\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:dc=\"http://www.purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation= \"http://www.opengis.net/csw http://schemas.opengis.net/csw/2.0.0/CSW-discovery.xsd http://www.opengis.net/ogc http://schemas.opengis.net/filter/1.0.0/filter.xsd http://www.purl.org/dc/elements/1.1/ http://schemas.opengis.net/csw/2.0.0/rec-dcmes.xsd\" version=\"2.0.0\" service=\"CSW\" outputFormat=\"text/xml\" outputSchema=\"http://schemas.opengis.net/csw/2.0.0/record.xsd\"><Query typeNames=\"csw:Record\"><Constraint><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:identifier</ogc:PropertyName><ogc:Literal>" + id + "</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></Constraint></Query></GetRecords>";
                    try {
                        String searchResponse = this.postRequest(searchReq, searchURL, false);
                        StringReader sResp = new StringReader(searchResponse);
                        out.print("<FORM METHOD='POST'>");
                        out.print(this.transfXMLToHTML(sResp, String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeIDSearch.xsl"));
                    }
                    catch (Exception e) {
                        System.err.println("Error processing doSelectID: " + e.getMessage());
                        e.printStackTrace(System.err);
                    }
                    out.print("<br>");
                    out.print("<INPUT TYPE='submit' VALUE='Select Schema' NAME='Select'>&nbsp;\n");
                    out.print("<INPUT TYPE='button' VALUE='Back to Results' NAME='GoBack' onClick='window.history.back()'>&nbsp;\n");
                    out.print("<INPUT TYPE='submit' VALUE='New Search' NAME='NewSearch'>&nbsp;\n");
                    out.print("<INPUT TYPE='submit' VALUE='Cancel' NAME='Cancel'>\n");
                    out.print("</FORM>");
                    break block6;
                }
                out.print("<i>session timeout</i>");
            }
            catch (IllegalStateException e) {
                System.err.println("session expired: " + e.getMessage());
                e.printStackTrace(System.err);
            }
            catch (Exception e) {
                System.err.println("error: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        out.print("</BODY></HTML>");
        out.close();
    }

    protected void doMoreInfo(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String title = "More information";
        this.doPrint_ii_Head(req, res, title);
        PrintWriter out = res.getWriter();
        String id = req.getParameter("MoreInfo");
        out.print("<h4>More information about registry entry with ID: " + id + "</h4>\n");
        String searchURL = "";
        try {
            HttpSession session = req.getSession(false);
            if (session != null) {
                searchURL = session.getAttribute("search.URL").toString();
                String searchReq = "<GetRecords xmlns=\"http://www.opengis.net/csw\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:dc=\"http://www.purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation= \"http://www.opengis.net/csw http://schemas.opengis.net/csw/2.0.0/CSW-discovery.xsd http://www.opengis.net/ogc http://schemas.opengis.net/filter/1.0.0/filter.xsd http://www.purl.org/dc/elements/1.1/ http://schemas.opengis.net/csw/2.0.0/rec-dcmes.xsd\" version=\"2.0.0\" service=\"CSW\" outputFormat=\"text/xml\" outputSchema=\"http://schemas.opengis.net/csw/2.0.0/record.xsd\"><Query typeNames=\"csw:Record\"><Constraint><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>/csw:Record/dc:identifier</ogc:PropertyName><ogc:Literal>" + id + "</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></Constraint></Query></GetRecords>";
                try {
                    String searchResponse = this.postRequest(searchReq, searchURL, false);
                    StringReader sResp = new StringReader(searchResponse);
                    out.print(this.transfXMLToHTML(sResp, String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeIDSearch.xsl"));
                }
                catch (Exception e) {
                    System.err.println("Error processing more information: " + e.getMessage());
                    e.printStackTrace(System.err);
                }
            } else {
                out.print("<i>session timeout</i>");
            }
        }
        catch (IllegalStateException e) {
            System.err.println("session expired: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("error: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        out.print("</BODY></HTML>");
        out.close();
    }

    protected String transfXMLToHTML(StringReader inputXML, String xsltFile) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xsltFile));
            StringWriter result = new StringWriter();
            transformer.transform(new StreamSource(inputXML), new StreamResult(result));
            return result.toString();
        }
        catch (Exception e) {
            System.err.println("Error in xslt processing: " + e.getMessage());
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void doConvert(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, FileNotFoundException {
        String repHttpUrl;
        String sTime;
        HttpSession session;
        String noXsdResultFile;
        block18: {
            Options options = new Options();
            options.appSchemaName = req.getParameter("appSchemaName");
            options.publicOnly = req.getParameter("publicOnly").equals("true");
            options.includeDocumentation = req.getParameter("includeDocumentation").equals("true");
            options.gmlVersion = req.getParameter("gmlVersion");
            options.metadataStyle = req.getParameter("metadataStyle");
            ShapeChangeResult result = new ShapeChangeResult(options);
            Converter converter = new Converter(options, result);
            String sessTime = new Long(System.currentTimeMillis()).toString();
            noXsdResultFile = "true";
            session = req.getSession();
            session.setAttribute("conv.time", (Object)sessTime);
            session.setAttribute("conv.resultfile", (Object)noXsdResultFile);
            sTime = session.getAttribute("conv.time").toString();
            String id = req.getParameter("GML_Rep");
            repHttpUrl = this.setConfigParam(fShapeChangeSystemConfiguration, id, "urlHttp");
            File file = new File(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep);
            file.mkdir();
            options.dirName = String.valueOf(ABS_PATH) + "out" + sep + sTime;
            options.dirURI = String.valueOf(repHttpUrl) + sTime;
            options.configFile = fConfigFile;
            options.reportLevel = fReportLevel;
            try {
                try {
                    options.loadConfiguration();
                    options.loadConfiguration();
                    converter.convert(new Xmi10Document(result, options, req.getParameter("xmiFile")));
                }
                catch (Exception e) {
                    converter.result.addError(e.getMessage());
                    System.err.println("Error in conversion process: " + e.getMessage());
                    e.printStackTrace(System.err);
                    converter.result.toFile(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml");
                    break block18;
                }
            }
            catch (Throwable throwable) {
                converter.result.toFile(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml");
                throw throwable;
            }
            converter.result.toFile(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml");
        }
        String[] xsdFile2 = new String[1];
        try {
            NodeList xsdFileList2 = this.getElementsFromResult(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml", "XSDFile");
            if (xsdFileList2.getLength() != 0) {
                xsdFile2 = new String[xsdFileList2.getLength()];
                noXsdResultFile = "false";
                session.setAttribute("conv.resultfile", (Object)noXsdResultFile);
                int i = 0;
                while (i < xsdFileList2.getLength()) {
                    Element e2 = (Element)xsdFileList2.item(i);
                    Node n2 = e2.getFirstChild();
                    xsdFile2[i] = n2.getNodeValue();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println("failed getting XSD-filenames from ShapeChangeResult.xml: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        noXsdResultFile = session.getAttribute("conv.resultfile").toString();
        this.transferToRepository(req, res);
        res.setContentType("text/html; charset=ISO-8859-1");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        out.print("<HTML><HEAD><TITLE>Conversion finished</TITLE></HEAD>\n");
        out.print("<BODY onLoad=\"window.open('" + repHttpUrl + sTime + "/ShapeChangeResult.xml');\" BGCOLOR='#F0F0F0' BACKGROUND='' TEXT='black'>\n");
        out.print("<table cellpadding='5'>");
        out.print("<tr>");
        out.print("<td width='90%' align='right'>");
        out.print("<FONT color='#0065FF'><b>interactive instruments GmbH</b><br><b>ShapeChange - UML to GML Application Schema Converter Tool</b><br></FONT>");
        out.print("<hr>");
        out.print("</td>");
        out.print("<td width='10%'>");
        out.print("<img src='../images/ii.gif' width='223'>");
        out.print("</td>");
        out.print("</tr>");
        out.print("</table>");
        out.print("<FORM METHOD='POST'>");
        out.print("<table cellspacing='10'>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        if (noXsdResultFile.equals("true")) {
            out.print("<td valign='top'><b>The schema conversion failed.</b></td>");
        } else {
            out.print("<td valign='top'><b>The schema conversion was successful.</b></td>");
        }
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><INPUT TYPE='button' VALUE='Show messages' NAME='ShowMessages' onClick=\"window.open('../servlet/ConverterServlet?ShowMessages=" + repHttpUrl + "', 'ShowMessages', 'toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes,width=680,height=680');\"></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>The following XML Schema documents were created and stored in the repository:</b></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td>");
        out.print("<table cellpadding='1'>");
        if (noXsdResultFile.equals("true")) {
            out.print("</tr><tr>");
            out.print("<td valign='top'><i>No files stored in the repository.</i></td>");
        } else if (xsdFile2.length != 0) {
            int j = 0;
            while (j < xsdFile2.length) {
                if (j % 5 == 0) {
                    out.print("</tr>");
                    out.print("<tr>");
                }
                out.print("<td><a href='" + repHttpUrl + sTime + "/" + xsdFile2[j] + "' target='_blank'>" + xsdFile2[j] + "</a>&nbsp;&nbsp;</td>");
                ++j;
            }
        }
        out.print("</tr>");
        out.print("</table>");
        out.print("</td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("</FORM>\n");
        out.print("<FORM METHOD='POST' action='?Register' name='reg' target='RegistryResult'>\n");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><b>Register in Application Schema Registry:&nbsp;</b></td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        if (req.getParameter("metadataStyle").equals("NONE") || noXsdResultFile.equals("true")) {
            out.print("<td valign='top'><select disabled name='ApplReg' size='1'>" + wrsOptionTags + "</select>&nbsp;\n" + "    <INPUT disabled TYPE='button' VALUE='Register' NAME='Register'></td>\n");
        } else {
            out.print("<td valign='top'><select name='ApplReg' size='1'>" + wrsOptionTags + "</select>&nbsp;\n" + "    <INPUT TYPE='button' VALUE='Register' NAME='Register'\n" + "    onClick=\"window.open('about:blank', 'RegistryResult', 'toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes,width=720,height=720');document.reg.submit()\"></td>");
        }
        out.print("<td>&nbsp;</td>");
        out.print("</tr>");
        String temp = req.getParameter("GML_Rep");
        out.print("<INPUT TYPE='hidden' VALUE='" + temp + "' NAME='GML_Rep'>");
        out.print("</FORM>\n");
        out.print("<FORM METHOD='POST'>");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'>&nbsp;</td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>\n");
        out.print("<tr>");
        out.print("<td>&nbsp;</td>");
        out.print("<td valign='top'><INPUT TYPE='submit' VALUE='Done' NAME='Done'>\n</td>");
        out.print("<td>&nbsp;</td>");
        out.print("</tr>\n");
        out.print("</FORM>");
        out.print("</BODY></HTML>");
        out.close();
    }

    protected void doRegister(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block7: {
            res.setContentType("text/html; charset=ISO-8859-1");
            res.setHeader("pragma", "no-cache");
            out = res.getWriter();
            String temp = req.getParameter("ApplReg");
            String regURL = this.setConfigParam(fShapeChangeSystemConfiguration, temp, "urlPost");
            String id = req.getParameter("GML_Rep");
            String repHttpUrl = this.setConfigParam(fShapeChangeSystemConfiguration, id, "urlHttp");
            out.print("<HTML><HEAD><TITLE>result messages</TITLE></HEAD>\n");
            out.print("<BODY BGCOLOR='#F0F0F0' BACKGROUND='' TEXT='black'>\n");
            out.print("<h3>registration result</h3><br><br>\n");
            String sTime = "";
            HttpSession session = req.getSession(false);
            if (session != null) {
                sTime = session.getAttribute("conv.time").toString();
                try {
                    NodeList xsdFileList3 = this.getElementsFromResult(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml", "XSDFile");
                    if (xsdFileList3.getLength() == 0) break block7;
                    int j = 0;
                    int i = 0;
                    while (i < xsdFileList3.getLength()) {
                        Element e3 = (Element)xsdFileList3.item(i);
                        if (e3.getAttribute("appSchema").equals("true")) {
                            Node n3 = e3.getFirstChild();
                            String xsdFile3 = n3.getNodeValue();
                            String harvestReq = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><Harvest xmlns=\"http://www.opengis.net/csw\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/csw http://schemas.cubewerx.com/schemas/csw/2.0.0/CSW-discovery.xsd\" version=\"2.0.0\" service=\"CSW\" outputFormat=\"text/xml\"><Source>" + repHttpUrl + sTime + "/" + xsdFile3 + "</Source></Harvest>";
                            String registerResponse = this.postRequest(harvestReq, regURL, false);
                            StringReader rResp = new StringReader(registerResponse);
                            int k = this.countRegistrations(registerResponse);
                            j += k;
                            out.print(this.transfXMLToHTML(rResp, String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeRegister.xsl"));
                        }
                        ++i;
                    }
                    out.print("\n<br>");
                    if (j == 1) {
                        out.print("<b>1 conversion result registered.</b>");
                        break block7;
                    }
                    out.print("<b>" + j + " conversion results registered.</b>");
                }
                catch (Exception e) {
                    System.err.println("Error getting filenames for registration or in getting response from postRequest(): " + e.getMessage());
                    e.printStackTrace(System.err);
                }
            } else {
                out.print("<i>session timeout</i>");
            }
        }
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    protected void doShowMessages(HttpServletRequest req, HttpServletResponse res) throws FileNotFoundException, NullPointerException, IOException {
        res.setContentType("text/html; charset=ISO-8859-1");
        res.setHeader("pragma", "no-cache");
        PrintWriter out = res.getWriter();
        String repHttpUrl = req.getParameter("ShowMessages");
        out.print("<HTML><HEAD><TITLE>result messages</TITLE></HEAD>\n");
        out.print("<BODY BGCOLOR='#F0F0F0' BACKGROUND='' TEXT='black'>\n");
        out.print("<b>The following messages were created during the ShapeChange conversion:</b><br><br>\n");
        String sTime = "";
        HttpSession session = req.getSession(false);
        if (session != null) {
            sTime = session.getAttribute("conv.time").toString();
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(new StreamSource(String.valueOf(ABS_PATH) + "XSLT" + sep + "ShapeChangeShowMessages.xsl"));
                StringWriter result = new StringWriter();
                transformer.transform(new StreamSource(String.valueOf(repHttpUrl) + sTime + sep + "ShapeChangeResult.xml"), new StreamResult(result));
                out.print(result.toString());
            }
            catch (Exception e) {
                System.err.println("Error while generating messages for html output: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        } else {
            out.print("<i>session timeout</i>");
        }
        out.print("</BODY>");
        out.print("</HTML>");
        out.close();
    }

    protected String postRequest(String sRequest, String sURL, boolean secureService) throws Exception {
        String responseXML = null;
        try {
            String temp;
            if (secureService) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
            }
            URL url = new URL(sURL);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            byte[] requestXML = sRequest.getBytes();
            httpConn.setRequestProperty("Content-Length", String.valueOf(requestXML.length));
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestMethod("POST");
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            OutputStream out = httpConn.getOutputStream();
            out.write(requestXML);
            out.close();
            InputStreamReader isr = new InputStreamReader(httpConn.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String tempResponse = "";
            while ((temp = br.readLine()) != null) {
                tempResponse = String.valueOf(tempResponse) + temp;
            }
            responseXML = tempResponse;
            br.close();
            isr.close();
        }
        catch (MalformedURLException e) {
            System.err.println("Error in postRequest(): Secure Service Required " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("Error in postRequest(): " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return responseXML;
    }

    protected void transferToRepository(HttpServletRequest req, HttpServletResponse res) throws IOException, FileNotFoundException {
        block16: {
            String id = req.getParameter("GML_Rep");
            String repUrl = this.setConfigParam(fShapeChangeSystemConfiguration, id, "urlFtp");
            String repUsername = this.setConfigParam(fShapeChangeSystemConfiguration, id, "userName");
            String repPassword = this.setConfigParam(fShapeChangeSystemConfiguration, id, "password");
            String sTime = "";
            HttpSession session = req.getSession(false);
            if (session == null) {
                throw new IllegalStateException("session expired during conversion");
            }
            sTime = session.getAttribute("conv.time").toString();
            FTPClient ftp = new FTPClient();
            try {
                try {
                    ftp.connect(repUrl);
                    ftp.login(repUsername, repPassword);
                    int reply = ftp.getReplyCode();
                    if (!FTPReply.isPositiveCompletion((int)reply)) {
                        ftp.disconnect();
                    }
                    ftp.changeWorkingDirectory("out");
                    ftp.makeDirectory(sTime);
                    ftp.sendSiteCommand("CHMOD 755 " + sTime);
                    ftp.changeWorkingDirectory(sTime);
                    FileInputStream fileinputstream_xml = new FileInputStream(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml");
                    ftp.storeFile("ShapeChangeResult.xml", (InputStream)fileinputstream_xml);
                    ftp.sendSiteCommand("CHMOD 644 ShapeChangeResult.xml");
                    NodeList xsdFileList = this.getElementsFromResult(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + "ShapeChangeResult.xml", "XSDFile");
                    if (xsdFileList.getLength() != 0) {
                        int i = 0;
                        while (i < xsdFileList.getLength()) {
                            Element e = (Element)xsdFileList.item(i);
                            Node n1 = e.getFirstChild();
                            String xsdFile = n1.getNodeValue();
                            FileInputStream fileinputstream_xsd = new FileInputStream(String.valueOf(ABS_PATH) + "out" + sep + sTime + sep + xsdFile);
                            ftp.storeFile(xsdFile, (InputStream)fileinputstream_xsd);
                            ftp.sendSiteCommand("CHMOD 644 " + xsdFile);
                            ++i;
                        }
                    }
                    ftp.logout();
                }
                catch (Exception e) {
                    System.err.println("Error in ftp transfer to repository: " + e.getMessage());
                    e.printStackTrace(System.err);
                    if (!ftp.isConnected()) break block16;
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException e2) {
                        System.err.println("FTP disconnect failed: " + e2.getMessage());
                        e2.printStackTrace(System.err);
                    }
                }
            }
            finally {
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException e) {
                        System.err.println("FTP disconnect failed: " + e.getMessage());
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    protected int countRegistrations(String regResp) {
        DocumentBuilder builder = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ShapeChangeErrorHandler());
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ParserConfigurationException e) {
            System.err.println("XML Parser was unable to be configured: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        try {
            Document document = builder.parse(new InputSource(new StringReader(regResp)));
            NodeList nl = document.getElementsByTagName("csw:totalInserted");
            Element e = (Element)nl.item(0);
            Node n = e.getFirstChild();
            String registrations = n.getNodeValue();
            int numberOfRegistrations = Integer.parseInt(registrations);
            return numberOfRegistrations;
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("SAXExc: " + e.getMessage());
                e.printStackTrace(System.err);
            } else {
                System.err.println("SAXExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("IOExc: " + e);
                e.printStackTrace(System.err);
            } else {
                System.err.println("IOExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Exc: " + e);
            e.printStackTrace(System.err);
        }
        return 0;
    }

    protected NodeList getElementsFromResult(String shapeChangeResultFile, String elementsName) throws FileNotFoundException {
        DocumentBuilder builder = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ShapeChangeErrorHandler());
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ParserConfigurationException e) {
            System.err.println("XML Parser was unable to be configured: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        try {
            Document document = builder.parse(shapeChangeResultFile);
            NodeList nl = document.getElementsByTagName(elementsName);
            return nl;
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("SAXExc: " + e.getMessage());
                e.printStackTrace(System.err);
            } else {
                System.err.println("SAXExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("IOExc: " + e);
                e.printStackTrace(System.err);
            } else {
                System.err.println("IOExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Exc: " + e);
            e.printStackTrace(System.err);
        }
        return null;
    }

    protected String setConfigParam(String shapeChangeSystemConfigFile, String id, String param) throws FileNotFoundException {
        String idTag = id.substring(0, 3);
        String idNumber = id.substring(3);
        int selectedRepository = Integer.parseInt(idNumber);
        DocumentBuilder builder = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ShapeChangeErrorHandler());
        }
        catch (FactoryConfigurationError e) {
            System.err.println("FactoryConfigurationError: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ParserConfigurationException e) {
            System.err.println("XML Parser was unable to be configured: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        try {
            Document document = builder.parse(shapeChangeSystemConfigFile);
            NodeList ftpConfigParamList = document.getElementsByTagName(idTag);
            Node nodeMain = ftpConfigParamList.item(selectedRepository - 1);
            Node nodeChild = null;
            NodeList ndListChilds = nodeMain.getChildNodes();
            int j = 0;
            while (j < ndListChilds.getLength()) {
                nodeChild = ndListChilds.item(j);
                if (nodeChild.getNodeType() == 1) {
                    String sNodeName = nodeChild.getNodeName();
                    Node nodeData = nodeChild.getFirstChild();
                    if (idTag.equals("ftp") && sNodeName.equals(param)) {
                        return nodeData.getNodeValue();
                    }
                    if (idTag.equals("wrs") && sNodeName.equals(param)) {
                        return nodeData.getNodeValue();
                    }
                }
                ++j;
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("SAXExc: " + e.getMessage());
                e.printStackTrace(System.err);
            } else {
                System.err.println("SAXExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("IOExc: " + e);
                e.printStackTrace(System.err);
            } else {
                System.err.println("IOExc no message: " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Exc: " + e);
            e.printStackTrace(System.err);
        }
        return null;
    }

    protected String[] tokenizeString(String input) {
        StringTokenizer st = new StringTokenizer(input);
        String[] results = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token;
            results[i] = token = st.nextToken();
            ++i;
        }
        return results;
    }

    public String getServletInfo() {
        return "ShapeChange Servlet \r\nVersion v0.3.1 2006-06-04 \r\n\r\nShapeChange takes a ISO 19109 Application Schema in UML \r\nand translates it into a GML Application Schema. \r\n\r\nAddress: \r\n interactive instrments GmbH \r\n Trierer Strasse 70-72 \r\n 53115 Bonn \r\n Germany \r\n\r\nEmail: \r\n ShapeChange@interactive-instruments.de \r\n";
    }

    protected class ShapeChangeErrorHandler
    implements ErrorHandler {
        protected ShapeChangeErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("XML parser fatalError: " + m + " (line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ")");
            } else {
                e.printStackTrace(System.err);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("XML parser Error: " + m + " (line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ")");
            } else {
                e.printStackTrace(System.err);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            String m = e.getMessage();
            if (m != null) {
                System.err.println("XML parser warning: " + m + " (line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ")");
            } else {
                e.printStackTrace(System.err);
            }
        }
    }
}

