<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1 -->
<!-- Suchbegriffe -->
<!-- Mit Überhakenflurstück testen, ob dies so funktioniert. -->

<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/><!-- Hier auf E1.xml bezogen statt wie zuvor bezugslos. -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<xsl:choose>
					<xsl:when test="count(document('E1.xml')//adv:AX_Flurstueck/adv:position/*/*)>1"><!-- Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. -->
				<!-- Selektion der relevanten tatsächlichen Nutzungen -->
						<wfs:Query typeName="AX_Hafenbecken">
							<ogc:Filter>
								<ogc:Or><!-- Hier or, weil es reicht, daß eine der Teilflächen schneidet. -->
									<xsl:for-each select="$p3/*"> <!-- Mit Überhakenflurstück testen, ob dies so funktioniert. -->
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/><!-- Hier statt value-of copy-of wie auch bei allen weiteren... -->
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_StehendesGewaesser">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Meer">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Fliessgewaesser">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Wohnbauflaeche">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_IndustrieUndGewerbeflaeche">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Halde">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Bergbaubetrieb">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_TagebauGrubeSteinbruch">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_FlaecheBesondererFunktionalerPraegung">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_SportFreizeitUndErholungsflaeche">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Friedhof">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_FlaecheGemischterNutzung">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Landwirtschaft">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Wald">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Gehoelz">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Heide">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Moor">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Sumpf">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_UnlandVegetationsloseFlaeche">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Strassenverkehr">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Platz">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Weg">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Bahnverkehr">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Flugverkehr">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Schiffsverkehr">
							<ogc:Filter>
								<ogc:Or>
									<xsl:for-each select="$p3/*">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/>
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
							</ogc:Filter>
						</wfs:Query>
					</xsl:when>
					<xsl:otherwise>
								<!-- Selektion der relevanten tatsächlichen Nutzungen -->
						<wfs:Query typeName="AX_Hafenbecken">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/><!-- Hier statt value-of copy-of wie auch bei allen weiteren... -->
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_StehendesGewaesser">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Meer">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Fliessgewaesser">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Wohnbauflaeche">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_IndustrieUndGewerbeflaeche">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Halde">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Bergbaubetrieb">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_TagebauGrubeSteinbruch">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_FlaecheBesondererFunktionalerPraegung">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_SportFreizeitUndErholungsflaeche">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Friedhof">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_FlaecheGemischterNutzung">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Landwirtschaft">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Wald">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Gehoelz">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Heide">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Moor">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Sumpf">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_UnlandVegetationsloseFlaeche">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Strassenverkehr">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Platz">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Weg">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Bahnverkehr">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Flugverkehr">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
						<wfs:Query typeName="AX_Schiffsverkehr">
							<ogc:Filter>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/>
								</ogc:Intersects>
							</ogc:Filter>
						</wfs:Query>
					</xsl:otherwise>
				</xsl:choose>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
