<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
	
		<xsl:variable name="flurstueck" select="document('E1.xml')//adv:AX_Flurstueck"/>
		<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="gemarkung" select="document('E1.xml')//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
		
		<xsl:variable name="regbez" select="document('E3.xml')//adv:AX_Regierungsbezirk/adv:bezeichnung"/>
		<xsl:variable name="kreis" select="document('E3.xml')//adv:AX_KreisRegion/adv:bezeichnung"/>
		<xsl:variable name="gemeinde" select="document('E3.xml')//adv:AX_Gemeinde/adv:bezeichnung"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Liegenschaftskarte xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<xsl:apply-templates select="//adv:folgeverarbeitung" mode="copy-it"/>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<xsl:copy-of select="document('E2.xml')//adv:koordinatenangaben"/><!-- Hier statt value-of copy-of -->
			<enthaelt>
				<wfs:FeatureCollection>
					<xsl:apply-templates select="document('E2.xml')//gml:boundedBy" mode="copy-it"/>
					<xsl:for-each select="document('E2.xml')//gml:featureMember">
				           <xsl:variable name="ao1" select="name(./*)" />
          				<xsl:if test="$ao1!='AX_KommunalesGebiet'">
						<xsl:apply-templates select="." mode="copy-it"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select="document('E3.xml')//gml:featureMember">
					   <xsl:variable name="ao2" select="name(./*)" />
          				<xsl:if test="$ao2!='AX_Gemeinde' or $ao2!='AX_Regierungsbezirk' or $ao2!='AX_KreisRegion'">
					<xsl:apply-templates select="." mode="copy-it"/>
					</xsl:if>
					</xsl:for-each>
				</wfs:FeatureCollection>
			</enthaelt>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<kopf>
				<AX_Kopf_Flurstueck>
					<gemarkungsname>
						<xsl:value-of select="$gemarkung/adv:bezeichnung"/>
					</gemarkungsname>
					<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
					<xsl:if test="count($flurstueck/adv:flurnummer)=1">
						<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
					</xsl:if>
				</AX_Kopf_Flurstueck>
			</kopf>
			<gemeinde><xsl:value-of select="$gemeinde"/></gemeinde>
			<xsl:if test="boolean(document('E3.xml')//adv:AX_KreisRegion)">
				<kreis><xsl:value-of select="$kreis"/></kreis>
			</xsl:if>	
			<xsl:if test="boolean(document('E3.xml')//adv:AX_Regierungsbezirk)">
				<regierungsbezirk><xsl:value-of select="$regbez"/></regierungsbezirk>
			</xsl:if>
		</AX_Liegenschaftskarte>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
