<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="p1" select="//adv:profilkennung"/>
	<!-- Antragsnummer: nicht optional -->
	<xsl:variable name="p2" select="//adv:antragsnummer"/>
	<!-- Geometrie: optional  -->
	<xsl:variable name="p3" select="//ogc:Intersects"/>
	<!-- Koordinatenreferenzsystem: optional -->
	<xsl:variable name="p4" select="//adv:koordinatenreferenzsystem"/>
	<!-- =========================================================== -->
	<!-- Filter für Punkte -->
	<xsl:template name="Punkt_Filter">
		<xsl:param name="punkttyp"/>
		<xsl:param name="punktorttyp"/>
		<xsl:param name="punktkennung"/>
		<xsl:if test="count($p3)=1"> 
			<!-- mit Geometrieselektion -->
			<wfs:Query>
				<xsl:attribute name="typeName"><xsl:value-of select="$punktorttyp"/></xsl:attribute>
				<adv:XlinkPropertyPath leafonly="true"><xsl:value-of select="concat('istTeilVon/',$punkttyp)"/></adv:XlinkPropertyPath>
				<ogc:Filter>
					<ogc:And>
						<ogc:PropertyIsEqualTo>				
							<ogc:PropertyName><xsl:value-of select="concat('istTeilVon/',$punkttyp,'/punktkennung')"/></ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$punktkennung"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<xsl:apply-templates select="$p3" mode="copy-it"/>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>koordinatenstatus</ogc:PropertyName>
							<ogc:Literal>1000</ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsNull>
							<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
						</ogc:PropertyIsNull>
					</ogc:And>
				</ogc:Filter>
			</wfs:Query>
		</xsl:if>
		<xsl:if test="count($p3)=0"> 
			<!-- ohne Geometrieselektion -->
			<wfs:Query>
				<xsl:attribute name="typeName"><xsl:value-of select="$punkttyp"/></xsl:attribute>
				<ogc:Filter>
					<ogc:and>
						<ogc:PropertyIsEqualTo>				
							<ogc:PropertyName>punktkennung</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$punktkennung"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
						<ogc:PropertyIsNull>
							<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
						</ogc:PropertyIsNull>
					</ogc:and>
				</ogc:Filter>
			</wfs:Query>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<xsl:if test="count($p4)=1">
				<koordinatenreferenzsystem>
					<xsl:value-of select="$p4"/>
				</koordinatenreferenzsystem>
			</xsl:if>
			<anforderungsmerkmale>
				<!-- Punkte selektieren nach Punktkennung -->
				<xsl:for-each select="document('E1.xml')//adv:AX_PunktkennungVergleichend[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
					<xsl:variable name="art" select="adv:art"/>
					<xsl:choose>
						<xsl:when test="$art=1100">
							<!-- Grenzpunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_Grenzpunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_Grenzpunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortTA'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1200">
							<!-- Besondere Gebäudepunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_BesondererGebaeudepunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAG'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_BesondererGebaeudepunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1300">
							<!-- Besondere topographische Punkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_BesondererTopographischerPunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1400">
							<!-- Aufnahmepunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_Aufnahmepunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/> 
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1500">
							<!-- Sicherungspunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_Sicherungspunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1600">
							<!-- Sonstige Vermessungspunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_SonstigerVermessungspunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$art=1700">
							<!-- Besondere Bauwerkspunkte -->
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_BesondererBauwerkspunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAG'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
							<xsl:call-template name="Punkt_Filter">
								<xsl:with-param name="punkttyp" select="'AX_BesondererBauwerkspunkt'"/>
								<xsl:with-param name="punktorttyp" select="'AX_PunktortAU'"/>
								<xsl:with-param name="punktkennung" select="adv:endgueltigePunktkennung"/> 
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
