<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="filter" select="//ogc:Filter"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_ListeDerReserviertenFachkennzeichen xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<artDerFachkennzeichen>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Art_Reservierung</xsl:with-param> 
					<xsl:with-param name="code" select="document('E1.xml')//adv:AX_Reservierung[1]/adv:art" />
				</xsl:call-template>
			</artDerFachkennzeichen>
			<gruppe>
				<AX_K_GRUPPE>
					<xsl:choose>
						<xsl:when test="contains($filter,'nummerierungsbezirk')">
							<!-- nach Nummerierungsbezirk gefiltert -->
							<nummerierungsbezirk>
								<xsl:value-of select="document('E1.xml')//adv:AX_Reservierung[1]/adv:nummerierungsbezirk"/>
							</nummerierungsbezirk>
						</xsl:when>
						<xsl:when test="contains($filter,'gebietskennung')">
							<!-- nach Gebietskennung und nicht nach Nummerieungsbezirk gefiltert -->
							<nummerierungsbezirk>
								<xsl:value-of select="document('E1.xml')//adv:AX_Reservierung[1]/adv:gebietskennung"/>
							</nummerierungsbezirk>
						</xsl:when>
					</xsl:choose>
					<xsl:for-each select="document('E1.xml')//adv:AX_Reservierung[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
						<reserviert>
							<AX_K_RESERVIERT>
								<ordnungsnummer>
									<xsl:value-of select="adv:nummer"/>
								</ordnungsnummer>
								<antragsnummerDerVermessung>
									<xsl:value-of select="adv:antragsnummer"/>
								</antragsnummerDerVermessung>
								<xsl:if test="count(adv:ablaufDerReservierung)=1">
									<ablauf>
										<xsl:value-of select="adv:ablaufDerReservierung"/>
									</ablauf>
								</xsl:if>
							</AX_K_RESERVIERT>
						</reserviert>
					</xsl:for-each>
				</AX_K_GRUPPE>
			</gruppe>
		</AX_ListeDerReserviertenFachkennzeichen>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
