<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 5.1.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1"
		xmlns:ogc="http://www.opengis.net/ogc"
		xmlns:gml="http://www.opengis.net/gml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="deckblatt" select="document('E1.xml')//adv:AX_FortfuehrungsnachweisDeckblatt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Fortfuehrungsnachweis xmlns="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/5.1.1" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" xmlns:wfs="http://www.opengis.net/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/5.1.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<deckblatt>
				<AX_K_FN_Deckblatt>
					<!-- Ausgabekopf aus Fortführungsnachweis-Deckblatt übernehmen -->
					<ausgabekopf>
						<AX_K_AUSGKOPF_Standard>
							<xsl:copy-of select="$deckblatt/adv:ausgabekopf/AX_K_AUSGKOPF_Standard/*"/>
						</AX_K_AUSGKOPF_Standard>
					</ausgabekopf>
					<fortfuehrungsfallNummernbereich> 
						<xsl:value-of select="$deckblatt/adv:fortfuehrungsfallNummernBereich"/>
					</fortfuehrungsfallNummernbereich> 
					<fNNummer>
						<xsl:copy-of select="$deckblatt/adv:fNNummer/AX_Fortfuehrungsnummer"/>
					</fNNummer>
					<titel>
						<xsl:value-of select="$deckblatt/adv:titel"/>
					</titel>
					<inGemarkung>
						<xsl:copy-of select="$deckblatt/adv:inGemarkung/adv:AX_Gemarkung_Schluessel"/>
					</inGemarkung>
					<xsl:if test="count($deckblatt/adv:erstelltAm)=1">
						<erstelltAm>
							<xsl:value-of select="$deckblatt/adv:erstelltAm"/>
						</erstelltAm>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:eignungspruefungAm)=1">
						<eignungspruefungAm>
							<xsl:value-of select="$deckblatt/adv:eignungspruefungAm"/>
						</eignungspruefungAm>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:fortfuehrungsentscheidungAm)=1">
						<fortfuehrungsentscheidungAm>
							<xsl:value-of select="$deckblatt/adv:fortfuehrungsentscheidungAm"/>
						</fortfuehrungsentscheidungAm>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:fortfuehrungsentscheidungVon)=1">
						<fortfuehrungsentscheidungVon>
							<xsl:value-of select="$deckblatt/adv:fortfuehrungsentscheidungVon"/>
						</fortfuehrungsentscheidungVon>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:eignungspruefungVon)=1">
						<eignungspruefungVon>
							<xsl:value-of select="$deckblatt/adv:eignungspruefungVon"/>
						</eignungspruefungVon>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:fortfuehrungsmitteilungenErzeugt)=1">
						<fortfuehrungsmitteilungenErzeugt>
							<xsl:value-of select="$deckblatt/adv:fortfuehrungsmitteilungenErzeugt"/>
						</fortfuehrungsmitteilungenErzeugt>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:bemerkung)=1">
						<bemerkung>
							<xsl:value-of select="$deckblatt/adv:bemerkung"/>
						</bemerkung>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:verwaltungsaktJN)=1">
						<verwaltungsaktJN>
							<xsl:value-of select="$deckblatt/adv:verwaltungsaktJN"/>
						</verwaltungsaktJN>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:erstelltVon)=1">
						<erstelltVon>
							<xsl:value-of select="$deckblatt/adv:erstelltVon"/>
						</erstelltVon>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:bekanntgabeAnBeteiligteAm)=1">
						<bekanntgabeAnBeteiligteAm>
							<xsl:value-of select="$deckblatt/adv:bekanntgabeAnBeteiligteAm"/>
						</bekanntgabeAnBeteiligteAm>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:auszugFuer)=1">
						<auszugFuer>
							<!-- Kopie von AX_Auszug -->
							<xsl:copy-of select="$deckblatt/adv:auszugFuer/*"/>
						</auszugFuer>
					</xsl:if>
					<xsl:if test="count($deckblatt/adv:grundbuchmitteilungFuerFinanzamt)=1">
						<grundbuchmitteilungFuerFinanzamt>
							<xsl:value-of select="$deckblatt/adv:grundbuchmitteilungFuerFinanzamt"/>
						</grundbuchmitteilungFuerFinanzamt>
					</xsl:if>
				</AX_K_FN_Deckblatt>
			</deckblatt>
			<!-- sortiert nach Fortführungsfallnummer -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Fortfuehrungsfall">
				<xsl:sort select="adv:fortfuehrungsfallnummer"/>
				<xsl:variable name="fortfuehrungsfall" select="."/>
				<fortfuehrungsfall>
					<AX_K_Fortfuehrungsfall_Ausgabe>
						<fortfuehrungsfallnummer>
							<xsl:value-of select="adv:fortfuehrungsfallnummer"/>
						</fortfuehrungsfallnummer>
						<laufendeNummer>
							<xsl:value-of select="adv:laufendeNummer"/>
						</laufendeNummer>
						<xsl:for-each select="adv:ueberschriftImFortfuehrungsnachweis">
							<xsl:copy-of select="."/>
						</xsl:for-each>
						<xsl:if test="count(adv:anzahlDerFortfuehrungsmitteilungen)=1">
							<anzahlDerFortfuehrungsmitteilungen>
								<xsl:value-of select="adv:anzahlDerFortfuehrungsmitteilungen"/>
							</anzahlDerFortfuehrungsmitteilungen>
						</xsl:if>
						<xsl:if test="count(adv:fortfuehrungsmitteilungAnEigentuemerAntragsteller)=1">
							<fortfuehrungsmitteilungAnEigentuemerAntragsteller>
								<xsl:value-of select="adv:fortfuehrungsmitteilungAnEigentuemerAntragsteller"/>
							</fortfuehrungsmitteilungAnEigentuemerAntragsteller>
						</xsl:if>
						<xsl:if test="count(adv:anmerkungFuerDenNotar)=1">
							<anmerkungFuerDenNotar>
								<xsl:value-of select="adv:anmerkungFuerDenNotar"/>
							</anmerkungFuerDenNotar>
						</xsl:if>
						<xsl:if test="count(adv:bemerkung)=1">
							<bemerkung>
								<xsl:value-of select="adv:bemerkung"/>
							</bemerkung>
						</xsl:if>
						<xsl:for-each select="adv:zeigtAufAltesFlurstueck">
							<flurstueck_alt>
								<xsl:call-template name="AX_K_FLURST_F">
									<xsl:with-param name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
								</xsl:call-template>
							</flurstueck_alt>
						</xsl:for-each>
						<xsl:for-each select="adv:zeigtAufNeuesFlurstueck">
							<flurstueck_neu>
								<xsl:call-template name="AX_K_FLURST_F">
									<xsl:with-param name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
								</xsl:call-template>
							</flurstueck_neu>
						</xsl:for-each>
						<!-- Buchungsangaben nur für alte Flurstücke -->
						<xsl:for-each select="adv:zeigtAufAltesFlurstueck">
							<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
							<buchung>
								<xsl:variable name="stelle" select="document('E1.xml')//adv:AX_Buchungsstelle[@gml:id=substring-after($flurstueck/adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
								<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
								  	<xsl:with-param name="blatt" select="document('E1.xml')//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/> 
								  	<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/> 
								  	<xsl:with-param name="bart"  select="$stelle/adv:buchungsart"/> 
								</xsl:call-template>
							</buchung>
						</xsl:for-each>
						<veraenderungsanalyse>
							<xsl:call-template name="AX_K_FANALYSE">
								<xsl:with-param name="fortfuehrungsfall" select="."/>
							</xsl:call-template>
						</veraenderungsanalyse>
						<xsl:if test="count(adv:verweistAuf/adv:AX_FGraphik)=1">
							<verweistAuf>
   								<xsl:value-of select="adv:verweistAuf/adv:AX_FGraphik"/>
							</verweistAuf>
						</xsl:if>
					</AX_K_Fortfuehrungsfall_Ausgabe>
				</fortfuehrungsfall>
			</xsl:for-each>
		</AX_Fortfuehrungsnachweis>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
