<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->	
	<!-- =========================================================== -->
	<!-- Keys zur Gruppierung über die Funktionswerte auf Gemeinde -->
	<xsl:key name="TNFL_funktionOA"  match="//flaecheTNGD/AX_K_TNFL_all/funktionOA" use="."/>
	<xsl:key name="TNGR_funktionOA"  match="//flaechensummeOAGD/AX_K_TNGR_all/funktionOA" use="."/>
	<xsl:key name="TNHGR_funktionOA" match="//flaechensummeHGrGD/AX_K_TNHGR_all/funktionHGr" use="."/>
	<!-- =========================================================== -->
	<!-- Summierung von Flächenwerten für gleichen Funktionswert und Bildung neuer Blöcke -->
	<xsl:template name="flaechensumme">
		<xsl:param name="nodes"/>	
		<xsl:param name="key"/>	
		<xsl:param name="elem1"/>	
		<xsl:param name="elem2"/>	
		<xsl:param name="gebiet"/>	
		<!-- Summenbildung über eindeutige Funktionswerte -->
		<xsl:variable name="unique">
		  <xsl:choose><!-- Bei AX_K_TNHGR_all funktionHGr, bei AX_K_TNFL_all und AX_K_TNGR_all funktionOA -->
		    <xsl:when test="$elem2 = 'AX_K_TNFL_all' or $elem2 = 'AX_K_TNGR_all'">
		      <xsl:copy-of select="$nodes/adv:funktionOA[count(.|key($key,.)[1]) = 1]"/>
		    </xsl:when>
		    <xsl:when test="$elem2 = 'AX_K_TNHGR_all'">
		     <xsl:copy-of select="$nodes/adv:funktionHGr[count(.|key($key,.)[1]) = 1]"/>
		    </xsl:when>
		  </xsl:choose>
		</xsl:variable>
		<xsl:for-each select="$unique">
			<xsl:sort select="."/>
			<xsl:element name="$elem1">
				<xsl:element name="$elem2">
					<gebiet>
						<xsl:value-of select="$gebiet"/>
					</gebiet>
					<xsl:choose><!-- Bei AX_K_TNHGR_all funktionHGr, bei AX_K_TNFL_all und AX_K_TNGR_all funktionOA -->
						<xsl:when test="$elem2 = 'AX_K_TNFL_all' or $elem2 = 'AX_K_TNGR_all'">
					  		<funktionOA>
								<xsl:value-of select="."/>
					  		</funktionOA>
					 	</xsl:when>
					 	<xsl:when test="$elem2 = 'AX_K_TNHGR_all'">
					  		<funktionHGr>
								<xsl:value-of select="."/>
					  		</funktionHGr>
					 	</xsl:when>
					</xsl:choose>
					<flaeche>
						<xsl:variable name="val" select="."/>
						<xsl:value-of select="sum($nodes/adv:funktionOA[. = $val]/../adv:flaeche)"/>
					</flaeche>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="naechsteSumme">	
		<!-- Summenbildung für KreisRegion über Gemeinde -->
		<xsl:for-each select="document('E1.xml')//adv:AX_KreisRegion">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaecheTNGD/adv:AX_K_TNFL_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNFL_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaecheTNKreis'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNFL_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_KreisRegion">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaechensummeOAGD/adv:AX_K_TNGR_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNGR_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaechensummeOAKreis'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNGR_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_KreisRegion">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaechensummeHGrGD/adv:AX_K_TNHGR_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNHGR_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaechensummeHGrKreis'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNHGR_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_KreisRegion">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<gesamtflaecheKreis>
				<AX_K_FLASU>
					<gebiet>
						<xsl:value-of select="$schluessel"/>
					</gebiet>
					<flaechensumme>
						<xsl:value-of select="sum(//adv:gesamtflaecheGD/adv:AX_K_FLASU[starts-with(adv:gebiet,$schluessel)]/adv:flaechensumme)"/>
					</flaechensumme>
				</AX_K_FLASU>
			</gesamtflaecheKreis>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:choose>
			<xsl:when test="$anlassart = '2110' or $anlassart = '2120' or $anlassart = '2121'">
				<!-- nur Gemeinde- und/oder Gemarkungsstatistk: somit hat der vorhergehende Schritt das Endergebnis ermittelt -->
				<xsl:copy-of select="document('A4_Statistik_Gemeinde.xml)."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- sonst: Muss die vorhergehende Statistik (Gemeindestatistik) gelöscht werden? -->
				<xsl:variable name="clear">
					<xsl:choose>
						<xsl:when test="$anlassart = '2131' or $anlassart = '2141' or $anlassart = '2151'">
							<!-- komplette Statistik: Gemeindestatistik nicht löschen -->
							<xsl:value-of select="''"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- nur höchste Statistik: Gemeindestatistik löschen -->
							<xsl:value-of select="'flaecheTNGD,flaechensummeOAGD,flaechensummeHGrGD,gesamtflaecheGD'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
					<!-- Teile vom vorhergehenden Ergebnis kopieren, ggf. Gemeindestatistik löschen -->
					<xsl:for-each select="document('A4_Statistik_Gemeinde.xml)/*/*">
						<xsl:if test="not(contains($clear,name(.)))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<!-- KreisRegion-Statistik über Aggregation der Gemeindestatistik bilden -->
					<xsl:call-template name="naechsteSumme"/>
				</AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
