<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<xsl:template name="summiereFlurstuecksflaechen">
		<xsl:param name="tn"/>
		<xsl:param name="flurstuecke"/>
		<xsl:choose>
			<xsl:when test="$tn">
				<xsl:variable name="rec_res">
					<xsl:call-template name="summiereFlurstuecksflaechen">
						<xsl:with-param name="tn" select="$tn"/>
						<xsl:with-param name="flurstuecke" select="$flurstuecke[position()>1]"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Flächenermittlung vom ersten Flurstück -->
				<xsl:variable name="flur" select="$flurstuecke[1]"/>
				<!-- Korrekturfaktor bestimmen -->
				<xsl:variable name="korrekturfaktor">
					<xsl:choose>
						<xsl:when test="function-available('ext:berechneFlaeche')">
							<xsl:value-of select="$flur/adv:amtlicheflaeche div ext:berechneFlaeche($flur/adv:position)"/>
						</xsl:when>
						<xsl:otherwise>1.0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- Flächenermittlung vom Rest -->
				<xsl:variable name="res">
					<xsl:call-template name="summiereTeilflaechen">
						<!-- alle Flurstücke der Gemarkung -->
						<xsl:with-param name="tn" select="$tn"/>
						<xsl:with-param name="flurstuecksflaeche" select="$flur/adv:position"/>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="number($res) + $rec_res"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	<!-- =========================================================== -->
	<xsl:template name="flaecheTNGK">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaecheTNGK>
				<AX_K_TNFL_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionOA><xsl:value-of select="$fkt"/></funktionOA>
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNFL_all>
			</flaecheTNGK>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeOAGK">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaechensummeOAGK>
				<AX_K_TNGR_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionOA><xsl:value-of select="$fkt"/></funktionOA>
					<!-- Gesamtflaeche über jedes Flurstück -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNGR_all>
			</flaechensummeOAGK>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeHGrGK">
		<xsl:param name="schluessel"/>
		<xsl:param name="tn"/>
		<xsl:param name="fkt"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<flaechensummeHGrGK>
				<AX_K_TNHGR_all>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<funktionHGr><xsl:value-of select="$fkt"/></funktionHGr>
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="tn" select="$tn"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_TNHGR_all>
			</flaechensummeHGrGK>
		</xsl:if>
	</xsl:template>					
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			
			<!-- Gebiet wird bei Anlassart der Ausgabe = 2150 und 2151 nicht belegt, sonst mit Gebietsselektionsparameter -->
			<!-- Am 24.03.2009 wieder aktiviert und erweitert aufgrund RL 1755 -->
			<xsl:if text="$anlassart != 2150 and $anlassart != 2151">
			<xsl:variable name="schluessel_gebiet" select="//ogc:Literal"/>
				<gebiet>
				  <AX_Gebiet_StatistikDerFlaechenDerTN_all>
				     <xsl:choose><!-- 10.05.2009: Zusätzliche neue Attribute werden belegt. -->
				      <xsl:when test="($anlassart='2110')">
				        <xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_Gemarkung[adv:schluesselGesamt=$schluessel_gebiet]"/>
					 <bezeichnung>Gemarkung</bezeichnung>
					 <name><xsl:value-of select="$gebiet/bezeichnung"/></name>
				      </xsl:when>
				      <xsl:when test="($anlassart='2120') or ($anlassart='2121')">
				        <xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_KommunalesGebiet[adv:schluesselGesamt=$schluessel_gebiet]"/>
					 <bezeichnung>Kommunales Gebiet</bezeichnung>
					 <name><xsl:value-of select="$gebiet/bezeichnung"/></name>
				      </xsl:when>
				      <xsl:when test="($anlassart='2130') or ($anlassart='2131')">
				        <xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_KreisRegion[adv:schluesselGesamt=$schluessel_gebiet]"/>
					 <bezeichnung>Kreis Region</bezeichnung>
					 <name><xsl:value-of select="$gebiet/bezeichnung"/></name>
				      </xsl:when>
				      <xsl:when test="($anlassart='2140') or ($anlassart='2141')">
				        <xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_Regierungsbezirk[adv:schluesselGesamt=$schluessel_gebiet]"/>
					 <bezeichnung>Regierungsbezirk</bezeichnung>
					 <name><xsl:value-of select="$gebiet/bezeichnung"/></name>
				      </xsl:when>
				     </xsl:choose>
				    <schluessel><xsl:value-of select="//ogc:Literal"/></schluessel>
				    <anzahlFlurstuecke>
				     <xsl:value-of select="count(document('E1.xml')//adv:AX_Flurstueck)">
				    </anzahlFlurstuecke>
				  </AX_Gebiet_StatistikDerFlaechenDerTN_all>	
				</gebiet>
			</xsl:if>
			
			<!-- über alle Gemarkungen: jede Gemarkung hat ein eigenes Ergebnisdokument 'E2_Gemarkung_<Schlüssel>.xml' -->
			<xsl:for-each select="document('E1.xml')//AX_Gemarkung">
				<!-- Sortierung der Ausgabe nach Bundesland und Gemarkungsnummer -->
				<xsl:sort select="adv:gemarkung/adv:land"/>
				<xsl:sort select="adv:gemarkung/adv:gemarkungsnummer"/>
				<!-- Schlüssel vermerken -->
				<xsl:variable name="schluessel" select="concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer)"/>

				<!-- flaecheTNKG --><!-- RL 1754 u. 1797 23.03.2009: Hier werden die Werte der Enumeration AX_FunktionOA_K_TNGRerweitert_all den Selektionen gem.
				AdV-Nutzungsartenverzeichnis zugeordnet. Es gelten die Vorgaben des Nutzungsartenverzeichnisses, d.h. z.B.
				Wert 'Industrie- und Gewerbefläche' wird den Instanzen der Objektart 41002 AX_IndustrieUndGewerbeflaeche zugeordnet,
				bei denen Attribut funktion nicht belegt ist.
				Wert 'Industrie- und Gewerbe' wird den Instanzen der Objektart 41002 AX_IndustrieUndGewerbeflaeche zugeordnet,
				bei denen Attribut funktion mit 1700 'Industrie- und Gewerbe' belegt ist.
				Der Datentyp AX_FunktionOA_K_TNGRerweitert_all ist eine Enumeration, die alle 26 Objektarten der Tatsächlichen Nutzung sowie alle Wertearten der
				zugehörigen Attribute funktion und vegetationsmerkmal beinhaltet. Bewußt nicht inbegriffen sind weitere Attribute wie z.B. lagergut, abbaugut, foerdergut. -->
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Wohnbaufläche"/><!-- Gem. RL 1754 u. 1797 am 23.03.2009 korrigiert: Da per Revision bei AX_K_TNFL_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, wird hier entschluesselte Wert "Wohnbaufläche" statt "4101" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wohnbauflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Industrie- und Gewerbefläche"/><!-- Sinngemäß gilt hier und bei den restlichen Aufrufen von flaecheTNGK derselbe Kommentar wie bei Aufruf bzgl. Wert Wohnbaufläche bzw. 4101 -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Industrie- und Gewerbe"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche[adv:funktion='1700']"/>
				</xsl:call-template >
				<!-- 23.03.2009 Für jeden Eintrag der Enumeration AX_FunktionOA_K_TNGRerweitert_all findet sich im AdV-Nutzungsartenverzeichnis eine zugeordnete Selektionsvorschrift. 
				Daher wurde hier davon abgesehen, die Einzeleinträge alle aufzulisten. -->
				
				<!-- 23.03.2009 In Zusammenhang mit der Bearbeitung von RL 1754 u. 1797 auskommentiert -->
				<!-- xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4103"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Halde"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4104"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bergbaubetrieb"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4105"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4106"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheGemischterNutzung"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4107"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4108"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4109"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Friedhof"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4201"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Strassenverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4206"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Weg"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4209"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Platz"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4210"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bahnverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4215"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Flugverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4216"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Schiffsverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4301"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Landwirtschaft"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4302"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wald"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4303"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Gehoelz"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4304"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Heide"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4305"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Moor"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4306"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Sumpf"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4307"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4401"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Fliessgewaesser"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4405"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Hafenbecken"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4406"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_StehendesGewaesser"/>
				</xsl:call-template >
				<xsl:call-template name="flaecheTNGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="4407"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Meer"/>
				</xsl:call-template --><!-- 23.03.2009 In Zusammenhang mit der Bearbeitung von RL 1797 auskommentiert -->

				<!-- flaechensummeOAGK -->
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Wohnbaufläche"/><!--Gem. RL 1754 u. 1797 am 24.03.2009 korrigiert: Da per Revision bei AX_K_TNGR_all/funktionOA bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, wird hier entschluesselte Wert "Wohnbaufläche" statt "4101" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wohnbauflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4102"/ -->
					<xsl:with-param name="fkt" select="Industrie- und Gewerbefläche"/><!-- Sinngemäß gilt hier und bei den restlichen Aufrufen von flaechensummeOAGK derselbe Kommentar wie bei Aufruf bzgl. Wert 4101 -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche[contains('1700,1701,1710,1720,1730,1740,1750,1760,1770,1780,1790,1400,1410,1420,1430,1440,1450,1460,1470,1480,1490,2500,2501,2502,2510,2520,2521,2522,2530,2531,2532,2540,2550,2551,2552,2560,2561,2562,2570,2571,2572,2580,2581,2582,2600,2601,2602,2610,2611,2612,2620,2621,2622,2623,2630,2640',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4103"/ -->
					<xsl:with-param name="fkt" select="Halde"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Halde"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4104"/ -->
					<xsl:with-param name="fkt" select="Bergbaubetrieb"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bergbaubetrieb"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4105"/ -->
					<xsl:with-param name="fkt" select="Tagebau, Grube, Steinbruch"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4106"/ -->
					<xsl:with-param name="fkt" select="Fläche gemischter Nutzung"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheGemischterNutzung[contains('2100,2110,2120,2130,2140,2150,2160,2700,2710,2720,2730,6800,7600',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheGemischterNutzung"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4107"/ -->
					<xsl:with-param name="fkt" select="Fläche besonderer funktionaler Prägung"/>
					<!-- Folgende Werte wurden ergänzt, die gemappt werden und zu den Zielwerten passen: 1100,1110,1120,1130,1140,1150,1160,1170,1200,1300,1310,1320 -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung[contains('1100,1110,1120,1130,1140,1150,1160,1170,1200,1300,1310,1320,1500,1510,1520,1530,1540,1550,1560,1570,1600,1800,1810,1820',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4108"/ -->
					<xsl:with-param name="fkt" select="Sport-, Freizeit- und Erholungsfläche"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche[contains('4100,4001,4101,4110, 4120,4130,4140,4150,4160,4170,4200,4210,4211,4220,4230,4240,4250,4260,4270,4280,4290,4300,4301,4310,4320,4321,4330,4331,4400,4410,4420,4430,4431,4440,4450,4460,4470',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4109"/ -->
					<xsl:with-param name="fkt" select="Friedhof"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Friedhof[contains('9401,9402,9403,9404',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Friedhof"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4201"/ -->
					<xsl:with-param name="fkt" select="Straßenverkehr"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Strassenverkehr[contains('2311,2312,2313,5130',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Strassenverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4206"/ -->
					<xsl:with-param name="fkt" select="Weg"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Weg[contains('5210,5211,5212,5220,5230,5240,5250,5260',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Weg"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4209"/ -->
					<xsl:with-param name="fkt" select="Platz"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Platz[contains('5130,5310,5320,5330,5340,5350',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Platz"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4210"/ -->
					<xsl:with-param name="fkt" select="Bahnverkehr"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bahnverkehr[contains('2321,2322',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bahnverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4215"/ -->
					<xsl:with-param name="fkt" select="Flugverkehr"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Flugverkehr[contains('5501',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Flugverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4216"/ -->
					<xsl:with-param name="fkt" select="Schiffsverkehr"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Schiffsverkehr[contains('2341,5610,5620,5630,5640',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Schiffsverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4301"/ -->
					<xsl:with-param name="fkt" select="Landwirtschaft"/>
					<!-- adv:vegetationsmerkmal wird geprüft, 1200 wird auf 2101 gemappt, deshalb mit in der Liste -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Landwirtschaft[contains('1200,1010,1011,1012,1013,1020,1021,1030,1031,1040,1050,1051,1052,2101',adv:vegetationsmerkmal)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Landwirtschaft"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4302"/ -->
					<xsl:with-param name="fkt" select="Wald"/>
					<!-- adv:vegetationsmerkmal wird geprüft -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wald[contains('1100,1200,1300,1310,1320',adv:vegetationsmerkmal)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wald"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4303"/ -->
					<xsl:with-param name="fkt" select="Gehoelz"/>
					<!-- adv:vegetationsmerkmal wird geprüft, 1400 wird auf 1401 gemappt, deshalb mit in der Liste -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Gehoelz[contains('1400,1401',adv:vegetationsmerkmal)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Gehoelz"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4304"/ -->
					<xsl:with-param name="fkt" select="Heide"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Heide"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4305"/ -->
					<xsl:with-param name="fkt" select="Moor"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Moor"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4306"/ -->
					<xsl:with-param name="fkt" select="Sumpf"/>
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Sumpf"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4307"/ -->
					<xsl:with-param name="fkt" select="UnlandVegetationslose Fläche"/>
					<!-- Folgende Werte wurden ergänzt, die gemappt werden und zu den Zielwerten passen: 1000,1100,1110,1120,1200 -->
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche[contains('1000,1100,1110,1120,1200,4307, 8111, 8112, 8113, 8114, 8115',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4401"/ -->
					<xsl:with-param name="fkt" select="Fließgewässer"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Fliessgewaesser[contains('8200,8210,8220,8300,8400,8410,8500',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Fliessgewaesser"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4405"/ -->
					<xsl:with-param name="fkt" select="Hafenbecken"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Hafenbecken[contains('8810',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Hafenbecken"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4406"/ -->
					<xsl:with-param name="fkt" select="Stehendes Gewässer"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_StehendesGewaesser[contains('8610,8620,8630,8631,8640',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_StehendesGewaesser"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeOAGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<!-- xsl:with-param name="fkt" select="4407"/ -->
					<xsl:with-param name="fkt" select="Meer"/>
					<!-- xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Meer[contains('8710,8720',adv:funktion)]"/ -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Meer"/>
				</xsl:call-template >
				
				<!-- flaechensummeHGrGD: nicht optimal, da einzelne Summen schon berechnet worden sind -->
				<xsl:call-template name="flaechensummeHGrGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Siedlung"/><!-- Gem. RL 1797 am 23.03.2009 korrigiert: Da per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Siedlung" statt "4100" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Wohnbauflaeche|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_IndustrieUndGewerbeflaeche|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Halde|document('E2_Gemarkung_{$schluessel}.xml')/AX_Bergbaubetrieb|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_TagebauGrubeSteinbruch|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheGemischterNutzung|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_FlaecheBesondererFunktionalerPraegung|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_SportFreizeitUndErholungsflaeche|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Friedhof"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeHGrGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Verkehr"/><!-- Gem. RL 1797 am 23.03.2009 korrigiert: Da per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Verkehr" statt "4200" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Strassenverkehr|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Weg|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Platz|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Bahnverkehr|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Flugverkehr|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Schiffsverkehr"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeHGrGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Vegetation"/><!-- Gem. RL 1797 am 23.03.2009 korrigiert: Da per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Vegetation" statt "4300" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Landwirtschaft|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Wald|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Gehoelz|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Heide|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Moor|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Sumpf|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_UnlandVegetationsloseFlaeche"/>
				</xsl:call-template >
				<xsl:call-template name="flaechensummeHGrGK">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="fkt" select="Gewässer"/><!-- Gem. RL 1797 am 23.03.2009 korrigiert: Da per Revision bei AX_K_TNHGR_all/funktionHGr bei der bisherigen Codelist nun der Datentyp Enumeration gesetzt wurde, dann wird hier entschluesselte Wert "Gewässer" statt "4400" übergeben. -->
					<xsl:with-param name="tn"  select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Fliessgewaesser|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Hafenbecken|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_StehendesGewaesser|
													   document('E2_Gemarkung_{$schluessel}.xml')/AX_Meer"/>
				</xsl:call-template >
			</xsl:for-each>
		</AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
