<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<xsl:template name="summiereFlurstuecksflaechen">
		<xsl:param name="bwrts"/>
		<xsl:param name="flurstuecke"/>
		<xsl:choose>
			<xsl:when test="$bwrts">
				<xsl:variable name="rec_res">
					<xsl:call-template name="summiereFlurstuecksflaechen">
						<xsl:with-param name="bwrts" select="$bwrts"/>
						<xsl:with-param name="flurstuecke" select="$flurstuecke[position()>1]"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Flächenermittlung vom ersten Flurstück -->
				<xsl:variable name="flur" select="$flurstuecke[1]"/>
				<!-- Korrekturfaktor bestimmen -->
				<xsl:variable name="korrekturfaktor">
					<xsl:choose>
						<xsl:when test="function-available('ext:berechneFlaeche')">
							<xsl:value-of select="$flur/adv:amtlicheflaeche div ext:berechneFlaeche($flur/adv:position)"/>
						</xsl:when>
						<xsl:otherwise>1.0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- Flächenermittlung vom Rest -->
				<xsl:variable name="res">
					<xsl:call-template name="summiereTeilflaechen">
						<!-- alle Flurstücke der Gemarkung -->
						<xsl:with-param name="tn" select="$bwrts"/>
						<xsl:with-param name="flurstuecksflaeche" select="$flur/adv:position"/>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="number($res) + $rec_res"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	<!-- =========================================================== -->
	<xsl:template name="flaecheOBGGK_Landwirt">
		<!-- Landwirtschaftliche Nutzung differenzieren nach Bodenschätzung -->
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="bwrts"/>
		<xsl:param name="boden"/>
		<!-- nur wenn Bewertungsflächen und Bodenschätzungen vorhanden -->
		<xsl:if test="count($bwrts)>0 and count($boden)>0">
			<flaecheOBGGK>
				<AX_K_BEWFL>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<klassifizierungOBG><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß hier vorhandener Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWFL.klassifizierungOBG durch Revision 'Enumeration' als Datentyp hat. -->
						<!-- AX_KlassifizierungOBG_K_BEWFL Codelistenname tritt hier nicht in Erscheinung sondern direkt der Enuerations-Inhalt. -->
							<xsl:value-of select="$klass"/>
							<!-- Zuordnung: -->
							<!-- Bewertung -->
							<!-- 2099=Noch nicht klassifiziert,  -->
							<!-- 2111=32-211 Ackerland, 2112=32-212 Acker-Grünland, 2113=32-213 Acker-Hackrain, 2114=32-231 Grünland, 2115=32-232 Grünland-Acker, 2116=32-233 Grünland-Hackrain, 2117=32-234 Wiese, 2118=32-235 Streuwiese, 2119=32-236 Hutung -->
							<!-- 2120=Hopfen, 2130=Spargel, 2200=Holzung, 2300=Weingarten (allgemein), 2310=Weingarten 1, 2320=Weingarten 2, 2330=Weingarten 3 -->
							<!-- 2340=Weingarten 4, 2350=Weingarten 5, 2360=Weingarten 6, 2370=Weingarten 7, 2380=Weingarten 8, 2390=Weingarten 9, 2410=Gartenland, 2420=Obstplantage, 2430=Baumschule, 2440=Anbaufläche unter Glas, 2450=Kleingarten -->
							<!-- 2510=Weihnachtsbaumkultur, 2520=Saatzucht, 2530=Teichwirtschaft, 2610=Abbauland der Land- und Forstwirtschaft, 2620=Geringstland -->
							<!-- 2630=Unland, 2640=Moor, 2650=Heide, 2700=Reet -->
							<!-- 2710=Reet I, 2720=Reet II, 2730=Reet III, 2800=Nebenfläche des Betriebs der Land- und Forstwirtschaft -->
							<!-- Klassifizierung nach Straßenrecht -->
							<!-- 1100=Klassifizierung nach Bundes- oder Landesstraßengesetz, 1110=Bundesautobahn, 1120=Bundesstraße, 1130=Landes- oder Staatsstraße -->
							<!-- 1140=Kreisstraße, 1150=Gemeindestraße, 1160=Ortsstraße, 1170=Gemeindeverbindungsstraße, 1180=Sonstige öffentliche Straße, 1190=Privatstraße -->
							<!-- Klassifizierung nach Wasserrecht -->
							<!-- 1300=Klassifizierung nach Bundes- oder Landeswassergesetz, 1310=Gewässer I. Ordnung - Bundeswasserstraße -->
							<!-- 1320=Gewässer I. Ordnung - nach Landesrecht, 1330=Gewässer II. Ordnung, 1340=Gewässer III. Ordnung -->
							<!-- Forstrecht -->
							<!-- 3900=Klassifizierung nach Bundes- oder Landeswaldgesetz, 3910=Staatswald Bund, 3920=Staatswald Land, 3930=Kommunalwald -->
							<!-- 3940=Anstalts- und Stiftungswald, 3950=Anderer öffentlicher Wald, 3960=Privater Gemeinschaftswald, 3970=Großprivatwald -->
							<!-- 3980=Kleinprivatwald, 3990=Anderer Privatwald -->
						<!-- /AX_KlassifizierungOBG_K_BEWFL -->
					</klassifizierungOBG>
					<!-- Bodenschätzungen ermitteln, die die Bewertungsflächen schneiden -->
					<xsl:variable name="boden1">
						<xsl:for-each select="$bwrts">
							<xsl:variable name="position" select="./adv:posoiton"/>
							<xsl:copy-of select="$boden[ext:intersects(adv:position,$position)]"/>
						</xsl:for-each>
					</xsl:variable>
					<!-- Summierung über ermittelte Bodenschätzungen -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="bwrts" select="$boden1"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_BEWFL>
			</flaecheOBGGK>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaecheOBGGK">
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="bwrts"/>
		<!-- nur wenn Bewertungsflächen vorhanden -->
		<xsl:if test="count($bwrts)>0">
			<flaecheOBGGK>
				<AX_K_BEWFL>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<klassifizierungOBG><xsl:value-of select="$klass"/></klassifizierungOBG><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß hier vorhandener Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWFL.klassifizierungOBG durch Revision 'Enumeration' als Datentyp hat. Zuordnung siehe obige Fundstelle von klassifizierungOBG -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="bwrts" select="$bwrts"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_BEWFL>
			</flaecheOBGGK>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeHGrGK">
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="obggk"/>
		<!-- nur wenn Werte vorhanden -->
		<xsl:if test="count($obggk)>0">
			<flaechensummeHGrGK>
				<AX_K_BEWGR>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<klassifizierungGr><xsl:value-of select="$klass"/></klassifizierungGr><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß hier vorhandener Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWGR.klassifizierungGr durch Revision 'Enumeration' als Datentyp hat. -->
					<!-- Zuordnung:  -->
					<!-- 2100=Landwirtschaftliche Nutzung, 2200= Forstwirtschaftliche Nutzung, 2300=Weinbauliche Nutzung -->
					<!-- 2400=Gärtnerische Nutzung, 2500=Sonstige Land- und forstwirtschaftliche Nutzung, 2600=Andere Nutzung -->
					<!-- 2800=Nebenflächen des Betriebs der Land- und Forstwirtschaft, 2900=Noch nicht klassifiziert -->
					<!-- 1100=Straßenflächen, 1300=Gewässerflächen, 1400=Waldflächen -->
					<!-- Summierung über Einzelflaechen -->
					<flaeche><xsl:value-of select="sum(adv:flaeche)"/></flaeche>
				</AX_K_BEWGR>
			</flaechensummeHGrGK>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_StatistikDerFlaechenNachDemBewertungsgesetz xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>			
			<gebiet>
				<AX_Gebiet_StatistikDerFlaechenNachDemBewertungsgesetz>
				<xsl:if test="$anlassart = '2210'">
					<bezeichnung>Gemarkung</bezeichnung>
					<xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_Gemarkung[1]"/>					
					<schluessel><xsl:value-of select="$gebiet/adv:schluesselGesamt"/></schluessel>
					<name><xsl:value-of select="$gebiet/adv:bezeichnung"/></name>
  				</xsl:if>
				<xsl:if test="$anlassart = '2220' or $anlassart = '2221'">
					<bezeichnung>Gemeinde</bezeichnung>
					<xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_KommunalesGebiet[1]"/>					
					<schluessel><xsl:value-of select="$gebiet/adv:schluesselGesamt"/></schluessel>
					<name><xsl:value-of select="$gebiet/adv:bezeichnung"/></name>
  				</xsl:if> 
				<xsl:if test="$anlassart = '2230' or $anlassart = '2231'">
					<bezeichnung>Landkreis</bezeichnung>
					<xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_KreisRegion[1]"/>					
					<schluessel><xsl:value-of select="$gebiet/adv:schluesselGesamt"/></schluessel>
					<name><xsl:value-of select="$gebiet/adv:bezeichnung"/></name>
  				</xsl:if> 
				<xsl:if test="$anlassart = '2240' or $anlassart = '2241'">
					<bezeichnung>Regierungsbezirk</bezeichnung>
					<xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_Regierungsbezirk[1]"/>					
					<schluessel><xsl:value-of select="$gebiet/adv:schluesselGesamt"/></schluessel>
					<name><xsl:value-of select="$gebiet/adv:bezeichnung"/></name>
  				</xsl:if> 
				<xsl:if test="$anlassart = '2250' or $anlassart = '2251'">
					<bezeichnung>Land</bezeichnung>
					<xsl:variable name="gebiet" select="document('E1.xml')//adv:AX_Bundesland[1]"/>					
					<schluessel><xsl:value-of select="$gebiet/adv:schluesselGesamt"/></schluessel>
					<name><xsl:value-of select="$gebiet/adv:bezeichnung"/></name>
  				</xsl:if> 
				</AX_Gebiet_StatistikDerFlaechenNachDemBewertungsgesetz>
			</gebiet>
			<xsl:if test="$anlassart = '2210'">				
				<gemarkung>
					<AX_K_GKG>
						<xsl:variable name="gkg" select="document('E1.xml')//adv:AX_Gemarkung[1]"/>					
						<gemarkungsnummer><xsl:value-of select="$gkg/adv:schluesselGesamt"/></gemarkungsnummer>
						<gemarkungsname><xsl:value-of select="$gkg/adv:bezeichnung"/></gemarkungsname>
						<!-- Flurstücke der Gemarkung -->
						<xsl:variable name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer) = $gkg/adv:schluesselGesamt]"/>
						<gemarkungsflaeche><xsl:value-of select="sum($flurstuecke/adv:amtlicheFlaeche)"/></gemarkungsflaeche>
						<anzahlflurstuecke><xsl:value-of select="count($flurstuecke)"/></anzahlflurstuecke>
					</AX_K_GKG>
				</gemarkung>
			</xsl:if>
			<!-- über alle Gemarkungen: jede Gemarkung hat ein eigenes Ergebnisdokument 'E2_Gemarkung_<Schlüssel>.xml' -->
			<xsl:for-each select="document('E1.xml')//AX_Gemarkung">
				<!-- Sortierung der Ausgabe nach Bundesland und Gemarkungsnummer -->
				<xsl:sort select="adv:gemarkung/adv:land"/>
				<xsl:sort select="adv:gemarkung/adv:gemarkungsnummer"/>
				<!-- Schlüssel und Gemarkung vermerken -->
				<xsl:variable name="schluessel" select="concat(adv:gemarkung/adv:land,adv:gemarkung/adv:gemarkungsnummer)"/>
				<xsl:variable name="gemarkung"  select="."/>
				
				<!-- flaecheOBGGK -->
				<xsl:variable name="flaecheOBGGk">
					<!-- Landwirtschaftliche Nutzung differenzieren über Bodenschätzung -->
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2111"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='1000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2112"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='2000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2113"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='1000' and adv:sonstigeAngaben='2400']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2114"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2115"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='4000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2116"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2500']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2117"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2100']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2118"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2200']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK_Landwirt">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2119"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
						<xsl:with-param name="boden" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2300']"/>
					</xsl:call-template>
					<!-- sonstiges nicht weiter differenzieren -->
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2120"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2120']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2130"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2130']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2410"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2410']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2420"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2420']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2430"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2430']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2440"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2440']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2450"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2450']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2200"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2200']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2099"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2899']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2300"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2300']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2310"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2310']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2320"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2320']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2330"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2330']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2340"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2340']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2350"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2350']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2360"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2360']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2370"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2370']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2380"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2380']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2390"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2390']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2510"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2510']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2520"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2520']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2530"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2530']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2800"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2800']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2610"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2610']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2620"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2620']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2630"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2630']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2640"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2640']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2650"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2650']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2700"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2700']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2710"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2710']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2720"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2720']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2730"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2730']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1100"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1100']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1110"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1110']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1120"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1120']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1130"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1130']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1140"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1140']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1150"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1150']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1160"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1160']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1170"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1170']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1180"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1180']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1190"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1190']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1300"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1300']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1310"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1310']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1320"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1320']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1330"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1330']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1340"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1340']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3900"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3900']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3910"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3910']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3920"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3920']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3930"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3930']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3940"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3940']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3950"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3950']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3960"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3960']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3970"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3970']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3980"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3980']"/>
					</xsl:call-template>
					<xsl:call-template name="flaecheOBGGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="3990"/>
						<xsl:with-param name="bwrts" select="document('E2_Gemarkung_{$schluessel}.xml')/AX_Forstrecht[adv:artDerFestlegung='3990']"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Ausgabe sortiert nach Klassifizierung -->
				<xsl:for-each select="flaecheOBGGK">
					<xsl:sort select="adv:klassifizierungOBG"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
				
				<!-- flaechensummeHGrGK: Aggregation über flaecheOBGGK -->
				<xsl:variable name="flaechensummeHGrGK">
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2100"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[contains('2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2130',adv:AX_K_BEWFL/adv:klassifizierungOBG)]"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2200"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[adv:AX_K_BEWFL/adv:klassifizierungOBG='2200']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2300"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='23']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2400"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='24']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2500"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='25']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2600"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='26' or substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='27']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2800"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[adv:AX_K_BEWFL/adv:klassifizierungOBG='2800']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="2900"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[adv:AX_K_BEWFL/adv:klassifizierungOBG='2099']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1100"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='11']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1300"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='13']"/>
					</xsl:call-template>
					<xsl:call-template name="flaechensummeHGrGK">
						<xsl:with-param name="schluessel" select="$schluessel"/>
						<xsl:with-param name="klass" select="1400"/>
						<xsl:with-param name="obggk" select="$flaecheOBGGK/flaecheOBGGK[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='14']"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Ausgabe sortiert nach Klassifizierung -->
				<xsl:for-each select="flaechensummeHGrGK">
					<xsl:sort select="adv:klassifizierungGr"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
					
				<!-- flaecheKlasseGK: Summierung über flaechensummeHGrGK -->
				<flaecheKlassGK>
					<AX_K_FLASU>
						<gebiet><xsl:value-of select="$schluessel"/></gebiet>
						<!-- Summierung über Einzelflaechen -->
						<flaechensumme><xsl:value-of select="sum($flaechensummeHGrGK//adv:flaeche)"/></flaechensumme>
					</AX_K_FLASU>
				</flaecheKlassGK>
				
				<!-- anzahlFlurstueckeKlassGK -->
				<anzahlFlurstueckeKlassGK>
				  <AX_K_FLUSU>
					<gemarkung><xsl:value-of select="$schluessel"/></gemarkung>
					<anzahlFlurstuecke><xsl:value-of select="count(document('E1.xml')//adv:AX_Flurstuecke[ext:intersects(adv:position,$gemarkung/adv:position)])"/></anzahlFlurstuecke>
				  </AX_K_FLUSU>
				</anzahlFlurstueckeKlassGK>

			</xsl:for-each>
		</AX_StatistikDerFlaechenNachDemBewertungsgesetz>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
