<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<!-- Bewertung-Selektion über Gemarkung -->
	<xsl:template name="query_gemarkung_bewertung">
		<xsl:param name="bewertung"/>
		<xsl:param name="grund"/>
		<!-- über alle Flurstücke der Gemarkung -->
		<xsl:variable name="gschluessel" select="concat(adv:schluessel/adv:AX_Gemarkung_Schluessel/adv:land,adv:schluessel/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer)"/><!-- Hier wird auf AX_Gemarkung zugegriffen. Daher im Pfad adv:AX_Gemarkung_Schluessel/ erforderlich. -->
		<xsl:for-each select="document('E1.xml')//AX_Flurstueck[concat(adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land,adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer) = $gschluessel]"><!-- Hier korrigiert, da: AX_Flurstueck hat kein Attribut schluessel, concat war unvollständig. -->
			<xsl:call-template name="query_flurstueck_bewertung">
				<xsl:with-param name="bewertung" select="$bewertung"/>
				<xsl:with-param name="grund" select="$grund"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<!-- Bewertung-Selektion über Gemeinde: Länder, die diese Statistik brauchen, müssen folglich AX_Flurstueck.gemeindezugehoerigkeit belegen. 
		 Optional könnte man eine Verschneideoperation mit den TNs durchführen. -->
	<xsl:template name="query_gemeinde_bewertung">
		<xsl:param name="bewertung"/>
		<xsl:param name="grund"/>
		<!-- über alle Flurstücke der Gemeinde -->
		<xsl:variable name="gschluessel" select="adv:schluesselGesamt"/>
		<xsl:for-each select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $gschluessel]">
			<xsl:call-template name="query_flurstueck_bewertung">
				<xsl:with-param name="bewertung" select="$bewertung"/>
				<xsl:with-param name="grund" select="$grund"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<!-- Bewertung-Selektion über Flurstücke -->
	<xsl:template name="query_flurstueck_bewertung">
		<xsl:param name="bewertung"/>
		<xsl:element name="wfs:Query"> 
			<xsl:attribute name="typeName">
				<xsl:value-of select="$bewertung"/>
			</xsl:attribute>
			<ogc:Filter>
				<ogc:And>
					<!-- basierend auf AX_K_Gebaeude_Query.xslt -->
					<xsl:choose>
						<xsl:when test="count(adv:Position/*/*)>1">
							<!--  Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. --> 
							<ogc:Or>
								<xsl:for-each select="adv:Position/*">
									<ogc:Intersects>
										<ogc:PropertyName>position</ogc:PropertyName> 
										<xsl:copy-of select="."/> 
									</ogc:Intersects>
								</xsl:for-each>
							</ogc:Or>
						</xsl:when>
						<xsl:otherwise>
							<ogc:Intersects>
								<ogc:PropertyName>position</ogc:PropertyName> 
								<xsl:copy-of select="adv:Position"/> 
							</ogc:Intersects>
						</xsl:otherwise>
					</xsl:choose>
					<!-- zeitliche Betrachtung -->
					<ogc:PropertyIsNull>
						<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
					</ogc:PropertyIsNull>
				</ogc:And>
			</ogc:Filter>
		</xsl:element>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- Für jede Gemarkung wird eine eigene Query-Datei 'A2_Gemarkung_<Schlüssel>.xml' für die Selektion der Bewertungen über die Flurstücksflächen erstellt. -->
		<xsl:for-each select="document('E1.xml')//AX_Gemarkung">
			<!-- Query-Datei mit Gemarkungsschlüssel benennen. -->
			<xsl:document href="A2_Gemarkung_{concat(adv:schluessel/adv_land, adv:schluessel/adv:gemarkungsnummer)}.xml" method="xml">
				<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
					<empfaenger>
						<AA_Empfaenger>
							<direkt/>
						</AA_Empfaenger>
					</empfaenger>
					<ausgabeform>application/xml</ausgabeform>
					<art>0010</art>
					<anforderungsmerkmale>
						<!-- Bewertungen selektieren -->
						<xsl:call-template name="query_gemarkung_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Bewertung'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemarkung_bewertung">
							<xsl:with-param name="bewertung" select="'AX_KlassifizierungNachStrassenrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemarkung_bewertung">
							<xsl:with-param name="bewertung" select="'AX_KlassifizierungNachWasserrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemarkung_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Forstrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemarkung_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Bodenschaetzung'"/>
						</xsl:call-template>
					</anforderungsmerkmale>
					<profilkennung>
						<xsl:value-of select="$profilkennung"/>
					</profilkennung>
					<antragsnummer>
						<xsl:value-of select="$antragsnummer"/>
					</antragsnummer>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
				</AX_Benutzungsauftrag>
			</xsl:document>
		</xsl:for-each>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- Für jede Gemeinde wird eine eigene Query-Datei 'A2_Gemeinde_<Schlüssel>.xml' für die Selektion der Bewertungen über die Flurstücksflächen erstellt. -->
		<xsl:for-each select="document('E1.xml')//adv:AX_KommunalesGebiet">
			<!-- Query-Datei mit Gemeindeschlüssel benennen. -->
			<xsl:document href="A2_Gemeinde_{adv:schluesselGesamt}.xml" method="xml">
				<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
					<empfaenger>
						<AA_Empfaenger>
							<direkt/>
						</AA_Empfaenger>
					</empfaenger>
					<ausgabeform>application/xml</ausgabeform>
					<art>0010</art>
					<anforderungsmerkmale>
						<!-- Bewertungen selektieren -->
						<xsl:call-template name="query_gemeinde_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Bewertung'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemeinde_bewertung">
							<xsl:with-param name="bewertung" select="'AX_KlassifizierungNachStrassenrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemeinde_bewertung">
							<xsl:with-param name="bewertung" select="'AX_KlassifizierungNachWasserrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemeinde_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Forstrecht'"/>
						</xsl:call-template>
						<xsl:call-template name="query_gemeinde_bewertung">
							<xsl:with-param name="bewertung" select="'AX_Bodenschaetzung'"/>
						</xsl:call-template>
					</anforderungsmerkmale>
					<profilkennung>
						<xsl:value-of select="$profilkennung"/>
					</profilkennung>
					<antragsnummer>
						<xsl:value-of select="$antragsnummer"/>
					</antragsnummer>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
				</AX_Benutzungsauftrag>
			</xsl:document>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
