<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="poscrs" select="document('../Parameter.xml')//param[@name='CRS_Position']"/>
		<xsl:variable name="hoehencrs" select="document('../Parameter.xml')//param[@name='CRS_Hoehe']"/>
		<xsl:variable name="lagecrs" select="document('../Parameter.xml')//param[@name='CRS_Lage']"/>
		<xsl:variable name="streifen" select="document('../Parameter.xml')//param[@name='CRS_StreifenAmtlich']"/>
		<xsl:variable name="punkte" select="document('E1.xml')//adv:AX_Referenzstationspunkt"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_PunktlisteReferenzstationspunkt xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<kopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</kopf>
			<xsl:for-each select="document('E1.xml')//adv:AX_Referenzstationspunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<xsl:variable name="punkt" select="."/>
				<punkte>
					<AX_PunktlisteReferenzstationspunkt_Eintrag>
						<punktkennung><xsl:value-of select="adv:punktkennung"/></punktkennung>
						<name><xsl:value-of select="adv:nameLagebezeichnung"/></name>
						<xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
							<xsl:choose>
								<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and contains($poscrs,adv:position/gml:Point/gml:pos/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></northOderYWert>
									<hoeheOderZWert><xsl:value-of select="substring-after(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hoeheOderZWert>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></northOderYWert>
									<hoeheOderZWert></hoeheOderZWert>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/@srsName and contains($poscrs,adv:position/gml:Point/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></northOderYWert>
									<hoeheOderZWert><xsl:value-of select="substring-after(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hoeheOderZWert>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/@srsName and contains($lagecrs,adv:position/gml:Point/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></northOderYWert>
									<hoeheOderZWert></hoeheOderZWert>
								</xsl:when>
								<xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and count(./adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($poscrs,document('E1.xml')//gml:Envelope/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></northOderYWert>
									<hoeheOderZWert><xsl:value-of select="substring-after(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hoeheOderZWert>
								</xsl:when>
								<xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and count(./adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName)">
									<eastOderXWert><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></eastOderXWert>
									<northOderYWert><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></northOderYWert>
									<hoeheOderZWert></hoeheOderZWert>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</AX_PunktlisteReferenzstationspunkt_Eintrag>
				</punkte>
			</xsl:for-each>
			<xsl:for-each select="document('E1.xml')//adv:AX_Referenzstationspunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]">
				<xsl:variable name="punkt" select="."/>
				<xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
					<xsl:choose>
						<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and (contains($poscrs,adv:position/gml:Point/gml:pos/@srsName) or contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="./adv:position/gml:Point/@srsName and (contains($poscrs,adv:position/gml:Point/@srsName) or contains($lagecrs,adv:position/gml:Point/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and (contains($poscrs,document('E1.xml')//gml:Envelope/@srsName) or contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:for-each>
		</AX_PunktlisteReferenzstationspunkt>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
