<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="poscrs" select="document('../Parameter.xml')//param[@name='CRS_Position']"/>
		<xsl:variable name="hoehencrs" select="document('../Parameter.xml')//param[@name='CRS_Hoehe']"/>
		<xsl:variable name="lagecrs" select="document('../Parameter.xml')//param[@name='CRS_Lage']"/>
		<xsl:variable name="streifen" select="document('../Parameter.xml')//param[@name='CRS_StreifenAmtlich']"/>
		<xsl:variable name="punkte" select="document('E1.xml')//adv:AX_Lagefestpunkt"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_PunktlisteLagefestpunkt xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<antragsnummer>
				<xsl:value-of select="//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<kopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</kopf>
			<!-- xsl:for-each select="document('E1.xml')//adv:AX_Lagefestpunkt[adv:klassifikation/adv:AX_Klassifikation_Lagefestpunkt/adv:wertigkeit=3000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]" -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Lagefestpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"><!-- Korrigiert am 01.04.2009 aufgrund RL 1839 -->
				<xsl:variable name="punkt" select="."/>
				<punkte>
					<AX_PunktlisteLagefestpunkt_Eintrag>
						<punktkennung><xsl:value-of select="adv:punktkennung"/></punktkennung>
						<vermarkungsart>
						<xsl:value-of select="adv:punktvermarkung"/><!-- Korrigiert am 01.04.2009 aufgrund RL 1852, denn es wird nicht entschluesselt. -->
							<!-- xsl:call-template name="entschluesseln">
								<xsl:with-param name="codelist">AX_Marke</xsl:with-param>
								<xsl:with-param name="code" select="adv:punktvermarkung"/>
							</xsl:call-template -->
						</vermarkungsart>
						<xsl:variable name="k6" select="adv:pfeilerhoehe/adv:AX_Pfeilerhoehe_Lagefestpunkt/adv:abstand"/>
						<xsl:if test="count(adv:nutzerspezifischeBemerkungen)>0">
							<!-- bemerkungen><xsl:text>Vorhanden</xsl:text></bemerkungen -->
							<bemerkungen><xsl:value-of select="adv:nutzerspezifischeBemerkungen"/></bemerkungen><!-- Am 03.06.2009 korrigiert wegen RL 1853 -->
						</xsl:if>
						<xsl:if test="count($k6)=1">
							<pfeilerhoehe><xsl:value-of select="$k6"/><xsl:text> mm</xsl:text></pfeilerhoehe>
						</xsl:if>
						<xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
							<xsl:choose>
								<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and contains($poscrs,adv:position/gml:Point/gml:pos/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwertOderNorth>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwertOderNorth>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/@srsName and contains($poscrs,adv:position/gml:Point/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwertOderNorth>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/@srsName and contains($lagecrs,adv:position/gml:Point/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwertOderNorth>
								</xsl:when>
								<xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and count(./adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($poscrs,document('E1.xml')//gml:Envelope/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-before(substring-after(normalize-space(adv:position/gml:Point/gml:pos),' '),' ')"/></hochwertOderNorth>
								</xsl:when>
								<xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and count(./adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName)">
									<rechtswertOderEast><xsl:value-of select="$streifen"/><xsl:value-of select="substring-before(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></rechtswertOderEast>
									<hochwertOderNorth><xsl:value-of select="substring-after(normalize-space(adv:position/gml:Point/gml:pos),' ')"/></hochwertOderNorth>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
						<!-- xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]" -->
						<xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:') and adv:koordinatenstatus=1000]"><!-- Korrigiert am 01.04.2009 RL 1851 -->
							<xsl:choose>
								<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and contains($hoehencrs,adv:position/gml:Point/gml:pos/@srsName)">
									<hoehe><xsl:value-of select="normalize-space(adv:position/gml:Point/gml:pos)"/></hoehe>
								</xsl:when>
								<xsl:when test="./adv:position/gml:Point/@srsName and contains($hoehencrs,adv:position/gml:Point/@srsName)">
									<hoehe><xsl:value-of select="normalize-space(adv:position/gml:Point/gml:pos)"/></hoehe>
								</xsl:when>
								<!-- xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName)" -->
								<xsl:when test="count(./adv:position/gml:Point/gml:pos/@srsName)=0 and count(./adv:position/gml:Point/@srsName)=0 and document('E1.xml')//gml:Envelope/@srsName and contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName)"><!-- Am 03.06.2009 ergänzt wegen RL 1850 -->
									<hoehe><xsl:value-of select="normalize-space(adv:position/gml:Point/gml:pos)"/></hoehe>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</AX_PunktlisteLagefestpunkt_Eintrag>
				</punkte>
			</xsl:for-each>
			<!-- xsl:for-each select="document('E1.xml')//adv:AX_Lagefestpunkt[adv:klassifikation/adv:AX_Klassifikation_Lagefestpunkt/adv:wertigkeit=3000 and count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]" -->
			<xsl:for-each select="document('E1.xml')//adv:AX_Lagefestpunkt[count(adv:lebenszeitintervall/adv:AA_Lebenzeitintervall/adv:endet)=0]"><!-- Korrigiert am 01.04.2009 aufgrund RL 1839 -->
				<xsl:variable name="punkt" select="."/>
				<xsl:variable name="punkt" select="."/>
				<xsl:for-each select="//adv:AX_PunktortAU[@gml:id=substring-after($punkt/adv:bestehtAus/@xlink:href,'urn:adv:oid:')]">
					<xsl:choose>
						<xsl:when test="./adv:position/gml:Point/gml:pos/@srsName and (contains($poscrs,adv:position/gml:Point/gml:pos/@srsName) or contains($lagecrs,adv:position/gml:Point/gml:pos/@srsName) or contains($hoehencrs,adv:position/gml:Point/gml:pos/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="./adv:position/gml:Point/@srsName and (contains($poscrs,adv:position/gml:Point/@srsName) or contains($lagecrs,adv:position/gml:Point/@srsName) or contains($hoehencrs,adv:position/gml:Point/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="./adv:position/gml:Point/@srsName"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="document('E1.xml')//gml:Envelope/@srsName and (contains($poscrs,document('E1.xml')//gml:Envelope/@srsName) or contains($lagecrs,document('E1.xml')//gml:Envelope/@srsName) or contains($hoehencrs,document('E1.xml')//gml:Envelope/@srsName))">
							<xsl:call-template name="system">
								<xsl:with-param name="crs" select="document('E1.xml')//gml:Envelope/@srsName"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:for-each>
		</AX_PunktlisteLagefestpunkt>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
