<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 Geändert am 19.12.2007 bzgl. RL-Nr. 1637 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/><!-- Bezug hier auf E1.xml gesetzt. -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Selektion der relevanten Gebäude mit deren Lagen -->
				<wfs:Query typeName="AX_Gebaeude">
					<XlinkPropertyPath>zeigtAuf</XlinkPropertyPath>
					<XlinkPropertyPath>hat</XlinkPropertyPath><!-- Für die Nicht-Standardausgaben wird hier auch LBEZmPseudoNr selektiert. -->
					<ogc:Filter>
						<xsl:choose>
							<xsl:when test="count(document('E1.xml')//adv:AX_Flurstueck/adv:position/*/*)>1"><!-- Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. -->
								<ogc:And>
								<ogc:Or>
									<xsl:for-each select="$p3">
										<ogc:Intersects>
											<ogc:PropertyName>position</ogc:PropertyName>
											<xsl:copy-of select="."/> <!-- Hier statt value-of copy-of -->
										</ogc:Intersects>
									</xsl:for-each>
								</ogc:Or>
								<!-- Weitere Bedingung zusätzlich zur geometrischen Verschneidung:
								Die Gebäude gehören dann zum Flurstück, wenn 
								- die Relation „zeigtAuf“ eines Gebäudes und die Relation „weistAuf“ des abgefragten Flurstücks auf
								das identische Zielobjekt verweisen (Hauptgebäude),
								- die Relation „hat“ eines Gebäudes und die Relation
								„weistAuf“ des abgefragten Flurstücks auf Lageobjekte
								verweisen, bei denen die Attribute „lagebezeichnung“ übereinstimmen und ferner „pseudonummer“ und „haus
								nummer“ identisch sind (Nebengebäude zu einem Hauptgebäude)
								oder
								- die Relation „hat“ eines Gebäudes und die Relation
								„zeigtAuf“ des abgefragten Flurstücks auf Lageobjekte
								verweisen, bei denen die Attribute „lagebezeichnung“ übereinstimmen (Nebengebäude ohne Hauptgebäude).
								-->
								</ogc:And>
							</xsl:when>
							<xsl:otherwise>
								<ogc:And>
								<ogc:Intersects>
									<ogc:PropertyName>position</ogc:PropertyName>
									<xsl:copy-of select="$p3"/> <!-- Hier statt value-of copy-of -->
								</ogc:Intersects>
								<!-- Weitere Bedingung zusätzlich zur geometrischen Verschneidung:
								Die Gebäude gehören dann zum Flurstück, wenn 
								- die Relation „zeigtAuf“ eines Gebäudes und die Relation „weistAuf“ des abgefragten Flurstücks auf
								das identische Zielobjekt verweisen (Hauptgebäude),
								- die Relation „hat“ eines Gebäudes und die Relation
								„weistAuf“ des abgefragten Flurstücks auf Lageobjekte
								verweisen, bei denen die Attribute „lagebezeichnung“ übereinstimmen und ferner „pseudonummer“ und „haus
								nummer“ identisch sind (Nebengebäude zu einem Hauptgebäude)
								oder
								- die Relation „hat“ eines Gebäudes und die Relation
								„zeigtAuf“ des abgefragten Flurstücks auf Lageobjekte
								verweisen, bei denen die Attribute „lagebezeichnung“ übereinstimmen (Nebengebäude ohne Hauptgebäude).
								-->
								</ogc:And>
							</xsl:otherwise>
						</xsl:choose>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"/><!-- Gezielte Suche sollte jedem Implementierer eine Selbstverständlichkeit sein. -->
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
