<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Fortführungsnachweise selektieren: dazu die Fortführungsfälle -->
				<wfs:Query typeName="AX_FortfuehrungsnachweisDeckblatt">
					<!-- zugehörige Fortführungsfälle mitselektieren -->
					<adv:XlinkPropertyPath>adv:beziehtSichAuf/adv:AX_Fortfuehrungsfall</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<!--  Filter aus node set ohne Root <ogc:Filter>: Dies bewirkt ein And im And, ist hier jedoch unkritisch. -->
						 	<xsl:copy-of select="//ogc:Filter/*" /> 
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>					
				</wfs:Query>
				<!-- Besorge ausserdem alle Objekte der weiteren Objektarten. 
				     Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
				     Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				     der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Flurstueck">
					<adv:XlinkPropertyPath>adv:weistAuf/adv:LagebezeichnungMitHausnummer</adv:XlinkPropertyPath>
					<adv:XlinkPropertyPath>adv:zeigtAuf/adv:LagebezeichnungOhneHausnummer</adv:XlinkPropertyPath>
					<!-- Hier sind alle Flurst. zu selektieren, auf die sich die Instanz/en von zu AX_FortfuehrungsnachweisDeckblatt gehörigen AX_Fortfuehrungsfall beziehen. -->
					<!-- Besonderheit hierbei: Neue Flst. sind bei FF mit Verarbeitungsstop zum Zeitpkt. der Erzeugung der FFMitteilung an Eigentümer noch im temp. Bereich. -->
					<!-- Die Buchungsangaben werden nur bzgl. der alten Flst. benötigt. -->
			        <adv:XlinkPropertyPath>adv:istGebucht/adv:AX_Buchungsstelle/adv:istBestandteilVon/adv:AX_Buchungsblatt</adv:XlinkPropertyPath>
				</wfs:Query>
				<wfs:Query typeName="AX_Dienststelle"/>
				<wfs:Query typeName="AX_Buchungsblattbezirk"/>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
