<?xml version="1.0" encoding="UTF-8"?>
<!-- GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" 
	xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:choose>
		<xsl:when test="//adv:art='0600'"><!-- Grundstücksnachweis hat zwei Einstiegsparameter. 20.12.2007 -->
		<xsl:variable name="p3" select="//wfs:Query[@typeName='AX_Buchungsblatt']/ogc:Filter/ogc:PropertyIsEqualTo/ogc:Literal"/><!-- 20.12.2007 Gezielte Belegung von $p3 ist durch mehrere ogc:Literal notwendig! -->
		</xsl:when>
		<xsl:otherwise>
		<xsl:variable name="p3" select="//ogc:literal"/>
		</xsl:otherwise>
		</xsl:choose>		
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
			        <wfs:Query typeName="AX_Namensnummer">
					<XlinkPropertyPath>benennt/AX_Person/hat</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>istBestandteilVon/AX_Buchungsblatt/buchungsblattkennzeichen</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
			<profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>			
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
