<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0.1 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1"
		xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template name="wirtschaftsart">
		<xsl:param name="wert"/>
		<xsl:param name="tn"/>
		<xsl:param name="flurstueck"/>
		<xsl:param name="korrekturfaktor"/>
		<!-- nur wenn Teilflächen vorhanden -->
		<xsl:if test="count($tn)>0">
			<wirtschaftsart>
				<AX_K_WIA>
					<abschnittWIA>
						<AX_AbschnittWIA>
							<abschnittsflaecheTN>
								<xsl:call-template name="summiereTeilflaechen">
									<xsl:with-param name="tn" select="$tn"/>
									<xsl:with-param name="flurstuecksflaeche" select="$flurstueck/adv:position"/>
									<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
								</xsl:call-template>
							</abschnittsflaecheTN>
							<wirtschaftsart>
								<!-- AX_Wirtschaftsart --><!-- Codelisten- bzw. Enumerationsname war zuviel des Guten. -->
									<!-- 	<xsl:call-template name="entschluesseln"> 
											<xsl:with-param name="codelist">AX_Wirtschaftsart</xsl:with-param> 
											<xsl:with-param name="code" select="$wert"/> 
										</xsl:call-template>
									-->
									<xsl:value-of select="$wert"/><!-- Falls per Revision bezgl. AX_AbschnittWIA.wirtschaftsart - CodeList AX_Wirtschaftsart nun Datentyp Enumeration gesetzt wurde, dann in den Aufrufen die dort angegebenen langschriftlichen Werte übergeben. -->
								<!-- /AX_Wirtschaftsart -->
							</wirtschaftsart>
						</AX_AbschnittWIA>
					</abschnittWIA>
				</AX_K_WIA>
			</wirtschaftsart>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<!-- rekursive Ermittlung, ob mindestens eine strittige Grenze vorliegt -->
	<xsl:template name="strittigeGrenze">
		<xsl:param name="flurstueckskennzeichen"/>
		<!-- Test für Abbruchbedingung -->
		<xsl:choose>
			<xsl:when test="$flurstueckskennzeichen">
				<!-- mindestens ein Flurstückskennzeichen noch vorhanden für Prüfung -->
				<xsl:choose>
					<!-- prüfen, ob zu ersten Flurstückskennzeichen eine strittige Grenze existiert -->
					<xsl:when test="count(document('E2.xml')//adv:AX_BesondereFlurstuecksgrenze[ext:contains(adv:position,document('E1.xml')//adv:AX_Flurstueck[adv:flurstueckskennzeichen=$flurstueckskennzeichen[1]]/adv:position)])>0">
						<!-- Ja: somit eine strittige Grenze gefunden -->
						true
					</xsl:when>
					<xsl:otherwise>
						<!-- Nein: rekursiv weiterprüfen ohne geprüftes erstes Flurstückskennzeichen -->
						<xsl:call-template name="strittigeGrenze">
							<xsl:with-param name="flurstueckskennzeichen" select="$flurstueckskennzeichen[position() != 1]"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- Abbruch, da kein Flurstückskennzeichen mehr für Prüfung vorhanden: somit auch keine strittige Grenze gefunden -->
				false
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_FortfuehrungsmitteilungAnJustizverwaltung xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0.1 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="document('AX_Benutzungsauftrag.xml')//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<titel>
				<AX_K_FM_Titel>
					<!-- Ausgabekopf aus Fortführungsnachweis-Deckblatt übernehmen -->
					<ausgabekopf>
						<AX_K_AUSGKOPF_Standard>
							<xsl:copy-of select="//adv:AX_FortfuehrungsnachweisDeckblatt/adv:ausgabekopf/*"/>
						</AX_K_AUSGKOPF_Standard>
					</ausgabekopf>
					<inGemarkung>
						<xsl:copy-of select="//adv:AX_FortfuehrungsnachweisDeckblatt/adv:inGemarkung/adv:AX_GemarkungSchluessel"/><!-- Falls AX_K_FM_Titel.inGemarkung per Revision Datentyp CharacterString erhält, dann bitte hier den entschlüsselten Wert eintragen.--><!-- 27.05.2009: CharacterString liegt mittlerweile vor, daher entschlüsseln. -->
					</inGemarkung>
				</AX_K_FM_Titel>
			</titel>
			<!-- sortiert nach Fortführungsfallnummer -->
			<xsl:for-each select="//adv:AX_Fortfuehrungsfall">
				<xsl:sort select="adv:fortfuehrungsfallnummer"/>
				<fortfuehrungsfall>
					<xsl:variable name="fortfuehrungsfall" select="."/>
					<AX_K_Fortfuehrungsfall_FMJ>
						<fortfuehrungsfallnummer>
							<xsl:value-of select="adv:fortfuehrungsfallnummer"/>
						</fortfuehrungsfallnummer>
						<laufendeNummer>
							<xsl:value-of select="adv:laufendeNummer"/>
						</laufendeNummer>
						<xsl:copy-of select="adv:ueberschriftImFortfuehrungsnachweis"/>
						<xsl:for-each select="adv:zeigtAufAltesFlurstueck">
							<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
							<flurstueck_alt>
								<AX_K_FLURST_F_alt>
									<flurstueckskennzeichen>
										<xsl:value-of select="."/>
									</flurstueckskennzeichen>
									<amtlicheFlaeche>
										<xsl:value-of select="$flurstueck/adv:amtlicheFlaeche"/>
									</amtlicheFlaeche>
								</AX_K_FLURST_F_alt>
							</flurstueck_alt>
						</xsl:for-each>
						<xsl:for-each select="adv:zeigtAufNeuesFlurstueck">
							<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
							<flurstueck_neu>
								<AX_K_FLURST_F_neu>
									<flurstueckskennzeichen>
										<xsl:value-of select="."/>
									</flurstueckskennzeichen>
									<amtlicheFlaeche>
										<xsl:value-of select="$flurstueck/adv:amtlicheFlaeche"/>
									</amtlicheFlaeche>
									<xsl:for-each select="$flurstueck/adv:weistAuf/adv:AX_LagebezeichnungMitHausnummer">
										<lagebezeichnung>
											<xsl:call-template name="AX_K_LBEZ">
												<xsl:with-param name="lage" select="."/>
											</xsl:call-template>
										</lagebezeichnung>
									</xsl:for-each>
									<xsl:for-each select="$flurstueck/adv:weistAuf/adv:AX_LagebezeichnungOhneHausnummer">
										<lagebezeichnung>
											<xsl:call-template name="AX_K_LBEZ">
												<xsl:with-param name="lage" select="."/>
											</xsl:call-template>
										</lagebezeichnung>
									</xsl:for-each>									
									<!-- wirtschaftsart über Tatsächliche Nutzung ermitteln -->
									<xsl:variable name="tn">
										<xsl:call-template name="Select_TN__alle">
										  	<xsl:with-param name="tn__alle" select="document('E2.xml')//." /> 
										  	<xsl:with-param name="position" select="$flurstueck/adv:position" /> 
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name="korrekturfaktor">
										<xsl:choose>
											<xsl:when test="function-available('ext:berechneFlaeche')">
												<xsl:value-of select="$flurstueck/adv:amtlicheFlaeche div ext:berechneFlaeche($flurstueck/adv:position)"/>
											</xsl:when>
											<xsl:otherwise>1.0</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<!-- 1000 für NTZ = 41001 AX_Wohnbauflaeche, 
														41002 AX_IndustrieUndGewerbeflaeche (ohne FKT, 1400, 1410, 1420, 1430, 1440, 1450, 1460, 1470, 1480, 1490, 1700, 1701, 1710, 1720, 1730, 1750, 1760, 1770, 1780, 1790, 2501, 2521, 2531, 2551, 2561, 2571, 2581, 2601, 2611, 2621), 
														41006 AX_FlaecheGemischterNutzung (ohne FKT, 2100, 2110, 2120, 2130, 2140, 2150, 2160, 2700, 2710, 2720, 2730), 
														41007 AX_FlaecheBesondererFunktionalerPraegung (ohne FKT, 1100, 1110, 1120, 1130, 1140, 1150, 1160, 1170), 
														41008 AX_SportFreizeitUndErholungsflaeche (4001, 4101, 4211, 4301, 4321, 4331, 4431), 
														41009 AX_Friedhof (9401), 
														42001 AX_Strassenverkehr (2311), 
														42010 AX_Bahnverkehr (2321), 
														42015 AX_Flugverkehr (5501), 
														42016 AX_Schiffsverkehr (2341) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'1000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Gebäude- und Freifläche" statt 1000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_Wohnbauflaeche | 
																		  $tn//adv:AX_IndustrieUndGewerbeflaeche[not(adv:funktion) or adv:funktion='1400' or adv:funktion='1410' or adv:funktion='1420' or adv:funktion='1430' or adv:funktion='1440' or adv:funktion='1450' or adv:funktion='1460' or adv:funktion='1470' or adv:funktion='1480' or adv:funktion='1490' or 
																		  										 adv:funktion='1700' or adv:funktion='1701' or adv:funktion='1710' or adv:funktion='1720' or adv:funktion='1730' or adv:funktion='1750' or adv:funktion='1760' or adv:funktion='1770' or adv:funktion='1780' or adv:funktion='1790' or 
																		  										 adv:funktion='2501' or adv:funktion='2521' or adv:funktion='2531' or adv:funktion='2551' or adv:funktion='2561' or adv:funktion='2571' or adv:funktion='2581' or 
																		  										 adv:funktion='2601' or adv:funktion='2611' or adv:funktion='2621'] |
																		  $tn//adv:AX_FlaecheGemischterNutzung[not(adv:funktion) or adv:funktion='2100' or adv:funktion='2110' or adv:funktion='2120' or adv:funktion='2130' or adv:funktion='2140' or adv:funktion='2150' or adv:funktion='2160' or 
																		                                       adv:funktion='2700' or adv:funktion='2710' or adv:funktion='2720' or adv:funktion='2730'] |
																		  $tn//adv:AX_FlaecheBesondererFunktionalerPraegung[not(adv:funktion) or adv:funktion='1100' or adv:funktion='1110' or adv:funktion='1120' or adv:funktion='1130' or adv:funktion='1140' or adv:funktion='1150' or adv:funktion='1160' or adv:funktion='1170'] |
																		  $tn//adv:AX_SportFreizeitUndErholungsflaeche[adv:funktion='4001' or adv:funktion='4101' or adv:funktion='4211' or adv:funktion='4301' or adv:funktion='4321' or adv:funktion='4331' or adv:funktion='4431'] |
																		  $tn//adv:AX_Friedhof[adv:funktion='9401'] |
																		  $tn//adv:AX_Strassenverkehr[adv:funktion='2311'] |
																		  $tn//adv:AX_Bahnverkehr[adv:funktion='2321'] |
																		  $tn//adv:AX_Flugverkehr[adv:funktion='5501'] |
																		  $tn//adv:AX_Schiffsverkehr[adv:funktion='2341']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 3000 für NTZ = 41002 AX_IndustrieUndGewerbeflaeche (1740, 2500, 2502, 2510, 2520, 2522, 2530, 2532, 2540, 2550, 2552, 2560, 2562, 2570, 2572, 2580, 2582, 2600, 2602, 2610, 2612, 2620, 2622, 2623, 2630, 2640), 
												 	    41003 AX_Halde, 
														41004 AX_Bergbaubetrieb, 
														41005 AX_TagebauGrubeSteinbruch -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'3000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Betriebsfläche" statt 3000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_IndustrieUndGewerbeflaeche[adv:funktion='1740' or 
																												 adv:funktion='2500' or adv:funktion='2502' or adv:funktion='2510' or adv:funktion='2520' or adv:funktion='2530' or adv:funktion='2532' or adv:funktion='2540' or 
																												 adv:funktion='2550' or adv:funktion='2552' or adv:funktion='2560' or adv:funktion='2562' or adv:funktion='2570' or adv:funktion='2572' or adv:funktion='2580' or adv:funktion='2582' or
																												 adv:funktion='2600' or adv:funktion='2602' or adv:funktion='2610' or adv:funktion='2612' or adv:funktion='2620' or adv:funktion='2622' or adv:funktion='2623' or adv:funktion='2630' or adv:funktion='2640'] | 
																		  $tn//adv:AX_Halde |
																		  $tn//adv:AX_Bergbaubetrieb |
																		  $tn//adv:AX_TagebauGrubeSteinbruch"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 4000 für NTZ = 41008 AX_SportFreizeitUndErholungsflaeche (ohne FKT, 4100, 4110, 4120, 4130, 4140, 4150, 4160, 4170, 4200, 4210, 4220, 4230, 4240, 4250, 4260, 4280, 4290, 4300, 4310, 4320, 4330, 4400, 4410, 4420, 4430, 4440, 4450, 4460, 4470, 9999) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'4000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Erholungsfläche" statt 4000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_SportFreizeitUndErholungsflaeche[not(adv:funktion) or adv:funktion='4100' or adv:funktion='4110' or adv:funktion='4120' or adv:funktion='4130' or adv:funktion='4140' or adv:funktion='4150' or adv:funktion='4160' or adv:funktion='4170' or 
																													   adv:funktion='4200' or adv:funktion='4210' or adv:funktion='4220' or adv:funktion='4230' or adv:funktion='4240' or adv:funktion='4250' or adv:funktion='4260' or adv:funktion='4280' or adv:funktion='4290' or 
																													   adv:funktion='4300' or adv:funktion='4310' or adv:funktion='4320' or adv:funktion='4330' or 
																													   adv:funktion='4400' or adv:funktion='4410' or adv:funktion='4420' or adv:funktion='4430' or adv:funktion='4440' or adv:funktion='4450' or adv:funktion='4460' or adv:funktion='4470' or
																													   adv:funktion='9999']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 5000 für NTZ = 41007 AX_FlaecheBesondererFunktionalerPraegung (1200), 
														42001 AX_Strassenverkehr (ohne FKT, 2312, 2313, 5130), 
														42006 AX_Weg (ohne FKT, 5210, 5211, 5212, 5220, 5230, 5240, 5250, 5260, 9999), 
														42009 AX_Platz (ohne FKT, 5130, 5310, 5320, 5330, 5340, 5350), 
														42010 AX_Bahnverkehr (ohne FKT, 2322), 
														42015 AX_Flugverkehr (ohne FKT), 
														42016 AX_Schiffsverkehr (ohne FKT, 5610, 5620, 5630, 5640), 
														43007 AX_UnlandVegetationsloseFlaeche (1100, 1110, 1120) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'5000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Verkehrsfläche" statt 5000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_FlaecheBesondererFunktionalerPraegung[adv:funktion='1200'] | 
																		  $tn//adv:AX_Strassenverkeh[not(adv:funktion) or adv:funktion='2312' or adv:funktion='2313' or adv:funktion='5130'] |
																		  $tn//adv:AX_Weg[not(adv:funktion) or adv:funktion='5210' or adv:funktion='5211' or adv:funktion='5212' or adv:funktion='5220' or adv:funktion='5230' or adv:funktion='5240' or adv:funktion='5250' or adv:funktion='5260' or adv:funktion='9999'] |
																		  $tn//adv:AX_Platz[not(adv:funktion) or adv:funktion='5130' or adv:funktion='5310' or adv:funktion='5320' or adv:funktion='5330' or adv:funktion='5340' or adv:funktion='5350'] |
																		  $tn//adv:AX_Bahnverkehr[not(adv:funktion) or adv:funktion='2322'] |
																		  $tn//adv:AX_Flugverkehr[not(adv:funktion)] |
																		  $tn//adv:AX_Schiffsverkehr[not(adv:funktion) or adv:funktion='5610' or adv:funktion='5620' or adv:funktion='5630' or adv:funktion='5640'] |
																		  $tn//adv:AX_UnlandVegetationsloseFlaeche[adv:funktion='1100' or adv:funktion='1110' or adv:funktion='1120']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 6000 für NTZ = 41006 AX_FlaecheGemischterNutzung (FKT 6800), 
														43001 AX_Landwirtschaft (ohne VEG, 1010, 1011, 1012, 1013, 1020, 1021, 1030, 1031, 1040, 1050, 1051,1052,1200), 
														43004 AX_Heide, 
														43005 AX_Moor, 
														43007 AX_UnlandVegetationsloseFlaeche (FKT 1200) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'6000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Landwirtschaftsfläche" statt 6000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_FlaecheGemischterNutzung[adv:funktion='6800'] | 
																		  $tn//adv:AX_Landwirtschaft[not(adv:vegetationsmerkmal) or adv:vegetationsmerkmal='1010' or adv:vegetationsmerkmal='1011' or adv:vegetationsmerkmal='1012' or adv:vegetationsmerkmal='1013' or 
																		                             adv:vegetationsmerkmal='1020' or adv:vegetationsmerkmal='1021' or adv:vegetationsmerkmal='1030' or adv:vegetationsmerkmal='1031' or 
																		                             adv:vegetationsmerkmal='1040' or adv:vegetationsmerkmal='1050' or adv:vegetationsmerkmal='1051' or adv:vegetationsmerkmal='1052' or adv:vegetationsmerkmal='1200'] |
																		  $tn//adv:AX_Heide |
																		  $tn//adv:AX_Moor |
																		  $tn//adv:AX_UnlandVegetationsloseFlaeche[adv:funktion='1200']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 7000 für NTZ = 41006 AX_FlaecheGemischterNutzung (FKT 7600), 
									                    43002 AX_Wald (ohne VEG, 1100,1200,1300,1310,1320), 
									                    43003 AX_Gehoelz (ohne VEG, 1400) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'7000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Waldfläche" statt 7000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_FlaecheGemischterNutzung[adv:funktion='7600'] | 
																		  $tn//adv:AX_Wald[not(adv:vegetationsmerkmal) or adv:vegetationsmerkmal='1100' or adv:vegetationsmerkmal='1200' or adv:vegetationsmerkmal='1300' or adv:vegetationsmerkmal='1310' or adv:vegetationsmerkmal='1320'] |
																		  $tn//adv:AX_Gehoelz[not(adv:vegetationsmerkmal) or adv:vegetationsmerkmal='1400']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 8000 für NTZ = 43006 AX_Sumpf, 
									                    44001 AX_Fliessgewaesser (ohne FKT, 8200, 8210, 8220, 8300, 8400, 8410, 8500), 
									                    44005 AX_Hafenbecken (ohne FKT, 8810), 
									                    44006 AX_StehendesGewaesser (ohne FKT, 8610, 8620, 8630, 8631, 8640, 9999), 
									                    44007 AX_Meer (ohne FKT, 8710, 8720) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'8000'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Wasserfläche" statt 8000 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_Sumpf | 
																		  $tn//adv:AX_Fliessgewaesser[not(adv:funktion) or adv:funktion='8200' or adv:funktion='8210' or adv:funktion='8220' or adv:funktion='8300' or adv:funktion='8400' or adv:funktion='8410' or adv:funktion='8500'] |
																		  $tn//adv:AX_Hafenbecken[not(adv:funktion) or adv:funktion='8810'] |
																		  $tn//adv:AX_StehendesGewaesser[not(adv:funktion) or adv:funktion='8610' or adv:funktion='8620' or adv:funktion='8630' or adv:funktion='8631' or adv:funktion='8640' or adv:funktion='9999'] |
																		  $tn//adv:AX_Meer[not(adv:funktion) or adv:funktion='8710' or adv:funktion='8720']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 9100 für NTZ = 41008 AX_SportFreizeitUndErholungsflaeche (4270) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'9100'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Übungsgelände" statt 9100 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_SportFreizeitUndErholungsflaeche[adv:funktion='4270']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 9300 für NTZ = 41007 AX_FlaecheBesondererFunktionalerPraegung (1300, 1310, 1320) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'9300'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Historische Anlage" statt 9300 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_FlaecheBesondererFunktionalerPraegung[adv:funktion='1300' or adv:funktion='1310' or adv:funktion='1320']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 9400 für NTZ = 41009 AX_Friedhof (ohne FKT, 9402, 9403, 9404) -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'9400'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Friedhof" statt 9400 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_Friedhof[not(adv:funktion) or adv:funktion='9402' or adv:funktion='9403' or adv:funktion='9404']"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
									<!-- 9500 für NTZ = 43007 AX_UnlandVegetationsloseFlaeche -->
									<xsl:call-template name="wirtschaftsart">
										<xsl:with-param name="wert" select="'9500'"/><!-- Falls Datentyp der CodeList AX_Wirtschaftsart seitens Revision nun Enumeration ist, dann hier "Unland" statt 9500 übergeben. -->
										<xsl:with-param name="tn" select="$tn//adv:AX_UnlandVegetationsloseFlaeche"/>
										<xsl:with-param name="flurstueck" select="$flurstueck"/>
										<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
									</xsl:call-template>
								</AX_K_FLURST_F_neu>
							</flurstueck_neu>
						</xsl:for-each>
						<!-- Buchungsangaben nur für alte Flurstücke -->
						<xsl:for-each select="$fortfuehrungsfall/adv:zeigtAufAltesFlurstueck">
							<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
							<buchung>
								<xsl:variable name="stelle" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($flurstueck/adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
								<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
								  	<xsl:with-param name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/> 
								  	<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/> 
								  	<xsl:with-param name="bart"  select="$stelle/adv:buchungsart"/> 
								</xsl:call-template>
							</buchung>
						</xsl:for-each>
						<!-- strittige Grenze? -->
						<strittigeGrenze>
							<xsl:call-template name="strittigeGrenze">
								<xsl:with-param name="flurstueckskennzeichen" select="$fortfuehrungsfall/adv:zeigtAufNeuesFlurstueck"/>
							</xsl:call-template>
						</strittigeGrenze>
						<veraenderungsanalyse>
							<xsl:call-template name="AX_K_FANALYSE">
								<xsl:with-param name="fortfuehrungsfall" select="$fortfuehrungsfall"/>
							</xsl:call-template>
						</veraenderungsanalyse>
						<xsl:if test="count($fortfuehrungsfall/adv:verweistAuf/adv:AX_FGraphik)=1">
							<verweistAuf>
   								<xsl:copy-of select="$fortfuehrungsfall/adv:verweistAuf/adv:AX_FGraphik"/>
							</verweistAuf>
						</xsl:if>
					</AX_K_Fortfuehrungsfall_FMJ>
				</fortfuehrungsfall>
			</xsl:for-each>
		</AX_FortfuehrungsmitteilungAnJustizverwaltung>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
