<?xml version="1.0" encoding="UTF-8"?>
<!-- GeoInfoDok 6.0.1 -->
<!-- Frage: Suchbegriff " Überflüssiger " -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0.1" 	
	xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" 
	xmlns:gml="http://www.opengis.net/gml/3.2" 
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" 
	xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" 
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- ==================================================== -->
	<!-- Voraussetzung: alle AX_Buchungsblattbezirk, AX_Dienststelle, AX_Flurstueck, AX_Person, AX_Anschrift, AX_Buchungsblatt, AX_Buchungsstelle, AX_Namensnummer, AX_Gemarkung-Objekte verfügbar -->
	<xsl:template name="AX_Grundstueck_Bestandsnachweis">
		<xsl:param name="stelle"/>
		<xsl:variable name="bart" select="$stelle/adv:buchungsart"/>
		<AX_Grundstueck_Bestandsnachweis xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0.1">
			<xsl:if test="count($stelle/adv:laufendeNummer)=1"> <!-- Überflüssiger Test, da Pflichtattr. bei AX_Buchungsstelle. Warum 0..1 bei Datentyp GBN / AX_Grundstueck_Bestandsnachweis? Eigentl. nur if-Inhalt notwendig. -->
				<laufendeNummerDerBuchungsstelle><xsl:value-of select="$stelle/adv:laufendeNummer"/></laufendeNummerDerBuchungsstelle>
			</xsl:if>
			<buchungsart>
				<xsl:call-template name="entschluesseln">
					<xsl:with-param name="codelist">AX_Buchungsart_Buchungsstelle</xsl:with-param>
					<xsl:with-param name="code" select="$bart"/>
				</xsl:call-template>
			</buchungsart>
			<xsl:choose>
				<xsl:when test="($bart='1301' or $bart='1302') and count($stelle/adv:anteil)=1">
					<xsl:apply-templates select="$stelle/adv:anteil" mode="copy-it"/>
				</xsl:when>
				<xsl:when test="($bart='1501' or $bart='1502') and count($stelle/adv:anteil)=1">
					<xsl:apply-templates select="$stelle/adv:anteil" mode="copy-it"/>
					<aufgeteilterAnteil>
						<xsl:apply-templates select="//adv:AX_Buchungsstelle[@gml:id=substring-after($stelle/adv:an/@xlink:href,'urn:adv:oid:') and (adv:buchungsart='1401' or adv:buchungsart='1402')]/adv:anteil/adv:AX_Anteil" mode="copy-it"/>
					</aufgeteilterAnteil>
				</xsl:when>
			</xsl:choose>
			<!-- War früher fälschlicherweise in utility.xslt bei Template Recht__fiktiv. Dort galt aber: AX_Recht.nummerImAufteilungsplan existiert nicht. -->
			<!-- nummerImAufteilungsplan kann nur bei den aufgezählten Buchungsarten vorkommen. -->
			<!-- Zusammengefaßt mit zuvor hier separat vorhandenem 1301 -->
				<xsl:if test="($bart='1301' or $bart='2201' or $bart='2202' or $bart='2401'or $bart='2402') and count($stelle/adv:nummerImAufteilungsplan)=1">
					<xsl:apply-templates select="$stelle/adv:nummerImAufteilungsplan" mode="copy-it"/>
				</xsl:if>
			<!-- War früher fälschlicherweise in utility.xslt bei Template Recht__fiktiv. Dort galt aber: AX_Recht.beschreibungDesSondereigentums existiert nicht. -->
			<!-- beschreibungDesSondereigentums kann nur bei den aufgezählten Buchungsarten vorkommen. -->
			<!-- Zusammengefaßt mit zuvor hier separat vorhandenem 1301 -->
				<xsl:if test="($bart='1301' or $bart='2201' or $bart='2202' or $bart='2401'or $bart='2402') and count($stelle/adv:beschreibungDesSondereigentums)=1">
					<xsl:apply-templates select="$stelle/adv:beschreibungDesSondereigentums" mode="copy-it"/>
				</xsl:if>
			<xsl:call-template name="AX_K_Buchungsangaben_HD">
				<xsl:with-param name="stelle" select="."/>
			</xsl:call-template>
			<xsl:for-each select="//adv:AX_Flurstueck[$stelle/@gml:id=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]">
				<flurstueck>
					<xsl:call-template name="AX_K_FLURSTUECK2">
						<xsl:with-param name="flurstueck" select="."/>
					</xsl:call-template>
				</flurstueck>
			</xsl:for-each>
			<grundstuecksflaeche><xsl:value-of select="sum(//adv:AX_Flurstueck[$stelle/@gml:id=substring-after(adv:istGebucht/@xlink:href,'urn:adv:oid:')]//adv:amtlicheFlaeche)"/></grundstuecksflaeche>
			<xsl:call-template name="AX_Recht">
				<xsl:with-param name="stelle" select="."/>
				<xsl:with-param name="bart" select="$bart"/>
			</xsl:call-template>
			<xsl:if test="count($stelle/adv:buchungstext)=1"><!-- Am 22.12.2008 ergaenzt aufgrund RL Nr. 1716 -->
			  <buchungstext><xsl:value-of select="$stelle/adv:buchungstext"/></buchungstext>
			</xsl:if>
		</AX_Grundstueck_Bestandsnachweis>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="blatt" select="//adv:AX_Buchungsblatt[adv:buchungsblattkennzeichen=document('AX_Benutzungsauftrag.xml')//ogc:Literal]"/>
		<xsl:for-each select="//adv:AX_Buchungsstelle[$blatt/@gml:id=substring-after(adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]">
			<xsl:call-template name="AX_Grundstueck_Bestandsnachweis">
				<xsl:with-param name="stelle" select="."/>
			</xsl:call-template>
		  <xsl:for-each select="//adv:AX_Buchungsstelle[substring-after(zu/@xlink:href,'urn:adv:oid:')=./@gml:id"/><!-- Ergänzt am 20.12.2007 bzgl. der zugebuchten Anteile zu dem "Hauptgrundstück"-->
			<xsl:call-template name="AX_Grundstueck_Bestandsnachweis">
				<xsl:with-param name="stelle" select="."/>
			</xsl:call-template>
		  </xsl:for-each>					
		</xsl:for-each>

	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
