<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<!-- Gebietsflaeche -->	
	<xsl:variable name="gebietsflaeche" select="document('E1.xml')/adv:AX_KommunalesGebiet/adv:position"/>
	<!-- =========================================================== -->
	<!-- TN-Selektion -->
	<xsl:template name="query_tn">
		<xsl:param name="tn"/>
		<xsl:param name="grund"/>
		<xsl:element name="wfs:Query"> 
			<xsl:attribute name="typeName">
				<xsl:value-of select="$tn"/>
			</xsl:attribute>
			<ogc:Filter>
				<ogc:And>
					<!-- basierend auf AX_K_Gebaeude_Query.xslt -->
					<xsl:choose>
						<xsl:when test="count($gebietsflaeche/*/*)>1">
							<!--  Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. --> 
							<ogc:Or>
								<xsl:for-each select="$gebietsflaeche/*">
									<ogc:Intersects>
										<ogc:PropertyName>position</ogc:PropertyName> 
										<xsl:copy-of select="."/> 
									</ogc:Intersects>
								</xsl:for-each>
							</ogc:Or>
						</xsl:when>
						<xsl:otherwise>
							<ogc:Intersects>
								<ogc:PropertyName>position</ogc:PropertyName> 
								<xsl:copy-of select="$gebietsflaeche"/> 
							</ogc:Intersects>
						</xsl:otherwise>
					</xsl:choose>
					<!-- optional die Grundflächenbeachtung -->
					<xsl:if test="grund = true()">
						<ogc:PropertyIsNull>hatDirektUnten</ogc:PropertyIsNull>					
					</xsl:if>
					<!-- zeitliche Betrachtung -->
					<ogc:PropertyIsNull>
						<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
					</ogc:PropertyIsNull>
				</ogc:And>
			</ogc:Filter>
		</xsl:element>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- TNs selektieren nach Fläche -->
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Wohnbauflaeche'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_IndustrieUndGewerbeflaeche'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Halde'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Bergbaubetrieb'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_TagebauGrubeSteinbruch'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_FlaecheGemischterNutzung'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_FlaecheBesondererFunktionalerPraegung'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_SportFreizeitUndErholungsflaeche'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Friedhof'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Strassenverkehr'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Weg'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Platz'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Bahnverkehr'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Flugverkehr'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Schiffsverkehr'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Landwirtschaft'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Wald'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Gehoelz'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Heide'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Moor'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Sumpf'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_UnlandVegetationsloseFlaeche'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Fliessgewaesser'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Hafenbecken'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_StehendesGewaesser'"/>
					<xsl:with-param name="grund" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="query_tn">
					<xsl:with-param name="tn"    select="'AX_Meer'"/>
					<xsl:with-param name="grund" select="false()"/>
				</xsl:call-template>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
