/*
 * Decompiled with CFR 0.152.
 */
package us.mitre.ShapeChange.Model.GSIP;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.mitre.ShapeChange.Model.GSIP.GSIPDocument;
import us.mitre.ShapeChange.Model.GSIP.PackageInfoGSIP;
import us.mitre.ShapeChange.Model.GSIP.PropertyInfoGSIP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoGSIP
extends ClassInfoImpl
implements ClassInfo {
    protected GSIPDocument document;
    protected PackageInfoGSIP packageInfo;
    protected ClassInfoGSIP baseclassInfo = null;
    protected HashSet<ClassInfoGSIP> baseclassInfoSet = null;
    protected HashSet<ClassInfoGSIP> subclassInfoSet = new HashSet();
    protected String gsipClassId = null;
    protected String gsipName = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected int numBaseClasses = 0;
    protected Vector<PropertyInfoGSIP> registeredRoles = new Vector();
    protected HashMap<String, String> taggedValuesCache = null;
    protected String stereotype = null;
    protected TreeMap<StructuredNumber, PropertyInfo> propertiesCache = null;
    protected HashMap<String, PropertyInfoGSIP> fPropertiesById = null;
    protected TreeMap<Integer, OperationInfo> operationsCache = null;
    protected Vector<Constraint> constraintsCache;
    protected boolean validatedConstraints = false;
    protected boolean hasNilReason = false;
    protected int enumLiteralSequenceNumber = 1;

    public ClassInfoGSIP(GSIPDocument doc, PackageInfoGSIP pi, HashMap<String, Object> properties) throws ShapeChangeAbortException {
        Pattern intPat;
        Matcher gsipNameMatcher;
        this.document = doc;
        this.packageInfo = pi;
        pi.childCI.add(this);
        this.gsipName = (String)properties.get("nsgAlphaCode");
        this.gsipClassId = (String)properties.get("itemIdentifier_PK");
        this.isAbstract = Boolean.parseBoolean((String)properties.get("isAbstract"));
        String st = this.document.options.normalizeStereotype((String)properties.get("umlStereotype"));
        if (st != null) {
            for (String s : Options.classStereotypes) {
                if (!st.toLowerCase().equals(s)) continue;
                this.stereotype = s;
            }
        }
        if (this.stereotype == null) {
            st = this.document.options.normalizeStereotype("");
            this.stereotype = st != null ? st : "";
        }
        String descriptionString = GSIPDocument.getDescriptionString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"));
        String documentation = GSIPDocument.getDocumentationString((String)properties.get("name"), (String)properties.get("definition"), (String)properties.get("description"), (String)properties.get("note"));
        properties.remove("description");
        properties.put("description", descriptionString);
        properties.put("documentation", documentation);
        if (this.stereotype.equalsIgnoreCase("featuretype") && this.packageInfo.schema != null) {
            String entityQueryResource;
            String schemaQueryResource = null;
            if (this.document.kmlReferenceType.equalsIgnoreCase("fdd")) {
                entityQueryResource = (String)properties.get("fddConceptRefID");
                schemaQueryResource = this.packageInfo.schema.taggedValue("fddQueryResource");
            } else {
                entityQueryResource = (String)properties.get("asStandardRefID");
                schemaQueryResource = this.packageInfo.schema.taggedValue("asQueryResource");
            }
            if (entityQueryResource != null && entityQueryResource != "" && schemaQueryResource != null && schemaQueryResource != "") {
                properties.put("kmlReference", schemaQueryResource + entityQueryResource);
            }
        }
        if ((gsipNameMatcher = (intPat = Pattern.compile("Integer")).matcher(this.gsipName)).find()) {
            String rangeMinimum = (String)properties.get("rangeMinimum");
            String rangeMaximum = (String)properties.get("rangeMaximum");
            if (rangeMinimum != null) {
                String rangeMin = new Integer(Double.valueOf(rangeMinimum).intValue()).toString();
                properties.remove("rangeMinimum");
                properties.put("rangeMinimum", rangeMin);
            }
            if (rangeMaximum != null) {
                String rangeMax = new Integer(Double.valueOf(rangeMaximum).intValue()).toString();
                properties.remove("rangeMaximum");
                properties.put("rangeMaximum", rangeMax);
            }
        }
        this.setAndValidateTaggedValues(properties);
        this.propertiesCache = new TreeMap();
        this.loadOperationsCache();
        this.establishCategory();
    }

    @Override
    public ClassInfo baseClass() {
        int stsize = 0;
        ClassInfoGSIP cir = null;
        int cat = this.category();
        if (cat == 1 || cat == 6 || cat == 5 || cat == 4 || cat == 8) {
            HashSet<ClassInfoGSIP> baseCIs = null;
            if (this.baseclassInfoSet != null) {
                baseCIs = this.baseclassInfoSet;
            } else if (this.baseclassInfo != null) {
                baseCIs = new HashSet(1);
                baseCIs.add(this.baseclassInfo);
            }
            if (baseCIs != null) {
                for (ClassInfoGSIP baseCI : baseCIs) {
                    int bcat = baseCI.category();
                    if ((cat == bcat || bcat == -1) && bcat != 4) {
                        ++stsize;
                        cir = baseCI;
                        continue;
                    }
                    if (bcat == 4) continue;
                    this.document.result.addError(null, 108, this.name());
                    this.document.result.addDebug(null, 10003, this.name(), "" + cat, "!FALSE");
                    this.document.result.addDebug(null, 10003, this.name(), "" + bcat, "!TRUE");
                }
            }
            if (stsize > 1) {
                this.document.result.addError(null, 109, this.name());
            }
        }
        return cir;
    }

    private void loadOperationsCache() {
        this.operationsCache = new TreeMap();
    }

    @Override
    public boolean checkSupertypes(int cat) {
        HashSet<Object> bcis = new HashSet<ClassInfoGSIP>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        boolean res = true;
        for (ClassInfoGSIP classInfoGSIP : bcis) {
            int bcicat = classInfoGSIP.category();
            if (bcicat == -1) {
                res = classInfoGSIP.checkSupertypes(cat);
            } else {
                if (bcicat == 4) continue;
                if (bcicat != cat) {
                    res = false;
                }
            }
            if (res) continue;
            break;
        }
        if (res) {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "TRUE");
        } else {
            this.document.result.addDebug(null, 10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    public void addConstraint(Constraint c) {
        if (this.constraintsCache == null) {
            this.constraintsCache = new Vector();
        }
        this.constraintsCache.add(c);
    }

    @Override
    public Vector<Constraint> constraints() {
        if (this.validatedConstraints) {
            return this.constraintsCache;
        }
        if (this.constraintsCache == null) {
            this.constraintsCache = new Vector();
        }
        HashMap<String, Constraint> namefilter = new HashMap<String, Constraint>();
        for (Constraint currConstraint : this.constraintsCache) {
            namefilter.put(currConstraint.name(), currConstraint);
        }
        HashSet<String> stids = this.supertypes();
        if (stids != null) {
            for (String stid : stids) {
                ClassInfo stci = this.model().classById(stid);
                Vector<Constraint> stcos = null;
                if (stci != null) {
                    stcos = stci.constraints();
                }
                if (stcos == null) continue;
                for (Constraint stco : stcos) {
                    String nam;
                    String string = nam = stco == null ? null : stco.name();
                    if (nam != null && nam.length() > 0 && namefilter.containsKey(nam)) continue;
                    this.addConstraint(stco);
                }
            }
        }
        Collections.sort(this.constraintsCache, new Comparator<Constraint>(){

            @Override
            public int compare(Constraint ci1, Constraint ci2) {
                return ci1.name().compareTo(ci2.name());
            }
        });
        this.validatedConstraints = true;
        return this.constraintsCache;
    }

    @Override
    public boolean hasNilReason() {
        return this.hasNilReason;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public OperationInfo operation(String name, String[] types) {
        return null;
    }

    @Override
    public PackageInfo pkg() {
        return this.packageInfo;
    }

    @Override
    public TreeMap<StructuredNumber, PropertyInfo> properties() {
        return (TreeMap)this.propertiesCache.clone();
    }

    @Override
    public PropertyInfo property(String name) {
        for (PropertyInfo pi : this.propertiesCache.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        HashSet<ClassInfoGSIP> bcis = new HashSet<ClassInfoGSIP>(1);
        if (this.baseclassInfo != null) {
            bcis.add(this.baseclassInfo);
        } else if (this.baseclassInfoSet != null) {
            bcis = this.baseclassInfoSet;
        }
        for (ClassInfoGSIP bci : bcis) {
            PropertyInfo pi = bci.property(name);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    @Override
    public HashSet<String> subtypes() {
        HashSet<String> subids = new HashSet<String>(this.subclassInfoSet.size());
        for (ClassInfoGSIP sci : this.subclassInfoSet) {
            subids.add(sci.id());
        }
        return subids;
    }

    @Override
    public HashSet<String> supertypes() {
        HashSet<String> baseids = new HashSet<String>(1);
        if (this.baseclassInfo != null) {
            baseids.add(this.baseclassInfo.id());
        } else if (this.baseclassInfoSet != null) {
            for (ClassInfoGSIP bci : this.baseclassInfoSet) {
                baseids.add(bci.id());
            }
        }
        return baseids;
    }

    @Override
    public String id() {
        return this.gsipClassId;
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public String name() {
        String s = this.gsipName.trim();
        if (s == null || s.equals("")) {
            s = this.id();
            this.document.result.addWarning(null, 100, "class", s);
        }
        return s;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValuesCache.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }

    private void setAndValidateTaggedValues(HashMap<String, Object> tvs) {
        this.taggedValuesCache = new HashMap(5);
        if (tvs != null) {
            for (Map.Entry<String, Object> e : tvs.entrySet()) {
                String t = e.getKey();
                if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                String v = (String)e.getValue();
                this.taggedValuesCache.put(t, v);
            }
        }
    }

    public void addProperty(PropertyInfo pi) {
        if (this.propertiesCache == null) {
            this.propertiesCache = new TreeMap();
        }
        if (this.fPropertiesById == null) {
            this.fPropertiesById = new HashMap();
        }
        this.propertiesCache.put(pi.sequenceNumber(), pi);
        this.fPropertiesById.put(pi.id(), (PropertyInfoGSIP)pi);
        if (pi.implementedByNilReason()) {
            this.hasNilReason = true;
        }
    }

    public PropertyInfoGSIP getPropertyById(String id) {
        if (this.fPropertiesById == null) {
            return null;
        }
        return this.fPropertiesById.get(id);
    }

    public void establishRoles(PropertyInfoGSIP pi) {
        this.registeredRoles.add(pi);
    }

    @Override
    public AssociationInfo isAssocClass() {
        return null;
    }
}

